/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui;

import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class LocaleSettings {
    private static Hashtable resources = new Hashtable();
    ResourceBundle resource = null;

    private LocaleSettings(ResourceBundle resource1) {
        this.resource = resource1;
    }

    public static LocaleSettings getInstance(String localFile) {
        LocaleSettings settings = (LocaleSettings)resources.get(localFile);
        if (settings == null) {
            PropertyResourceBundle resource = null;
            try {
                resource = new PropertyResourceBundle(new FileInputStream(localFile));
                settings = new LocaleSettings(resource);
                resources.put(localFile, settings);
            }
            catch (Exception ex) {
                settings = new LocaleSettings(null);
                resources.put(localFile, settings);
            }
        }
        return settings;
    }

    public String getResourceString(String s, String s1) {
        String s2;
        if (this.resource == null) {
            return s1;
        }
        try {
            s2 = this.resource.getString(s);
        }
        catch (MissingResourceException ex) {
            s2 = s1;
        }
        return s2;
    }

    public String getResourceString(String key, String defaultFormat, Object[] arguments) {
        MessageFormat f = new MessageFormat(this.getResourceString(key, defaultFormat));
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i] == null) {
                arguments[i] = "null";
            } else if (!(arguments[i] instanceof String || arguments[i] instanceof Number || arguments[i] instanceof Date)) {
                arguments[i] = arguments[i].toString();
            }
            ++i;
        }
        return f.format(arguments);
    }

    public void releaseResource(String localFile) {
        resources.remove(localFile);
    }
}

