/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.resource.GuiResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class EditorPropertiesDialog
extends JDialog
implements ActionListener {
    public static final String OK_CMD = "OK_CMD";
    public static final String CANCEL_CMD = "CANCEL_CMD";
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel controlPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton okBtn = new JButton();
    JButton cancelBtn = new JButton();
    Border anEtchedBorder = BorderFactory.createEtchedBorder();
    Border editorBorder;
    private boolean isOkAction = false;
    private String serviceName;
    private JComponent component;

    public EditorPropertiesDialog(Frame frame, String title, String serviceName, JComponent component) {
        super(frame, title, true);
        this.serviceName = serviceName;
        this.component = component;
        try {
            this.initDialog();
            this.pack();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public boolean isOk() {
        return this.isOkAction;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.isOkAction = false;
        }
        super.setVisible(visible);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(OK_CMD)) {
            this.isOkAction = true;
            this.setVisible(false);
        } else if (cmd.equals(CANCEL_CMD)) {
            this.isOkAction = false;
            this.setVisible(false);
        }
    }

    private void initDialog() throws Exception {
        LookAndFeelHandler.add(this);
        this.editorBorder = this.serviceName != null && this.serviceName.trim().length() > 0 ? BorderFactory.createTitledBorder(this.anEtchedBorder, this.serviceName) : this.anEtchedBorder;
        this.component.setBorder(this.editorBorder);
        this.panel1.setLayout(this.borderLayout1);
        this.panel1.add((Component)this.component, "Center");
        this.controlPanel.setLayout(this.gridBagLayout1);
        this.okBtn.setText(GuiResourceManager.getResourceString("OkButton", "Ok"));
        this.okBtn.setActionCommand(OK_CMD);
        this.okBtn.addActionListener(this);
        this.cancelBtn.setText(GuiResourceManager.getResourceString("CancelButton", "Cancel"));
        this.cancelBtn.setActionCommand(CANCEL_CMD);
        this.cancelBtn.addActionListener(this);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.controlPanel, "South");
        this.controlPanel.add((Component)this.okBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.controlPanel.add((Component)this.cancelBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void updateLook_Feel() {
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void setComponent(JComponent comp) {
        this.panel1.remove(this.component);
        this.component = comp;
        this.panel1.add((Component)this.component, "Center");
    }

    public void setServiceName(String theName) {
        this.serviceName = theName;
    }
}

