/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.CWizardPanel;
import com.sap.engine.gui.wizard.ImageLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public abstract class CWizardDialog
extends CEscapeDialog
implements ActionListener {
    public static final byte NORMAL_TYPE = 0;
    public static final byte FINISH_TYPE = 2;
    public static final byte HELP_TYPE = 4;
    public static final byte FINISH_HELP_TYPE = 6;
    public static final byte FINISH_ICONS = 10;
    public static final byte START_ICONS = 11;
    private JPanel buttonPanel = new JPanel();
    protected JPanel cardPanel = new JPanel();
    private JLabel imageLabel = new JLabel();
    protected JPanel imagePanel = new JPanel();
    protected JButton nextB = new JButton();
    protected JButton prevB = new JButton();
    protected JButton exitB = new JButton();
    protected JButton finishB = new JButton();
    protected JButton helpB = new JButton();
    private JButton defNextB;
    private JButton defPrevB;
    private JButton defExitB;
    private JButton defFinishB;
    private JButton defHelpB;
    protected ImageLoader il = new ImageLoader();
    Icon wizardImg = null;
    Icon prevN = this.il.getIcon("prevN");
    Icon prevL = this.il.getIcon("prevL");
    Icon prevG = this.il.getIcon("prevG");
    Icon prevP = this.il.getIcon("prevP");
    Icon nextN = this.il.getIcon("nextN");
    Icon nextL = this.il.getIcon("nextL");
    Icon nextG = this.il.getIcon("nextG");
    Icon nextP = this.il.getIcon("nextP");
    Icon startN = this.il.getIcon("startN");
    Icon startL = this.il.getIcon("startL");
    Icon startG = this.il.getIcon("startG");
    Icon startP = this.il.getIcon("startP");
    Icon finishN = this.il.getIcon("finishN");
    Icon finishL = this.il.getIcon("finishL");
    Icon finishG = this.il.getIcon("finishG");
    Icon finishP = this.il.getIcon("finishP");
    Icon exitN = this.il.getIcon("exitN");
    Icon exitL = this.il.getIcon("exitL");
    Icon exitP = this.il.getIcon("exitP");
    Icon exitG = this.il.getIcon("exitG");
    Icon helpN = this.il.getIcon("helpN");
    Icon helpL = this.il.getIcon("helpL");
    Icon helpG = this.il.getIcon("helpG");
    Icon helpP = this.il.getIcon("helpP");
    Icon userN;
    Icon userL;
    Icon userG;
    Icon userP;
    private JFrame parent;
    private CWizardPanel tmp;
    private Vector panels = new Vector(5);
    private int step = 0;
    private byte wizardType = 0;
    private byte finishButtonType = (byte)10;
    private boolean userFinishIcons = false;
    private boolean userNextButton = false;

    public CWizardDialog() {
        this((JFrame)null, "", false);
    }

    public CWizardDialog(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.parent = frame;
        this.init();
        this.pack();
    }

    public CWizardDialog(JFrame frame, String title, boolean modal, Icon image) {
        super(frame, title, modal);
        this.parent = frame;
        this.init();
        this.setWizardImage(image);
        this.pack();
    }

    public CWizardDialog(JFrame frame, String title, boolean modal, byte wizType) {
        this(frame, title, modal);
        this.setWizardType(wizType);
    }

    public CWizardDialog(JFrame frame, String title, boolean modal, byte wizType, byte finishButtonType) {
        this(frame, title, modal);
        this.setWizardType(wizType);
        this.setFinishButtonIcons(finishButtonType);
        this.defFinishB = this.finishB;
    }

    public CWizardDialog(JFrame frame, String title, boolean modal, byte wizType, Icon wizImage) {
        this(frame, title, modal, wizImage);
        this.setWizardType(wizType);
    }

    public CWizardDialog(JFrame frame, String title, boolean modal, byte wizType, byte finishButtonType, Icon wizImage) {
        this(frame, title, modal, wizImage);
        this.setWizardType(wizType);
        this.setFinishButtonIcons(finishButtonType);
        this.defFinishB = this.finishB;
    }

    void init() {
        this.setDefaultCloseOperation(0);
        this.imagePanel.setPreferredSize(new Dimension(150, 100));
        this.imagePanel.setBackground(new Color(204, 204, 255));
        this.imagePanel.setMinimumSize(new Dimension(50, 100));
        this.imagePanel.setLayout(new BorderLayout());
        this.imagePanel.setBorder(new EtchedBorder());
        this.imageLabel.setHorizontalAlignment(0);
        this.cardPanel.setBackground(new Color(192, 152, 124));
        this.cardPanel.setLayout(new BorderLayout());
        this.exitB.addActionListener(this);
        this.exitB.setIcon(this.exitN);
        this.exitB.setRolloverIcon(this.exitL);
        this.exitB.setDisabledIcon(this.exitG);
        this.exitB.setPressedIcon(this.exitP);
        this.exitB.setMnemonic('x');
        this.exitB.setBorderPainted(false);
        this.exitB.setContentAreaFilled(false);
        this.exitB.setFocusPainted(false);
        this.exitB.setBorder(new EmptyBorder(0, 20, 0, 0));
        this.nextB.addActionListener(this);
        this.nextB.setIcon(this.nextN);
        this.nextB.setRolloverIcon(this.nextL);
        this.nextB.setDisabledIcon(this.nextG);
        this.nextB.setPressedIcon(this.nextP);
        this.nextB.setMnemonic('n');
        this.nextB.setContentAreaFilled(false);
        this.nextB.setBorderPainted(false);
        this.nextB.setFocusPainted(false);
        this.nextB.setToolTipText("Next");
        this.prevB.addActionListener(this);
        this.prevB.setIcon(this.prevN);
        this.prevB.setRolloverIcon(this.prevL);
        this.prevB.setDisabledIcon(this.prevG);
        this.prevB.setPressedIcon(this.prevP);
        this.prevB.setMnemonic('p');
        this.prevB.setContentAreaFilled(false);
        this.prevB.setBorderPainted(false);
        this.prevB.setFocusPainted(false);
        this.prevB.setToolTipText("Previous");
        this.finishB.addActionListener(this);
        if (this.finishButtonType == 10) {
            this.finishB.setIcon(this.finishN);
            this.finishB.setRolloverIcon(this.finishL);
            this.finishB.setDisabledIcon(this.finishG);
            this.finishB.setPressedIcon(this.finishP);
        } else {
            this.finishB.setIcon(this.startN);
            this.finishB.setRolloverIcon(this.startL);
            this.finishB.setDisabledIcon(this.startG);
            this.finishB.setPressedIcon(this.startP);
        }
        this.finishB.setMnemonic('f');
        this.finishB.setContentAreaFilled(false);
        this.finishB.setBorderPainted(false);
        this.finishB.setFocusPainted(false);
        this.helpB.addActionListener(this);
        this.helpB.setIcon(this.helpN);
        this.helpB.setRolloverIcon(this.helpL);
        this.helpB.setDisabledIcon(this.helpG);
        this.helpB.setPressedIcon(this.helpP);
        this.helpB.setMnemonic('h');
        this.helpB.setContentAreaFilled(false);
        this.helpB.setBorderPainted(false);
        this.helpB.setFocusPainted(false);
        this.defPrevB = this.prevB;
        this.defNextB = this.nextB;
        this.defFinishB = this.finishB;
        this.defHelpB = this.helpB;
        this.defExitB = this.exitB;
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.prevB, null);
        this.buttonPanel.add((Component)this.nextB, null);
        this.buttonPanel.add((Component)this.exitB, null);
        this.imagePanel.add((Component)this.imageLabel, "Center");
        this.getContentPane().add((Component)this.imagePanel, "West");
        this.getContentPane().add((Component)this.cardPanel, "Center");
        this.addWindowListener(new WinL());
        ((Component)this).setSize(500, 400);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
    }

    public void setWizardType(byte wizType) {
        switch (wizType) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                this.wizardType = wizType;
                this.redoWizardButtons();
            }
        }
    }

    private void redoWizardButtons() {
        this.buttonPanel.removeAll();
        this.buttonPanel.add(this.prevB);
        this.buttonPanel.add(this.nextB);
        if ((this.wizardType & 2) > 0) {
            this.buttonPanel.add(this.finishB);
        }
        if ((this.wizardType & 4) > 0) {
            this.buttonPanel.add(this.helpB);
        }
        this.buttonPanel.add(this.exitB);
        this.buttonPanel.updateUI();
    }

    public void setVisibleWizardImage(boolean b) {
        if (this.imagePanel.isVisible() != b) {
            this.imagePanel.setVisible(b);
        }
    }

    public void setFinishButtonIcons(byte finishBT) {
        switch (finishBT) {
            case 10: 
            case 11: {
                this.finishButtonType = finishBT;
                if (finishBT == 11) {
                    this.finishB.setIcon(this.startN);
                    this.finishB.setRolloverIcon(this.startL);
                    this.finishB.setDisabledIcon(this.startG);
                    this.finishB.setPressedIcon(this.startP);
                } else {
                    this.finishB.setIcon(this.finishN);
                    this.finishB.setRolloverIcon(this.finishL);
                    this.finishB.setDisabledIcon(this.finishG);
                    this.finishB.setPressedIcon(this.finishP);
                }
                this.finishB.updateUI();
            }
        }
    }

    public void setUserNextButtonFinishIcons(Icon normal, Icon rollover, Icon disabled, Icon pressed) {
        this.userFinishIcons = true;
        this.userN = normal;
        this.userL = rollover;
        this.userG = disabled;
        this.userP = pressed;
    }

    public void setDefaultNextButtonFinishIcons() {
        this.userFinishIcons = false;
    }

    public void addPanel(CWizardPanel panel) {
        this.panels.addElement(panel);
    }

    public boolean insertPanelAt(CWizardPanel panel, int inx) {
        if (inx < 0 || inx > this.panels.size()) {
            return false;
        }
        if (inx == this.panels.size()) {
            this.addPanel(panel);
        } else {
            this.panels.insertElementAt(panel, inx);
        }
        return true;
    }

    public void removePanel(int inx) {
        if (inx > this.panels.size() - 1 || inx < 0) {
            return;
        }
        this.panels.removeElementAt(inx);
    }

    public void removePanel(String panelName) {
        int i = 0;
        while (i < this.panels.size()) {
            if (((CWizardPanel)this.panels.elementAt(i)).getName().equals(panelName)) {
                this.panels.removeElementAt(i);
            }
            ++i;
        }
    }

    public boolean removePanel(Object o) {
        return this.panels.removeElement(o);
    }

    public void removeAllPanels() {
        this.panels.removeAllElements();
        this.step = 0;
    }

    public int getPanelNumber() {
        return this.panels.size();
    }

    public int getCurrentPanelIndex() {
        return this.step;
    }

    public CWizardPanel getPanelAt(int index) {
        if (index < 0 || index > this.panels.size()) {
            return null;
        }
        return (CWizardPanel)this.panels.elementAt(index);
    }

    public int getIndexOf(CWizardPanel panel) {
        int i = 0;
        while (i < this.panels.size()) {
            if ((CWizardPanel)this.panels.elementAt(i) == panel) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean exists(CWizardPanel panel) {
        int i = 0;
        while (i < this.panels.size()) {
            if ((CWizardPanel)this.panels.elementAt(i) == panel) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setShowingInterval(int begin, int end) {
        int len = this.panels.size();
        int i = begin;
        while (i <= end) {
            if (i >= 0 && i < len) {
                ((CWizardPanel)this.panels.elementAt(i)).setDisplayable(true);
            }
            ++i;
        }
        if (this.hasMorePanels()) {
            this.setNextButtonIcons();
        }
        if (this.hasMoreBackPanels() && !this.prevB.isEnabled()) {
            this.prevB.setEnabled(true);
        }
    }

    public void setNonShowingInterval(int begin, int end) {
        int len = this.panels.size();
        int i = begin;
        while (i <= end) {
            if (i >= 0 && i < len) {
                ((CWizardPanel)this.panels.elementAt(i)).setDisplayable(false);
            }
            ++i;
        }
        if (!this.hasMorePanels()) {
            this.setNextButtonFinishIcons();
        }
        if (!this.hasMoreBackPanels() && this.prevB.isEnabled()) {
            this.prevB.setEnabled(false);
        }
    }

    public void updateNextButtonIcons() {
        if (this.step == this.panels.size() - 1 || !this.hasMorePanels()) {
            this.setNextButtonFinishIcons();
        } else {
            this.setNextButtonIcons();
        }
    }

    public boolean hasPanels() {
        return this.panels.size() > 0;
    }

    public void showNextPanel() {
        if (!this.panels.isEmpty()) {
            this.getContentPane().remove(this.cardPanel);
            this.cardPanel.removeAll();
            this.tmp = (CWizardPanel)this.panels.elementAt(++this.step);
            while (!this.tmp.isDisplayable()) {
                this.tmp = (CWizardPanel)this.panels.elementAt(++this.step);
            }
            this.cardPanel.add(this.tmp);
            this.setTitle(this.tmp.getName());
            if (this.tmp.getPanelImage() != null) {
                this.imageLabel.setIcon(this.tmp.getPanelImage());
            } else if (this.imageLabel.getIcon() != this.wizardImg) {
                this.imageLabel.setIcon(this.wizardImg);
            }
            this.getContentPane().add((Component)this.cardPanel, "Center");
            this.cardPanel.revalidate();
            this.tmp.repaint();
            if (this.hasMoreBackPanels() && !this.prevB.isEnabled()) {
                this.prevB.setEnabled(true);
            }
            this.lieButton(this.prevB);
            this.nextB.setEnabled(this.tmp.isInfoFilled());
            this.updateNextButtonIcons();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void showFirstPanel() {
        this.getContentPane().remove(this.cardPanel);
        this.cardPanel.removeAll();
        this.tmp = (CWizardPanel)this.panels.firstElement();
        this.step = 0;
        if (this.hasMorePanels() || this.tmp.isDisplayable()) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            this.tmp = (CWizardPanel)this.panels.elementAt(++this.step);
lbl8:
            // 2 sources

            ** while (!this.tmp.isDisplayable())
        }
lbl9:
        // 1 sources

        this.cardPanel.add(this.tmp);
        if (this.tmp.getPanelImage() != null) {
            this.imageLabel.setIcon(this.tmp.getPanelImage());
        } else if (this.imageLabel.getIcon() != this.wizardImg) {
            this.imageLabel.setIcon(this.wizardImg);
        }
        this.nextB.requestFocus();
        this.setTitle(this.tmp.getName());
        this.getContentPane().add((Component)this.cardPanel, "Center");
        this.cardPanel.revalidate();
        this.tmp.repaint();
        this.prevB.setEnabled(false);
        this.nextB.setEnabled(this.tmp.isInfoFilled());
        this.updateNextButtonIcons();
        this.lieButton(this.nextB);
    }

    public void showPreviousPanel() {
        this.getContentPane().remove(this.cardPanel);
        this.cardPanel.removeAll();
        this.tmp = (CWizardPanel)this.panels.elementAt(--this.step);
        while (!this.tmp.isDisplayable() && this.step > 0) {
            this.tmp = (CWizardPanel)this.panels.elementAt(--this.step);
        }
        this.cardPanel.add(this.tmp);
        if (this.tmp.getPanelImage() != null) {
            this.imageLabel.setIcon(this.tmp.getPanelImage());
        } else if (this.imageLabel.getIcon() != this.wizardImg) {
            this.imageLabel.setIcon(this.wizardImg);
        }
        this.setTitle(this.tmp.getName());
        this.getContentPane().add((Component)this.cardPanel, "Center");
        this.cardPanel.revalidate();
        this.tmp.repaint();
        if (this.step == 0 || !this.hasMoreBackPanels()) {
            this.prevB.setEnabled(false);
        }
        this.updateNextButtonIcons();
        this.nextB.setEnabled(true);
        this.lieButton(this.nextB);
    }

    public boolean showPanel(int index) {
        if (index < 0 || index > this.panels.size() - 1) {
            return false;
        }
        this.tmp = (CWizardPanel)this.panels.elementAt(index);
        if (!this.tmp.isDisplayable()) {
            return false;
        }
        this.step = index;
        this.getContentPane().remove(this.cardPanel);
        this.cardPanel.removeAll();
        this.cardPanel.add(this.tmp);
        if (this.tmp.getPanelImage() != null) {
            this.imageLabel.setIcon(this.tmp.getPanelImage());
        } else if (this.imageLabel.getIcon() != this.wizardImg) {
            this.imageLabel.setIcon(this.wizardImg);
        }
        this.nextB.requestFocus();
        this.setTitle(this.tmp.getName());
        this.getContentPane().add((Component)this.cardPanel, "Center");
        this.cardPanel.revalidate();
        this.tmp.repaint();
        if (!this.hasMoreBackPanels()) {
            this.prevB.setEnabled(false);
        } else {
            this.prevB.setEnabled(true);
        }
        this.nextB.setEnabled(this.tmp.isInfoFilled());
        this.updateNextButtonIcons();
        this.lieButton(this.nextB);
        return true;
    }

    private boolean hasMoreBackPanels() {
        int i = this.step - 1;
        while (i >= 0) {
            if (((CWizardPanel)this.panels.elementAt(i)).isDisplayable()) {
                return true;
            }
            --i;
        }
        return false;
    }

    public JButton getNextButton() {
        return this.nextB;
    }

    public void setNextButton(JButton button) {
        if (this.nextB != button) {
            this.userNextButton = true;
        }
        this.nextB = this.setNewButton(this.nextB, button);
    }

    public void restoreDefaultNextButton() {
        this.setNextButton(this.defNextB);
        this.userNextButton = false;
    }

    public JButton getPreviousButton() {
        return this.prevB;
    }

    public void setPreviousButton(JButton button) {
        this.prevB = this.setNewButton(this.prevB, button);
    }

    public void restoreDefaultPreviousButton() {
        this.setPreviousButton(this.defPrevB);
    }

    public JButton getHelpButton() {
        return this.helpB;
    }

    public void setHelpButton(JButton button) {
        this.helpB = this.setNewButton(this.helpB, button);
    }

    public void restoreDefaultHelpButton() {
        this.setHelpButton(this.defHelpB);
    }

    public JButton getFinishButton() {
        return this.finishB;
    }

    public void setFinishButton(JButton button) {
        this.finishB = this.setNewButton(this.finishB, button);
    }

    public void restoreDefaultFinishButton() {
        this.setFinishButton(this.defFinishB);
    }

    public JButton getExitButton() {
        return this.exitB;
    }

    public void setExitButton(JButton button) {
        this.exitB = this.setNewButton(this.exitB, button);
    }

    public void restoreDefaultExitButton() {
        this.setExitButton(this.defExitB);
    }

    public void restoreAllDefaultButtons() {
        this.restoreDefaultPreviousButton();
        this.restoreDefaultNextButton();
        this.restoreDefaultFinishButton();
        this.restoreDefaultExitButton();
        this.restoreDefaultHelpButton();
    }

    private int getPositionOf(JButton button) {
        int len = this.buttonPanel.getComponentCount();
        int i = 0;
        while (i < len) {
            if (this.buttonPanel.getComponent(i) == button) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private JButton setNewButton(JButton button, JButton newButton) {
        int pos = this.getPositionOf(button);
        if (pos >= 0) {
            this.buttonPanel.remove(pos);
            button.removeActionListener(this);
            newButton.addActionListener(this);
            this.buttonPanel.add((Component)newButton, pos);
            this.buttonPanel.updateUI();
            return newButton;
        }
        return button;
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.prevB) {
            this.previousPressed();
        } else if (o == this.nextB) {
            this.nextPressed();
        } else if (o == this.exitB) {
            this.exitWizard();
        } else if (o == this.finishB) {
            this.finishPressed();
        } else if (o == this.helpB) {
            this.helpPressed();
        }
    }

    protected void setNextButtonIcons() {
        if (this.userNextButton) {
            return;
        }
        if (this.nextB.getIcon() != this.nextN) {
            this.nextB.setIcon(this.nextN);
            this.nextB.setRolloverIcon(this.nextL);
            this.nextB.setDisabledIcon(this.nextG);
            this.nextB.setPressedIcon(this.nextP);
            this.nextB.setSelectedIcon(this.nextL);
        }
    }

    protected void setNextButtonFinishIcons() {
        if ((this.wizardType & 2) > 0) {
            this.nextB.setEnabled(false);
        } else {
            if (this.userFinishIcons) {
                this.nextB.setIcon(this.userN);
                this.nextB.setRolloverIcon(this.userL);
                this.nextB.setDisabledIcon(this.userG);
                this.nextB.setPressedIcon(this.userP);
                return;
            }
            if (this.finishButtonType == 10) {
                this.nextB.setIcon(this.finishN);
                this.nextB.setRolloverIcon(this.finishL);
                this.nextB.setDisabledIcon(this.finishG);
                this.nextB.setPressedIcon(this.finishP);
            } else {
                this.nextB.setIcon(this.startN);
                this.nextB.setRolloverIcon(this.startL);
                this.nextB.setDisabledIcon(this.startG);
                this.nextB.setPressedIcon(this.startP);
            }
        }
    }

    private void lieButton(Component comp) {
        comp.dispatchEvent(new MouseEvent(comp, 504, new Date().getTime(), 0, 0, 0, 0, false));
        comp.dispatchEvent(new MouseEvent(comp, 505, new Date().getTime(), 0, 0, 0, 0, false));
    }

    public void previousPressed() {
        if (this.step > 0) {
            this.showPreviousPanel();
        }
    }

    public void nextPressed() {
        if (this.step < this.panels.size() - 1 && this.hasMorePanels()) {
            this.showNextPanel();
        } else if ((this.wizardType & 2) == 0) {
            this.finishPressed();
        }
    }

    public boolean hasMorePanels() {
        int len = this.panels.size();
        int i = this.step + 1;
        while (i < len) {
            if (((CWizardPanel)this.panels.elementAt(i)).isDisplayable()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public CWizardPanel getNextPanel() {
        if (this.step < this.panels.size() - 1) {
            return (CWizardPanel)this.panels.elementAt(this.step + 1);
        }
        return null;
    }

    public void setWizardImage(Icon img) {
        this.wizardImg = img;
        this.imageLabel.setIcon(this.wizardImg);
    }

    public Icon getWizardImage() {
        return this.wizardImg;
    }

    public CWizardPanel getCurrentPanel() {
        return (CWizardPanel)this.panels.elementAt(this.step);
    }

    public void clearAllPanels() {
        int len = this.panels.size();
        int i = 0;
        while (i < len) {
            ((CWizardPanel)this.panels.elementAt(i)).resetValues();
            ++i;
        }
    }

    public String getAllInfo() {
        StringBuffer tmp = new StringBuffer(200);
        int len = this.panels.size();
        int i = 0;
        while (i < len) {
            tmp.append(((CWizardPanel)this.panels.elementAt(i)).getInfo());
            ++i;
        }
        return tmp.toString();
    }

    public void showDialog() {
        if (this.panels.size() < 1) {
            JOptionPane.showMessageDialog(this.parent, "There are no installed panels!", "Warning", 2);
            return;
        }
        this.clearAllPanels();
        this.showFirstPanel();
        this.setLocationRelativeTo(this.parent);
        this.show();
    }

    public void updatePanelsUI() {
        int i = 0;
        while (i < this.panels.size()) {
            SwingUtilities.updateComponentTreeUI((CWizardPanel)this.panels.elementAt(i));
            ++i;
        }
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            if (this.exitB.isEnabled()) {
                this.exitWizard();
                e.consume();
            }
        } else if (code == 112) {
            if (this.helpB.isEnabled()) {
                this.helpPressed();
                e.consume();
            }
        } else if (code == 37 && e.isControlDown()) {
            if (this.prevB.isEnabled()) {
                this.previousPressed();
                e.consume();
            }
        } else if (code == 39 && e.isControlDown() && this.nextB.isEnabled()) {
            this.nextPressed();
            e.consume();
        }
    }

    public void helpPressed() {
    }

    public abstract void finishPressed();

    public abstract void exitWizard();

    public class WinL
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            CWizardDialog.this.exitWizard();
        }
    }
}

