/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class CToolBarSeparator
extends JComponent
implements AncestorListener,
PropertyChangeListener {
    private boolean isVertical = true;

    public CToolBarSeparator() {
        this(null);
    }

    public CToolBarSeparator(Dimension size) {
        if (size == null) {
            size = (Dimension)UIManager.get("ToolBar.separatorSize");
            if (size == null) {
                size = new Dimension(10, 24);
            } else {
                size.height = 24;
            }
        }
        this.setPreferredSize(size);
        this.addAncestorListener(this);
        this.updateUI();
    }

    public void setVertical(boolean value) {
        if (value == this.isVertical) {
            return;
        }
        this.isVertical = value;
        this.swapDimension();
        this.repaint();
        this.getParent().repaint();
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void updateUI() {
        this.setBackground(UIManager.getColor("Separator.background"));
        this.setForeground(UIManager.getColor("Separator.foreground"));
    }

    public void setBounds(int x, int y, int width, int height) {
        Dimension size = this.getPreferredSize();
        height = size.height;
        width = size.width;
        super.setBounds(x, y, width, height);
    }

    public void paint(Graphics g) {
        Dimension size = this.getPreferredSize();
        int x = size.width / 2 - 1;
        int y = size.height / 2 - 1;
        if (this.isVertical) {
            g.setColor(this.getForeground());
            g.drawLine(x, 0, x, size.height);
            g.setColor(this.getBackground());
            g.drawLine(x + 1, 0, x + 1, size.height);
        } else {
            g.setColor(this.getForeground());
            g.drawLine(0, y, size.width, y);
            g.setColor(this.getBackground());
            g.drawLine(0, y + 1, size.width, y + 1);
        }
    }

    public void ancestorRemoved(AncestorEvent e) {
        if (e.getAncestorParent() != null) {
            e.getAncestorParent().removePropertyChangeListener(this);
        }
    }

    public void ancestorAdded(AncestorEvent e) {
        if (e.getAncestorParent() != null) {
            ((Component)e.getAncestorParent()).addPropertyChangeListener(this);
        }
    }

    public void ancestorMoved(AncestorEvent e) {
    }

    private void swapDimension() {
        this.setPreferredSize(new Dimension(this.getPreferredSize().height, this.getPreferredSize().width));
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() instanceof JToolBar) {
            this.setVertical(((JToolBar)e.getSource()).getOrientation() == 0);
        }
    }
}

