/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.lf.LookAndFeelListener;
import com.sap.engine.gui.resource.GuiResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class CMessageDialog
extends CEscapeDialog
implements ActionListener,
LookAndFeelListener {
    private JButton okButton;
    private JButton detailButton;
    private JTextArea messageTextArea;
    private JScrollPane messageScrollPane;
    private JPanel messagePanel;
    private JTextArea detailTextArea;
    private JScrollPane detailScrollPane;
    private JPanel detailPanel;
    private JPanel textPanel;
    private JPanel scrollPanel;
    private JPanel buttonsSubPanel;
    private JPanel buttonsPanel;
    private JPanel mainPanel;
    private JPanel detailTextPanel;
    private String detail;
    private JLabel iconLabel;
    private JPanel iconPanel;
    private Frame parentFrame;
    private String detailsStr = GuiResourceManager.getResourceString("DetailsButton", "Details");
    private String noDetailsStr = GuiResourceManager.getResourceString("NoDetailsButton", "No Details");
    Border border = BorderFactory.createEmptyBorder(10, 10, 5, 10);
    Border detailBorder = BorderFactory.createEmptyBorder(10, 0, 0, 0);
    Border scrollBorder = BorderFactory.createEmptyBorder(10, 10, 5, 25);
    Border borderButtonsPanel = BorderFactory.createEmptyBorder(5, 60, 5, 60);
    Border borderIconPanel = BorderFactory.createEmptyBorder(10, 10, 5, 10);
    Border borderDetailPanel = BorderFactory.createEmptyBorder(10, 0, 5, 0);
    Border etchedBorder = BorderFactory.createEtchedBorder();
    Border messageBorder = BorderFactory.createTitledBorder(this.etchedBorder, GuiResourceManager.getResourceString("MESSAGE_LABEL", "Message"));
    Border detailsBorder = BorderFactory.createTitledBorder(this.etchedBorder, GuiResourceManager.getResourceString("DETAILS_LABEL", "Details"));
    Icon errorIcon = new ImageIcon(this.getClass().getResource("messagedialog/error.gif"));
    Icon warningIcon = new ImageIcon(this.getClass().getResource("messagedialog/warn.gif"));
    Icon informIcon = new ImageIcon(this.getClass().getResource("messagedialog/inform.gif"));
    protected static CMessageDialog aMessageDialog;

    protected CMessageDialog(Frame parentFrame) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.errorDialogInit();
    }

    public static CMessageDialog getInstance(Frame parentFrame) {
        if (aMessageDialog == null) {
            aMessageDialog = new CMessageDialog(parentFrame);
        }
        return aMessageDialog;
    }

    void errorDialogInit() {
        this.textPanel = new JPanel(new BorderLayout());
        this.buttonsPanel = new JPanel(new BorderLayout());
        this.buttonsSubPanel = new JPanel(new GridLayout(1, 2, 20, 10));
        this.mainPanel = new JPanel(new BorderLayout());
        this.detailTextPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        this.detailTextPanel.setBorder(this.borderDetailPanel);
        this.iconPanel = new JPanel(new BorderLayout());
        this.iconLabel = new JLabel();
        this.iconPanel.add((Component)this.iconLabel, "North");
        this.iconPanel.setBorder(this.borderIconPanel);
        this.buttonsPanel.setBorder(this.borderButtonsPanel);
        this.messageTextArea = new JTextArea();
        this.detailTextArea = new JTextArea();
        this.textPanel.setBorder(this.border);
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setOpaque(false);
        this.detailTextArea.setEditable(false);
        this.detailTextArea.setOpaque(false);
        this.messageScrollPane = new JScrollPane(this.messageTextArea);
        this.messageScrollPane.setPreferredSize(new Dimension(250, 60));
        this.messagePanel = new JPanel(new BorderLayout());
        this.messagePanel.setBorder(this.messageBorder);
        this.messagePanel.add((Component)this.messageScrollPane, "Center");
        this.okButton = new JButton();
        this.detailButton = new JButton();
        this.okButton.setText(GuiResourceManager.getResourceString("OK_Button", "OK"));
        this.okButton.addActionListener(this);
        this.detailButton.setText(this.detailsStr);
        this.detailButton.addActionListener(this);
        this.buttonsSubPanel.add(this.okButton);
        this.buttonsSubPanel.add(this.detailButton);
        this.buttonsPanel.add((Component)this.buttonsSubPanel, "Center");
        this.detailScrollPane = new JScrollPane(this.detailTextArea);
        this.detailScrollPane.setPreferredSize(new Dimension(250, 60));
        this.detailPanel = new JPanel(new BorderLayout());
        this.detailPanel.setBorder(this.detailsBorder);
        this.detailPanel.add((Component)this.detailScrollPane, "Center");
        this.scrollPanel = new JPanel(new BorderLayout());
        this.scrollPanel.setBorder(this.scrollBorder);
        this.scrollPanel.add((Component)this.messagePanel, "North");
        this.scrollPanel.add((Component)this.detailPanel, "Center");
        this.mainPanel.add((Component)this.scrollPanel, "Center");
        this.mainPanel.add((Component)this.buttonsPanel, "South");
        this.mainPanel.add((Component)this.iconPanel, "West");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.okButton) {
            this.okButton_actionPerformed();
        } else if (obj == this.detailButton) {
            this.detailButton_actionPerformed();
        }
    }

    void okButton_actionPerformed() {
        ((Component)this).setVisible(false);
    }

    void detailButton_actionPerformed() {
        String details = this.detailTextArea.getText();
        if (details.equals("")) {
            this.detailPanel.setVisible(true);
            this.detailScrollPane.setVisible(true);
            this.detailTextArea.setText(this.detail);
            this.detailButton.setText(this.noDetailsStr);
            this.pack();
        } else {
            this.detailPanel.setVisible(false);
            this.detailScrollPane.setVisible(false);
            this.detail = details;
            this.detailTextArea.setText("");
            this.detailButton.setText(this.detailsStr);
            this.pack();
        }
        this.detailTextArea.setEditable(false);
        this.messageScrollPane.validate();
        this.detailScrollPane.validate();
        this.validate();
        this.pack();
    }

    public void showErrorDialog(String message, String detail) {
        this.setTitle(GuiResourceManager.getResourceString("ERROR", "Error"));
        this.iconLabel.setIcon(this.errorIcon);
        this.detailTextArea.setText("");
        this.messageTextArea.setText(message);
        this.messageScrollPane.validate();
        this.detailScrollPane.validate();
        this.validate();
        if (detail != null && detail != "") {
            this.detailPanel.setVisible(false);
            this.detailScrollPane.setVisible(false);
            this.detailButton.setEnabled(true);
            this.detail = detail;
        } else {
            detail = null;
            this.detailPanel.setVisible(false);
            this.detailScrollPane.setVisible(false);
            this.detailButton.setEnabled(false);
        }
        this.pack();
        this.setLocationRelativeTo(this.parentFrame);
        this.detailButton.setText(this.detailsStr);
        this.messageTextArea.setEditable(false);
        this.detailTextArea.setEditable(false);
        ((Component)this).setVisible(true);
    }

    public void showWarningDialog(String message, String detail) {
        this.setTitle(GuiResourceManager.getResourceString("WARNING", "Warning"));
        this.iconLabel.setIcon(this.warningIcon);
        this.messageTextArea.setText(message);
        this.detailTextArea.setText("");
        this.messageScrollPane.validate();
        this.detailScrollPane.validate();
        this.validate();
        if (detail != null && detail != "") {
            this.detailPanel.setVisible(false);
            this.detailScrollPane.setVisible(false);
            this.detailButton.setEnabled(true);
            this.detail = detail;
        } else {
            detail = null;
            this.detailPanel.setVisible(false);
            this.detailScrollPane.setVisible(false);
            this.detailButton.setEnabled(false);
        }
        this.pack();
        this.setLocationRelativeTo(this.parentFrame);
        this.detailButton.setText(this.detailsStr);
        this.messageTextArea.setEditable(false);
        this.detailTextArea.setEditable(false);
        this.show();
    }

    public void showInformDialog(String message, String detail) {
        this.setTitle(GuiResourceManager.getResourceString("INFORM", "Information"));
        this.iconLabel.setIcon(this.informIcon);
        this.detailTextArea.setText("");
        this.messageTextArea.setText(message);
        this.messageScrollPane.validate();
        this.detailScrollPane.validate();
        this.validate();
        if (detail != null && detail != "") {
            this.detailPanel.setVisible(false);
            this.detailScrollPane.setVisible(false);
            this.detailButton.setEnabled(true);
            this.detail = detail;
        } else {
            detail = null;
            this.detailPanel.setVisible(false);
            this.detailScrollPane.setVisible(false);
            this.detailButton.setEnabled(false);
        }
        this.pack();
        this.setLocationRelativeTo(this.parentFrame);
        this.detailButton.setText(this.detailsStr);
        this.messageTextArea.setEditable(false);
        this.detailTextArea.setEditable(false);
        ((Component)this).setVisible(true);
    }

    public void lookAndFeelChanged() {
        SwingUtilities.updateComponentTreeUI(this);
    }
}

