/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.filechooser.DefaultFileSorter;
import com.sap.engine.gui.filechooser.DefaultFileSystem;
import com.sap.engine.gui.filechooser.DriveObject;
import com.sap.engine.gui.filechooser.FCFile;
import com.sap.engine.gui.filechooser.FCFileSorter;
import com.sap.engine.gui.filechooser.FileChooserListener;
import com.sap.engine.gui.filechooser.FileFilter;
import com.sap.engine.gui.filechooser.FileListException;
import com.sap.engine.gui.filechooser.FileObject;
import com.sap.engine.gui.filechooser.FileSystem;
import com.sap.engine.gui.filechooser.ui.FileChooserUI;
import com.sap.engine.gui.filechooser.ui.StandardFileChooserUI;
import com.sap.engine.gui.lf.LookAndFeelHandler;
import com.sap.engine.gui.lf.LookAndFeelListener;
import com.sap.engine.lib.io.FileUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class CFileChooser
extends CEscapeDialog
implements FileChooserListener,
LookAndFeelListener {
    public static final int FILE = 0;
    public static final int DIRECTORY = 1;
    public static String HOME_DIR;
    public static String CUR_DIR;
    public static String LAST_DIR;
    public static String PROJ_DIR;
    protected static CFileChooser fileChooser;
    protected Frame parentF;
    protected FileChooserUI fcUI;
    protected FileSystem fSystem;
    protected DriveObject[] drvObject;
    protected Vector filters = new Vector();
    protected FileObject curDir;
    protected int curType = 0;
    protected boolean isOkPressed;
    protected String fileSep;
    protected boolean doSort = true;
    protected FCFileSorter fSorter;

    public static synchronized CFileChooser getInstance(Frame parent) {
        if (fileChooser == null) {
            fileChooser = PROJ_DIR == null ? new CFileChooser(parent) : new CFileChooser(parent, PROJ_DIR);
        }
        return fileChooser;
    }

    public CFileChooser(Frame frame) {
        super(frame, true);
        this.parentF = frame;
        this.fcUI = new StandardFileChooserUI(this);
        this.fSystem = new DefaultFileSystem();
        this.drvObject = this.fSystem.getSystemDrives();
        this.fcUI.setDriveList(this.drvObject);
        this.addFileFilter(new FileFilter("All Files (*.*)", "*"));
        this.fSorter = new DefaultFileSorter();
        HOME_DIR = this.fSystem.getHomeDirectory();
        LAST_DIR = CUR_DIR = this.fSystem.getUserDirectory();
        if (PROJ_DIR == null) {
            PROJ_DIR = LAST_DIR;
        }
        this.curDir = this.fSystem.getFile(HOME_DIR);
        this.fileSep = this.fSystem.getFileSeparator();
        LookAndFeelHandler.addLookAndFeelListener(this);
        this.getContentPane().add(this.fcUI);
    }

    public CFileChooser(Frame frame, String prjDir) {
        super(frame, true);
        this.parentF = frame;
        this.fcUI = new StandardFileChooserUI(this);
        this.fSystem = new DefaultFileSystem();
        this.drvObject = this.fSystem.getSystemDrives();
        this.fcUI.setDriveList(this.drvObject);
        this.addFileFilter(new FileFilter("All Files (*.*)", "*"));
        this.fSorter = new DefaultFileSorter();
        HOME_DIR = this.fSystem.getHomeDirectory();
        LAST_DIR = CUR_DIR = this.fSystem.getUserDirectory();
        PROJ_DIR = prjDir;
        this.curDir = this.fSystem.getFile(HOME_DIR);
        this.fileSep = this.fSystem.getFileSeparator();
        LookAndFeelHandler.addLookAndFeelListener(this);
        this.getContentPane().add(this.fcUI);
    }

    public void reinit() {
        this.filters.removeAllElements();
        this.addFileFilter(new FileFilter("All Files (*.*)", "*"));
    }

    public void addFileFilter(FileFilter filter) {
        if (!this.filtersContains(filter)) {
            this.filters.addElement(filter);
        }
    }

    public void insertFileFilterAt(FileFilter filter, int index) {
        if (!this.filtersContains(filter)) {
            this.filters.insertElementAt(filter, index);
        }
    }

    public void addFileFilter(String description, String ext) {
        FileFilter filter = new FileFilter(description, ext);
        if (!this.filtersContains(filter)) {
            this.filters.addElement(filter);
        }
    }

    public void insertFileFilterAt(String description, String ext, int index) {
        FileFilter filter = new FileFilter(description, ext);
        if (!this.filtersContains(filter)) {
            this.filters.insertElementAt(filter, index);
        }
    }

    private boolean filtersContains(FileFilter filter) {
        int i = 0;
        while (i < this.filters.size()) {
            if (((FileFilter)this.filters.elementAt(i)).getDescription().equals(filter.getDescription())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeFileFilter(FileFilter filter) {
        this.filters.removeElement(filter);
    }

    public void removeFileFilter(int index) {
        this.filters.removeElementAt(index);
    }

    public FileFilter getSelectedFileFilter() {
        return this.fcUI.getSelectedFileFilter();
    }

    public String[] showFileDialog(String title, boolean multipleSelection) {
        return this.showFileDialog(title, PROJ_DIR, multipleSelection);
    }

    public String[] showFileDialog(String title, String dirType, boolean multipleSelection) {
        return this.showDialog(title, dirType, multipleSelection, "", 0);
    }

    public String[] showFileDialog(String title, boolean multipleSelection, String initFile) {
        return this.showDialog(title, PROJ_DIR, multipleSelection, initFile, 0);
    }

    public String[] showDirDialog(String title, boolean multipleSelection) {
        return this.showDirDialog(title, PROJ_DIR, multipleSelection);
    }

    public String[] showDirDialog(String title, String dirType, boolean multipleSelection) {
        return this.showDialog(title, dirType, multipleSelection, "", 1);
    }

    public String[] showDirDialog(String title, boolean multipleSelection, String initFile) {
        return this.showDialog(title, PROJ_DIR, multipleSelection, initFile, 0);
    }

    public String[] showDialog(String title, String dirType, boolean multipleSelection, String initFileName, int type) {
        String[] selFiles;
        if (title != null) {
            this.setTitle(title);
        }
        if (dirType == null) {
            dirType = HOME_DIR;
        }
        if (dirType.equals(HOME_DIR)) {
            this.curDir = this.fSystem.getFile(HOME_DIR);
        } else if (dirType.equals(CUR_DIR)) {
            this.curDir = this.fSystem.getFile(CUR_DIR);
        } else if (dirType.equals(LAST_DIR)) {
            this.curDir = this.fSystem.getFile(LAST_DIR);
        } else {
            this.curDir = this.fSystem.getFile(dirType);
            if (!this.curDir.exists()) {
                JOptionPane.showMessageDialog(this.parentF, "Directory not found !", "Warning", 2);
                return null;
            }
        }
        try {
            while (!this.curDir.exists()) {
                this.curDir = this.fSystem.getFile(this.curDir.getParent());
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.parentF, "Disk error !", "Warning", 2);
            return null;
        }
        this.fcUI.setMultipleSelectionEnabled(multipleSelection);
        this.curType = type;
        this.fcUI.setFileChooserType(this.curType);
        Object[] fFilters = new FileFilter[this.filters.size()];
        this.filters.copyInto(fFilters);
        this.fcUI.setFileFilters((FileFilter[])fFilters);
        this.fcUI.setSelectedFileFilter((FileFilter)fFilters[this.filters.size() - 1]);
        this.setCurrentDriveObject();
        this.setCurrentDirectory(this.curDir);
        if (initFileName != null) {
            this.fcUI.setFileName(initFileName);
        } else {
            this.fcUI.setFileName("");
        }
        do {
            this.isOkPressed = false;
            this.pack();
            this.setLocationRelativeTo(this.parentF);
            ((Component)this).setVisible(true);
            if (!this.isOkPressed) {
                return null;
            }
            LAST_DIR = this.curDir.getPath();
            selFiles = this.fcUI.getSelectedFileNames();
            if (FileUtils.isCorrectFileName(selFiles[0])) continue;
            JOptionPane.showMessageDialog(this.parentF, "The name contains forbiden symbols!", "Warning", 0);
        } while (!FileUtils.isCorrectFileName(selFiles[0]));
        String cDir = this.curDir.getPath();
        if (!cDir.endsWith(this.fileSep)) {
            cDir = cDir + this.fileSep;
        }
        String[] res = new String[selFiles.length];
        int i = 0;
        while (i < res.length) {
            res[i] = cDir + selFiles[i];
            ++i;
        }
        return res;
    }

    protected void setCurrentDirectory(FileObject newDir) {
        this.setCursor(new Cursor(3));
        FileFilter filter = this.fcUI.getSelectedFileFilter();
        FCFile[] files = null;
        try {
            files = this.curType == 1 ? newDir.listDirs() : newDir.list(filter);
        }
        catch (FileListException ex) {
            this.setCursor(new Cursor(0));
            JOptionPane.showMessageDialog(this.parentF, ex.getMessage(), "Warning", 2);
            return;
        }
        this.curDir = newDir;
        if (this.doSort) {
            this.fSorter.sort(files);
        }
        this.fcUI.setFileList(files);
        this.fcUI.setCurrentDirectory(this.curDir.getPath());
        this.setCursor(new Cursor(0));
    }

    protected void setCurrentDriveObject() {
        String cDir = this.curDir.getPath();
        String drv = cDir.substring(0, cDir.indexOf(this.fileSep) + 1);
        int i = 0;
        while (i < this.drvObject.length) {
            if (this.drvObject[i].getName().equals(drv)) {
                this.fcUI.setCurrentDrive(this.drvObject[i]);
                break;
            }
            ++i;
        }
    }

    public void setFileSorter(FCFileSorter fs) {
        this.fSorter = null;
        this.fSorter = fs;
    }

    public FCFileSorter getFileSorter() {
        return this.fSorter;
    }

    public void setSorting(boolean s) {
        this.doSort = s;
    }

    public boolean isSorting() {
        return this.doSort;
    }

    public FileChooserUI getUI() {
        return this.fcUI;
    }

    public void setUI(FileChooserUI ui) {
        this.getContentPane().remove(this.fcUI);
        this.fcUI = ui;
        this.getContentPane().add(this.fcUI);
        this.fcUI.setFileChooserListener(this);
    }

    public FileSystem getFileSystem() {
        return this.fSystem;
    }

    public void setFileSystem(FileSystem fs) {
        this.fSystem = fs;
        this.drvObject = this.fSystem.getSystemDrives();
        this.fcUI.setDriveList(this.drvObject);
        HOME_DIR = this.fSystem.getHomeDirectory();
        CUR_DIR = this.fSystem.getUserDirectory();
        LAST_DIR = HOME_DIR;
        this.curDir = this.fSystem.getFile(HOME_DIR);
        this.fileSep = this.fSystem.getFileSeparator();
    }

    public void commandPerformed(String cmd) {
        if (cmd.equals("UP_CMD")) {
            this.goUp();
        } else if (cmd.equals("HOME_CMD")) {
            this.goHome();
        } else if (cmd.equals("MKDIR_CMD")) {
            this.mkDir();
        } else if (cmd.equals("DRIVE_CMD")) {
            this.drvChange();
        } else if (cmd.equals("OK_CMD")) {
            this.okAct();
        } else if (cmd.equals("CANCEL_CMD")) {
            this.canAct();
        } else if (cmd.equals("FILTER_CHNG_CMD")) {
            this.filterChange();
        } else if (cmd.equals("DIR_CHNG_CMD")) {
            this.dirChanged();
        } else if (cmd.equals("DELETE_CMD")) {
            this.delete();
        } else if (cmd.equals("RENAME_CMD")) {
            this.rename();
        }
    }

    protected void goUp() {
        FileObject fObj = this.fSystem.getFile(this.curDir.getParent());
        if (fObj == null) {
            return;
        }
        this.setCurrentDirectory(fObj);
    }

    protected void goHome() {
        this.setCurrentDriveObject();
        this.setCurrentDirectory(this.fSystem.getFile(HOME_DIR));
    }

    protected void mkDir() {
        String answer = JOptionPane.showInputDialog(this.parentF, "Please Enter Folder Name: ", "New Folder", 3);
        if (answer == null) {
            return;
        }
        String cDir = this.curDir.getPath();
        if (!cDir.endsWith(this.fileSep)) {
            cDir = cDir + this.fileSep;
        }
        if (!this.fSystem.createDirectory(cDir + answer)) {
            JOptionPane.showMessageDialog(this.parentF, "Could not Create Folder !", "Warning", 2);
        } else {
            this.setCurrentDirectory(this.curDir);
        }
    }

    protected void drvChange() {
        String newDir = this.fcUI.getSelectedDrive().getName();
        FileObject newF = this.fSystem.getFile(newDir);
        if (!newF.exists()) {
            JOptionPane.showMessageDialog(this.parentF, "Drive not ready !", "Warning", 2);
            this.setCurrentDriveObject();
            return;
        }
        this.setCurrentDirectory(newF);
    }

    protected void okAct() {
        String[] files = this.fcUI.getSelectedFileNames();
        if (files.length == 0) {
            return;
        }
        if (files.length == 1) {
            File tempF;
            if (files[0].length() == 2 && files[0].charAt(1) == ':') {
                files[0] = files[0] + File.separator;
            }
            if ((tempF = new File(files[0])).isAbsolute()) {
                if (tempF.exists() && tempF.isDirectory()) {
                    if (!files[0].endsWith(this.fileSep)) {
                        files[0] = files[0] + this.fileSep;
                    }
                    FileObject newF = this.fSystem.getFile(files[0]);
                    String post = "";
                    if (files[0].length() > 1 && files[0].charAt(1) == ':') {
                        post = ":" + File.separator;
                    }
                    String tempS = files[0].charAt(0) + post;
                    tempS = tempS.toUpperCase();
                    DriveObject[] dobj = this.fSystem.getSystemDrives();
                    int i = 0;
                    while (i < dobj.length) {
                        if (dobj[i].getName().equalsIgnoreCase(tempS)) {
                            this.fcUI.setSelectedDrive(i);
                            break;
                        }
                        ++i;
                    }
                    this.setCurrentDirectory(newF);
                    this.fcUI.clearTextField();
                    return;
                }
                JOptionPane.showMessageDialog(this.parentF, "Drive Not Ready!", "Warnng", 2);
                this.fcUI.clearTextField();
                return;
            }
        }
        this.isOkPressed = true;
        this.dispose();
    }

    protected void canAct() {
        this.dispose();
    }

    protected void filterChange() {
        this.setCurrentDirectory(this.curDir);
    }

    protected void dirChanged() {
        String chngDir = this.fcUI.getChangedDir();
        String cDir = this.curDir.getPath();
        if (!cDir.endsWith(this.fileSep)) {
            cDir = cDir + this.fileSep;
        }
        this.setCurrentDirectory(this.fSystem.getFile(cDir + chngDir));
    }

    protected void delete() {
        Object[] files = this.fcUI.getList().getSelectedValues();
        String[] filenames = new String[files.length];
        String cDir = this.curDir.getPath();
        if (!cDir.endsWith(this.fileSep)) {
            cDir = cDir + this.fileSep;
        }
        int i = 0;
        while (i < files.length) {
            filenames[i] = cDir + ((FCFile)files[i]).toString();
            ++i;
        }
        String message = files.length > 1 ? "Are you sure you want to delete these files?" : "Are you sure you want to delete this file?";
        int answer = JOptionPane.showConfirmDialog(this.parentF, message, "Delete?", 0);
        if (answer == 0) {
            boolean successful = this.fSystem.deleteFile(filenames);
            if (!successful) {
                JOptionPane.showMessageDialog(this.parentF, "Could not delete one or more files.", "Warning", 2);
            } else {
                this.setCurrentDirectory(this.curDir);
            }
        }
    }

    protected void rename() {
        boolean res;
        String filename = ((FCFile)this.fcUI.getList().getSelectedValue()).toString();
        String answer = JOptionPane.showInputDialog(this.parentF, "Rename " + filename + " to:", "Rename", 3);
        if (answer == null || answer.equals("")) {
            return;
        }
        String cDir = this.curDir.getPath();
        if (!cDir.endsWith(this.fileSep)) {
            cDir = cDir + this.fileSep;
        }
        if (res = this.fSystem.setFileName(cDir + filename, cDir + answer)) {
            this.setCurrentDirectory(this.curDir);
        }
    }

    public void lookAndFeelChanged() {
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void setProjectDirectory(String prjDir) {
        PROJ_DIR = prjDir;
    }

    public static void main(String[] args) {
        CFileChooser fChooser = CFileChooser.getInstance(new JFrame());
        FileFilter filter = new FileFilter("Standard Project (.psp)", ".htm,.html");
        String[] answer = fChooser.showFileDialog("Save", true, "NewProject1.psp");
        System.exit(0);
    }

    static {
        fileChooser = null;
    }
}

