/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.gui;

import com.sap.engine.gui.CFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class AdditionalTab
extends JPanel
implements ActionListener {
    private JFrame frame;
    private JDialog dialog;
    private JDialog inputDialog;
    private JCheckBox checkBox;
    private Properties property;
    private int countOfCheckBoxes = 0;
    private String nameFromTextField;
    private String classFromTextField;
    private Vector allTabs;
    private JTextField nameTextField;
    private JTextField classPathTextField;
    private JTextField browserField;
    private JButton brwButton;
    private Vector tabPlusPath;
    private JPanel tabsPanel;
    private JPanel browserPanel;
    private JPanel transferPanel;
    private JCheckBox transferCheckBox;
    private CFileChooser chooser;
    private boolean adding;

    public AdditionalTab(Properties property, JFrame frame, JDialog dialog) {
        this.property = property;
        this.frame = frame;
        this.dialog = dialog;
        this.allTabs = new Vector();
        this.initialization(property);
    }

    private void initialization(Properties property) {
        this.setLayout(new BorderLayout());
        this.tabsPanel = new JPanel();
        this.browserPanel = new JPanel();
        this.transferPanel = new JPanel();
        this.transferPanel.setLayout(new BorderLayout());
        this.transferCheckBox = new JCheckBox("Enable transfer between tabs", true);
        this.transferPanel.add(this.transferCheckBox);
        this.brwButton = new JButton();
        this.brwButton.setText("...");
        this.brwButton.setPreferredSize(new Dimension(25, 25));
        this.brwButton.setActionCommand("Browser");
        this.brwButton.addActionListener(this);
        this.browserField = new JTextField();
        this.browserField.setPreferredSize(new Dimension(200, 25));
        this.browserPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Browser"));
        this.browserPanel.setLayout(new GridBagLayout());
        this.browserPanel.add((Component)new JLabel("Path: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.browserPanel.add((Component)this.browserField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.browserPanel.add((Component)this.brwButton, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.chooser = new CFileChooser(this.frame);
        this.tabsPanel.setLayout(new GridBagLayout());
        this.tabsPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Tabs"));
        String availableTabs = "";
        if (property != null) {
            availableTabs = property.getProperty("AvailableTabs");
            this.browserField.setText(property.getProperty("BrowserPath"));
        }
        this.tabPlusPath = new Vector();
        if (property != null) {
            if (property.getProperty("TransferBetweenTabs") != null) {
                if (property.getProperty("TransferBetweenTabs").equals("true")) {
                    this.transferCheckBox.setSelected(true);
                } else {
                    this.transferCheckBox.setSelected(false);
                }
            }
            if (availableTabs != null && !availableTabs.equals(null) && !availableTabs.trim().equals("") && availableTabs.trim() != "") {
                this.insertCheckBoxes(availableTabs);
            }
        }
        this.add((Component)this.browserPanel, "North");
        this.add((Component)this.transferPanel, "South");
        this.add((Component)this.tabsPanel, "Center");
    }

    private boolean isInDefaultTabs(String tab) {
        boolean result = false;
        String defaultTabs = this.property.getProperty("DefaultTabs");
        StringTokenizer dt = new StringTokenizer(defaultTabs, ";");
        while (dt.hasMoreTokens()) {
            if (!tab.equals(dt.nextToken())) continue;
            result = true;
        }
        return result;
    }

    private void insertCheckBoxes(String availableTabs) {
        StringTokenizer at = new StringTokenizer(availableTabs, ";");
        this.countOfCheckBoxes = at.countTokens();
        String curentTab = "";
        int i = 0;
        while (i < this.countOfCheckBoxes) {
            curentTab = at.nextToken();
            if (curentTab.endsWith("Components") && !curentTab.endsWith(" Components")) {
                curentTab = curentTab.substring(0, curentTab.indexOf("Components")) + " Components";
            }
            this.checkBox = new JCheckBox(curentTab, this.isInDefaultTabs(curentTab));
            this.allTabs.add(this.checkBox);
            this.tabsPanel.add((Component)this.checkBox, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            ++i;
        }
    }

    public Vector getVector() {
        return this.allTabs;
    }

    public Vector getAddedTabs() {
        return this.tabPlusPath;
    }

    public String getBrowserPath() {
        return this.browserField.getText();
    }

    public boolean getTransferTabsStatus() {
        return this.transferCheckBox.isSelected();
    }

    private boolean checkExistance(String key) {
        if (this.property != null || this.adding) {
            int i = 0;
            while (i < this.allTabs.size()) {
                JCheckBox checkBoxTmp = new JCheckBox();
                checkBoxTmp = (JCheckBox)this.allTabs.elementAt(i);
                if (checkBoxTmp.getText().equals(key)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    public boolean hasSelectedTab() {
        boolean result = false;
        int i = 0;
        while (i < this.allTabs.size()) {
            JCheckBox cb = new JCheckBox();
            cb = (JCheckBox)this.allTabs.elementAt(i);
            if (cb.isSelected()) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Browser")) {
            String[] brwFile = new String[1];
            brwFile = this.chooser.showFileDialog("Select Browser", false);
            if (brwFile != null && brwFile[0] != null && !brwFile[0].equals("")) {
                this.browserField.setText(brwFile[0]);
            }
        }
    }
}

