/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.load.res;

import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.frame.core.load.res.ClassInfo;
import com.sap.engine.frame.core.load.res.JarResource;
import com.sap.engine.frame.core.load.res.Resource;
import java.io.InputStream;
import java.net.URL;
import java.security.PermissionCollection;
import java.util.HashSet;
import java.util.Vector;
import java.util.jar.Attributes;

public class JarsResource
implements Resource {
    protected JarResource[] jars = new JarResource[0];
    protected PermissionCollection permissionCollection;

    public JarsResource() {
    }

    public JarsResource(String fileName) {
        this.addJar(fileName);
    }

    public JarsResource(String[] fileNames) {
        this.addJars(fileNames);
    }

    public ClassInfo getClassInfo(String className, String fileName) {
        ClassInfo result = null;
        int i = 0;
        while (i < this.jars.length) {
            result = this.jars[i].getClassInfo(className, fileName);
            if (result != null) break;
            ++i;
        }
        return result;
    }

    public URL getURL(String fileName) {
        URL result = null;
        int i = 0;
        while (i < this.jars.length) {
            result = this.jars[i].getURL(fileName);
            if (result != null) break;
            ++i;
        }
        return result;
    }

    public URL[] getURLs(String fileName) {
        Vector<URL> array = new Vector<URL>();
        URL next = null;
        int i = 0;
        while (i < this.jars.length) {
            next = this.jars[i].getURL(fileName);
            if (next != null) {
                array.add(next);
            }
            ++i;
        }
        return array.toArray(new URL[array.size()]);
    }

    public InputStream getInputStream(String fileName) {
        InputStream result = null;
        int i = 0;
        while (i < this.jars.length) {
            result = this.jars[i].getInputStream(fileName);
            if (result != null) break;
            ++i;
        }
        return result;
    }

    public Attributes getAttributes(String packageName, boolean filterCheck) {
        Attributes result = null;
        int i = 0;
        while (i < this.jars.length) {
            result = this.jars[i].getAttributes(packageName, filterCheck);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public String[] getResourceNames() {
        String[] names = new String[this.jars.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.jars[i].getName();
            ++i;
        }
        return names;
    }

    public Resource[] getSimpleResources() {
        Resource[] result = new Resource[this.jars.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.jars[i];
            ++i;
        }
        return result;
    }

    public void addJar(String jar) {
        if (jar != null) {
            this.addResources(new JarResource[]{new JarResource(jar)});
        }
    }

    public void addJars(String[] jarNames) {
        if (jarNames != null) {
            JarResource[] newResources = new JarResource[jarNames.length];
            int i = 0;
            while (i < jarNames.length) {
                newResources[i] = new JarResource(jarNames[i]);
                ++i;
            }
            this.addResources(newResources);
        }
    }

    public void addResource(JarResource jarResource) {
        if (jarResource != null) {
            this.addResources(new JarResource[]{jarResource});
        }
    }

    public synchronized void addResources(JarResource[] jarResources) {
        if (!ReferencedLoader.isStrictResourceOrder()) {
            if (jarResources != null) {
                HashSet<JarResource> set = new HashSet<JarResource>();
                int i = 0;
                while (i < this.jars.length) {
                    set.add(this.jars[i]);
                    ++i;
                }
                int i2 = 0;
                while (i2 < jarResources.length) {
                    set.add(jarResources[i2]);
                    ++i2;
                }
                JarResource[] tempResources = new JarResource[set.size()];
                set.toArray(tempResources);
                this.jars = tempResources;
            }
        } else if (jarResources != null) {
            Vector<JarResource> set = new Vector<JarResource>();
            int i = 0;
            while (i < this.jars.length) {
                set.add(this.jars[i]);
                ++i;
            }
            int i3 = 0;
            while (i3 < jarResources.length) {
                set.add(jarResources[i3]);
                ++i3;
            }
            JarResource[] tempResources = new JarResource[set.size()];
            set.toArray(tempResources);
            this.jars = tempResources;
        }
    }
}

