/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.load.res;

import com.sap.engine.boot.ControlledCryptographyProvider;
import com.sap.engine.boot.JarFilter;
import com.sap.engine.frame.core.load.ClassLoadingLog;
import com.sap.engine.frame.core.load.SAPLoadingIllegalArgumentException;
import com.sap.engine.frame.core.load.res.ClassInfo;
import com.sap.engine.frame.core.load.res.JarThread;
import com.sap.engine.frame.core.load.res.Resource;
import com.sap.engine.lib.security.domain.ProtectionDomainFactory;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarResource
implements Resource {
    private static final byte IMMEDIATE_CLOSE = 0;
    private static final byte NO_CLOSE = 1;
    private static final byte TIMEOUT_CLOSE = 2;
    protected static final Location location = Location.getLocation((Class)(class$com$sap$engine$frame$core$load$res$JarResource == null ? (class$com$sap$engine$frame$core$load$res$JarResource = JarResource.class$("com.sap.engine.frame.core.load.res.JarResource")) : class$com$sap$engine$frame$core$load$res$JarResource));
    private static final JarThread jarThread = new JarThread();
    protected String jarName;
    protected JarFilter jarFilter;
    protected String jarNameURL;
    protected File jarFile;
    protected CodeSource codeSource;
    protected ProtectionDomain protectionDomain;
    protected boolean tempProtectionDomain;
    private boolean mainAttributesLoaded;
    private String jarSpecTitle;
    private String jarSpecVersion;
    private String jarSpecVendor;
    private String jarImplTitle;
    private String jarImplVersion;
    private String jarImplVendor;
    private boolean dumpedOpenException = false;
    private byte closeType = 0;
    private int workingThreads = 0;
    private boolean jarClosed = true;
    private long timeoutTime = 0L;
    static /* synthetic */ Class class$com$sap$engine$frame$core$load$res$JarResource;

    public JarResource(String jar) {
        this(jar, false, null);
    }

    public JarResource(String jar, boolean tempProtectionDomain) throws SAPLoadingIllegalArgumentException {
        this(jar, tempProtectionDomain, null);
    }

    public JarResource(String jar, boolean tempProtectionDomain, ProtectionDomain protectionDomain) throws SAPLoadingIllegalArgumentException {
        if (jar == null) {
            throw new SAPLoadingIllegalArgumentException("kernel_5800", new Object[]{jar, "JarResource"});
        }
        try {
            this.jarFile = new File(jar).getCanonicalFile();
        }
        catch (IOException e) {
            throw new SAPLoadingIllegalArgumentException("kernel_5800", new Object[]{jar, "JarResource"}, e);
        }
        this.jarName = this.jarFile.getAbsolutePath();
        try {
            URL jarURL = this.jarFile.toURL();
            this.jarNameURL = jarURL.toString();
            this.codeSource = new CodeSource(jarURL, null);
        }
        catch (MalformedURLException e) {
            throw new SAPLoadingIllegalArgumentException("kernel_5800", new Object[]{jar, "JarResource"}, e);
        }
        this.tempProtectionDomain = tempProtectionDomain;
        this.protectionDomain = protectionDomain == null ? (tempProtectionDomain ? new ProtectionDomain(this.codeSource, Policy.getPolicy().getPermissions(this.codeSource)) : ProtectionDomainFactory.getFactory().registerProtectionDomain(this.jarName, this.codeSource)) : protectionDomain;
    }

    public ClassInfo getClassInfo(String className, String fileName) {
        if (this.jarFilter != null && !this.jarFilter.accept(fileName)) {
            return null;
        }
        byte[] bytes = null;
        if (this.openJar()) {
            bytes = this.readResourceFromJar(fileName);
            this.closeJar();
        }
        if (bytes == null) {
            return null;
        }
        return new ClassInfo(className, bytes, this.protectionDomain, this);
    }

    public URL getURL(String fileName) {
        if (this.jarFilter != null && !this.jarFilter.accept(fileName)) {
            return null;
        }
        boolean hasIt = false;
        if (this.openJar()) {
            hasIt = this.jarFilter.getJar().getJarEntry(fileName) != null;
            this.closeJar();
        }
        if (hasIt) {
            try {
                return new URL("jar", "", this.jarNameURL + "!/" + fileName);
            }
            catch (MalformedURLException murlException) {
                ClassLoadingLog.logThrowable(location, (byte)5, "getURL(String fileName)", murlException);
                return null;
            }
        }
        return null;
    }

    public URL[] getURLs(String fileName) {
        return new URL[]{this.getURL(fileName)};
    }

    public InputStream getInputStream(String fileName) {
        if (this.jarFilter != null && !this.jarFilter.accept(fileName)) {
            return null;
        }
        byte[] result = null;
        if (this.openJar()) {
            result = this.readResourceFromJar(fileName);
            this.closeJar();
        }
        if (result != null) {
            return new ByteArrayInputStream(result);
        }
        return null;
    }

    public String[] getResourceNames() {
        return new String[]{this.jarName};
    }

    public Attributes getAttributes(String packageName, boolean filterCheck) {
        Attributes packageAttributes;
        Manifest manifest;
        if (packageName == null) {
            return null;
        }
        String fileName = packageName.replace('.', '/');
        if (filterCheck) {
            boolean hasIt = false;
            if (this.openJar()) {
                JarEntry entry = this.jarFilter.getJar().getJarEntry(fileName);
                if (entry != null && entry.isDirectory()) {
                    hasIt = true;
                }
                this.closeJar();
            }
            if (!hasIt) {
                return null;
            }
        }
        if ((manifest = this.jarFilter.getManifest()) == null) {
            return null;
        }
        if (!this.mainAttributesLoaded) {
            Attributes mainAttributes = manifest.getMainAttributes();
            this.jarSpecTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            this.jarSpecVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            this.jarSpecVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            this.jarImplTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            this.jarImplVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            this.jarImplVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            this.mainAttributesLoaded = true;
        }
        if ((packageAttributes = manifest.getAttributes(fileName)) == null) {
            packageAttributes = new Attributes();
        }
        if (this.jarSpecTitle != null && packageAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE) == null) {
            packageAttributes.put(Attributes.Name.SPECIFICATION_TITLE, this.jarSpecTitle);
        }
        if (this.jarSpecVersion != null && packageAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION) == null) {
            packageAttributes.put(Attributes.Name.SPECIFICATION_VERSION, this.jarSpecVersion);
        }
        if (this.jarSpecVendor != null && packageAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR) == null) {
            packageAttributes.put(Attributes.Name.SPECIFICATION_VENDOR, this.jarSpecVendor);
        }
        if (this.jarImplTitle != null && packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE) == null) {
            packageAttributes.put(Attributes.Name.IMPLEMENTATION_TITLE, this.jarImplTitle);
        }
        if (this.jarImplVersion != null && packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION) == null) {
            packageAttributes.put(Attributes.Name.IMPLEMENTATION_VERSION, this.jarImplVersion);
        }
        if (this.jarImplVendor != null && packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR) == null) {
            packageAttributes.put(Attributes.Name.IMPLEMENTATION_VENDOR, this.jarImplVendor);
        }
        return packageAttributes;
    }

    public Resource[] getSimpleResources() {
        return new Resource[]{this};
    }

    public synchronized void useNoClose() {
        this.closeType = 1;
    }

    public synchronized void useTimeoutClose() {
        this.closeType = (byte)2;
        if (this.workingThreads < 1 && !this.jarClosed) {
            this.timeoutTime = System.currentTimeMillis();
            jarThread.register(this, this.timeoutTime);
        }
    }

    public synchronized void useImmediateClose() {
        this.closeType = 0;
        if (this.workingThreads < 1 && !this.jarClosed) {
            this.closeFinal();
        }
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    /*
     * Loose catch block
     */
    private byte[] readResourceFromJar(String fileName) {
        byte[] result;
        block12: {
            JarFile jar = this.jarFilter.getJar();
            JarEntry entry = jar.getJarEntry(fileName);
            if (entry == null) {
                return null;
            }
            result = null;
            InputStream in = null;
            String provider = null;
            int len = (int)entry.getSize();
            result = new byte[len];
            provider = ControlledCryptographyProvider.useProvider("SUN");
            in = jar.getInputStream(entry);
            int n = 0;
            while (n < len) {
                int count = in.read(result, n, len - n);
                if (count < 0) {
                    throw new EOFException();
                }
                n += count;
            }
            Object var11_12 = null;
            ControlledCryptographyProvider.revertToProvider(provider);
            try {
                in.close();
            }
            catch (Exception e2) {
                in = null;
            }
            break block12;
            {
                catch (IOException e) {
                    ClassLoadingLog.logThrowable(location, (byte)5, "readResourceFromJar(String fileName)", e);
                    byte[] byArray = null;
                    Object var11_13 = null;
                    ControlledCryptographyProvider.revertToProvider(provider);
                    try {
                        in.close();
                    }
                    catch (Exception e2) {
                        in = null;
                    }
                    return byArray;
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                ControlledCryptographyProvider.revertToProvider(provider);
                try {
                    in.close();
                }
                catch (Exception e2) {
                    in = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    private synchronized boolean openJar() {
        if (this.jarFilter == null) {
            try {
                if (!this.jarFile.exists()) {
                    throw new FileNotFoundException(this.jarFile.getAbsolutePath());
                }
                this.jarFilter = new JarFilter(this.jarName);
            }
            catch (IOException ioException) {
                if (!this.dumpedOpenException) {
                    ClassLoadingLog.logThrowable(location, (byte)5, "openJar() " + this.jarName, ioException);
                    this.dumpedOpenException = true;
                }
                return false;
            }
        }
        try {
            if (this.workingThreads < 1 && this.jarClosed) {
                this.jarFilter.open();
            }
        }
        catch (IOException ioException) {
            ClassLoadingLog.logThrowable(location, (byte)5, "openJar()", ioException);
            return false;
        }
        ++this.workingThreads;
        this.jarClosed = false;
        return true;
    }

    private synchronized void closeJar() {
        --this.workingThreads;
        if (this.closeType != 1 && this.workingThreads < 1) {
            if (this.closeType == 0) {
                this.closeFinal();
            } else {
                this.timeoutTime = System.currentTimeMillis();
                jarThread.register(this, this.timeoutTime);
            }
        }
    }

    synchronized void closeTimeout(long oldTime) {
        if (this.workingThreads < 1 && this.closeType == 2 && this.timeoutTime == oldTime) {
            this.closeFinal();
        }
    }

    private synchronized void closeFinal() {
        block5: {
            try {
                try {
                    this.jarFilter.getJar().close();
                }
                catch (IOException ioException) {
                    ClassLoadingLog.logThrowable(location, (byte)5, "closeJar()", ioException);
                    Object var4_2 = null;
                    this.jarClosed = true;
                    break block5;
                }
                catch (NullPointerException npException) {
                    ClassLoadingLog.logThrowable(location, (byte)5, "closeJar()", npException);
                    Object var4_3 = null;
                    this.jarClosed = true;
                }
                Object var4_1 = null;
                this.jarClosed = true;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.jarClosed = true;
                throw throwable;
            }
        }
    }

    public String getName() {
        return this.jarName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        JarResource tempResource = null;
        if (!(obj instanceof JarResource)) {
            return false;
        }
        tempResource = (JarResource)obj;
        return this.jarFile.equals(tempResource.jarFile);
    }

    public int hashCode() {
        return this.jarFile.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        jarThread.start();
    }
}

