/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.load.res;

import com.sap.engine.frame.core.load.ClassLoadingLog;
import com.sap.engine.frame.core.load.SAPLoadingIllegalArgumentException;
import com.sap.engine.frame.core.load.res.ClassInfo;
import com.sap.engine.frame.core.load.res.Resource;
import com.sap.engine.lib.security.domain.ProtectionDomainFactory;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.jar.Attributes;

public class DirResource
implements Resource {
    protected String dirName;
    protected File dirFile;
    protected CodeSource codeSource;
    protected ProtectionDomain protectionDomain;
    protected boolean tempProtectionDomain;
    protected static final Location location = Location.getLocation((Class)(class$com$sap$engine$frame$core$load$res$DirResource == null ? (class$com$sap$engine$frame$core$load$res$DirResource = DirResource.class$("com.sap.engine.frame.core.load.res.DirResource")) : class$com$sap$engine$frame$core$load$res$DirResource));
    static /* synthetic */ Class class$com$sap$engine$frame$core$load$res$DirResource;

    public DirResource(String dir) {
        this(dir, false, null);
    }

    public DirResource(String dir, boolean tempProtectionDomain) throws SAPLoadingIllegalArgumentException {
        this(dir, tempProtectionDomain, null);
    }

    public DirResource(String dir, boolean tempProtectionDomain, ProtectionDomain protectionDomain) {
        if (dir == null) {
            throw new SAPLoadingIllegalArgumentException("kernel_5800", new Object[]{dir, "DirResource"});
        }
        try {
            this.dirFile = new File(dir).getCanonicalFile();
        }
        catch (IOException e) {
            throw new SAPLoadingIllegalArgumentException("kernel_5800", new Object[]{dir, "DirResource"}, e);
        }
        this.dirName = this.dirFile.getAbsolutePath();
        try {
            this.codeSource = new CodeSource(this.dirFile.toURL(), null);
        }
        catch (MalformedURLException e) {
            throw new SAPLoadingIllegalArgumentException("kernel_5800", new Object[]{dir, "DirResource"}, e);
        }
        this.tempProtectionDomain = tempProtectionDomain;
        this.protectionDomain = protectionDomain == null ? (tempProtectionDomain ? new ProtectionDomain(this.codeSource, Policy.getPolicy().getPermissions(this.codeSource)) : ProtectionDomainFactory.getFactory().registerProtectionDomain(this.dirName, this.codeSource)) : protectionDomain;
    }

    public ClassInfo getClassInfo(String className, String fileName) {
        byte[] bytes = this.readResourceData(fileName);
        if (bytes != null) {
            return new ClassInfo(className, bytes, this.protectionDomain, this);
        }
        return null;
    }

    public URL getURL(String fileName) {
        File file = new File(this.dirFile, fileName);
        if (file.exists()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException murlException) {
                ClassLoadingLog.logThrowable(location, (byte)5, "getURL(String fileName)", murlException);
                return null;
            }
        }
        return null;
    }

    public URL[] getURLs(String fileName) {
        return new URL[]{this.getURL(fileName)};
    }

    public InputStream getInputStream(String fileName) {
        byte[] result = this.readResourceData(fileName);
        if (result == null) {
            return null;
        }
        return new ByteArrayInputStream(result);
    }

    public String[] getResourceNames() {
        return new String[]{this.dirName};
    }

    public Attributes getAttributes(String packageName, boolean filterCheck) {
        return null;
    }

    public Resource[] getSimpleResources() {
        return new Resource[]{this};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] readResourceData(String fileName) {
        byte[] byArray;
        File file = new File(this.dirFile, fileName);
        if (!file.exists()) {
            return null;
        }
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(file);
                int len = ((InputStream)in).available();
                byte[] result = new byte[len];
                int n = 0;
                while (true) {
                    if (n >= len) {
                        byArray = result;
                        Object var9_11 = null;
                        break;
                    }
                    int count = ((InputStream)in).read(result, n, len - n);
                    if (count < 0) {
                        throw new EOFException();
                    }
                    n += count;
                }
            }
            catch (IOException ioException) {
                ClassLoadingLog.logThrowable(location, (byte)5, "readResourceData(String fileName)", ioException);
                byte[] byArray2 = null;
                Object var9_12 = null;
                try {
                    ((InputStream)in).close();
                    return byArray2;
                }
                catch (Exception e) {
                    return byArray2;
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            try {}
            catch (Exception e) {
                in = null;
                throw throwable;
            }
            ((InputStream)in).close();
            throw throwable;
        }
        try {}
        catch (Exception e) {
            return byArray;
        }
        ((InputStream)in).close();
        return byArray;
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public String getName() {
        return this.dirName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DirResource) {
            DirResource tempResource = (DirResource)obj;
            return this.dirFile.equals(tempResource.dirFile);
        }
        return false;
    }

    public int hashCode() {
        return this.dirFile.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

