/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.load;

import com.sap.engine.boot.FileClassLoader;
import com.sap.engine.boot.ModificationFactory;
import com.sap.engine.frame.core.load.ClassLoadingLog;
import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.frame.core.load.SAPLoadingIllegalArgumentException;
import com.sap.engine.frame.core.load.res.ClassInfo;
import com.sap.engine.frame.core.load.res.CompoundEnumeration;
import com.sap.engine.frame.core.load.res.JarResource;
import com.sap.engine.frame.core.load.res.MultipleResource;
import com.sap.engine.frame.core.load.res.Resource;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;

public class ResourceLoader
extends ReferencedLoader {
    public static final byte NONE = -1;
    public static final byte PARENT = 0;
    public static final byte LOCAL = 1;
    public static final byte REFERENCES = 2;
    protected byte[] sequence;
    protected Resource resource;
    protected static Location location = null;
    private static boolean useTrace = false;
    static /* synthetic */ Class class$com$sap$engine$frame$core$load$ResourceLoader;

    public ResourceLoader(String name, Resource resource, ClassLoader parent, ProtectionDomain domain) throws SAPLoadingIllegalArgumentException {
        this(name, resource, parent, domain, 0, 2, 1);
    }

    public ResourceLoader(String name, Resource resource, ClassLoader parent, ProtectionDomain domain, byte first, byte second, byte third) throws SAPLoadingIllegalArgumentException {
        super(name, parent, domain);
        this.setResource(resource);
        this.setLoadModel(first, second, third);
    }

    public final void addResource(Resource newResource) {
        if (newResource == null) {
            return;
        }
        MultipleResource tempResource = null;
        if (!(this.resource instanceof MultipleResource)) {
            tempResource = new MultipleResource();
            tempResource.addResource(this.resource);
        } else {
            tempResource = (MultipleResource)this.resource;
        }
        tempResource.addResource(newResource);
        this.resource = tempResource;
        super.clearNegativeCache();
        this.clearNegativeCacheInReferees();
    }

    public String[] getResourceNames() {
        return this.resource.getResourceNames();
    }

    public String getAdditionalInfo() {
        StringBuffer buffer = new StringBuffer("Loading model: {");
        int i = 0;
        while (i < this.sequence.length) {
            if (this.sequence[i] == 0) {
                buffer.append("parent");
            } else if (this.sequence[i] == 1) {
                buffer.append("local");
            } else {
                buffer.append("references");
            }
            if (i != this.sequence.length - 1) {
                buffer.append(',');
            }
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public void prepareForRemove() {
        super.prepareForRemove();
        Resource[] allResources = this.resource.getSimpleResources();
        if (allResources != null) {
            int i = 0;
            while (i < allResources.length) {
                if (allResources[i] instanceof JarResource) {
                    JarResource jarResource = (JarResource)allResources[i];
                    jarResource.useImmediateClose();
                }
                ++i;
            }
        }
    }

    protected final Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class result = null;
        String fileName = null;
        int i = 0;
        while (i < this.sequence.length) {
            try {
                switch (this.sequence[i]) {
                    case 0: {
                        result = this.parentLoader.loadClass(className);
                        break;
                    }
                    case 2: {
                        if (fileName == null) {
                            fileName = className.replace('.', '/') + ".class";
                        }
                        result = super.loadClassByReference(className, fileName);
                        break;
                    }
                    case 1: {
                        if (fileName == null) {
                            fileName = className.replace('.', '/') + ".class";
                        }
                        result = this.loadLocalClass(className, fileName);
                    }
                }
                if (resolve) {
                    this.resolveClass(result);
                }
                return result;
            }
            catch (ClassNotFoundException e) {
                ++i;
            }
        }
        throw ReferencedLoader.CLASS_NOT_FOUND_EXCEPTION;
    }

    public URL getResource(String fileName) {
        URL result = null;
        int i = 0;
        while (i < this.sequence.length) {
            switch (this.sequence[i]) {
                case 0: {
                    result = this.parentLoader.getResource(fileName);
                    break;
                }
                case 2: {
                    result = super.getResourceByReference(fileName);
                    break;
                }
                case 1: {
                    result = this.getLocalResource(fileName);
                }
            }
            if (result != null) break;
            ++i;
        }
        return result;
    }

    public InputStream getResourceAsStream(String fileName) {
        InputStream result = null;
        int i = 0;
        while (i < this.sequence.length) {
            switch (this.sequence[i]) {
                case 0: {
                    result = this.parentLoader.getResourceAsStream(fileName);
                    break;
                }
                case 2: {
                    result = super.getResourceAsStreamByReference(fileName);
                    break;
                }
                case 1: {
                    result = this.getLocalResourceAsStream(fileName);
                }
            }
            if (result != null) break;
            ++i;
        }
        return result;
    }

    protected Enumeration findResources(String fileName) throws IOException {
        CompoundEnumeration enumeration = new CompoundEnumeration();
        int i = 0;
        while (i < this.sequence.length) {
            switch (this.sequence[i]) {
                case 2: {
                    enumeration.add(super.findResourcesByReference(fileName));
                    break;
                }
                case 1: {
                    enumeration.add(this.findLocalResources(fileName));
                }
            }
            ++i;
        }
        return enumeration;
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        return this.loadLocalClass(className, className.replace('.', '/') + ".class");
    }

    protected Class loadLocalClass(String className, String fileName) throws ClassNotFoundException {
        ClassInfo classInfo = this.resource.getClassInfo(className, fileName);
        Class<?> result = null;
        if (classInfo == null) {
            throw ReferencedLoader.CLASS_NOT_FOUND_EXCEPTION;
        }
        ResourceLoader resourceLoader = this;
        synchronized (resourceLoader) {
            result = this.findLoadedClass(className);
            if (result != null) {
                Class<?> clazz = result;
                return clazz;
            }
            String pkgName = classInfo.getPackageName();
            if (pkgName != null && this.getPackage(pkgName) == null) {
                this.definePackage(pkgName, classInfo.getAttributes());
            }
            if (useTrace) {
                try {
                    classInfo.setBytes(ModificationFactory.getModificator(this).modify(classInfo.getBytes(), className));
                }
                catch (Exception exc) {
                    ClassLoadingLog.logThrowable(location, (byte)5, "ModificationFactory.getModificator(this).modify(" + classInfo.getBytes() + ", " + className + ")", exc);
                }
            }
            result = this.defineClass(className, classInfo.getBytes(), 0, classInfo.getBytes().length, classInfo.getProtectionDomain() == null ? this.domain : classInfo.getProtectionDomain());
        }
        return result;
    }

    protected InputStream getLocalResourceAsStream(String fileName) {
        return this.resource.getInputStream(fileName);
    }

    protected URL getLocalResource(String fileName) {
        return this.resource.getURL(fileName);
    }

    protected Enumeration findLocalResources(String fileName) throws IOException {
        CompoundEnumeration enumeration = new CompoundEnumeration();
        enumeration.add(this.resource.getURLs(fileName));
        return enumeration;
    }

    private final void setLoadModel(byte first, byte second, byte third) throws SAPLoadingIllegalArgumentException {
        int index = 0;
        byte[] temp = new byte[3];
        if (first == 0 || first == 1 || first == 2) {
            temp[index++] = first;
        }
        if ((second == 0 || second == 1 || second == 2) && second != first) {
            temp[index++] = second;
        }
        if ((third == 0 || third == 1 || third == 2) && third != first && third != second) {
            temp[index++] = third;
        }
        if (index == 0) {
            throw new SAPLoadingIllegalArgumentException("kernel_5701");
        }
        this.sequence = new byte[index];
        int i = 0;
        while (i < index) {
            this.sequence[i] = temp[i];
            ++i;
        }
    }

    private final void setResource(Resource newResource) throws SAPLoadingIllegalArgumentException {
        if (newResource == null) {
            throw new SAPLoadingIllegalArgumentException("kernel_5700");
        }
        this.resource = newResource;
        super.clearNegativeCache();
        this.clearNegativeCacheInReferees();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (FileClassLoader.useTracing()) {
            useTrace = true;
            location = Location.getLocation((Class)(class$com$sap$engine$frame$core$load$ResourceLoader == null ? (class$com$sap$engine$frame$core$load$ResourceLoader = ResourceLoader.class$("com.sap.engine.frame.core.load.ResourceLoader")) : class$com$sap$engine$frame$core$load$ResourceLoader));
        }
    }
}

