/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.cluster.message;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.message.DestinationLostException;
import com.sap.engine.frame.cluster.message.DestinationNotAvailableException;
import com.sap.engine.frame.cluster.message.MultipleAnswer;
import com.sap.engine.frame.cluster.message.NoListenerOnDestinationException;
import com.sap.engine.frame.cluster.message.RemoteClusterException;
import com.sap.engine.frame.cluster.message.ResponseTimedOutException;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class PartialResponseException
extends ClusterException {
    private static final String RESOURCE_ID = "kernel_2034";
    private MultipleAnswer partialResponse;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$frame$cluster$message$PartialResponseException == null ? (class$com$sap$engine$frame$cluster$message$PartialResponseException = PartialResponseException.class$("com.sap.engine.frame.cluster.message.PartialResponseException")) : class$com$sap$engine$frame$cluster$message$PartialResponseException));
    static /* synthetic */ Class class$com$sap$engine$frame$cluster$message$PartialResponseException;

    public PartialResponseException(MultipleAnswer partialResponse) {
        super(RESOURCE_ID, new Object[]{PartialResponseException.getResponseStatus(partialResponse)});
        this.partialResponse = partialResponse;
    }

    public MultipleAnswer getPartialResponse() {
        return this.partialResponse;
    }

    private static String getResponseStatus(MultipleAnswer partialResponse) {
        StringBuffer status = new StringBuffer();
        int[] participants = partialResponse.participants();
        boolean isThereRemoteExceptions = false;
        status.append("[");
        int i = 0;
        while (i < participants.length) {
            status.append(participants[i]);
            status.append('-');
            try {
                partialResponse.getAnswer(participants[i]);
                status.append("OK");
            }
            catch (DestinationNotAvailableException e) {
                status.append("DNAE");
            }
            catch (NoListenerOnDestinationException e) {
                status.append("NLODE");
            }
            catch (DestinationLostException e) {
                status.append("DLE");
            }
            catch (ResponseTimedOutException e) {
                status.append("RTOE");
            }
            catch (RemoteClusterException e) {
                status.append("RCE");
                isThereRemoteExceptions = true;
            }
            catch (ClusterException e) {
                status.append("UNKN");
            }
            if (i < participants.length - 1) {
                status.append(',');
            }
            ++i;
        }
        status.append("]. ");
        if (isThereRemoteExceptions) {
            String nl = SystemProperties.getProperty("line.separator");
            status.append(nl);
            status.append("==============================================");
            status.append(nl);
            int i2 = 0;
            while (i2 < participants.length) {
                try {
                    partialResponse.getAnswer(participants[i2]);
                }
                catch (RemoteClusterException e) {
                    StringWriter stringWriter = new StringWriter();
                    e.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                    status.append(stringWriter.toString());
                    status.append("==============================================");
                }
                catch (ClusterException _) {
                    // empty catch block
                }
                ++i2;
            }
        }
        return status.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

