/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.cluster.message;

public final class MessageAnswer {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private byte[] body;
    private int offset;
    private int length;

    public MessageAnswer() {
        this(EMPTY_ARRAY, 0, 0);
    }

    public MessageAnswer(byte[] body) {
        this(body, 0, body.length);
    }

    public MessageAnswer(byte[] body, int offset, int length) {
        this.check(body, offset, length);
        this.body = body;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getMessage() {
        return this.body;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setMessage(byte[] body) {
        this.check(body, this.offset, this.length);
        this.body = body;
    }

    public void setMessage(byte[] body, int offset, int length) {
        this.check(body, offset, length);
        this.body = body;
        this.offset = offset;
        this.length = length;
    }

    public void setOffset(int offset) {
        this.check(this.body, offset, this.length);
        this.offset = offset;
    }

    public void setLength(int length) {
        this.check(this.body, this.offset, length);
        this.length = length;
    }

    private void check(byte[] body, int offset, int length) throws NullPointerException, IndexOutOfBoundsException {
        if (body == null) {
            throw new NullPointerException("body cannot be null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset cannot be negative");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length cannot be negative");
        }
        if (offset + length > body.length) {
            throw new IndexOutOfBoundsException("offset + length cannot be greater than body.length");
        }
    }
}

