/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.client;

import com.sap.engine.frame.client.ClientException;
import com.sap.engine.frame.client.ClientThreadContextFactory;

public class ClientFactory {
    private static ClientThreadContextFactory threadContextFactory;

    public static synchronized ClientThreadContextFactory getThreadContextFactory() throws ClientException {
        if (threadContextFactory != null) {
            return threadContextFactory;
        }
        String className = null;
        try {
            className = System.getProperty("CLIENT_THREAD_CONTEXT_FACTORY_CLASS");
            if (className == null) {
                className = "com.sap.engine.frame.client.ClientThreadContextImpl";
            }
            Class<?> threadContextFactoryClass = Class.forName(className);
            threadContextFactory = (ClientThreadContextFactory)threadContextFactoryClass.newInstance();
            return threadContextFactory;
        }
        catch (ClassNotFoundException cnfException) {
            throw new ClientException("Class " + className + " not found", (Throwable)cnfException);
        }
        catch (InstantiationException iException) {
            throw new ClientException("Can't instantiate object from class " + className, (Throwable)iException);
        }
        catch (IllegalAccessException iaException) {
            throw new ClientException(iaException);
        }
    }
}

