/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.util;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.util.LoadedFilesListener;
import com.sap.engine.lib.lang.DynamicClassLoader;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassLoadingThread
extends Thread {
    private Vector classes;
    private Vector alreadyLoadedFiles = new Vector();
    private Hashtable beanClassesTable = new Hashtable();
    private Vector listeners = new Vector();
    private String classPath;
    private boolean isStopped = true;
    private boolean stopThread = false;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$javax$ejb$EJBLocalHome;
    static /* synthetic */ Class class$javax$ejb$EJBObject;
    static /* synthetic */ Class class$javax$ejb$EJBLocalObject;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$javax$servlet$Filter;
    static /* synthetic */ Class class$javax$servlet$ServletContextAttributeListener;
    static /* synthetic */ Class class$javax$servlet$ServletContextListener;
    static /* synthetic */ Class class$javax$servlet$http$HttpSessionListener;
    static /* synthetic */ Class class$javax$servlet$Servlet;
    static /* synthetic */ Class class$javax$servlet$http$HttpServlet;

    public ClassLoadingThread(Hashtable beanClassesTable) {
        this.beanClassesTable = beanClassesTable;
        if (beanClassesTable == null) {
            beanClassesTable = new Hashtable();
        }
    }

    public synchronized void getBeanClasses(String[] path, String classPath) {
        this.classes = new Vector();
        if (path == null || path.length == 0) {
            this.classPathCompliance();
            this.alreadyLoadedFiles = new Vector();
            return;
        }
        int j = 0;
        while (j < path.length) {
            if (new File(path[j]).isDirectory()) {
                this.getAllClassFilesInDirectory(new File(path[j]), path[j]);
            }
            ++j;
        }
        this.classPathCompliance();
        if (classPath == null) {
            classPath = ApplicationInformationProvider.arrayToString(path, File.pathSeparator);
        }
        DynamicClassLoader loader = new DynamicClassLoader(classPath);
        Class myClass = null;
        int i = 0;
        while (i < this.classes.size()) {
            block26: {
                try {
                    myClass = loader.loadClass((String)this.classes.elementAt(i));
                }
                catch (ClassNotFoundException classNotFound) {
                    break block26;
                }
                catch (ClassCircularityError cce) {
                    break block26;
                }
                catch (Exception exc) {
                    break block26;
                }
                catch (NoClassDefFoundError ncdfe) {
                    break block26;
                }
                if (this.stopThread) {
                    return;
                }
                if (!this.alreadyLoadedFiles.contains(this.classes.elementAt(i))) {
                    this.alreadyLoadedFiles.add(this.classes.elementAt(i));
                }
                if (myClass != null) {
                    if (myClass.isInterface()) {
                        if ((class$javax$ejb$EJBHome == null ? ClassLoadingThread.class$("javax.ejb.EJBHome") : class$javax$ejb$EJBHome).isAssignableFrom(myClass)) {
                            this.fireAddNewValue("javax.ejb.EJBHome", (String)this.classes.elementAt(i));
                        } else if ((class$javax$ejb$EJBLocalHome == null ? ClassLoadingThread.class$("javax.ejb.EJBLocalHome") : class$javax$ejb$EJBLocalHome).isAssignableFrom(myClass)) {
                            this.fireAddNewValue("javax.ejb.EJBLocalHome", (String)this.classes.elementAt(i));
                        } else if ((class$javax$ejb$EJBObject == null ? ClassLoadingThread.class$("javax.ejb.EJBObject") : class$javax$ejb$EJBObject).isAssignableFrom(myClass)) {
                            this.fireAddNewValue("javax.ejb.EJBObject", (String)this.classes.elementAt(i));
                        } else if ((class$javax$ejb$EJBLocalObject == null ? ClassLoadingThread.class$("javax.ejb.EJBLocalObject") : class$javax$ejb$EJBLocalObject).isAssignableFrom(myClass)) {
                            this.fireAddNewValue("javax.ejb.EJBLocalObject", (String)this.classes.elementAt(i));
                        }
                    } else {
                        if ((class$java$io$Serializable == null ? ClassLoadingThread.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(myClass)) {
                            this.fireAddNewValue("PrimaryKey", (String)this.classes.elementAt(i));
                        }
                        if ((class$javax$servlet$Filter == null ? ClassLoadingThread.class$("javax.servlet.Filter") : class$javax$servlet$Filter).isAssignableFrom(myClass)) {
                            this.fireAddNewValue("javax.servlet.Filter", (String)this.classes.elementAt(i));
                        }
                        if ((class$javax$servlet$ServletContextAttributeListener == null ? ClassLoadingThread.class$("javax.servlet.ServletContextAttributeListener") : class$javax$servlet$ServletContextAttributeListener).isAssignableFrom(myClass) || (class$javax$servlet$ServletContextListener == null ? ClassLoadingThread.class$("javax.servlet.ServletContextListener") : class$javax$servlet$ServletContextListener).isAssignableFrom(myClass) || (class$javax$servlet$http$HttpSessionListener == null ? ClassLoadingThread.class$("javax.servlet.http.HttpSessionListener") : class$javax$servlet$http$HttpSessionListener).isAssignableFrom(myClass)) {
                            this.fireAddNewValue("LISTENER", (String)this.classes.elementAt(i));
                        }
                        if ((class$javax$servlet$Servlet == null ? ClassLoadingThread.class$("javax.servlet.Servlet") : class$javax$servlet$Servlet).isAssignableFrom(myClass) || (class$javax$servlet$http$HttpServlet == null ? ClassLoadingThread.class$("javax.servlet.http.HttpServlet") : class$javax$servlet$http$HttpServlet).isAssignableFrom(myClass)) {
                            this.fireAddNewValue("SERVLET", (String)this.classes.elementAt(i));
                        }
                        this.fireAddNewValue("BeanClass", (String)this.classes.elementAt(i));
                    }
                }
            }
            ++i;
        }
        this.classes = new Vector();
    }

    private Vector findingClassesForSkipLoading() {
        Vector result = new Vector();
        int i = 0;
        while (i < this.classes.size()) {
            if (this.alreadyLoadedFiles.contains(this.classes.elementAt(i))) {
                this.classes.removeElementAt(i--);
            }
            ++i;
        }
        return result;
    }

    private void alreadyLoadFilesCompilance() {
        Vector allForRemove = new Vector();
        int i = 0;
        while (i < this.alreadyLoadedFiles.size()) {
            if (!this.classes.contains(this.alreadyLoadedFiles.elementAt(i))) {
                allForRemove.addElement(this.alreadyLoadedFiles.elementAt(i));
                this.alreadyLoadedFiles.removeElementAt(i--);
            }
            ++i;
        }
        if (allForRemove.size() != 0) {
            this.simpleRemove(allForRemove);
        }
    }

    private void simpleRemove(Vector classFiles) {
        Enumeration en = this.beanClassesTable.keys();
        String key = null;
        String[] values = null;
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            values = (String[])this.beanClassesTable.get(key);
            if (values == null) continue;
            Vector<String> forRemove = new Vector<String>();
            int i = 0;
            while (i < values.length) {
                if (classFiles.contains(values[i])) {
                    forRemove.addElement(values[i]);
                }
                ++i;
            }
            if (forRemove.size() == 0) continue;
            this.fireRemoveValue(key, forRemove);
        }
    }

    private void classPathCompliance() {
        this.alreadyLoadFilesCompilance();
        this.findingClassesForSkipLoading();
    }

    private void getAllClassFilesInDirectory(File path, String beginPath) {
        if (this.stopThread) {
            return;
        }
        if (path.isFile()) {
            return;
        }
        File[] files = path.listFiles();
        if (this.stopThread) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.getAllClassFilesInDirectory(files[i], beginPath);
            } else if (files[i].getAbsolutePath().toLowerCase().endsWith(".class")) {
                this.classes.add(files[i].getAbsolutePath().substring(beginPath.length() + 1, files[i].getAbsolutePath().length() - ".class".length()).replace(File.separatorChar, '.'));
            }
            ++i;
        }
    }

    public void addLoadedFilesListener(LoadedFilesListener arg0) {
        if (!this.listeners.contains(arg0)) {
            this.listeners.add(arg0);
        }
    }

    public void run() {
        this.isStopped = false;
        this.stopThread = false;
        if (this.stopThread) {
            this.isStopped = true;
            return;
        }
        this.getBeanClasses(this.tokenizertoArray(this.classPath), this.classPath);
        this.isStopped = true;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void stopThread() {
        this.stopThread = true;
    }

    private String[] tokenizertoArray(String temp) {
        Object[] result = null;
        if (temp == null) {
            return null;
        }
        Vector<String> resultV = new Vector<String>();
        StringTokenizer st = new StringTokenizer(temp, ";");
        while (st.hasMoreTokens()) {
            resultV.add(st.nextToken());
        }
        result = new String[resultV.size()];
        resultV.copyInto(result);
        return result;
    }

    public void fireAddNewValue(String key, String value) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((LoadedFilesListener)this.listeners.elementAt(i)).addToHashTable(key, value);
            ++i;
        }
    }

    public void fireRemoveValue(String key, Vector value) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((LoadedFilesListener)this.listeners.elementAt(i)).removeFromHashTable(key, value);
            ++i;
        }
    }

    public void setBeanClassesTable(Hashtable beanClassesTable) {
        this.beanClassesTable = beanClassesTable;
    }

    public Vector getAlreadyLoadedFiles() {
        return this.alreadyLoadedFiles;
    }

    public void setAlreadyLoadedFiles(Vector alreadyLoadedFiles) {
        this.alreadyLoadedFiles = alreadyLoadedFiles;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

