/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.tree;

import com.sap.engine.deploy.tool.tree.ArchiveDescriptorNode;
import com.sap.engine.deploy.tool.tree.BasicDescriptorNode;
import com.sap.engine.deploy.tool.tree.DescriptorNode;
import com.sap.engine.deploy.tool.tree.EARDescriptorNode;
import com.sap.engine.deploy.tool.tree.ImageHolder;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.FilterDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class DescriptorTreeRenderer
extends JLabel
implements TreeCellRenderer {
    private Icon alone;
    private Icon server;
    private Icon dispatcher;
    private Icon library;
    private Icon plug_in_interface;
    private Icon service;
    private Icon serviceJar;
    private Icon ejb;
    private Icon ejbJar;
    private Icon web;
    private Icon servlet;
    private Icon filter;
    private Icon listener;
    private Icon client;
    private Icon connector;
    private Icon ear;
    private Icon defaultIcon;

    public DescriptorTreeRenderer() {
        this.setOpaque(true);
        this.initImages();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        BasicDescriptorNode node = (BasicDescriptorNode)value;
        int type = node.getType();
        Icon image = node.getIcon();
        if (image != null) {
            this.setIcon(image);
        } else {
            Icon newIcon = this.getNewIcon(value);
            switch (type) {
                case 4: {
                    this.setIcon(newIcon != null ? newIcon : this.serviceJar);
                    break;
                }
                case 15: {
                    this.setIcon(newIcon != null ? newIcon : this.server);
                    break;
                }
                case 16: {
                    this.setIcon(newIcon != null ? newIcon : this.dispatcher);
                    break;
                }
                case 12: {
                    this.setIcon(newIcon != null ? newIcon : this.library);
                    break;
                }
                case 13: {
                    this.setIcon(newIcon != null ? newIcon : this.plug_in_interface);
                    break;
                }
                case 1: {
                    this.setIcon(newIcon != null ? newIcon : this.service);
                    break;
                }
                case 3: {
                    this.setIcon(newIcon != null ? newIcon : this.ejbJar);
                    break;
                }
                case 0: {
                    this.setIcon(newIcon != null ? newIcon : this.ejb);
                    break;
                }
                case 5: {
                    this.setIcon(newIcon != null ? newIcon : this.web);
                    break;
                }
                case 2: {
                    this.setIcon(newIcon != null ? newIcon : this.servlet);
                    break;
                }
                case 10: {
                    this.setIcon(newIcon != null ? newIcon : this.filter);
                    break;
                }
                case 11: {
                    this.setIcon(newIcon != null ? newIcon : this.listener);
                    break;
                }
                case 6: {
                    this.setIcon(newIcon != null ? newIcon : this.client);
                    break;
                }
                case 9: {
                    this.setIcon(newIcon != null ? newIcon : this.connector);
                    break;
                }
                case 7: {
                    this.setIcon(newIcon != null ? newIcon : this.ear);
                    break;
                }
                case 8: {
                    this.setIcon(newIcon != null ? newIcon : this.defaultIcon);
                    break;
                }
                default: {
                    this.setIcon(this.defaultIcon);
                }
            }
        }
        this.setText(node.getName());
        if (node.getLastIsCorrectStatus() == 0) {
            this.setBackground(selected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground"));
            this.setForeground(selected ? UIManager.getColor("Tree.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        } else if (node.getLastIsCorrectStatus() == 1) {
            this.setBackground(selected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground"));
            this.setForeground(new Color(40, 105, 220));
        } else if (node.getLastIsCorrectStatus() == 2) {
            this.setBackground(selected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground"));
            this.setForeground(new Color(238, 6, 12));
        }
        return this;
    }

    private Icon getNewIcon(Object value) {
        Icon newIcon = null;
        if (value instanceof ArchiveDescriptorNode) {
            ArchiveDescriptor archDescr = ((ArchiveDescriptorNode)value).getCurrentDescriptor();
            if (archDescr != null && archDescr.getSmallIcon() != null) {
                newIcon = archDescr.getSmallIcon().getBytes() != null ? new ImageIcon(archDescr.getSmallIcon().getBytes()) : this.getIconFromArchive((ArchiveDescriptorNode)value, ((ArchiveDescriptorNode)value).getCurrentDescriptor().getSmallIcon().getFileName());
            }
        } else if (value instanceof DescriptorNode) {
            Descriptor descr = ((DescriptorNode)value).getCurrentDescriptor();
            if (descr != null) {
                if (descr instanceof DeploymentDescriptor && ((DeploymentDescriptor)descr).getSmallIcon() != null) {
                    if (((DeploymentDescriptor)descr).getSmallIcon().getBytes() != null) {
                        newIcon = new ImageIcon(((DeploymentDescriptor)descr).getSmallIcon().getBytes());
                    } else {
                        ArchiveDescriptorNode archiveDescrNode = (ArchiveDescriptorNode)((DescriptorNode)value).getParent();
                        newIcon = this.getIconFromArchive(archiveDescrNode, ((DeploymentDescriptor)descr).getSmallIcon().getFileName());
                    }
                } else if (descr instanceof ServletDescriptor && ((ServletDescriptor)descr).getSmallIcon() != null) {
                    if (((ServletDescriptor)descr).getSmallIcon().getBytes() != null) {
                        newIcon = new ImageIcon(((ServletDescriptor)descr).getSmallIcon().getBytes());
                    } else {
                        ArchiveDescriptorNode archiveDescrNode = (ArchiveDescriptorNode)((DescriptorNode)value).getParent();
                        newIcon = this.getIconFromArchive(archiveDescrNode, ((ServletDescriptor)descr).getSmallIcon().getFileName());
                    }
                } else if (descr instanceof FilterDescriptor && ((FilterDescriptor)descr).getSmallIcon() != null) {
                    if (((FilterDescriptor)descr).getSmallIcon().getBytes() != null) {
                        newIcon = new ImageIcon(((FilterDescriptor)descr).getSmallIcon().getBytes());
                    } else {
                        ArchiveDescriptorNode archiveDescrNode = (ArchiveDescriptorNode)((DescriptorNode)value).getParent();
                        newIcon = this.getIconFromArchive(archiveDescrNode, ((FilterDescriptor)descr).getSmallIcon().getFileName());
                    }
                }
            }
        } else if (value instanceof EARDescriptorNode && ((EARDescriptorNode)value).getModifiedDescriptor() != null && ((EARDescriptorNode)value).getModifiedDescriptor().getSmallIcon() != null && ((EARDescriptorNode)value).getModifiedDescriptor().getSmallIcon().getBytes() != null) {
            newIcon = new ImageIcon(((EARDescriptorNode)value).getModifiedDescriptor().getSmallIcon().getBytes());
        }
        return newIcon;
    }

    private Icon getIconFromArchive(ArchiveDescriptorNode node, String name) {
        ImageIcon newIcon = null;
        String archName = node.getArchiveFileName();
        SerializableFile newIconFromArchive = this.getIconFromArchive(archName, name);
        if (newIconFromArchive != null && newIconFromArchive.getBytes() != null) {
            newIcon = new ImageIcon(newIconFromArchive.getBytes());
        }
        return newIcon;
    }

    private SerializableFile getIconFromArchive(String archiveFile, String fileName) {
        SerializableFile icon = null;
        if (archiveFile != null) {
            try {
                ZipFile zip = null;
                String temp = null;
                if (archiveFile.lastIndexOf(File.separator) == -1) {
                    return null;
                }
                temp = archiveFile.substring(0, archiveFile.lastIndexOf(File.separator)) + File.separator + "deploy_temp" + archiveFile.substring(archiveFile.lastIndexOf(File.separator));
                if (new File(temp).exists()) {
                    zip = new ZipFile(temp);
                } else if (new File(archiveFile).exists()) {
                    zip = new ZipFile(archiveFile);
                } else {
                    return null;
                }
                ZipEntry entry = null;
                entry = zip.getEntry(fileName.replace(File.separatorChar, '/'));
                if (entry != null) {
                    BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));
                    byte[] bytes = new byte[(int)entry.getSize()];
                    in.read(bytes);
                    icon = new SerializableFile();
                    icon.setFileName(fileName);
                    icon.setBytes(bytes);
                } else {
                    icon = new SerializableFile(fileName);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return icon;
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 10, retDimension.height);
        }
        return retDimension;
    }

    private void initImages() {
        try {
            this.ejb = ImageHolder.anEJBeanIcon;
            this.ejbJar = ImageHolder.aJarIcon;
            this.web = ImageHolder.aWebIcon;
            this.servlet = ImageHolder.aJSP_ServletIcon;
            this.filter = ImageHolder.aFilterIcon;
            this.listener = ImageHolder.aListenerIcon;
            this.ear = ImageHolder.anEarIcon;
            this.client = ImageHolder.aClientIcon;
            this.connector = ImageHolder.anConnectorIcon;
            this.library = ImageHolder.aLibraryIcon;
            this.plug_in_interface = ImageHolder.aInterfaceIcon;
            this.service = ImageHolder.aServiceIcon;
            this.server = ImageHolder.aServerIcon;
            this.dispatcher = ImageHolder.aDispatcherIcon;
            this.alone = ImageHolder.aAloneIcon;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

