/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.tree;

import com.sap.engine.deploy.tool.tree.BasicDescriptorNode;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.gui.mapping.MappingObject;
import java.io.File;
import java.util.Vector;

public abstract class ArchiveDescriptorNode
extends BasicDescriptorNode {
    protected ArchiveDescriptor descriptor;
    protected ArchiveDescriptor modifiedDescr;
    protected Vector additionalFiles;
    protected Vector baseAddFiles;
    protected long manifestTimeStamp;

    public ArchiveDescriptorNode() {
    }

    public ArchiveDescriptorNode(String name) {
        super(name);
    }

    public ArchiveDescriptorNode(String name, int type) {
        super(name, type);
    }

    public void setArchiveDescriptor(ArchiveDescriptor descr) {
        this.descriptor = descr;
    }

    public void setModifiedDescriptor(ArchiveDescriptor descr) {
        this.modifiedDescr = descr;
    }

    public ArchiveDescriptor getArchiveDescriptor() {
        return this.descriptor;
    }

    public ArchiveDescriptor getModifiedDescriptor() {
        return this.modifiedDescr;
    }

    public Vector getAdditionalFiles() {
        return this.additionalFiles;
    }

    public void setAdditionalFiles(Vector addFiles) {
        this.additionalFiles = addFiles;
    }

    public void addAdditionalFile(Object obj) {
        if (obj == null) {
            return;
        }
        if (this.additionalFiles == null) {
            this.additionalFiles = new Vector();
        }
        if (this.needsAdd(this.additionalFiles, obj)) {
            this.additionalFiles.add(obj);
        }
    }

    private boolean needsAdd(Vector vect, Object info) {
        if (vect != null && info != null) {
            int i = 0;
            while (i < vect.size()) {
                if (info.equals(vect.elementAt(i))) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    public ArchiveDescriptor getCurrentDescriptor() {
        if (this.modifiedDescr == null) {
            return this.descriptor;
        }
        return this.modifiedDescr;
    }

    public boolean needSave() {
        if (this.modifiedDescr == null) {
            return false;
        }
        if (!this.descriptor.equals(this.modifiedDescr)) {
            return true;
        }
        return this.isAddFilesChanged();
    }

    public void save() {
        if (this.modifiedDescr != null) {
            this.descriptor = (ArchiveDescriptor)this.modifiedDescr.clone();
        }
        this.setBaseAddFiles(this.additionalFiles);
    }

    public void setBaseAddFiles(Vector v) {
        if (v == null) {
            this.baseAddFiles = null;
            return;
        }
        this.baseAddFiles = new Vector();
        Object obj = null;
        File file = null;
        int i = 0;
        while (i < v.size()) {
            obj = v.elementAt(i);
            if (obj instanceof MappingObject) {
                this.baseAddFiles.add(((MappingObject)obj).clone());
            } else if (obj instanceof InfoObject) {
                if (((InfoObject)obj).getEntryName().equalsIgnoreCase("meta-inf\\Manifest.mf")) {
                    file = new File(((InfoObject)obj).getFilePath());
                    this.manifestTimeStamp = file.lastModified();
                }
                this.baseAddFiles.add(((InfoObject)obj).clone());
            }
            ++i;
        }
    }

    protected boolean isAddFilesChanged() {
        if (this.additionalFiles == null) {
            if (this.baseAddFiles == null) {
                return false;
            }
            return this.baseAddFiles.size() != 0;
        }
        if (this.baseAddFiles == null) {
            return this.additionalFiles.size() != 0;
        }
        if (this.additionalFiles.size() != this.baseAddFiles.size()) {
            return true;
        }
        Object obj1 = null;
        Object obj2 = null;
        File file = null;
        boolean isConsist = false;
        int i = 0;
        while (i < this.additionalFiles.size()) {
            obj1 = this.additionalFiles.elementAt(i);
            isConsist = false;
            int j = 0;
            while (j < this.baseAddFiles.size()) {
                obj2 = this.baseAddFiles.elementAt(j);
                if (obj1 instanceof MappingObject && obj2 instanceof MappingObject && ((MappingObject)obj1).equals(obj2)) {
                    isConsist = true;
                    break;
                }
                if (obj1 instanceof InfoObject && obj2 instanceof InfoObject) {
                    if (((InfoObject)obj1).getEntryName().equalsIgnoreCase("meta-inf\\Manifest.mf") && this.manifestTimeStamp != (file = new File(((InfoObject)obj1).getFilePath())).lastModified()) {
                        return true;
                    }
                    if (((InfoObject)obj1).equals(obj2)) {
                        isConsist = true;
                        break;
                    }
                }
                ++j;
            }
            if (!isConsist) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

