/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.server.common;

import com.sap.engine.deploy.server.provider.ServiceProviderDocument;
import com.sap.engine.deploy.tool.server.common.ProviderDescriptorPanel;
import com.sap.engine.deploy.tool.server.common.SComponentsReference;
import com.sap.engine.gui.LookAndFeelHandler;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ServiceProviderDescriptorPanel
extends ProviderDescriptorPanel {
    private JTextField dispatcherFrameTextField = new JTextField();
    private JTextField serverFrameTextField = new JTextField();
    private JLabel dispFrameLabel = new JLabel("Communication Frame:");
    private JLabel servFrameLabel = new JLabel("Application Frame:");
    private JLabel runtimeEditorLabel = new JLabel("Runtime Editor:");
    private JTextField runtimeEditorTextField = new JTextField();

    public ServiceProviderDescriptorPanel(Frame _frame) {
        super(_frame);
        this.initSpecific();
    }

    public void initSpecific() {
        LookAndFeelHandler.add(this.dispFrameLabel);
        LookAndFeelHandler.add(this.dispatcherFrameTextField);
        LookAndFeelHandler.add(this.servFrameLabel);
        LookAndFeelHandler.add(this.serverFrameTextField);
        this.add((Component)this.runtimeEditorLabel, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.runtimeEditorTextField, new GridBagConstraints(2, 6, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setSpecificInfo() {
        if (((ServiceProviderDocument)this.mainDoc).getCommunicationFrame() != null) {
            this.dispatcherFrameTextField.setText(((ServiceProviderDocument)this.mainDoc).getCommunicationFrame());
            this.init(16);
        }
        if (((ServiceProviderDocument)this.mainDoc).getApplicationFrame() != null) {
            this.serverFrameTextField.setText(((ServiceProviderDocument)this.mainDoc).getApplicationFrame());
            this.init(15);
        }
        this.runtimeEditorTextField.setText(((ServiceProviderDocument)this.mainDoc).getRuntimeEditor());
    }

    public void init(int madeFromConstant) {
        if (madeFromConstant == 16) {
            this.remove(this.serverFrameTextField);
            this.remove(this.servFrameLabel);
            this.add((Component)this.dispFrameLabel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.dispatcherFrameTextField, new GridBagConstraints(2, 4, 1, 1, 0.1, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        if (madeFromConstant == 15) {
            this.remove(this.dispatcherFrameTextField);
            this.remove(this.dispFrameLabel);
            this.add((Component)this.servFrameLabel, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.serverFrameTextField, new GridBagConstraints(2, 5, 1, 1, 0.1, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    public void commitChange() {
        this.mainDoc.setDisplayName(this.displayNameTextField.getText());
        this.mainDoc.setComponentName(this.componentNameTextField.getText());
        this.mainDoc.setGroupName(this.groupNameTextField.getText());
        this.mainDoc.setMajorVersion(this.majorField.getValue() + "");
        this.mainDoc.setMinorVersion(this.minorField.getValue() + "");
        this.mainDoc.setMicroVersion(this.microField.getValue() + "");
        this.mainDoc.setProviderName(this.providerTextField.getText());
        ((ServiceProviderDocument)this.mainDoc).setRuntimeEditor(this.runtimeEditorTextField.getText());
        this.mainDoc.setDescription(this.descrPanel.getText());
        if (this.dispatcherFrameTextField.getText() != null && !this.dispatcherFrameTextField.getText().trim().equals("")) {
            ((ServiceProviderDocument)this.mainDoc).setCommunicationFrame(this.dispatcherFrameTextField.getText());
        }
        if (this.serverFrameTextField.getText() != null && !this.serverFrameTextField.getText().trim().equals("")) {
            ((ServiceProviderDocument)this.mainDoc).setApplicationFrame(this.serverFrameTextField.getText());
        }
        SComponentsReference[] refs = this.refPanel.getReferences();
        Hashtable<String, String> refHash = new Hashtable<String, String>();
        Hashtable<String, String> refStrength = new Hashtable<String, String>();
        String refType = null;
        String strength = null;
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                switch (refs[i].getReferenceType()) {
                    case 12: {
                        refType = "library";
                        break;
                    }
                    case 13: {
                        refType = "interface";
                        break;
                    }
                    case 1: {
                        refType = "service";
                    }
                }
                refHash.put(refs[i].getName(), refType);
                switch (refs[i].getStrength()) {
                    case 0: {
                        strength = "weak";
                        break;
                    }
                    case 1: {
                        strength = "hard";
                        break;
                    }
                    case 2: {
                        strength = "notify";
                    }
                }
                refStrength.put(refs[i].getName(), strength);
                ++i;
            }
        }
        this.mainDoc.setReferences(refHash);
        this.mainDoc.setRefStrength(refStrength);
    }
}

