/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.server.common;

import com.sap.engine.deploy.tool.server.common.AddSComponentsReferenceDialog;
import com.sap.engine.deploy.tool.server.common.SComponentsReference;
import com.sap.engine.deploy.tool.server.common.SComponentsReferenceTableModel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SComponentsReferencePanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected Frame frame;
    protected SComponentsReferenceTableModel model = new SComponentsReferenceTableModel();
    protected JTable table = new JTable(this.model);
    protected JScrollPane scroll = new JScrollPane(this.table);
    protected JButton addButton = new JButton();
    protected JButton editButton = new JButton();
    protected JButton removeButton = new JButton();
    protected String borderName = null;
    private int componentType = 1;

    public SComponentsReferencePanel(Frame _frame) {
        this.frame = _frame;
        this.initView();
    }

    public SComponentsReferencePanel(Frame _frame, int _type) {
        this.componentType = _type;
        this.frame = _frame;
        this.initView();
    }

    private void initView() {
        this.setLayout(new GridBagLayout());
        this.model.clearAll();
        switch (this.componentType) {
            case 12: {
                this.borderName = "Library References";
                break;
            }
            case 13: {
                this.borderName = "Interface References";
                break;
            }
            case 1: {
                this.borderName = "Service References";
            }
        }
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.borderName));
        this.addButton.setText("Add");
        this.addButton.addActionListener(this);
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(this);
        this.editButton.setText("Edit");
        this.editButton.addActionListener(this);
        this.add((Component)this.scroll, new GridBagConstraints(0, 0, 1, 3, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.removeButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        this.valueChanged(null);
    }

    public void initReferences(SComponentsReference[] refs) {
        this.table.getSelectionModel().clearSelection();
        this.model.addRows(refs);
    }

    public int getType() {
        return this.componentType;
    }

    public void setType(int _type) {
        this.componentType = _type;
        switch (this.componentType) {
            case 12: {
                this.borderName = "Library References";
                break;
            }
            case 13: {
                this.borderName = "Interface References";
                break;
            }
            case 1: {
                this.borderName = "Service References";
            }
        }
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.borderName));
    }

    public SComponentsReference[] getReferences() {
        SComponentsReference[] res = this.model.getAllRows();
        if (res.length == 0) {
            return null;
        }
        return res;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.table.getSelectedRow() >= 0 && this.table.getSelectedRow() < this.table.getRowCount()) {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.addAction();
        } else if (e.getSource() == this.removeButton) {
            this.removeAction();
        } else if (e.getSource() == this.editButton) {
            this.editAction();
        }
    }

    protected void addAction() {
        AddSComponentsReferenceDialog dialog = new AddSComponentsReferenceDialog(this.frame, this.componentType);
        ((Component)dialog).setVisible(true);
        if (dialog.isCancel()) {
            return;
        }
        SComponentsReference ref = dialog.getReference();
        if (ref != null) {
            this.model.addRow(ref);
        }
    }

    protected void editAction() {
        int index = this.table.getSelectedRow();
        SComponentsReference ref = this.model.getRow(index);
        if (ref != null) {
            AddSComponentsReferenceDialog dialog = new AddSComponentsReferenceDialog(this.frame, ref, this.componentType);
            ((Component)dialog).setVisible(true);
            if (dialog.isCancel()) {
                return;
            }
            ref = dialog.getReference();
            if (ref != null) {
                this.model.updateReference(ref, index);
            }
        }
    }

    protected void removeAction() {
        this.model.removeRow(this.table.getSelectedRow());
        this.table.getSelectionModel().clearSelection();
    }
}

