/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.server.common;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.deploy.gui.SFileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SComponentsDialog
extends CEscapeDialog
implements ActionListener,
KeyListener {
    public static final byte LIBRARY = 0;
    public static final byte INTERFACE = 1;
    public static final byte SERVICE = 2;
    public static final String OK_CMD = "OK_CMD";
    public static final String CANCEL_CMD = "CANCEL_CMD";
    public static final String BROWSE_CMD = "BROWSE1_CMD";
    public static final String NEW_CMD = "NEW_CMD";
    public static final String LOAD_CMD = "LOAD_CMD";
    public static String LIBRARY_NAME = "Library Name:";
    public static String INTERFACE_NAME = "Interface Name:";
    public static String SERVICE_NAME = "Service Name:";
    protected boolean isOkAction = false;
    protected boolean createNew = true;
    protected SFileChooser chooser = null;
    protected Frame frame;
    JPanel panel1 = new JPanel();
    JPanel panel2 = new JPanel();
    JPanel mainPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout mainGridBag = new GridBagLayout();
    JLabel archLabel = new JLabel();
    JTextField archField = new JTextField();
    JLabel jarLabel = new JLabel();
    JTextField jarField = new JTextField();
    String dialogName;
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    JButton browseButton = new JButton();
    JRadioButton newButton = new JRadioButton("Create New");
    JRadioButton loadButton = new JRadioButton("Load Existing");
    ButtonGroup group = new ButtonGroup();
    private byte type;

    public SComponentsDialog(Frame frame, String title, boolean modal, byte compType) {
        super(frame, title, modal);
        this.frame = frame;
        this.type = compType;
        try {
            this.init();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(frame, "Could not initialize server components dialog.\n " + ex.toString(), "Error", 0);
        }
    }

    private void init() throws Exception {
        this.addKeyListener(this);
        this.panel1.setLayout(this.gridBagLayout1);
        this.panel2.setLayout(this.gridBagLayout2);
        this.mainPanel.setLayout(this.mainGridBag);
        switch (this.type) {
            case 0: {
                this.archLabel.setText("Library Name: ");
                break;
            }
            case 1: {
                this.archLabel.setText("Interface Name: ");
                break;
            }
            case 2: {
                this.archLabel.setText("Service Name: ");
            }
        }
        this.archField.setText("");
        this.okButton.setText("Ok");
        this.cancelButton.setText("Cancel");
        this.browseButton.setText("...");
        this.browseButton.setPreferredSize(new Dimension(21, 21));
        this.getContentPane().add(this.mainPanel);
        this.panel1.add((Component)this.archLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.archField, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(15, 5, 5, 15), 0, 0));
        this.panel2.add((Component)this.newButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 15, 0), 0, 0));
        this.panel2.add((Component)this.loadButton, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 15, 15), 0, 0));
        this.panel2.add((Component)this.jarLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.panel2.add((Component)this.jarField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.panel2.add((Component)this.browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jarLabel.setText("JAR File: ");
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.okButton.setActionCommand(OK_CMD);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand(CANCEL_CMD);
        this.browseButton.addActionListener(this);
        this.browseButton.setActionCommand(BROWSE_CMD);
        this.newButton.addActionListener(this);
        this.newButton.setActionCommand(NEW_CMD);
        this.loadButton.addActionListener(this);
        this.loadButton.setActionCommand(LOAD_CMD);
        this.panel1.setBorder(BorderFactory.createEtchedBorder());
        this.panel2.setBorder(BorderFactory.createEtchedBorder());
        this.group.add(this.newButton);
        this.group.add(this.loadButton);
        this.mainPanel.add((Component)this.panel1, new GridBagConstraints(0, 0, 3, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.panel2, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 3, 3, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.newButton.setSelected(true);
        this.jarField.setEnabled(false);
        this.browseButton.setEnabled(false);
        ((Component)this).setSize(new Dimension(400, 230));
    }

    public void initFields() {
        this.archField.setText("");
        this.jarField.setText("");
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(OK_CMD)) {
            this.okAction();
        } else if (cmd.equals(CANCEL_CMD)) {
            this.cancelAction();
        } else if (cmd.equals(BROWSE_CMD)) {
            if (this.chooser == null) {
                this.chooser = SFileChooser.getInstance((JFrame)this.frame);
            }
            this.chooser.setFilters(new String[]{".jar"});
            String name = this.getSelectedFile();
            if (name != null) {
                this.jarField.setText(name);
            }
        } else if (cmd.equals(NEW_CMD)) {
            this.createNew = true;
            this.jarField.setEnabled(false);
            this.browseButton.setEnabled(false);
        } else if (cmd.equals(LOAD_CMD)) {
            this.createNew = false;
            this.jarField.setEnabled(true);
            this.browseButton.setEnabled(true);
        }
    }

    public boolean isOkAction() {
        return this.isOkAction;
    }

    public boolean isNew() {
        return this.createNew;
    }

    public String getComponentName() {
        return this.archField.getText();
    }

    public String getJarName() {
        return this.jarField.getText();
    }

    protected String getSelectedFile() {
        String[] files = null;
        this.chooser.setFilters(new String[]{".jar"});
        files = this.chooser.showFileDialog("Select File", false, false, false);
        if (files != null && files[0] != null) {
            return files[0];
        }
        return null;
    }

    private void cancelAction() {
        this.isOkAction = false;
        ((Component)this).setVisible(false);
    }

    private void okAction() {
        if (this.createNew) {
            if (this.archField.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "The obligatory fields are not filled in!\n       Archive Name is Missing!", "Warning", 0);
                return;
            }
        } else {
            if (this.jarField.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "The obligatory fields are not filled in!       JAR Name is Missing!", "Warning", 0);
                return;
            }
            if (this.archField.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "The obligatory fields are not filled in!\n       Archive Name is Missing!", "Warning", 0);
                return;
            }
        }
        if (!FileUtils.isCorrectFileName(this.archField.getText())) {
            JOptionPane.showMessageDialog(this.frame, "The archive name contains forbiden symbols!", "Warning", 0);
            return;
        }
        this.isOkAction = true;
        ((Component)this).setVisible(false);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.okAction();
        } else if (keyEvent.getKeyCode() == 27) {
            this.cancelAction();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public void setarchLabelText(String _text) {
        this.archLabel.setText(_text);
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }
}

