/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.server.common;

import com.sap.engine.deploy.tool.server.common.SComponentsReference;
import com.sap.engine.gui.CEscapeDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddSComponentsReferenceDialog
extends CEscapeDialog
implements ActionListener,
DocumentListener {
    protected JPanel centralPanel = new JPanel();
    protected JPanel controlPanel = new JPanel();
    protected JLabel nameLabel = new JLabel();
    protected JTextField nameField = new JTextField();
    protected JLabel typeLabel = new JLabel();
    protected JComboBox typeCombo;
    protected JLabel strengthLabel = new JLabel();
    protected JComboBox strengthCombo;
    protected JButton okBtn = new JButton();
    protected JButton cancelBtn = new JButton();
    protected boolean isCancel = true;
    private SComponentsReference reference;
    private int componentType;

    public AddSComponentsReferenceDialog(Frame frame, int _type) {
        super(frame, "Add Reference", true);
        this.componentType = _type;
        this.initView();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public AddSComponentsReferenceDialog(Frame frame, SComponentsReference reference, int _type) {
        super(frame, "Edit Reference", true);
        this.componentType = _type;
        this.initView();
        this.pack();
        this.setLocationRelativeTo(frame);
        this.nameField.setText(reference.getName());
        int refType = reference.getReferenceType();
        int strength = reference.getStrength();
        switch (refType) {
            case 13: {
                this.typeCombo.setSelectedIndex(0);
                break;
            }
            case 12: {
                this.typeCombo.setSelectedIndex(1);
                break;
            }
            case 1: {
                this.typeCombo.setSelectedIndex(2);
            }
        }
        switch (strength) {
            case 0: {
                this.strengthCombo.setSelectedIndex(1);
                break;
            }
            case 1: {
                this.strengthCombo.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.strengthCombo.setSelectedIndex(2);
            }
        }
    }

    protected void initView() {
        this.centralPanel.setLayout(new GridBagLayout());
        this.centralPanel.setBorder(BorderFactory.createEtchedBorder());
        this.nameLabel.setText("Reference Name: ");
        this.typeLabel.setText("Type:");
        String[] types = null;
        switch (this.componentType) {
            case 13: {
                types = new String[]{"Interface"};
                break;
            }
            case 12: {
                types = new String[]{"Interface", "Library"};
                break;
            }
            case 1: {
                types = new String[]{"Interface", "Library", "Service"};
            }
        }
        this.typeCombo = new JComboBox(types);
        this.typeCombo.addActionListener(this);
        this.strengthLabel.setText("Strength:");
        this.strengthCombo = this.componentType == 1 ? new JComboBox<String>(new String[]{"Weak", "Hard", "Notify"}) : new JComboBox<String>(new String[]{"Weak"});
        this.nameField.setPreferredSize(new Dimension(250, 19));
        this.nameField.getDocument().addDocumentListener(this);
        this.centralPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.centralPanel.add((Component)this.nameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.centralPanel.add((Component)this.typeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.centralPanel.add((Component)this.typeCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.centralPanel.add((Component)this.strengthLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.centralPanel.add((Component)this.strengthCombo, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.controlPanel.setLayout(new FlowLayout());
        this.okBtn.setText("Ok");
        this.okBtn.addActionListener(this);
        this.okBtn.setEnabled(false);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(this);
        this.controlPanel.add(this.okBtn);
        this.controlPanel.add(this.cancelBtn);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.centralPanel, "Center");
        this.getContentPane().add((Component)this.controlPanel, "South");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okBtn) {
            this.okAction();
        } else if (e.getSource() == this.cancelBtn) {
            this.cancelAction();
        } else if (e.getSource() == this.typeCombo) {
            switch (this.componentType) {
                case 13: {
                    this.strengthCombo.setSelectedItem("Weak");
                    this.strengthCombo.setEnabled(false);
                    break;
                }
                case 12: {
                    this.strengthCombo.setSelectedItem("Weak");
                    this.strengthCombo.setEnabled(false);
                    break;
                }
                case 1: {
                    this.strengthCombo.setSelectedItem("Weak");
                    this.strengthCombo.setEnabled(true);
                }
            }
        }
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }

    private void okAction() {
        String name = this.nameField.getText().trim();
        int refType = 0;
        switch (this.typeCombo.getSelectedIndex()) {
            case 0: {
                refType = 13;
                break;
            }
            case 1: {
                refType = 12;
                break;
            }
            case 2: {
                refType = 1;
            }
        }
        int strength = this.strengthCombo.getSelectedIndex();
        if (name.length() == 0) {
            this.cancelAction();
        }
        this.reference = new SComponentsReference();
        this.reference.setName(name);
        this.reference.setReferenceType(refType);
        this.reference.setStrength(strength);
        this.isCancel = false;
        ((Component)this).setVisible(false);
    }

    private void cancelAction() {
        this.reference = null;
        this.isCancel = true;
        ((Component)this).setVisible(false);
    }

    public SComponentsReference getReference() {
        return this.reference;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.nameField.getText().trim().equals("")) {
            this.okBtn.setEnabled(true);
        } else {
            this.okBtn.setEnabled(false);
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.nameField.getText().trim().equals("")) {
            this.okBtn.setEnabled(true);
        } else {
            this.okBtn.setEnabled(false);
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }
}

