/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.deployer;

import com.sap.engine.deploy.tool.deployer.UndeployTableModel;
import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.SortTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;

public class UndeployDialog
extends CEscapeDialog
implements ActionListener {
    private UndeployTableModel tableModel = new UndeployTableModel();
    private Frame frame;
    private SortTable table;
    private JPanel panel;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton selectAllBtn;
    private JButton deselectAllBtn;
    private final String OK_CMD = "OK";
    private final String CANCEL_CMD = "CANCEL";
    private final String SELECT_ALL_CMD = "SELECT_ALL";
    private final String DESELECT_ALL_CMD = "DESELECT_ALL";
    private boolean isOk = false;

    public UndeployDialog(Frame frame1) {
        super(frame1);
        this.frame = frame1;
        this.init();
        LookAndFeelHandler.add(this);
    }

    private void init() {
        this.table = new SortTable(this.tableModel);
        this.table.setModel(this.tableModel);
        this.panel = new JPanel();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("CANCEL");
        this.cancelButton.addActionListener(this);
        this.selectAllBtn = new JButton("Select All");
        this.selectAllBtn.setActionCommand("SELECT_ALL");
        this.selectAllBtn.addActionListener(this);
        this.deselectAllBtn = new JButton("Deselect All");
        this.deselectAllBtn.setActionCommand("DESELECT_ALL");
        this.deselectAllBtn.addActionListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(400);
        this.buttonPanel.add(this.selectAllBtn);
        this.buttonPanel.add(this.deselectAllBtn);
        this.buttonPanel.add(new JSeparator());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.panel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Applicatons for undeploy"));
        this.panel.setLayout(new GridBagLayout());
        this.panel.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 0.01, 0.01, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.setPreferredSize(new Dimension(300, 300));
        this.setModal(true);
        ((Component)this).setSize(new Dimension(640, 460));
        this.setResizable(true);
        this.setTitle("Undeploy Editor Panel");
        this.getContentPane().add(this.panel);
        this.setLocationRelativeTo(this.frame);
    }

    public void initData(String[] apps) {
        this.tableModel.initData(apps);
    }

    public void updateData(String[] apps) {
        this.tableModel.updateData(apps);
    }

    public String[] getAppForUndeploy() {
        return this.tableModel.getSelected(1);
    }

    public boolean isOk() {
        return this.isOk;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("OK")) {
            if (this.tableModel.hasRepeatable(2)) {
                JOptionPane.showMessageDialog(this.frame, "There is components with duplicated names.\nChenge names or diselect components with repeatable names.", "Error", 0);
                return;
            }
            if (this.tableModel.hasRepeatable(1)) {
                JOptionPane.showMessageDialog(this.frame, "There is already  a  servlet  or  jsp with the same class(es).\nRemove duplicated class from additional or deselect repeatable \nfiles from combo box and try again. ", "Warning", 2);
                return;
            }
            this.isOk = true;
            ((Component)this).setVisible(false);
        } else if (cmd.equals("CANCEL")) {
            this.isOk = false;
            ((Component)this).setVisible(false);
        } else if (cmd.equals("SELECT_ALL")) {
            this.tableModel.selectAll(true);
        } else if (cmd.equals("DESELECT_ALL")) {
            this.tableModel.selectAll(false);
        }
    }

    protected void performEnterAction(KeyEvent e) {
        if (this.tableModel.hasRepeatable(2)) {
            JOptionPane.showMessageDialog(this.frame, "There is components with duplicated names.\nChenge names or diselect components with repeatable names.", "Error", 0);
            return;
        }
        if (this.tableModel.hasRepeatable(1)) {
            JOptionPane.showMessageDialog(this.frame, "There is already  a  servlet  or  jsp with the same class(es).\nRemove duplicated class from additional or deselect repeatable \nfiles from combo box and try again. ", "Warning", 2);
            return;
        }
        this.isOk = true;
        ((Component)this).setVisible(false);
    }

    protected void performEscapeAction(KeyEvent e) {
        this.isOk = false;
        ((Component)this).setVisible(false);
    }
}

