/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.deployer;

import com.sap.engine.deploy.SimpleEARClassLoader;
import com.sap.engine.deploy.ejb.gui.EJBJarPanel;
import com.sap.engine.deploy.manager.DeployConfigDocument;
import com.sap.engine.deploy.manager.LoginInfo;
import com.sap.engine.deploy.manager.component.ComponentInfo;
import com.sap.engine.deploy.manager.component.SComponentsXmlDocument;
import com.sap.engine.deploy.server.SComponentObject;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.MainTabPanel;
import com.sap.engine.deploy.tool.PopupListener;
import com.sap.engine.deploy.tool.ToolTabPanel;
import com.sap.engine.deploy.tool.deployer.DeployerActionManager;
import com.sap.engine.deploy.tool.tree.ArchiveDescriptorNode;
import com.sap.engine.deploy.tool.tree.BasicDescriptorNode;
import com.sap.engine.deploy.tool.tree.EARDescriptorNode;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.security.remote.RemoteSecurity;
import java.awt.Frame;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class DeployTab
extends MainTabPanel
implements ToolTabPanel {
    String tabName = "Deployer";
    JButton[] b = new JButton[3];
    DeployerActionManager manager = null;
    JMenu menu;
    protected JLabel status = new JLabel();
    protected JProgressBar progressBar = new JProgressBar();
    protected String prjFileDir;
    boolean needSaving = false;
    private File oldDir = null;
    protected Properties tabProperties = null;
    protected JPopupMenu popup = new JPopupMenu();
    protected MouseListener mouseListener;
    public static String REMOTE_P4_PORT = "RemotePort";
    public static String HTTP_TUNNELING_PORT = "Http_tunneling_port";
    public static String SSL_PORT = "Ssl_port";
    public static String HTTPS_PORT = "Https_port";

    public DeployTab() {
        this.manager = new DeployerActionManager(this);
        this.manager.setTree(this.tree);
        this.madeFrom = 3;
        this.appInfoProvider = new ApplicationInformationProvider((DefaultMutableTreeNode)this.treeModel.getRoot(), this.madeFrom);
        this.mouseListener = new PopupListener(this.popup);
        this.tree.addMouseListener(this.mouseListener);
    }

    public DeployTab(Frame frame, boolean displayRoot, int panelType, boolean askBeforeSaveOnSelection) {
        super(frame, displayRoot, panelType, askBeforeSaveOnSelection);
        this.manager = new DeployerActionManager(this);
        this.manager.setTree(this.tree);
        this.madeFrom = 3;
        this.appInfoProvider = new ApplicationInformationProvider((DefaultMutableTreeNode)this.treeModel.getRoot(), this.madeFrom);
        this.mouseListener = new PopupListener(this.popup);
        this.tree.addMouseListener(this.mouseListener);
    }

    public JMenu getContentMenu() {
        return this.manager.getDeployMenu();
    }

    public JButton[] getToolBarButtons() {
        return this.manager.getDeployButtons();
    }

    public String getTabName() {
        return this.tabName;
    }

    public String getXMLFileLocation() {
        return this.manager.xmlFileName;
    }

    public void makeDeployableEAR(String archiveName) throws IOException {
        File archFile = new File(archiveName);
        if (archFile.exists() && archFile.isDirectory()) {
            throw new IOException(archiveName + " is a name of existing directory. Making of deployable ear with name " + archiveName + " is imposible.");
        }
        archiveName.replace('/', File.separatorChar);
        archiveName.replace('\\', File.separatorChar);
        int index = archiveName.lastIndexOf(File.separatorChar);
        if (index != -1 && !(archFile = new File(archiveName.substring(0, index))).exists()) {
            archFile.mkdirs();
        }
        if (!archiveName.toLowerCase().endsWith(".ear") && !archiveName.toLowerCase().endsWith(".sda")) {
            archiveName = archiveName + ".ear";
        }
        this.manager.deployAction((byte)2, archiveName);
    }

    public String getXMLRelativeLocation() {
        String result = "";
        String tmp0 = this.manager.xmlFileName;
        if (tmp0 == null) {
            return null;
        }
        if (this.prjFileDir == null) {
            return tmp0;
        }
        File f = new File(this.prjFileDir);
        if (f.getAbsolutePath().equals(new File(tmp0).getParent())) {
            return tmp0;
        }
        if (f.getParent() != null && tmp0.indexOf(f.getParent()) == -1) {
            return tmp0;
        }
        String tmp1 = tmp0.substring(tmp0.lastIndexOf(File.separator, tmp0.length()));
        String tmp15 = tmp0.substring(0, tmp0.lastIndexOf(File.separator));
        String tmp2 = tmp15.substring(tmp15.lastIndexOf(File.separator, tmp15.length()));
        result = tmp2 + tmp1;
        return result;
    }

    public int getType() {
        return 0;
    }

    public void isCorrect() {
    }

    public boolean isVerifying() {
        return this.manager.isVerifyApplication();
    }

    public void initOnProjectOpen(String xmlFile, String[] paths) throws IOException {
        this.removeTemp(this.manager.parentDir);
        this.manager.initOnProjectOpen(xmlFile, paths);
    }

    public void saveXMLOnProjectSave() {
        this.commitSelected();
        this.needSaving = false;
        if (((DefaultMutableTreeNode)this.treeModel.getRoot()).getChildCount() == 0) {
            this.manager.xmlFileName = null;
            return;
        }
        try {
            this.manager.saveNodeProperties();
            this.manager.saveXMLFile();
            this.saveNodes();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred while trying to save deployer xml file: " + e.getMessage(), "Error in xml", 0);
        }
    }

    public void clearOnProjectClose() {
        this.removeTemp(this.manager.parentDir);
        this.treeModel = (DefaultTreeModel)this.tree.getModel();
        ((DefaultMutableTreeNode)this.treeModel.getRoot()).removeAllChildren();
        ((DefaultTreeModel)this.tree.getModel()).setRoot(new EARDescriptorNode("EAR"));
        this.tree.setRootVisible(false);
        this.treeModel.reload();
        this.manager.xmlFileName = null;
        this.manager.logFileName = null;
        this.manager.document = new DeployConfigDocument();
        LoginInfo loginInfo = new LoginInfo();
        try {
            loginInfo.setRemotePort(new Integer(this.tabProperties.getProperty("RemotePort")));
        }
        catch (Exception portEx) {
            loginInfo.setRemotePort(50004);
        }
        loginInfo.setTransportProtocol(new String[]{"None"});
        this.manager.document.setInfo(loginInfo);
        this.manager.disconnectOnClose();
        if (this.loader != null && this.loader instanceof SimpleEARClassLoader) {
            ((SimpleEARClassLoader)this.loader).clear();
        }
        this.status.setText("");
        this.status.repaint();
        this.status.validate();
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(false);
        this.needSaving = false;
        this.clearSelected();
        this.manager.deployButtons[2].setEnabled(false);
        this.manager.deploy_ear_Item.setEnabled(false);
        this.manager.updateEarItem.setEnabled(false);
        this.manager.clusterItem.setEnabled(false);
        this.manager.refresh_ear_Item.setEnabled(false);
        this.manager.deployButtons[3].setEnabled(false);
        this.manager.getTempEarItem.setEnabled(false);
        this.manager.getTempEarItem1.setEnabled(false);
        if (this.manager.broker != null) {
            this.manager.broker.close();
        }
        this.manager.ctx = null;
    }

    protected void clearSelected() {
        this.lastSelectedPanel = null;
        this.lastSelectedNode = null;
        this.propertiesPanel.removeAll();
        this.tree.clearSelection();
        this.mainFrame.repaint();
    }

    public void recievedTabSelection() {
        if (((EARDescriptorNode)this.tree.getModel().getRoot()).getArchiveFileName() != null) {
            long time;
            long newTime;
            File earFile = new File(((EARDescriptorNode)this.tree.getModel().getRoot()).getArchiveFileName());
            if (!earFile.exists()) {
                return;
            }
            if (this.manager.getDObjType() != null && this.manager.getDObjType().equals("Ear") && (newTime = earFile.lastModified()) > (time = ((EARDescriptorNode)this.tree.getModel().getRoot()).getArchiveTime())) {
                if (this.manager.document != null) {
                    this.manager.document.setDisplayName(null);
                    this.manager.document.setAliases(new Hashtable());
                    this.manager.document.setEarFileAltDD(null);
                }
                this.manager.loadEar(earFile.getAbsolutePath());
            }
        }
        if (this.manager.deployStatus) {
            this.manager.deployButtons[2].setEnabled(false);
            this.manager.deploy_ear_Item.setEnabled(false);
        } else if (this.manager.treeModel != null && ((EARDescriptorNode)this.manager.treeModel.getRoot()).getChildCount() > 0) {
            this.manager.deployButtons[2].setEnabled(true);
            this.manager.deploy_ear_Item.setEnabled(true);
        }
    }

    public void setFrame(Frame frame) {
        this.setParentFrame(frame);
    }

    public void setProjectProperties(Properties props) {
        this.tabProperties = props;
    }

    public void setVerifyApplication(boolean state) {
        this.manager.setVerifyApplication(state);
    }

    public void setAdditionalClasspath(String[] classpath) {
        this.manager.setClassPath(classpath);
    }

    public void newProjectCreated() {
        this.manager.initAdditionalDirs(true);
        this.clearOnProjectClose();
    }

    public void setProjectDir(File dir, File fileDir) {
        this.oldDir = this.manager.parentDir;
        this.prjFileDir = dir != null ? fileDir.getAbsolutePath() : null;
        super.setPrjDir(this.manager.getProjectDir());
        this.manager.parentDir = dir;
    }

    public String[] hasResults() {
        return null;
    }

    public Object[] getValue(String tabName) {
        return null;
    }

    public void setValue(Object[] values) {
        if (values != null && values.length != 0) {
            long time;
            File earFile;
            long newTime;
            if (values[0] instanceof String && (newTime = (earFile = new File((String)values[0])).lastModified()) > (time = ((EARDescriptorNode)this.tree.getModel().getRoot()).getArchiveTime())) {
                this.manager.setIsTransfer(true);
                if (this.manager.document != null) {
                    this.manager.document.setDisplayName(null);
                    this.manager.document.setAliases(new Hashtable());
                    this.manager.document.setEarFileAltDD(null);
                }
                this.manager.loadEar((String)values[0]);
                this.passRoles1();
            }
            if (this.manager.document.getComponentXmlDoc() == null) {
                this.manager.document.setComponentXmlDoc(new SComponentsXmlDocument());
            }
            ComponentInfo[] cInfo = new ComponentInfo[]{};
            ComponentInfo[] temp = null;
            int i = 0;
            while (i < values.length) {
                if (values[i] instanceof SComponentObject) {
                    temp = new ComponentInfo[cInfo.length + 1];
                    System.arraycopy(cInfo, 0, temp, 0, cInfo.length);
                    temp[cInfo.length] = new ComponentInfo((SComponentObject)values[i], "deploy");
                    cInfo = temp;
                }
                ++i;
            }
            this.manager.document.getComponentXmlDoc().setComponents(cInfo);
        }
    }

    public boolean needSave() {
        this.commitSelected();
        if (this.needSaving) {
            return true;
        }
        return this.isNeedSave();
    }

    public void setStatusBar(JLabel label) {
        this.status = label;
    }

    public void setRemoteSecurity(RemoteSecurity node1) {
        this.node = node1;
        this.mainRarPanel.setContext(this.node);
        this.mainEarPanel.setContext(this.node);
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public String getPrjFileDir() {
        return this.prjFileDir;
    }

    public void removeTemp(File parent) {
        File[] files;
        String name = null;
        if (parent != null && (files = parent.listFiles()) != null) {
            int j = 0;
            while (j < files.length) {
                name = files[j].getName();
                if (name.startsWith("deploy_temp")) {
                    this.removeTempDir(files[j]);
                    break;
                }
                ++j;
            }
        }
    }

    public String[] getAdditionalClassPaths() {
        return null;
    }

    public void removeTempDir(File tempDir) {
        File[] files = tempDir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.removeTempDir(files[i]);
                }
                boolean flag = files[i].delete();
                ++i;
            }
        }
        boolean bl = tempDir.delete();
    }

    public void clearOnSaveAs() {
        this.manager.xmlFileName = null;
        if (this.manager.treeModel == null || this.manager.treeModel.getRoot() == null) {
            return;
        }
        EARDescriptorNode earNode = (EARDescriptorNode)this.manager.treeModel.getRoot();
        BasicDescriptorNode archNode = null;
        BasicDescriptorNode archChildNode = null;
        int count1 = 0;
        int count2 = 0;
        if (earNode != null) {
            earNode.setXMLFileName(null);
            earNode.setArchiveFileName(this.resetArchiveFileNames(earNode.getArchiveFileName()));
            this.manager.document.setEarPath(earNode.getArchiveFileName());
            count1 = earNode.getChildCount();
            int i = 0;
            while (i < count1) {
                archNode = (BasicDescriptorNode)earNode.getChildAt(i);
                if (archNode != null) {
                    archNode.setXMLFileName(null);
                    count2 = archNode.getChildCount();
                    int j = 0;
                    while (j < count2) {
                        archChildNode = (BasicDescriptorNode)archNode.getChildAt(j);
                        if (archChildNode != null) {
                            archChildNode.setXMLFileName(null);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private String resetArchiveFileNames(String name) {
        if (name == null) {
            return null;
        }
        if (this.oldDir == null || name.indexOf(this.oldDir.getAbsolutePath()) == -1) {
            return name;
        }
        String relativeName = name.substring(this.oldDir.getAbsolutePath().length() + 1);
        File f = new File(this.manager.parentDir.getAbsolutePath() + File.separator + relativeName);
        if (!f.exists()) {
            return name;
        }
        if (f.getParent().equals(this.manager.parentDir.getParent())) {
            return name;
        }
        return f.getAbsolutePath();
    }

    public void lostTabSelection() {
        this.updateNodeProperties();
    }

    public void enableWebServAction() {
        if (!(this.lastSelectedPanel instanceof EJBJarPanel)) {
            JOptionPane.showMessageDialog(this.mainFrame, "Web Services supported only for EJB Jars components.", "Not implemented yet.", 0);
        } else {
            ((EJBJarPanel)this.lastSelectedPanel).enableWebService();
        }
    }

    public void deleteGeneratedFiles() {
        EARDescriptorNode root = (EARDescriptorNode)this.treeModel.getRoot();
        Enumeration<TreeNode> children = root.children();
        ArchiveDescriptorNode node = null;
        String currXML = null;
        String dir = null;
        File currFile = null;
        while (children.hasMoreElements()) {
            node = (ArchiveDescriptorNode)children.nextElement();
            currXML = node.getXMLFileName();
            dir = node.getArchiveFileName().replace('.', '_');
            currFile = new File(dir);
            FileUtils.deleteDirectory(currFile);
            if (currXML == null || (currFile = new File(currXML)) == null || !currFile.exists()) continue;
            currFile.delete();
        }
        currFile = this.manager.getLogFile();
        if (currFile != null && currFile.exists()) {
            currFile.delete();
        }
    }

    protected void passRoles1() {
        this.manager.passRoles();
    }

    public void removePopupMenu() {
        this.tree.removeMouseListener(this.mouseListener);
    }
}

