/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.deployer;

import com.sap.engine.gui.lf.LookAndFeelFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JOptionPane;

public class DeployOptions {
    public static int INITIAL_WIDTH = 510;
    public static int INITIAL_HEIGHT = 515;
    public static int MAX_RECONNECT = 4;
    private String fileName;
    private String optionsName = "Deploy Frame Options";
    public Properties props;
    protected LookAndFeelFactory lfFactory = new LookAndFeelFactory();

    public DeployOptions(Properties props) {
        this.props = props;
    }

    public void updateFrameLocation(Frame frame) {
        try {
            int locatX = Integer.parseInt(this.props.getProperty("FrameLocationX"));
            int locatY = Integer.parseInt(this.props.getProperty("FrameLocationY"));
            int width = Integer.parseInt(this.props.getProperty("FrameWidth"));
            int height = Integer.parseInt(this.props.getProperty("FrameHeight"));
            ((Component)frame).setLocation(locatX, locatY);
            ((Component)frame).setSize(width, height);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(frame, "Location and/or size for this frame is not correct. Default values will be set.\n" + ex.toString(), "Warning", 2);
        }
    }

    public void setFrameProperties(Frame frame) {
        int locatX = frame.getLocation().x;
        int locatY = frame.getLocation().y;
        int width = frame.getSize().width;
        int height = frame.getSize().height;
        ((Hashtable)this.props).put("FrameLocationX", String.valueOf(locatX));
        ((Hashtable)this.props).put("FrameLocationY", String.valueOf(locatY));
        ((Hashtable)this.props).put("FrameWidth", String.valueOf(width));
        ((Hashtable)this.props).put("FrameHeight", String.valueOf(height));
    }

    public String getLookAndFeel() {
        return this.props.getProperty("LookAndFeel");
    }

    public void setLookAndFeel(String landf) {
        ((Hashtable)this.props).put("LookAndFeel", landf);
    }

    public void saveProperties() {
        try {
            this.lfFactory.store(this.props);
            FileOutputStream propStream = new FileOutputStream(this.fileName);
            this.props.store(propStream, this.optionsName);
            propStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getReconnectCount() {
        try {
            return Integer.parseInt(this.props.getProperty("ReconnectCount"));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public void setReconnectCount(int count) {
        ((Hashtable)this.props).put("ReconnectCount", String.valueOf(count));
    }

    public int getMaxReconnectCount() {
        try {
            return Integer.parseInt(this.props.getProperty("MaxReconnectCount"));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public void setMaxReconnectCount(int count) {
        ((Hashtable)this.props).put("MaxReconnectCount", String.valueOf(MAX_RECONNECT));
    }

    public String getUserName(int i) {
        String res = this.props.getProperty("Name" + String.valueOf(i));
        if (res == null) {
            res = "";
        }
        return res;
    }

    public String getHostName(int i) {
        String res = this.props.getProperty("Host" + String.valueOf(i));
        if (res == null) {
            res = "";
        }
        return res;
    }

    public int getPortNumber(int i) {
        try {
            return Integer.parseInt(this.props.getProperty("Port" + String.valueOf(i)));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public int getLayer(int i) {
        String res = this.props.getProperty("TransportLayerQueue" + String.valueOf(i));
        if (res == null) {
            return 0;
        }
        if (res.equals("HTTP")) {
            return 1;
        }
        if (res.equals("SSL")) {
            return 2;
        }
        return 0;
    }

    public String getHTTPHost(int i) {
        String res = this.props.getProperty("HTTP_Host" + String.valueOf(i));
        if (res == null) {
            res = "";
        }
        return res;
    }

    public String getHTTPPort(int i) {
        String res = this.props.getProperty("HTTP_Port" + String.valueOf(i));
        if (res == null) {
            res = "";
        }
        return res;
    }

    public String getCertFileName(int i) {
        String res = this.props.getProperty("SSL_CertFile" + String.valueOf(i));
        if (res == null) {
            res = "";
        }
        return res;
    }

    public String getKeyFileName(int i) {
        String res = this.props.getProperty("SSL_KeyFile" + String.valueOf(i));
        if (res == null) {
            res = "";
        }
        return res;
    }

    public void addReconnectInfo(String userName, String hostName, int port, Properties transports) {
        int index = this.getReconnectCount();
        int i = 0;
        while (i < this.getReconnectCount()) {
            if (this.getUserName(i).equals(userName) && this.getHostName(i).equals(hostName) && this.getPortNumber(i) == port) {
                index = i;
            }
            ++i;
        }
        int i2 = index;
        while (i2 > 0) {
            if (i2 < MAX_RECONNECT) {
                ((Hashtable)this.props).put("Name" + String.valueOf(i2), this.getUserName(i2 - 1));
                ((Hashtable)this.props).put("Host" + String.valueOf(i2), this.getHostName(i2 - 1));
                ((Hashtable)this.props).put("Port" + String.valueOf(i2), String.valueOf(this.getPortNumber(i2 - 1)));
                ((Hashtable)this.props).put("TransportLayerQueue" + String.valueOf(i2), transports.getProperty("TransportLayerQueue"));
                ((Hashtable)this.props).put("HTTP_Host" + String.valueOf(i2), transports.getProperty("HTTP_Host"));
                ((Hashtable)this.props).put("HTTP_Port" + String.valueOf(i2), transports.getProperty("HTTP_Port"));
                ((Hashtable)this.props).put("SSL_CertFile" + String.valueOf(i2), transports.getProperty("SSL_CertFile"));
                ((Hashtable)this.props).put("SSL_KeyFile" + String.valueOf(i2), transports.getProperty("SSL_KeyFile"));
            }
            --i2;
        }
        ((Hashtable)this.props).put("Name0", userName);
        ((Hashtable)this.props).put("Host0", hostName);
        ((Hashtable)this.props).put("Port0", String.valueOf(port));
        ((Hashtable)this.props).put("TransportLayerQueue0", transports.getProperty("TransportLayerQueue"));
        ((Hashtable)this.props).put("HTTP_Host0", transports.getProperty("HTTP_Host"));
        ((Hashtable)this.props).put("HTTP_Port0", transports.getProperty("HTTP_Port"));
        ((Hashtable)this.props).put("SSL_CertFile0", transports.getProperty("SSL_CertFile"));
        ((Hashtable)this.props).put("SSL_KeyFile0", transports.getProperty("SSL_KeyFile"));
        if (index == this.getReconnectCount() && this.getReconnectCount() < MAX_RECONNECT) {
            ((Hashtable)this.props).put("ReconnectCount", String.valueOf(this.getReconnectCount() + 1));
        }
    }

    public LookAndFeelFactory getLookAndFeelFactory() {
        return this.lfFactory;
    }

    public void setLookAndFeelFactory(LookAndFeelFactory factory) {
        this.lfFactory = factory;
        this.saveProperties();
    }

    private void initDefaultProperties() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int locatX = screenSize.width / 2 - INITIAL_WIDTH / 2;
        int locatY = screenSize.height / 2 - INITIAL_HEIGHT / 2;
        ((Hashtable)this.props).put("Name0", "Administrator");
        ((Hashtable)this.props).put("Host0", "localhost");
        ((Hashtable)this.props).put("Port0", "3011");
        ((Hashtable)this.props).put("FrameLocationX", String.valueOf(locatX));
        ((Hashtable)this.props).put("FrameLocationY", String.valueOf(locatY));
        ((Hashtable)this.props).put("FrameWidth", String.valueOf(INITIAL_WIDTH));
        ((Hashtable)this.props).put("FrameHeight", String.valueOf(INITIAL_HEIGHT));
        ((Hashtable)this.props).put("LookAndFeel", "Metal");
        ((Hashtable)this.props).put("ReconnectCount", "1");
        ((Hashtable)this.props).put("MaxReconnectCount", "4");
        ((Hashtable)this.props).put("TransportLayerQueue", "None");
        this.saveProperties();
    }
}

