/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.components;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.deploy.gui.SFileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NewDialog
extends CEscapeDialog
implements ActionListener,
KeyListener {
    public static final byte EJB = 0;
    public static final byte WEB = 1;
    public static final byte CLIENT = 2;
    public static final byte CONNECTOR = 3;
    public static final String OK_CMD = "OK_CMD";
    public static final String CANCEL_CMD = "CANCEL_CMD";
    public static final String BROWSE1_CMD = "BROWSE1_CMD";
    public static final String BROWSE_CMD = "BROWSE_CMD";
    public static final String BROWSE2_CMD = "BROWSE2_CMD";
    public static final String NEW_CMD = "NEW_CMD";
    public static final String LOAD_CMD = "LOAD_CMD";
    public static String SS_NAME = "Service Name:";
    public static String SS_JAR_NAME = "Service Jar Name:";
    public static String EJB_NAME = "EJB Name:";
    public static String EJB_JAR_NAME = "EJB Jar Name:";
    public static String WEB_NAME = "Web Component:";
    public static String WAR_NAME = "War Name:";
    public static String CL_NAME = "Client Name:";
    public static String CL_JAR_NAME = "Client Jar Name:";
    public static String OTHER_NAME = "Other Component Name:";
    public static String EAR_NAME = "Ear Name:";
    protected boolean isOkAction = false;
    protected boolean createNew = true;
    protected SFileChooser chooser = null;
    protected Frame frame;
    JPanel panel1 = new JPanel();
    JPanel panel2 = new JPanel();
    JPanel panel3 = new JPanel();
    JPanel mainPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    GridBagLayout mainGridBag = new GridBagLayout();
    JLabel nameLabel = new JLabel();
    JLabel arhLabel = new JLabel();
    JLabel xmlLabel = new JLabel();
    JLabel dirLabel = new JLabel("Files Directory:");
    JTextField xmlField = new JTextField();
    JTextField dirField = new JTextField();
    String componentName;
    String arhName = new String("Archive Name:");
    JTextField nameField = new JTextField();
    JTextField arhField = new JTextField();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    JButton browseButton = new JButton();
    JButton browse1Button = new JButton();
    JRadioButton newButton = new JRadioButton("Create New");
    JRadioButton loadButton = new JRadioButton("Load Existing");
    ButtonGroup group = new ButtonGroup();
    private byte type = 0;

    public NewDialog(Frame frame, String title, boolean modal, String label1, byte compType) {
        super(frame, title, modal);
        this.frame = frame;
        this.componentName = label1;
        this.type = compType;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(frame, "Could not initialize the dialog.\n " + ex.toString(), "Error", 0);
        }
    }

    private void jbInit() throws Exception {
        this.addKeyListener(this);
        this.panel1.setLayout(this.gridBagLayout1);
        this.panel2.setLayout(this.gridBagLayout2);
        this.panel3.setLayout(this.gridBagLayout3);
        this.mainPanel.setLayout(this.mainGridBag);
        this.nameLabel.setText(this.componentName);
        this.nameField.setText("");
        this.arhLabel.setText(this.arhName);
        this.arhField.setText("");
        this.okButton.setText("Ok");
        this.cancelButton.setText("Cancel");
        this.browseButton.setText("...");
        this.browse1Button.setText("...");
        this.browseButton.setPreferredSize(new Dimension(21, 21));
        this.browse1Button.setPreferredSize(new Dimension(21, 21));
        this.getContentPane().add(this.mainPanel);
        this.panel1.add((Component)this.arhLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.arhField, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(15, 5, 5, 15), 0, 0));
        this.panel2.add((Component)this.newButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 15, 0), 0, 0));
        this.panel2.add((Component)this.loadButton, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 15, 15), 0, 0));
        this.panel2.add((Component)this.xmlLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.panel2.add((Component)this.xmlField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.panel2.add((Component)this.browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel3.add((Component)this.dirLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel3.add((Component)this.dirField, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.panel3.add((Component)this.browse1Button, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        switch (this.type) {
            case 0: {
                this.xmlLabel.setText("ejb-jar.xml File: ");
                break;
            }
            case 3: {
                this.xmlLabel.setText("ra.xml File: ");
                break;
            }
            case 1: {
                this.xmlLabel.setText("web.xml File: ");
                break;
            }
            case 2: {
                this.xmlLabel.setText("client.xml File: ");
            }
        }
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.okButton.setActionCommand(OK_CMD);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand(CANCEL_CMD);
        this.browse1Button.addActionListener(this);
        this.browse1Button.setActionCommand(BROWSE1_CMD);
        this.browseButton.addActionListener(this);
        this.browseButton.setActionCommand(BROWSE_CMD);
        this.newButton.addActionListener(this);
        this.newButton.setActionCommand(NEW_CMD);
        this.loadButton.addActionListener(this);
        this.loadButton.setActionCommand(LOAD_CMD);
        this.panel1.setBorder(BorderFactory.createEtchedBorder());
        this.panel2.setBorder(BorderFactory.createEtchedBorder());
        this.panel3.setBorder(BorderFactory.createEtchedBorder());
        this.group.add(this.newButton);
        this.group.add(this.loadButton);
        this.mainPanel.add((Component)this.panel1, new GridBagConstraints(0, 0, 3, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.panel2, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.panel3, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 3, 3, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.newButton.setSelected(true);
        this.xmlField.setEnabled(false);
        this.browseButton.setEnabled(false);
        ((Component)this).setSize(new Dimension(400, 270));
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(OK_CMD)) {
            this.okAction();
        } else if (cmd.equals(CANCEL_CMD)) {
            this.cancelAction();
        } else if (cmd.equals(BROWSE_CMD)) {
            if (this.chooser == null) {
                this.chooser = SFileChooser.getInstance((JFrame)this.frame);
            }
            this.chooser.setFilters(new String[]{".xml"});
            String name = this.getSelectedFile();
            if (name != null) {
                this.xmlField.setText(name);
            }
        } else if (cmd.equals(BROWSE1_CMD)) {
            String[] names;
            if (this.chooser == null) {
                this.chooser = SFileChooser.getInstance((JFrame)this.frame);
            }
            if ((names = this.getSelectedDirs()) != null) {
                String text = "";
                int i = 0;
                while (i < names.length) {
                    if (i > 0) {
                        text = text + File.pathSeparator;
                    }
                    text = text + names[i];
                    ++i;
                }
                this.dirField.setText(text);
            }
        } else if (cmd.equals(BROWSE2_CMD)) {
            if (this.chooser == null) {
                this.chooser = SFileChooser.getInstance((JFrame)this.frame);
            }
        } else if (cmd.equals(NEW_CMD)) {
            this.createNew = true;
            this.xmlField.setEnabled(false);
            this.nameField.setEnabled(true);
            this.browseButton.setEnabled(false);
        } else if (cmd.equals(LOAD_CMD)) {
            this.createNew = false;
            this.nameField.setEnabled(false);
            this.xmlField.setEnabled(true);
            this.browseButton.setEnabled(true);
            this.browse1Button.setEnabled(true);
        }
    }

    public boolean isOkAction() {
        return this.isOkAction;
    }

    public boolean createBrandNew() {
        return this.createNew;
    }

    public String getComponentName() {
        return this.nameField.getText();
    }

    public String getArhName() {
        return this.arhField.getText();
    }

    public String[] getDirNames() {
        String text = this.dirField.getText();
        String[] res = null;
        if (text != null) {
            StringTokenizer tokenizer = new StringTokenizer(text, File.pathSeparator);
            res = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                res[i] = tokenizer.nextToken();
                if (res[i] != null) {
                    while (res[i].endsWith(File.separator)) {
                        res[i] = res[i].substring(0, res[i].length() - File.separator.length());
                    }
                }
                ++i;
            }
        }
        return res;
    }

    public String getXMLName() {
        return this.xmlField.getText();
    }

    protected String getSelectedFile() {
        String[] files = null;
        this.chooser.setFilters(new String[]{".xml"});
        files = this.chooser.showFileDialog("Select File", false, false, false);
        if (files != null && files[0] != null) {
            return files[0];
        }
        return null;
    }

    protected String[] getSelectedDirs() {
        String[] files = null;
        files = this.chooser.showDirDialog("Select Directories To Add", false, true, false);
        return files;
    }

    private void cancelAction() {
        this.isOkAction = false;
        ((Component)this).setVisible(false);
    }

    private void okAction() {
        String folder;
        if (this.createNew) {
            if (this.arhField.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "The obligatory fields are not filled in.\n       Archive Name is missing.", "Warning", 0);
                return;
            }
            if (!FileUtils.isCorrectFileName(this.arhField.getText())) {
                JOptionPane.showMessageDialog(this.frame, "The archive name contains forbidden symbols.", "Warning", 0);
                return;
            }
        } else {
            if (this.xmlField.getText().trim().equals("")) {
                if (this.type == 0) {
                    if (this.dirField.getText().trim().equals("")) {
                        JOptionPane.showMessageDialog(this.frame, "The obligatory fields are not filled in!", "Warning", 0);
                        return;
                    }
                    if (!FileUtils.isCorrectFileName(this.arhField.getText())) {
                        JOptionPane.showMessageDialog(this.frame, "The archive name contains forbiden symbols!", "Warning", 0);
                        return;
                    }
                }
                JOptionPane.showMessageDialog(this.frame, "The obligatory fields are not filled in!", "Warning", 0);
                return;
            }
            if (this.arhField.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "The obligatory fields are not filled in!", "Warning", 0);
                return;
            }
        }
        if (!(folder = this.dirField.getText()).trim().equals("")) {
            String[] folderPaths = ApplicationInformationProvider.tokenizerToArray(folder, File.pathSeparator);
            String correctResultExist = "";
            String correctResultFile = "";
            int i = 0;
            while (i < folderPaths.length) {
                if (folderPaths[i] != null) {
                    File folderFile = new File(folderPaths[i]);
                    if (!folderFile.exists()) {
                        correctResultExist = correctResultExist + folderPaths[i] + "\n";
                    } else if (folderFile.isFile()) {
                        correctResultFile = correctResultFile + folderPaths[i] + "\n";
                    }
                }
                ++i;
            }
            if (correctResultExist.length() > 0 || correctResultFile.length() > 0) {
                String directoryString;
                String msg = "";
                if (correctResultExist.length() > 0) {
                    directoryString = ApplicationInformationProvider.tokenizerToArray(correctResultExist, "\n").length > 1 ? "directories" : "directory";
                    msg = "The " + directoryString + " you have specified doesn't exist: \n" + correctResultExist;
                }
                if (correctResultFile.length() > 0) {
                    String fileString;
                    if (ApplicationInformationProvider.tokenizerToArray(correctResultFile, "\n").length > 1) {
                        directoryString = "Directories";
                        fileString = "files were";
                    } else {
                        directoryString = "Directory";
                        fileString = "file was";
                    }
                    msg = msg + "\n " + directoryString + " expected, but " + fileString + " found: \n" + correctResultFile;
                }
                JOptionPane.showMessageDialog(this.frame, msg, "Warning", 0);
                return;
            }
        }
        this.isOkAction = true;
        ((Component)this).setVisible(false);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.okAction();
        } else if (keyEvent.getKeyCode() == 27) {
            this.cancelAction();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }
}

