/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.assembler;

import com.sap.engine.deploy.tool.JarHelper;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.ConfigProperty;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.ContextParam;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ErrorPage;
import com.sap.engine.services.servlets_jsp.descriptor.FilterDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.MIMEMapping;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.TagLib;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class DescriptorMerge {
    protected File archFile;
    protected ArchiveDescriptor altDD;
    protected ClassLoader loader = null;
    protected JarHelper helper = new JarHelper();

    public DescriptorMerge() {
    }

    public DescriptorMerge(File archFile, ArchiveDescriptor altDD) {
        this.archFile = archFile;
        this.altDD = altDD;
    }

    public ArchiveDescriptor mergeDescriptors(File archFile, ArchiveDescriptor altDD) throws Exception {
        ArchiveDescriptor fileDescr = this.helper.loadArchiveDescriptor(archFile.getAbsolutePath());
        if (altDD == null) {
            return fileDescr;
        }
        this.loader = new DynamicClassLoader(archFile.getAbsolutePath());
        if (fileDescr instanceof EJBJarDescriptor) {
            if (altDD instanceof EJBJarDescriptor) {
                if (fileDescr.getDisplayName() == null || fileDescr.getDisplayName().trim().equals("")) {
                    fileDescr.setDisplayName(archFile.getName());
                }
                return this.mergeEJBJarDescriptors((EJBJarDescriptor)fileDescr, (EJBJarDescriptor)altDD);
            }
            if (altDD == null) {
                return fileDescr;
            }
            throw new Exception("Try to merge deferent type descriptors.");
        }
        if (fileDescr instanceof WebDeploymentDescriptor) {
            if (altDD instanceof WebDeploymentDescriptor) {
                if (fileDescr.getDisplayName() == null || fileDescr.getDisplayName().trim().equals("")) {
                    fileDescr.setDisplayName(archFile.getName());
                }
                return this.mergeWarDescriptors((WebDeploymentDescriptor)fileDescr, (WebDeploymentDescriptor)altDD);
            }
            if (altDD == null) {
                return fileDescr;
            }
            throw new Exception("Try to merge deferent type descriptors.");
        }
        if (fileDescr instanceof JCDescriptor) {
            if (altDD instanceof JCDescriptor) {
                if (fileDescr.getDisplayName() == null || fileDescr.getDisplayName().trim().equals("")) {
                    fileDescr.setDisplayName(archFile.getName());
                }
                return this.mergeRarDescriptors((JCDescriptor)fileDescr, (JCDescriptor)altDD);
            }
            if (altDD == null) {
                return fileDescr;
            }
            throw new Exception("Try to merge deferent type descriptors.");
        }
        if (fileDescr instanceof ApplicationClientDescriptor) {
            if (altDD instanceof ApplicationClientDescriptor) {
                if (fileDescr.getDisplayName() == null || fileDescr.getDisplayName().trim().equals("")) {
                    fileDescr.setDisplayName(archFile.getName());
                }
                return this.mergeClientDescriptors((ApplicationClientDescriptor)fileDescr, (ApplicationClientDescriptor)altDD);
            }
            throw new Exception("Try to merge deferent type descriptors.");
        }
        throw new Exception("Try to merge deferent type descriptors.");
    }

    protected ArchiveDescriptor mergeEJBJarDescriptors(EJBJarDescriptor fileDD, EJBJarDescriptor altDD) {
        EJBJarDescriptor resultDD = (EJBJarDescriptor)fileDD.clone();
        resultDD.setDescription(altDD.getDescription());
        resultDD.setSecurityRoles(altDD.getSecurityRoles());
        resultDD.setDescriptors(this.concatArrays(resultDD.getDDescriptors(), altDD.getDDescriptors()));
        return resultDD;
    }

    private DeploymentDescriptor merge(DeploymentDescriptor fileD, DeploymentDescriptor altD) {
        DeploymentDescriptor resultD = (DeploymentDescriptor)fileD.clone();
        resultD.setDescription(altD.getDescription());
        resultD.setEJBeanReferences(this.concatArrays(resultD.getEJBeanReferences(), altD.getEJBeanReferences()));
        resultD.setEJBeanLocalReferences(this.concatArrays(resultD.getEJBeanLocalReferences(), altD.getEJBeanLocalReferences()));
        resultD.setEnvironmentEntries(this.concatArrays(resultD.getEnvironmentEntries(), altD.getEnvironmentEntries()));
        resultD.setResourceReferences(this.concatArrays(resultD.getResourceReferences(), altD.getResourceReferences()));
        resultD.setResourceEnvReferences(this.concatArrays(resultD.getResourceEnvReferences(), altD.getResourceEnvReferences()));
        resultD.setAccessControlEntries(altD.getAccessControlEntries());
        resultD.setSecurityIdentity(altD.getSecurityIdentity());
        SecurityRoleReference[] refs = resultD.getRoleReferences().values().toArray(new SecurityRoleReference[0]);
        refs = this.concatArrays(refs, altD.getRoleReferences().values().toArray(new SecurityRoleReference[0]));
        Hashtable<String, SecurityRoleReference> roleRefs = new Hashtable<String, SecurityRoleReference>();
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                if (refs[i] != null) {
                    roleRefs.put(refs[i].getRoleName(), refs[i]);
                }
                ++i;
            }
        }
        resultD.setRoleReferences(roleRefs);
        resultD.setTransactionDescriptors(altD.getTransactionDescriptors());
        return resultD;
    }

    protected ArchiveDescriptor mergeWarDescriptors(WebDeploymentDescriptor fileDD, WebDeploymentDescriptor altDD) {
        WebDeploymentDescriptor resultDD = (WebDeploymentDescriptor)fileDD.clone();
        resultDD.setDescription(altDD.getDescription());
        resultDD.setSmallIcon(altDD.getSmallIcon());
        resultDD.setLargeIcon(altDD.getLargeIcon());
        resultDD.setSessionTimeout(altDD.getSessionTimeout());
        resultDD.setDistributable(altDD.getDistributable());
        resultDD.setLoginConfig(altDD.getLoginConfig());
        resultDD.setServlets(this.mergeAllServletDescriptors(resultDD.getServlets(), altDD.getServlets()));
        resultDD.setFilters(this.mergeAllFilterDescriptors(resultDD.getFilters(), altDD.getFilters()));
        resultDD.setSecRoles(altDD.getSecRoles());
        resultDD.setResReference(this.concatArrays(resultDD.getResReferences(), altDD.getResReferences()));
        resultDD.setResEnvReferences(this.concatArrays(resultDD.getResEnvReferences(), altDD.getResEnvReferences()));
        resultDD.setEjbRefs(this.concatArrays(resultDD.getEjbRefs(), altDD.getEjbRefs()));
        resultDD.setEjbLocalRefs(this.concatArrays(resultDD.getEjbLocalRefs(), altDD.getEjbLocalRefs()));
        resultDD.setEnvEntries(this.concatArrays(resultDD.getEnvEntries(), altDD.getEnvEntries()));
        resultDD.setTagLib(this.concatArrays(resultDD.getTagLib(), altDD.getTagLib()));
        resultDD.setWelcomeFileList(altDD.getWelcomeFileList());
        resultDD.setErrorPage(this.concatArrays(resultDD.getErrorPage(), altDD.getErrorPage()));
        resultDD.setSecConstraints(altDD.getSecConstraints());
        resultDD.setServletMapping(altDD.getServletMapping());
        resultDD.setFilterMappings(altDD.getFilterMappings());
        resultDD.setMIMEMapping(this.concatArrays(resultDD.getMIMEMapping(), altDD.getMIMEMapping()));
        resultDD.setContextParams(this.concatArrays(resultDD.getContextParams(), altDD.getContextParams()));
        return resultDD;
    }

    protected ArchiveDescriptor mergeRarDescriptors(JCDescriptor fileDD, JCDescriptor altDD) {
        JCDescriptor resultDD = (JCDescriptor)fileDD.clone();
        if (resultDD.getManagedFactoryProperty() != null) {
            if (altDD.getManagedFactoryProperty() != null) {
                resultDD.getManagedFactoryProperty().setConfigProperties(this.concatArrays(resultDD.getManagedFactoryProperty().getConfigProperties(), altDD.getManagedFactoryProperty().getConfigProperties()));
            }
        } else if (altDD.getManagedFactoryProperty() != null) {
            resultDD.setManagedFactoryProperty(altDD.getManagedFactoryProperty());
        }
        resultDD.setDescription(altDD.getDescription());
        return resultDD;
    }

    protected ArchiveDescriptor mergeClientDescriptors(ApplicationClientDescriptor fileDD, ApplicationClientDescriptor altDD) {
        ApplicationClientDescriptor resultDD = (ApplicationClientDescriptor)fileDD.clone();
        resultDD.setCallBack(altDD.getCallBack());
        resultDD.setDescription(altDD.getDescription());
        resultDD.setEJBeanReferences(this.concatArrays(resultDD.getEJBeanReferences(), altDD.getEJBeanReferences()));
        resultDD.setResourceReferences(this.concatArrays(resultDD.getResourceReferences(), altDD.getResourceReferences()));
        resultDD.setEnvironmentProperties(this.concatArrays(resultDD.getEnvironmentProperties(), altDD.getEnvironmentProperties()));
        resultDD.setResourceEnvReferences(this.concatArrays(resultDD.getResourceEnvReference(), altDD.getResourceEnvReference()));
        return resultDD;
    }

    private ServletDescriptor[] mergeAllServletDescriptors(ServletDescriptor[] fileSd, ServletDescriptor[] altSd) {
        if (fileSd == null) {
            return altSd;
        }
        if (altSd == null) {
            return fileSd;
        }
        Vector<ServletDescriptor> elements = new Vector<ServletDescriptor>();
        int i = 0;
        while (i < altSd.length) {
            elements.add(altSd[i]);
            ++i;
        }
        ServletDescriptor sd = null;
        int i2 = 0;
        while (i2 < fileSd.length) {
            int index = this.containsServletDescr(elements, fileSd[i2]);
            if (index != -1) {
                sd = (ServletDescriptor)elements.elementAt(index);
                elements.remove(sd);
                elements.add(this.mergeServletDescr(fileSd[i2], sd));
            } else {
                elements.add(fileSd[i2]);
            }
            ++i2;
        }
        Object[] result = new ServletDescriptor[elements.size()];
        elements.copyInto(result);
        return result;
    }

    private FilterDescriptor[] mergeAllFilterDescriptors(FilterDescriptor[] fileFd, FilterDescriptor[] altFd) {
        if (fileFd == null) {
            return altFd;
        }
        if (altFd == null) {
            return fileFd;
        }
        Vector<FilterDescriptor> elements = new Vector<FilterDescriptor>();
        int i = 0;
        while (i < altFd.length) {
            elements.add(altFd[i]);
            ++i;
        }
        FilterDescriptor fd = null;
        int i2 = 0;
        while (i2 < fileFd.length) {
            int index = this.containsFilterDescr(elements, fileFd[i2]);
            if (index != -1) {
                fd = (FilterDescriptor)elements.elementAt(index);
                elements.remove(fd);
                elements.add(this.mergeFilterDescr(fileFd[i2], fd));
            } else {
                elements.add(fileFd[i2]);
            }
            ++i2;
        }
        Object[] result = new FilterDescriptor[elements.size()];
        elements.copyInto(result);
        return result;
    }

    private ServletDescriptor mergeServletDescr(ServletDescriptor fSd, ServletDescriptor altSd) {
        if (fSd == null) {
            return altSd;
        }
        if (altSd == null) {
            return fSd;
        }
        ServletDescriptor resultSd = (ServletDescriptor)fSd.clone();
        resultSd.setLoadOnStartUp(altSd.getLoadOnStartUp());
        resultSd.setDescription(altSd.getDescription());
        resultSd.setInitParams(this.concatArrays(resultSd.getInitParams(), altSd.getInitParams()));
        resultSd.setRoleReferences(this.concatArrays(resultSd.getRoleReferences(), altSd.getRoleReferences()));
        resultSd.setRunAs(altSd.getRunAs());
        return resultSd;
    }

    private FilterDescriptor mergeFilterDescr(FilterDescriptor fFd, FilterDescriptor altFd) {
        if (fFd == null) {
            return altFd;
        }
        if (altFd == null) {
            return fFd;
        }
        FilterDescriptor resultFd = (FilterDescriptor)fFd.clone();
        resultFd.setDescription(altFd.getDescription());
        resultFd.setInitParams(this.concatArrays(resultFd.getInitParams(), altFd.getInitParams()));
        return resultFd;
    }

    private int containsServletDescr(Vector v, ServletDescriptor s) {
        if (v == null || s == null) {
            return -1;
        }
        ServletDescriptor sV = null;
        int i = 0;
        while (i < v.size()) {
            sV = (ServletDescriptor)v.elementAt(i);
            if (sV.getName().equals(s.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int containsFilterDescr(Vector v, FilterDescriptor f) {
        if (v == null || f == null) {
            return -1;
        }
        FilterDescriptor fD = null;
        int i = 0;
        while (i < v.size()) {
            fD = (FilterDescriptor)v.elementAt(i);
            if (fD.getName().equals(f.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private TagLib[] concatArrays(TagLib[] tagLib1, TagLib[] tagLib2) {
        if (tagLib1 == null) {
            return null;
        }
        if (tagLib2 == null) {
            return tagLib1;
        }
        Vector<TagLib> result = new Vector<TagLib>();
        String uri = null;
        int i = 0;
        while (i < tagLib1.length) {
            if (tagLib1[i] != null && (uri = tagLib1[i].getUri()) != null && !uri.equals("")) {
                int j = 0;
                while (j < tagLib2.length) {
                    if (tagLib2[j] != null && uri.equals(tagLib2[j].getUri())) {
                        tagLib1[i].setLocation(tagLib2[j].getLocation());
                    }
                    ++j;
                }
                result.add(tagLib1[i]);
            }
            ++i;
        }
        if (result.size() > 0) {
            Object[] res = new TagLib[result.size()];
            result.copyInto(res);
            return res;
        }
        return null;
    }

    private ErrorPage[] concatArrays(ErrorPage[] errorPage1, ErrorPage[] errorPage2) {
        if (errorPage1 == null) {
            return null;
        }
        if (errorPage2 == null) {
            return errorPage1;
        }
        Vector<ErrorPage> result = new Vector<ErrorPage>();
        String uri = null;
        int i = 0;
        while (i < errorPage1.length) {
            if (errorPage1[i] != null && (uri = errorPage1[i].getLocation()) != null && !uri.equals("")) {
                int j = 0;
                while (j < errorPage2.length) {
                    if (errorPage2[j] != null && uri.equals(errorPage2[j].getLocation())) {
                        errorPage1[i].setType(errorPage2[j].getType());
                        errorPage1[i].setValue(errorPage2[j].getValue());
                    }
                    ++j;
                }
                result.add(errorPage1[i]);
            }
            ++i;
        }
        if (result.size() > 0) {
            Object[] res = new ErrorPage[result.size()];
            result.copyInto(res);
            return res;
        }
        return null;
    }

    private MIMEMapping[] concatArrays(MIMEMapping[] mimeMap1, MIMEMapping[] mimeMap2) {
        if (mimeMap1 == null) {
            return null;
        }
        if (mimeMap2 == null) {
            return mimeMap1;
        }
        Vector<MIMEMapping> result = new Vector<MIMEMapping>();
        String mimeExt = null;
        int i = 0;
        while (i < mimeMap1.length) {
            if (mimeMap1[i] != null && (mimeExt = mimeMap1[i].getExtension()) != null && !mimeExt.equals("")) {
                int j = 0;
                while (j < mimeMap2.length) {
                    if (mimeMap2[j] != null && mimeExt.equals(mimeMap2[j].getExtension())) {
                        mimeMap1[i].setMIMEType(mimeMap2[j].getMIMEType());
                    }
                    ++j;
                }
                result.add(mimeMap1[i]);
            }
            ++i;
        }
        if (result.size() > 0) {
            Object[] res = new MIMEMapping[result.size()];
            result.copyInto(res);
            return res;
        }
        return null;
    }

    private ContextParam[] concatArrays(ContextParam[] contParam1, ContextParam[] contParam2) {
        if (contParam1 == null) {
            return null;
        }
        if (contParam2 == null) {
            return contParam2;
        }
        Vector<ContextParam> result = new Vector<ContextParam>();
        String paramName = null;
        int i = 0;
        while (i < contParam1.length) {
            if (contParam1[i] != null && (paramName = contParam1[i].getParamName()) != null && !paramName.equals("")) {
                int j = 0;
                while (j < contParam2.length) {
                    if (contParam2[j] != null && paramName.equals(contParam2[j].getParamName())) {
                        contParam1[i].setParamValue(contParam2[j].getParamValue());
                        contParam1[i].setDescription(contParam2[j].getDescription());
                    }
                    ++j;
                }
                result.add(contParam1[i]);
            }
            ++i;
        }
        if (result.size() > 0) {
            Object[] res = new ContextParam[result.size()];
            result.copyInto(res);
            return res;
        }
        return null;
    }

    private EnvironmentEntry[] concatArrays(EnvironmentEntry[] s1, EnvironmentEntry[] s2) {
        if (s1 == null) {
            return null;
        }
        if (s2 == null) {
            return s1;
        }
        Vector<EnvironmentEntry> result = new Vector<EnvironmentEntry>();
        String name = null;
        int index = -1;
        EnvironmentEntry envEntry = null;
        int i = 0;
        while (i < s1.length) {
            index = -1;
            if (s1[i] != null && (name = s1[i].getEntryName()) != null && !name.equals("")) {
                int j = 0;
                while (j < s2.length) {
                    if (s2[j] != null && name.equals(s2[j].getEntryName())) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                envEntry = (EnvironmentEntry)s1[i].clone();
                if (index > -1 && envEntry.getEntryType().equals(s2[index].getEntryType())) {
                    envEntry.setEntryValue(s2[index].getEntryValue());
                    envEntry.setEntryDescription(s2[index].getEntryDescription());
                }
                result.add(envEntry);
            }
            ++i;
        }
        if (result.size() > 0) {
            Object[] res = new EnvironmentEntry[result.size()];
            result.copyInto(res);
            return res;
        }
        return null;
    }

    private EJBeanReference[] concatArrays(EJBeanReference[] s1, EJBeanReference[] s2) {
        if (s1 == null) {
            return null;
        }
        if (s2 == null) {
            return s1;
        }
        Vector<EJBeanReference> result = new Vector<EJBeanReference>();
        String refName = null;
        int index = -1;
        EJBeanReference ejbRef = null;
        int i = 0;
        while (i < s1.length) {
            index = -1;
            if (s1[i] != null && (refName = s1[i].getReferenceName()) != null && !refName.equals("")) {
                int j = 0;
                while (j < s2.length) {
                    if (s2[j] != null && refName.equals(s2[j].getReferenceName())) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                ejbRef = (EJBeanReference)s1[i].clone();
                if (index > -1 && ejbRef.getType() == s2[index].getType() && ejbRef.getHomeInterfaceName().equals(s2[index].getHomeInterfaceName()) && ejbRef.getRemoteInterfaceName().equals(s2[index].getRemoteInterfaceName())) {
                    ejbRef.setReferenceEjbLink(s2[index].getReferenceEjbLink());
                    ejbRef.setReferenceDescription(s2[index].getReferenceDescription());
                }
                result.add(ejbRef);
            }
            ++i;
        }
        if (result.size() > 0) {
            Object[] res = new EJBeanReference[result.size()];
            result.copyInto(res);
            return res;
        }
        return null;
    }

    private EJBeanLocalReference[] concatArrays(EJBeanLocalReference[] s1, EJBeanLocalReference[] s2) {
        if (s1 == null) {
            return null;
        }
        if (s2 == null) {
            return s1;
        }
        Vector<EJBeanLocalReference> result = new Vector<EJBeanLocalReference>();
        String refName = null;
        int index = -1;
        EJBeanLocalReference ejbRef = null;
        int i = 0;
        while (i < s1.length) {
            index = -1;
            if (s1[i] != null && (refName = s1[i].getReferenceName()) != null && !refName.equals("")) {
                int j = 0;
                while (j < s2.length) {
                    if (s2[j] != null && refName.equals(s2[j].getReferenceName())) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                ejbRef = (EJBeanLocalReference)s1[i].clone();
                if (index > -1 && ejbRef.getType() == s2[index].getType() && ejbRef.getLocalHomeInterfaceName().equals(s2[index].getLocalHomeInterfaceName()) && ejbRef.getLocalInterfaceName().equals(s2[index].getLocalInterfaceName())) {
                    ejbRef.setReferenceEjbLink(s2[index].getReferenceEjbLink());
                    ejbRef.setReferenceDescription(s2[index].getReferenceDescription());
                }
                result.add(ejbRef);
            }
            ++i;
        }
        if (result.size() > 0) {
            Object[] res = new EJBeanLocalReference[result.size()];
            result.copyInto(res);
            return res;
        }
        return null;
    }

    private ResourceReference[] concatArrays(ResourceReference[] s1, ResourceReference[] s2) {
        if (s1 == null) {
            return null;
        }
        if (s2 == null) {
            return s1;
        }
        Vector<ResourceReference> result = new Vector<ResourceReference>();
        String name = null;
        int index = -1;
        ResourceReference resRef = null;
        int i = 0;
        while (i < s1.length) {
            index = -1;
            if (s1[i] != null && (name = s1[i].getResourceName()) != null && !name.equals("")) {
                int j = 0;
                while (j < s2.length) {
                    if (s2[j] != null && name.equals(s2[j].getResourceName())) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                resRef = index > -1 ? (ResourceReference)s2[index].clone() : (ResourceReference)s1[i].clone();
                result.add(resRef);
            }
            ++i;
        }
        if (result.size() > 0) {
            Object[] res = new ResourceReference[result.size()];
            result.copyInto(res);
            return res;
        }
        return null;
    }

    private ResourceEnvReference[] concatArrays(ResourceEnvReference[] s1, ResourceEnvReference[] s2) {
        if (s1 == null) {
            return null;
        }
        if (s2 == null) {
            return s1;
        }
        Vector<ResourceEnvReference> result = new Vector<ResourceEnvReference>();
        String name = null;
        int index = -1;
        ResourceEnvReference resRef = null;
        int i = 0;
        while (i < s1.length) {
            index = -1;
            if (s1[i] != null && (name = s1[i].getName()) != null && !name.equals("")) {
                int j = 0;
                while (j < s2.length) {
                    if (s2[j] != null && name.equals(s2[j].getName())) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                resRef = index > -1 ? (ResourceEnvReference)s2[index].clone() : (ResourceEnvReference)s1[i].clone();
                result.add(resRef);
            }
            ++i;
        }
        if (result.size() > 0) {
            Object[] res = new ResourceEnvReference[result.size()];
            result.copyInto(res);
            return res;
        }
        return null;
    }

    private SecurityRoleReference[] concatArrays(SecurityRoleReference[] ref1, SecurityRoleReference[] ref2) {
        if (ref1 == null) {
            return null;
        }
        if (ref2 == null) {
            return ref1;
        }
        Vector<SecurityRoleReference> result = new Vector<SecurityRoleReference>();
        String roleName = null;
        int i = 0;
        while (i < ref1.length) {
            if (ref1[i] != null && (roleName = ref1[i].getRoleName()) != null && !roleName.equals("")) {
                int j = 0;
                while (j < ref2.length) {
                    if (ref2[j] != null && roleName.equals(ref2[j].getRoleName())) {
                        ref1[i].setSecurityRoleName(ref2[j].getSecurityRoleName());
                        ref1[i].setDescription(ref2[j].getDescription());
                    }
                    ++j;
                }
                result.add(ref1[i]);
            }
            ++i;
        }
        if (result.size() > 0) {
            Object[] res = new SecurityRoleReference[result.size()];
            result.copyInto(res);
            return res;
        }
        return null;
    }

    private DeploymentDescriptor[] concatArrays(DeploymentDescriptor[] s1, DeploymentDescriptor[] s2) {
        if (s1 == null) {
            return null;
        }
        if (s2 == null) {
            return s1;
        }
        Vector<DeploymentDescriptor> result = new Vector<DeploymentDescriptor>();
        String name = null;
        int index = -1;
        DeploymentDescriptor dd = null;
        int i = 0;
        while (i < s1.length) {
            index = -1;
            if (s1[i] != null && (name = s1[i].getEjbName()) != null && !name.equals("")) {
                int j = 0;
                while (j < s2.length) {
                    if (s2[j] != null && name.equals(s2[j].getEjbName())) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                dd = index > -1 ? this.merge(s1[i], s2[index]) : (DeploymentDescriptor)s1[i].clone();
                result.add(dd);
            }
            ++i;
        }
        if (result.size() > 0) {
            Object[] res = new DeploymentDescriptor[result.size()];
            result.copyInto(res);
            return res;
        }
        return null;
    }

    private ConfigProperty[] concatArrays(ConfigProperty[] s1, ConfigProperty[] s2) {
        if (s1 == null) {
            return null;
        }
        if (s2 == null) {
            return s1;
        }
        Vector<ConfigProperty> result = new Vector<ConfigProperty>();
        String name = null;
        int index = -1;
        ConfigProperty prop = null;
        int i = 0;
        while (i < s1.length) {
            index = -1;
            if (s1[i] != null && (name = s1[i].getConfigPropertyName()) != null && !name.equals("")) {
                int j = 0;
                while (j < s2.length) {
                    if (s2[j] != null && name.equals(s2[j].getConfigPropertyName())) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                prop = (ConfigProperty)s1[i].clone();
                if (index > -1 && prop.getConfigPropertyType().equals(s2[index].getConfigPropertyType()) && s2[index].getConfigPropertyValue() != null && !s2[index].getConfigPropertyValue().equals("")) {
                    prop.setConfigPropertyValue(s2[index].getConfigPropertyValue());
                }
                result.add(prop);
            }
            ++i;
        }
        if (result.size() > 0) {
            Object[] res = new ConfigProperty[result.size()];
            result.copyInto(res);
            return res;
        }
        return null;
    }
}

