/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.assembler;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.deploy.ejb.descriptors.xml.EJB20DescriptorDocument;
import com.sap.engine.deploy.generator.EARGeneratorException;
import com.sap.engine.deploy.generator.EarJob;
import com.sap.engine.deploy.generator.EarObject;
import com.sap.engine.deploy.generator.XMLEarGenerator;
import com.sap.engine.deploy.generator.XMLEarManager;
import com.sap.engine.deploy.tool.DeployFrame;
import com.sap.engine.deploy.tool.JarHelper;
import com.sap.engine.deploy.tool.RenameDialog;
import com.sap.engine.deploy.tool.assembler.AssembleTab;
import com.sap.engine.deploy.tool.assembler.DescriptorMerge;
import com.sap.engine.deploy.tool.tree.ArchiveDescriptorNode;
import com.sap.engine.deploy.tool.tree.BasicDescriptorNode;
import com.sap.engine.deploy.tool.tree.ClientDescriptorNode;
import com.sap.engine.deploy.tool.tree.ConnectorDescriptorNode;
import com.sap.engine.deploy.tool.tree.DescriptorNode;
import com.sap.engine.deploy.tool.tree.EARDescriptorNode;
import com.sap.engine.deploy.tool.tree.EJBDescriptorNode;
import com.sap.engine.deploy.tool.tree.EJBJarDescriptorNode;
import com.sap.engine.deploy.tool.tree.FilterDescriptorNode;
import com.sap.engine.deploy.tool.tree.ListenerDescriptorNode;
import com.sap.engine.deploy.tool.tree.ServletDescriptorNode;
import com.sap.engine.deploy.tool.tree.WebDescriptorNode;
import com.sap.engine.gui.LogMessageDialog;
import com.sap.engine.gui.LogViewerDialog;
import com.sap.engine.gui.TreeUtils;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.gui.SFileChooser;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.FilterDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ListenerDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Document;

public class AssembleActionManager
implements ActionListener {
    private StandardDOMParser parser;
    public static final String ASMBL_ADD_CMD = "ASMBL_ADD_CMD";
    public static final String ASMBL_REMOVE_CMD = "ASMBL_REMOVE_CMD";
    public static final String ASMBL_MAKE_EAR_CMD = "ASMBL_MAKE_EAR_CMD";
    public static final String ASMBL_REFRESH_CMD = "ASMBL_REFRESH_CMD";
    public static final String ASMBL_VIEW_LOG_FILE = "ASMBL_VIEW_LOG_FILE";
    public static final String ASMBL_RENAME_CMD = "ASMBL_RENAME_CMD";
    protected BasicDescriptorNode root;
    protected SFileChooser chooser;
    protected LogMessageDialog error;
    protected Frame mainFrame;
    protected DefaultTreeModel treeModel;
    protected JTree tree;
    protected JarHelper generator = new JarHelper();
    protected AssembleTab tabPanel;
    protected File projectDir = null;
    protected String xmlLocation = null;
    protected String logFile = "./ear_generator_log.txt";
    protected String classPath = SystemProperties.getProperty("java.class.path");
    protected boolean isTransfer = false;
    public Vector dDescr = new Vector();
    private boolean madeArchive = false;
    private StandardDOMWriter writer;

    private AssembleActionManager() {
    }

    public AssembleActionManager(Frame frame, AssembleTab tab) {
        this.mainFrame = frame;
        this.tabPanel = tab;
        this.initXMLToolkit();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equalsIgnoreCase(ASMBL_ADD_CMD)) {
            this.tabPanel.needSaveing = this.addArchiveAction();
        } else if (cmd.equalsIgnoreCase(ASMBL_REMOVE_CMD)) {
            this.removeArchiveAction();
            this.tabPanel.needSaveing = true;
        } else if (cmd.equalsIgnoreCase(ASMBL_MAKE_EAR_CMD)) {
            this.makeEar();
        } else if (cmd.equalsIgnoreCase(ASMBL_REFRESH_CMD)) {
            this.refreshAction();
        } else if (cmd.equalsIgnoreCase(ASMBL_VIEW_LOG_FILE)) {
            File logF;
            if (this.tabPanel.getLogViewerDialog() == null) {
                this.tabPanel.logViewerDialog = new LogViewerDialog(this.mainFrame, "Log");
            }
            if (!(logF = new File(this.logFile)).exists()) {
                JOptionPane.showMessageDialog(this.mainFrame, "There is no log file.", "Warning", 2);
            } else {
                this.tabPanel.getLogViewerDialog().show(this.mainFrame, logF);
            }
            this.tabPanel.logViewerDialog = null;
        } else if (cmd.equalsIgnoreCase(ASMBL_RENAME_CMD) && !this.tree.getSelectionModel().isSelectionEmpty()) {
            this.renameAction();
        }
    }

    public void refreshAction() {
        BasicDescriptorNode root;
        if (this.tabPanel.needSave()) {
            int option = JOptionPane.showConfirmDialog(this.mainFrame, "You have changed information of the descriptors in this tab. \nIf you commit refresh without saving, this changes will be lost. \nDo you want to save project?", "Warning", 1);
            if (option == 2) {
                this.tabPanel.status.setText("Refreshing is canceled.");
                return;
            }
            if (option == 0) {
                this.tabPanel.status.setText("Saving project.");
                this.tabPanel.saveXMLOnProjectSave();
                this.tabPanel.status.setText("Project is saved.");
            }
        }
        if ((root = (BasicDescriptorNode)this.treeModel.getRoot()).getChildCount() == 0) {
            return;
        }
        ArchiveDescriptorNode archNode = null;
        this.tabPanel.status.setText("Refreshing archives.");
        int i = 0;
        while (i < root.getChildCount()) {
            archNode = (ArchiveDescriptorNode)root.getChildAt(i);
            this.tabPanel.refreshNode(archNode);
            ++i;
        }
        this.tabPanel.status.setText("Archives are refreshed.");
        this.treeModel.reload();
        TreeUtils.expandTree(this.tree, 1);
    }

    public boolean addArchiveAction() {
        if (!this.tree.isRootVisible()) {
            this.tree.setRootVisible(true);
        }
        if (this.chooser == null) {
            this.chooser = SFileChooser.getInstance((JFrame)this.mainFrame);
        }
        this.chooser.setProjectDir(this.projectDir.getAbsolutePath());
        this.chooser.setFilters(new String[]{".war" + File.pathSeparator + ".jar" + File.pathSeparator + ".rar"});
        String name = this.getSelectedFile("Please select the file for the ear component", false);
        this.isTransfer = false;
        return this.addArchiveAction(name);
    }

    public boolean addArchiveAction(String name) {
        if (name != null) {
            if (this.generator == null) {
                this.generator = new JarHelper();
            }
            this.generator.setClassPath(this.classPath);
            int type = -1;
            ArchiveDescriptor archDescr = null;
            try {
                archDescr = this.generator.loadArchiveDescriptor(name);
                if (archDescr.getDisplayName() == null) {
                    if (name.lastIndexOf(File.separator) > 0) {
                        archDescr.setDisplayName(name.substring(name.lastIndexOf(File.separator)));
                    } else {
                        archDescr.setDisplayName(name);
                    }
                }
                type = this.generator.getJarComponentType(name);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.mainFrame, "Could not load archive. \nIt doesn't contain XML file or Incorect Archive! " + e.toString(), "Error", 0);
                return false;
            }
            this.classPath = name + File.pathSeparator + this.classPath + File.pathSeparator;
            DynamicClassLoader loader = new DynamicClassLoader(this.classPath);
            this.tabPanel.setLoader(loader);
            switch (type) {
                case 1: {
                    try {
                        this.loadEJBJar(null, name, (EJBJarDescriptor)archDescr, loader, this.generator.getFilesFromArchive(name));
                        this.tabPanel.status.setText("EJB Jar is added.");
                        break;
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not load EJB jar! \n" + e.toString(), "Error", 0);
                        return false;
                    }
                }
                case 3: {
                    try {
                        this.loadClientJar(null, name, (ApplicationClientDescriptor)archDescr, this.generator.getFilesFromArchive(name));
                        this.tabPanel.status.setText("Client Jar is added.");
                        break;
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not load application client jar! \n" + e.toString(), "Error", 0);
                        return false;
                    }
                }
                case 4: {
                    try {
                        this.loadWeb(null, name, (WebDeploymentDescriptor)archDescr, this.generator.getFilesFromArchive(name), false);
                        this.tabPanel.status.setText("Web War is added.");
                        break;
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not load Web war! \n" + e.toString(), "Error", 0);
                        return false;
                    }
                }
                case 5: {
                    try {
                        this.loadConnectorRar(null, name, (JCDescriptor)archDescr, this.generator.getFilesFromArchive(name));
                        this.tabPanel.status.setText("RAR of resource adapter is added.");
                        break;
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not load RAR of resource adapter! \n" + e.toString(), "Error", 0);
                        return false;
                    }
                }
            }
            if (!this.isTransfer) {
                archDescr.setLoaded(true);
            }
            this.passRoles();
            return true;
        }
        return false;
    }

    private void removeArchiveAction() {
        ArchiveDescriptorNode sellNode = null;
        if (!this.tree.isSelectionEmpty()) {
            sellNode = (ArchiveDescriptorNode)this.tree.getSelectionModel().getSelectionPath().getLastPathComponent();
            if (sellNode instanceof WebDescriptorNode) {
                String name = ((WebDescriptorNode)sellNode).getArchiveFileName();
                if (((WebDescriptorNode)sellNode).getArchiveFileName().lastIndexOf(File.separator) > -1) {
                    name = ((WebDescriptorNode)sellNode).getArchiveFileName().substring(((WebDescriptorNode)sellNode).getArchiveFileName().lastIndexOf(File.separator) + 1);
                }
                ((EARDescriptorNode)this.root).getModifiedDescriptor().removeModule(name);
            }
            if (sellNode.getXMLFileName() != null) {
                File forDeletion = new File(sellNode.getXMLFileName());
                forDeletion.delete();
            }
            this.treeModel.removeNodeFromParent(sellNode);
            this.tabPanel.getPropertiesPanel().removeAll();
            this.tabPanel.getPropertiesPanel().repaint();
            this.tabPanel.lastSelectedNode = null;
            this.tabPanel.checkEnable(null);
            this.saveXMLFile(null);
            this.passRoles();
            this.tabPanel.status.setText("Archive was removed from EAR.");
        }
    }

    private void makeEar() {
        this.tabPanel.commitSelected();
        String name = null;
        this.tabPanel.status.setText("Making EAR ...");
        if (((EARDescriptorNode)this.root).getArchiveFileName() == null) {
            name = this.getSelectedEarName();
            if (name == null) {
                this.tabPanel.status.setText("");
                return;
            }
            if (!name.trim().toLowerCase().endsWith(".ear")) {
                name = name + ".ear";
            }
            ((EARDescriptorNode)this.root).setArchiveFileName(name);
        } else {
            name = ((EARDescriptorNode)this.root).getArchiveFileName();
        }
        boolean isCorrect = false;
        if (name != null) {
            while (!isCorrect) {
                if (name.endsWith("/.ear") || name.endsWith("\\.ear") || name.endsWith("\\") || name.endsWith("/")) {
                    this.tabPanel.status.setText("Incorrect name of EAR. Select new one!");
                    name = this.getSelectedEarName();
                    continue;
                }
                isCorrect = true;
            }
        }
        this.xmlLocation = this.projectDir.getAbsolutePath() + File.separator + "assembler_xml.xml";
        this.saveXMLFile(name);
        XMLEarGenerator generator = new XMLEarGenerator();
        generator.setClasspath(this.classPath);
        this.tabPanel.getFrame().setCursor(new Cursor(3));
        boolean res = false;
        try {
            res = generator.generateEar(this.xmlLocation, this.logFile);
        }
        catch (EARGeneratorException e) {
            if (this.error == null) {
                this.error = LogMessageDialog.getInstance(this.mainFrame);
            }
            this.tabPanel.status.setText("Errors occurred during making ear.");
            this.error.showErrorDialog(e.toString(), this.logFile);
            this.tabPanel.getFrame().setCursor(new Cursor(0));
            return;
        }
        if (res) {
            this.tabPanel.getFrame().setCursor(new Cursor(0));
            this.madeArchive = true;
            this.tabPanel.status.setText("Ear " + name + " made successfully.");
        } else {
            if (this.error == null) {
                this.error = LogMessageDialog.getInstance(this.mainFrame);
            }
            this.tabPanel.status.setText("Errors occurred during making ear.");
            this.error.showErrorDialog("Could not create ear.", this.logFile);
            this.tabPanel.getFrame().setCursor(new Cursor(0));
        }
    }

    public void setRoot(BasicDescriptorNode _root) {
        this.root = _root;
    }

    private boolean loadClientJar(EarObject obj, String jarName, ApplicationClientDescriptor archDescr, Vector additionalFiles) throws Exception {
        ClientDescriptorNode clientNode = null;
        if (archDescr == null) {
            return false;
        }
        if (archDescr.getDisplayName() == null) {
            if (jarName.lastIndexOf(File.separator) > 0) {
                archDescr.setDisplayName(jarName.substring(jarName.lastIndexOf(File.separator) + 1));
            } else {
                archDescr.setDisplayName(jarName);
            }
        }
        File clientName = new File(jarName);
        String theName = clientName.getName();
        try {
            clientNode = (ClientDescriptorNode)this.findNode(this.root, theName);
        }
        catch (ClassCastException ccexc) {
            JOptionPane.showMessageDialog(this.mainFrame, "Could not load application client. There is EJB jar with same name", "Error during adding client jar", 0);
            return false;
        }
        if (clientNode == null) {
            clientNode = new ClientDescriptorNode(theName);
        }
        clientNode.setArchiveTime(clientName.lastModified());
        if (obj != null && obj.getAlternativeDD(theName) != null) {
            clientNode.setXMLFileName(obj.getAlternativeDD(theName).getPath());
        }
        DescriptorMerge merge = new DescriptorMerge();
        if (obj != null && obj.getAlternativeDD(archDescr.getDisplayName()) != null && new File(obj.getAlternativeDD(archDescr.getDisplayName()).getPath()).exists()) {
            ApplicationClientDescriptor clientDD = this.readClientAltDD(obj.getAlternativeDD(archDescr.getDisplayName()).getPath(), archDescr.getDisplayName());
            clientDD = (ApplicationClientDescriptor)merge.mergeDescriptors(clientName, clientDD);
            clientNode.setArchiveDescriptor(clientDD);
            archDescr = clientDD;
            clientNode.setXMLFileName(obj.getAlternativeDD(archDescr.getDisplayName()).getPath());
        } else {
            clientNode.setArchiveDescriptor(archDescr);
        }
        clientNode.setAdditionalFiles(additionalFiles);
        clientNode.setArchiveFileName(jarName);
        this.root.add(clientNode);
        this.treeModel.reload();
        this.initDeplDescr();
        this.setReferenceLink();
        TreeUtils.expandTree(this.tree, 1);
        return true;
    }

    private boolean loadConnectorRar(EarObject obj, String jarName, JCDescriptor archDescr, Vector additionalFiles) throws Exception {
        ConnectorDescriptorNode connectorNode = null;
        if (archDescr == null) {
            return false;
        }
        if (archDescr.getDisplayName() == null) {
            if (jarName.lastIndexOf(File.separator) > 0) {
                archDescr.setDisplayName(jarName.substring(jarName.lastIndexOf(File.separator) + 1));
            } else {
                archDescr.setDisplayName(jarName);
            }
        }
        File connectorName = new File(jarName);
        String theName = connectorName.getName();
        try {
            connectorNode = (ConnectorDescriptorNode)this.findNode(this.root, theName);
        }
        catch (ClassCastException ccexc) {
            JOptionPane.showMessageDialog(this.mainFrame, "Could not load application client. There is EJB jar with same name", "Error during adding client jar", 0);
            return false;
        }
        if (connectorNode == null) {
            connectorNode = new ConnectorDescriptorNode(theName);
        }
        connectorNode.setArchiveTime(connectorName.lastModified());
        if (obj != null && obj.getAlternativeDD(theName) != null) {
            connectorNode.setXMLFileName(obj.getAlternativeDD(theName).getPath());
        }
        DescriptorMerge merge = new DescriptorMerge();
        if (obj != null && obj.getAlternativeDD(archDescr.getDisplayName()) != null && new File(obj.getAlternativeDD(archDescr.getDisplayName()).getPath()).exists()) {
            JCDescriptor connectorDD = this.readRarAltDD(obj.getAlternativeDD(archDescr.getDisplayName()).getPath(), archDescr.getDisplayName());
            connectorDD = (JCDescriptor)merge.mergeDescriptors(connectorName, connectorDD);
            connectorNode.setArchiveDescriptor(connectorDD);
            archDescr = connectorDD;
            connectorNode.setXMLFileName(obj.getAlternativeDD(archDescr.getDisplayName()).getPath());
        } else {
            connectorNode.setArchiveDescriptor(archDescr);
        }
        connectorNode.setAdditionalFiles(additionalFiles);
        connectorNode.setArchiveFileName(jarName);
        this.root.add(connectorNode);
        this.treeModel.reload();
        TreeUtils.expandTree(this.tree, 1);
        return true;
    }

    private boolean loadEJBJar(EarObject obj, String jarName, EJBJarDescriptor archDescr, DynamicClassLoader loader, Vector additionalFiles) throws Exception {
        DeploymentDescriptor[] allDescr = null;
        EJBJarDescriptorNode jarNode = null;
        EJBDescriptorNode ejbNode = null;
        if (archDescr == null) {
            return false;
        }
        if (archDescr.getDisplayName() == null) {
            if (jarName.lastIndexOf(File.separator) > 0) {
                archDescr.setDisplayName(jarName.substring(jarName.lastIndexOf(File.separator) + 1));
            } else {
                archDescr.setDisplayName(jarName);
            }
        }
        File jName = new File(jarName);
        DescriptorMerge merge = new DescriptorMerge();
        String theName = jName.getName();
        jarNode = (EJBJarDescriptorNode)this.findNode(this.root, theName);
        int forOldArchive = 0;
        int forNewArchive = 0;
        if (jarNode != null && jarNode.getArchiveFileName() != null && jarName != null) {
            forOldArchive = jarNode.getArchiveFileName().lastIndexOf(File.separator);
            forNewArchive = jarName.lastIndexOf(File.separator);
        }
        if (jarNode == null || jarNode.getArchiveFileName() != null && !jarNode.getArchiveFileName().substring(forOldArchive).equals(jarName.substring(forNewArchive))) {
            jarNode = new EJBJarDescriptorNode(theName);
        } else {
            jarNode.removeAllChildren();
        }
        if (obj != null && obj.getAlternativeDD(theName) != null) {
            jarNode.setXMLFileName(obj.getAlternativeDD(theName).getPath());
        }
        jarNode.setArchiveTime(jName.lastModified());
        if (obj != null && obj.getAlternativeDD(archDescr.getDisplayName()) != null && new File(obj.getAlternativeDD(archDescr.getDisplayName()).getPath()).exists()) {
            EJBJarDescriptor jar = this.readEjbJarAltDD(obj.getAlternativeDD(archDescr.getDisplayName()).getPath(), archDescr.getDisplayName(), loader);
            if ((jar = (EJBJarDescriptor)merge.mergeDescriptors(jName, jar)).getDisplayName() == null) {
                jar.setDisplayName(jarName.substring(jarName.lastIndexOf(File.separator) + 1));
            }
            jarNode.setArchiveDescriptor(jar);
            archDescr = jar;
            jarNode.setXMLFileName(obj.getAlternativeDD(archDescr.getDisplayName()).getPath());
        } else {
            jarNode.setArchiveDescriptor(archDescr);
        }
        jarNode.setAdditionalFiles(additionalFiles);
        jarNode.setArchiveFileName(jarName);
        this.root.add(jarNode);
        allDescr = (DeploymentDescriptor[])archDescr.getDescriptors();
        if (allDescr != null) {
            int j = 0;
            while (j < allDescr.length) {
                String nodeName = null;
                nodeName = allDescr[j].getDisplayName() != null ? allDescr[j].getDisplayName() : (allDescr[j].getEjbName() != null ? allDescr[j].getEjbName() : "DefaultName" + j);
                if (nodeName != null) {
                    ejbNode = new EJBDescriptorNode(nodeName.trim());
                    if (obj != null && obj.getAlternativeDD(allDescr[j].getName()) != null) {
                        ejbNode.setDescriptor(this.readEjbAltDD(obj.getAlternativeDD(allDescr[j].getName()).getPath(), allDescr[j].getName(), loader));
                        ejbNode.setXMLFileName(obj.getAlternativeDD(allDescr[j].getName()).getPath());
                    } else {
                        ejbNode.setDescriptor(allDescr[j]);
                    }
                    allDescr[j].setDisplayName(nodeName.trim());
                    jarNode.add(ejbNode);
                }
                ++j;
            }
        }
        this.treeModel.reload();
        this.initDeplDescr();
        this.setReferenceLink();
        TreeUtils.expandTree(this.tree, 1);
        return true;
    }

    private boolean loadWeb(EarObject obj, String jarName, WebDeploymentDescriptor archDescr, Vector additionalFiles, boolean isOnProjectOpen) throws Exception {
        String nodeName;
        ServletDescriptor[] allDescr = null;
        FilterDescriptor[] filtDescr = null;
        ListenerDescriptor[] listDescr = null;
        WebDescriptorNode webNode = null;
        ServletDescriptorNode srvNode = null;
        FilterDescriptorNode filtNode = null;
        ListenerDescriptorNode listNode = null;
        DescriptorMerge merge = new DescriptorMerge();
        if (archDescr == null) {
            return false;
        }
        if (archDescr.getDisplayName() == null) {
            if (jarName.lastIndexOf(File.separator) > 0) {
                archDescr.setDisplayName(jarName.substring(jarName.lastIndexOf(File.separator) + 1));
            } else {
                archDescr.setDisplayName(jarName);
            }
        }
        File wName = new File(jarName);
        String theName = wName.getName();
        webNode = (WebDescriptorNode)this.findNode(this.root, theName);
        int forOldArchive = 0;
        int forNewArchive = 0;
        if (webNode != null && webNode.getArchiveFileName() != null && jarName != null) {
            forOldArchive = webNode.getArchiveFileName().lastIndexOf(File.separator);
            forNewArchive = jarName.lastIndexOf(File.separator);
        }
        if (webNode != null) {
            if (webNode.getArchiveFileName() != null && webNode.getArchiveFileName().substring(forOldArchive).equals(jarName.substring(forNewArchive))) {
                Descriptor[] descr = archDescr.getDescriptors();
                if (descr != null) {
                    String nodeName2 = null;
                    String descrName = null;
                    int i = 0;
                    while (i < descr.length) {
                        descrName = descr[i].getName();
                        Enumeration<TreeNode> childs = webNode.children();
                        while (childs.hasMoreElements()) {
                            DescriptorNode childNode = (DescriptorNode)childs.nextElement();
                            nodeName2 = childNode.getCurrentDescriptor().getName();
                            if (!nodeName2.trim().equals(descrName.trim())) continue;
                            descr[i] = childNode.getCurrentDescriptor();
                        }
                        ++i;
                    }
                }
                archDescr.setDescriptors(descr);
                this.root.remove(webNode);
                webNode.removeAllChildren();
            } else {
                webNode = new WebDescriptorNode(theName);
            }
        } else {
            webNode = new WebDescriptorNode(theName);
        }
        webNode.setArchiveTime(wName.lastModified());
        if (obj != null && obj.getAlternativeDD(theName) != null) {
            webNode.setXMLFileName(obj.getAlternativeDD(theName).getPath());
        }
        if (obj != null && obj.getAlternativeDD(archDescr.getDisplayName()) != null && new File(obj.getAlternativeDD(archDescr.getDisplayName()).getPath()).exists()) {
            WebDeploymentDescriptor webDD = this.readWebAltDD(obj.getAlternativeDD(archDescr.getDisplayName()).getPath(), archDescr.getDisplayName());
            webDD = (WebDeploymentDescriptor)merge.mergeDescriptors(wName, webDD);
            webNode.setArchiveDescriptor(webDD);
            archDescr = webDD;
            webNode.setXMLFileName(obj.getAlternativeDD(archDescr.getDisplayName()).getPath());
        } else {
            webNode.setArchiveDescriptor(archDescr);
        }
        webNode.setAdditionalFiles(additionalFiles);
        webNode.setArchiveFileName(jarName);
        this.root.add(webNode);
        String name = jarName;
        if (jarName.lastIndexOf(File.separator) > -1) {
            name = jarName.substring(jarName.lastIndexOf(File.separator) + 1);
        }
        String contRootName = null;
        contRootName = obj != null ? (obj.getContextroot() != null ? obj.getContextroot() : name) : name;
        if (contRootName.endsWith(".war")) {
            contRootName = contRootName.substring(0, contRootName.indexOf(".war"));
        }
        if (isOnProjectOpen) {
            ((EARDescriptorNode)this.root).getModifiedDescriptor().initModules();
        }
        ((EARDescriptorNode)this.root).getModifiedDescriptor().addModule(new J2EEModule(name, contRootName));
        allDescr = archDescr.getServlets();
        if (allDescr != null) {
            int j = 0;
            while (j < allDescr.length) {
                nodeName = null;
                nodeName = allDescr[j].getDisplayName() != null && !allDescr[j].getDisplayName().trim().equals("") ? allDescr[j].getDisplayName() : (allDescr[j].getServletName() != null ? allDescr[j].getServletName() : (allDescr[j].getName() != null ? allDescr[j].getName() : "DefaultServletName" + j));
                if (nodeName != null) {
                    srvNode = new ServletDescriptorNode(nodeName.trim());
                    if (obj != null && allDescr[j].getServletName() != null && obj.getAlternativeDD(allDescr[j].getServletName()) != null) {
                        srvNode.setDescriptor(this.readServletAltDD(obj.getAlternativeDD(allDescr[j].getServletName()).getPath(), allDescr[j].getServletName()));
                        srvNode.setXMLFileName(obj.getAlternativeDD(allDescr[j].getServletName()).getPath());
                    } else if (obj != null && allDescr[j].getName() != null && obj.getAlternativeDD(allDescr[j].getName()) != null) {
                        srvNode.setDescriptor(this.readServletAltDD(obj.getAlternativeDD(allDescr[j].getName()).getPath(), allDescr[j].getName()));
                        srvNode.setXMLFileName(obj.getAlternativeDD(allDescr[j].getName()).getPath());
                    } else {
                        srvNode.setDescriptor(allDescr[j]);
                    }
                    this.treeModel.insertNodeInto(srvNode, webNode, 0);
                }
                ++j;
            }
        }
        if ((filtDescr = archDescr.getFilters()) != null) {
            int j = 0;
            while (j < filtDescr.length) {
                nodeName = null;
                nodeName = filtDescr[j].getDisplayName() != null && !filtDescr[j].getDisplayName().trim().equals("") ? filtDescr[j].getDisplayName() : (filtDescr[j].getFilterName() != null ? filtDescr[j].getFilterName() : (filtDescr[j].getName() != null ? filtDescr[j].getName() : "DefaultFilterName" + j));
                if (nodeName != null) {
                    filtNode = new FilterDescriptorNode(nodeName.trim());
                    filtNode.setDescriptor(filtDescr[j]);
                    this.treeModel.insertNodeInto(filtNode, webNode, 0);
                }
                ++j;
            }
        }
        if ((listDescr = archDescr.getListenersDescriptor()) != null) {
            int j = 0;
            while (j < listDescr.length) {
                nodeName = null;
                nodeName = listDescr[j].getListenerClass() != null && !listDescr[j].getListenerClass().trim().equals("") ? listDescr[j].getListenerClass() : (listDescr[j].getName() != null ? listDescr[j].getName() : "DefaultListenerName" + j);
                if (nodeName != null) {
                    listNode = new ListenerDescriptorNode(nodeName.trim());
                    listNode.setDescriptor(listDescr[j]);
                    this.treeModel.insertNodeInto(listNode, webNode, 0);
                }
                ++j;
            }
        }
        this.treeModel.reload();
        this.initDeplDescr();
        this.setReferenceLink();
        TreeUtils.expandTree(this.tree, 1);
        return true;
    }

    protected DeploymentDescriptor readEjbAltDD(String path, String name, ClassLoader loader) {
        DeploymentDescriptor descr = null;
        path = path.replace('\\', File.separator.charAt(0));
        EJBJarDescriptor jar = new EJBJarDescriptor();
        try {
            jar = this.generator.getConvertedEJBDescriptor(loader, path);
            descr = (DeploymentDescriptor)jar.getDescriptor(name);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred while getting EJB Descriptor.\nReason: " + e.toString(), "Getting descriptor error", 0);
        }
        return descr;
    }

    protected EJBJarDescriptor readEjbJarAltDD(String path, String name, ClassLoader loader) {
        path = path.replace('\\', File.separator.charAt(0));
        EJBJarDescriptor jar = new EJBJarDescriptor();
        try {
            jar = this.generator.getConvertedEJBDescriptor(loader, path, false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred while getting JAR Descriptor.\nReason: " + e.toString(), "Getting descriptor error", 0);
        }
        return jar;
    }

    protected ApplicationClientDescriptor readClientAltDD(String path, String name) {
        path = path.replace('\\', File.separator.charAt(0));
        ApplicationClientDescriptor client = new ApplicationClientDescriptor();
        Document doc = null;
        try {
            doc = this.parser.parse(path);
            client.loadFromDocument(doc);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred while getting Client Information.\nReason: " + e.toString(), "Getting descriptor error", 0);
        }
        return client;
    }

    protected ServletDescriptor readServletAltDD(String path, String name) {
        ServletDescriptor descr = null;
        path = path.replace('\\', File.separator.charAt(0));
        WebDeploymentDescriptor war = new WebDeploymentDescriptor();
        try {
            war = this.generator.getConvertedWebDescriptor(path);
            descr = (ServletDescriptor)war.getDescriptor(name);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred while getting Servlet Descriptor.\nReason: " + e.toString(), "Getting descriptor error", 0);
        }
        return descr;
    }

    protected WebDeploymentDescriptor readWebAltDD(String path, String name) {
        path = path.replace('\\', File.separator.charAt(0));
        WebDeploymentDescriptor war = new WebDeploymentDescriptor();
        try {
            war = this.generator.getConvertedWebDescriptor(path);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred while getting WAR Descriptor.\nReason: " + e.toString(), "Getting descriptor error", 0);
        }
        return war;
    }

    protected JCDescriptor readRarAltDD(String path, String name) {
        path = path.replace('\\', File.separator.charAt(0));
        JCDescriptor rar = new JCDescriptor();
        Document doc = null;
        try {
            doc = this.parser.parse(path);
            rar.loadFromDocument(doc);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred while getting Connector Descriptor.\nReason: " + e.toString(), "Getting descriptor error", 0);
        }
        return rar;
    }

    private String getSelectedFile(String message, boolean newFile) {
        String[] files = null;
        files = this.chooser.showFileDialog(message, true, false, newFile);
        if (files != null && files[0] != null) {
            return files[0];
        }
        return null;
    }

    private String getSelectedEarName() {
        String new_name = "";
        if (this.chooser == null) {
            this.chooser = SFileChooser.getInstance((JFrame)this.mainFrame);
        }
        if (this.projectDir != null) {
            this.chooser.setProjectDir(this.projectDir.getAbsolutePath());
        }
        this.chooser.setFilters(new String[]{".ear"});
        if (this.projectDir == null) {
            this.projectDir = new File(SystemProperties.getProperty("user.dir"));
        }
        if (!new_name.trim().toLowerCase().endsWith(".ear")) {
            new_name = new_name + ".ear";
        }
        String fname = "";
        do {
            if ((new_name = this.getSelectedFile("Please select name for the ear:", true)) == null) {
                return null;
            }
            fname = new File(new_name).getName();
            if (!new_name.trim().equals("") && FileUtils.isCorrectFileName(fname)) continue;
            JOptionPane.showMessageDialog(this.mainFrame, "Can not have empty name or illegal characters in the file name of ear.\nPlease enter valid name for ear.", "Warning", 0);
        } while (new_name.trim().equals("") || !FileUtils.isCorrectFileName(fname));
        if (new_name != null && !new_name.equals("")) {
            if (!new_name.trim().toLowerCase().endsWith(".ear")) {
                new_name = new_name + ".ear";
            }
            return new_name;
        }
        return null;
    }

    private BasicDescriptorNode findNode(BasicDescriptorNode earNode, String jarName) {
        int i = 0;
        while (i < earNode.getChildCount()) {
            BasicDescriptorNode currentNode = (BasicDescriptorNode)earNode.getChildAt(i);
            if (currentNode.getName().equals(jarName)) {
                return currentNode;
            }
            ++i;
        }
        return null;
    }

    public void setTree(JTree _tree) {
        this.tree = _tree;
        this.treeModel = (DefaultTreeModel)_tree.getModel();
    }

    public void saveXMLFile(String name) {
        this.tabPanel.removeRenamedArchives();
        if (!this.tree.isSelectionEmpty() && !this.tabPanel.updateNodeProperties()) {
            return;
        }
        if (((BasicDescriptorNode)this.treeModel.getRoot()).getChildCount() == 0) {
            this.xmlLocation = null;
            return;
        }
        if (this.xmlLocation == null) {
            if (this.projectDir == null) {
                this.projectDir = new File(".");
            }
            this.xmlLocation = this.projectDir.getAbsolutePath() + File.separator + "assembler_xml.xml";
        }
        if (name == null) {
            name = ((EARDescriptorNode)this.root).getArchiveFileName();
        }
        if (name == null && (name = this.getSelectedEarName()) == null) {
            JOptionPane.showMessageDialog(this.mainFrame, "EarName is obligational field in xml. Please select name for the ear again!\nOtherwise default name wiil be set.");
            name = this.getSelectedEarName();
            if (name == null) {
                if (this.projectDir == null) {
                    this.projectDir = new File(SystemProperties.getProperty("user.dir"));
                }
                name = this.projectDir.getName() + ".ear";
                JOptionPane.showMessageDialog(this.mainFrame, "Your ear is named: \"" + name + "\".\n If you want to rename it you will have to correct the name in assembler.xml.", "Warning", 2);
                name = this.projectDir.getAbsolutePath() + File.separator + name;
            }
        }
        ((EARDescriptorNode)this.root).setArchiveFileName(name);
        try {
            XMLEarManager manager = new XMLEarManager();
            String earDisplayName = ((EARDescriptorNode)this.root).getModifiedDescriptor().getDisplayName();
            if (earDisplayName == null || earDisplayName.equals("")) {
                String fname = new File(name).getName();
                ((EARDescriptorNode)this.root).getModifiedDescriptor().setDisplayName(fname.substring(0, fname.length() - 4));
            }
            EarJob job = new EarJob(name, ((EARDescriptorNode)this.root).getModifiedDescriptor().getDisplayName());
            job.setSmallIcon(((EARDescriptorNode)this.root).getModifiedDescriptor().getSmallIconName());
            job.setLargeIcon(((EARDescriptorNode)this.root).getModifiedDescriptor().getLargeIconName());
            job.setDescription(((EARDescriptorNode)this.root).getModifiedDescriptor().getDescription());
            ArchiveDescriptorNode current_arch = null;
            Vector addFiles = ((EARDescriptorNode)this.root).getAdditionalFiles();
            InfoObject info = null;
            int i = 0;
            while (i < addFiles.size()) {
                info = (InfoObject)addFiles.elementAt(i);
                job.addOtherFile(info.getFilePath(), info.getEntryName());
                ++i;
            }
            EarObject obj = null;
            J2EEModule[] modules = ((EARDescriptorNode)this.root).getModifiedDescriptor().getWEBs();
            String jarName = "";
            String contextRoot = null;
            int i2 = 0;
            while (i2 < this.root.getChildCount()) {
                contextRoot = null;
                current_arch = (ArchiveDescriptorNode)this.root.getChildAt(i2);
                jarName = current_arch.getArchiveFileName().lastIndexOf(File.separator) > 0 ? current_arch.getArchiveFileName().substring(current_arch.getArchiveFileName().lastIndexOf(File.separator) + 1) : current_arch.getArchiveFileName();
                if (current_arch instanceof EJBJarDescriptorNode) {
                    obj = new EarObject(jarName, current_arch.getArchiveFileName(), 1);
                    this.makeAlternateEJBXML(current_arch, current_arch.getCurrentDescriptor(), obj);
                } else if (current_arch instanceof WebDescriptorNode) {
                    if (modules != null) {
                        int j = 0;
                        while (j < modules.length) {
                            if (modules[j] != null && modules[j].getUri() != null && (modules[j].getUri().equals(jarName) || modules[j].getUri().equals(current_arch.getArchiveFileName()))) {
                                contextRoot = modules[j].getContextRoot();
                                break;
                            }
                            ++j;
                        }
                    }
                    if (contextRoot == null || contextRoot.trim().equals("")) {
                        contextRoot = jarName;
                    }
                    obj = new EarObject(jarName, current_arch.getArchiveFileName(), contextRoot);
                    this.makeAlternateWebXML(current_arch, current_arch.getCurrentDescriptor(), obj);
                } else if (current_arch instanceof ClientDescriptorNode) {
                    obj = new EarObject(jarName, current_arch.getArchiveFileName(), 4);
                    this.makeAlternateClientXML(current_arch, current_arch.getCurrentDescriptor(), obj);
                } else if (current_arch instanceof ConnectorDescriptorNode) {
                    obj = new EarObject(jarName, current_arch.getArchiveFileName(), 5);
                    this.makeAlternateConnectorXML(current_arch, current_arch.getCurrentDescriptor(), obj);
                } else {
                    obj = new EarObject(jarName, current_arch.getArchiveFileName(), 3);
                }
                obj.setIsLoaded(current_arch.getArchiveDescriptor().isLoaded());
                job.addEarObject(obj);
                ++i2;
            }
            manager.setPrjFileDir(this.tabPanel.getPrjFileDir());
            manager.writeJob(job, this.xmlLocation);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred while saving assembler xml " + e.toString(), "Error during saving project", 0);
        }
    }

    protected void makeAlternateClientXML(ArchiveDescriptorNode arch, ArchiveDescriptor descr, EarObject obj) {
        String altDDName = arch.getName();
        altDDName = altDDName.replace('.', '_') + "_AltDD";
        boolean save = false;
        if (arch.needSave()) {
            save = true;
        }
        String xmlName = arch.getXMLFileName() == null ? (this.projectDir != null ? this.projectDir + File.separator + altDDName + ".xml" : "." + File.separator + altDDName + ".xml") : arch.getXMLFileName();
        if (!save && arch.getXMLFileName() == null) {
            return;
        }
        String illegalArgumentException = descr.saveToFile(xmlName);
        if (illegalArgumentException != null && illegalArgumentException.length() != 0) {
            JOptionPane.showMessageDialog(this.mainFrame, "These errors occurred during saving of " + new File(xmlName).getName() + " in Assembler Tab: " + illegalArgumentException, "Illegal Argument Errors", 2);
        }
        obj.addAlternateDD(xmlName, descr.getDisplayName(), true);
        arch.setXMLFileName(xmlName);
    }

    protected void makeAlternateConnectorXML(ArchiveDescriptorNode arch, ArchiveDescriptor descr, EarObject obj) {
        String altDDName = arch.getName();
        altDDName = altDDName.replace('.', '_') + "_AltDD";
        boolean save = false;
        if (arch.needSave()) {
            save = true;
        }
        String xmlName = arch.getXMLFileName() == null ? (this.projectDir != null ? this.projectDir + File.separator + altDDName + ".xml" : "." + File.separator + altDDName + ".xml") : arch.getXMLFileName();
        if (!save && arch.getXMLFileName() == null) {
            return;
        }
        String illegalArgumentException = descr.saveToFile(xmlName);
        if (illegalArgumentException != null && illegalArgumentException.length() != 0) {
            JOptionPane.showMessageDialog(this.mainFrame, "These errors occurred during saving of " + new File(xmlName).getName() + " in Assembler Tab: " + illegalArgumentException, "Illegal Argument Errors", 2);
        }
        obj.addAlternateDD(xmlName, descr.getDisplayName(), true);
        arch.setXMLFileName(xmlName);
    }

    protected void makeAlternateEJBXML(ArchiveDescriptorNode arch, ArchiveDescriptor descr, EarObject obj) {
        int j;
        String altDDName = arch.getName();
        altDDName = altDDName.replace('.', '_') + "AltDD";
        boolean save = false;
        if (arch.needSave()) {
            save = true;
        } else {
            int countChild = arch.getChildCount();
            DescriptorNode currentChild = null;
            if (countChild != 0) {
                j = 0;
                while (j < countChild) {
                    currentChild = (DescriptorNode)arch.getChildAt(j);
                    if (currentChild.needSave()) {
                        save = true;
                        break;
                    }
                    ++j;
                }
            }
        }
        if (!save && arch.getXMLFileName() == null) {
            return;
        }
        String xmlName = arch.getXMLFileName() == null ? (this.projectDir != null ? this.projectDir + File.separator + altDDName + ".xml" : "." + File.separator + altDDName + ".xml") : arch.getXMLFileName();
        EJBDescriptorNode node = null;
        Descriptor[] descriptors = new DeploymentDescriptor[arch.getChildCount()];
        j = 0;
        while (j < arch.getChildCount()) {
            node = (EJBDescriptorNode)arch.getChildAt(j);
            descriptors[j] = (DeploymentDescriptor)node.getCurrentDescriptor();
            obj.addAlternateDD(xmlName, node.getCurrentDescriptor().getName(), true);
            node.setXMLFileName(xmlName);
            ++j;
        }
        obj.addAlternateDD(xmlName, descr.getDisplayName(), true);
        descr.setDescriptors(descriptors);
        this.saveEjbAltDDToFile(xmlName, (EJBJarDescriptor)descr);
        arch.setXMLFileName(xmlName);
    }

    private void saveEjbAltDDToFile(String xmlDescriptorName, EJBJarDescriptor jar) {
        EJB20DescriptorDocument doc = new EJB20DescriptorDocument(false);
        Document document = null;
        try {
            document = doc.loadEJBJarDescriptor(jar);
            this.writer.write(document, xmlDescriptorName, "<!DOCTYPE ejb-jar PUBLIC '-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN' 'http://java.sun.com/dtd/ejb-jar_2_0.dtd'>", "UTF-8");
            String illegalArgumentException = doc.getIllegalArgumentException();
            if (illegalArgumentException != null && illegalArgumentException.length() != 0) {
                JOptionPane.showMessageDialog(this.mainFrame, "These errors occurred during saving of " + new File(xmlDescriptorName).getName() + " in Assembler Tab: " + illegalArgumentException, "Illegal Argument Errors", 2);
            }
        }
        catch (IllegalArgumentException iaex) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred during saving of " + new File(xmlDescriptorName).getName() + " in Assembler Tab: " + iaex, "Illegal Argument Error", 0);
        }
        catch (IOException ioex) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred during saving of " + new File(xmlDescriptorName).getName() + " in Assembler Tab: " + ioex, "IO Error", 0);
        }
        catch (Throwable thr) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred during saving of " + new File(xmlDescriptorName).getName() + " in Assembler Tab: " + thr, "Error", 0);
        }
    }

    protected void makeAlternateWebXML(ArchiveDescriptorNode arch, ArchiveDescriptor descr, EarObject obj) {
        String altDDName = arch.getName();
        altDDName = altDDName.replace('.', '_') + "_AltDD";
        boolean save = false;
        if (arch.needSave()) {
            save = true;
        } else {
            int countChild = arch.getChildCount();
            DescriptorNode currentChild = null;
            if (countChild != 0) {
                int j = 0;
                while (j < countChild) {
                    currentChild = (DescriptorNode)arch.getChildAt(j);
                    if (currentChild.needSave()) {
                        save = true;
                        break;
                    }
                    ++j;
                }
            }
        }
        if (!save && arch.getXMLFileName() == null) {
            return;
        }
        String xmlName = arch.getXMLFileName() == null ? (this.projectDir != null ? this.projectDir + File.separator + altDDName + ".xml" : "." + File.separator + altDDName + ".xml") : arch.getXMLFileName();
        DescriptorNode node = null;
        Vector<ServletDescriptor> descriptorsV = new Vector<ServletDescriptor>();
        Vector<ListenerDescriptor> listeners = new Vector<ListenerDescriptor>();
        Vector<Descriptor> filters = new Vector<Descriptor>();
        int j = 0;
        while (j < arch.getChildCount()) {
            if (arch.getChildAt(j) instanceof ServletDescriptorNode) {
                node = (ServletDescriptorNode)arch.getChildAt(j);
                descriptorsV.add((ServletDescriptor)node.getCurrentDescriptor());
                if (((ServletDescriptor)node.getCurrentDescriptor()).getServletName() != null) {
                    obj.addAlternateDD(xmlName, ((ServletDescriptor)node.getCurrentDescriptor()).getServletName(), true);
                } else {
                    obj.addAlternateDD(xmlName, node.getCurrentDescriptor().getName(), true);
                }
                node.setXMLFileName(xmlName);
            } else if (arch.getChildAt(j) instanceof FilterDescriptorNode) {
                node = (FilterDescriptorNode)arch.getChildAt(j);
                filters.add(((FilterDescriptorNode)node).getCurrentDescriptor());
                if (((FilterDescriptor)node.getCurrentDescriptor()).getFilterName() != null) {
                    obj.addAlternateDD(xmlName, ((FilterDescriptor)node.getCurrentDescriptor()).getFilterName(), true);
                } else {
                    obj.addAlternateDD(xmlName, node.getCurrentDescriptor().getName(), true);
                }
                node.setXMLFileName(xmlName);
            } else if (arch.getChildAt(j) instanceof ListenerDescriptorNode) {
                node = (ListenerDescriptorNode)arch.getChildAt(j);
                listeners.add((ListenerDescriptor)node.getCurrentDescriptor());
                if (((ListenerDescriptor)node.getCurrentDescriptor()).getName() != null) {
                    obj.addAlternateDD(xmlName, ((ListenerDescriptor)node.getCurrentDescriptor()).getName(), true);
                } else {
                    obj.addAlternateDD(xmlName, node.getCurrentDescriptor().getName(), true);
                }
            }
            ++j;
        }
        Object[] descriptors = new ServletDescriptor[descriptorsV.size()];
        Object[] filterDescriptors = new FilterDescriptor[filters.size()];
        Object[] listenerDescriptors = new ListenerDescriptor[listeners.size()];
        filters.copyInto(filterDescriptors);
        listeners.copyInto(listenerDescriptors);
        descriptorsV.copyInto(descriptors);
        obj.addAlternateDD(xmlName, descr.getDisplayName(), true);
        ((WebDeploymentDescriptor)descr).setListeners((ListenerDescriptor[])listenerDescriptors);
        ((WebDeploymentDescriptor)descr).setFilters((FilterDescriptor[])filterDescriptors);
        ((WebDeploymentDescriptor)descr).setServlets((ServletDescriptor[])descriptors);
        String illegalArgumentException = descr.saveToFile(xmlName);
        if (illegalArgumentException != null && illegalArgumentException.length() != 0) {
            JOptionPane.showMessageDialog(this.mainFrame, "These errors occurred during saving of " + new File(xmlName).getName() + " in Assembler Tab: " + illegalArgumentException, "Illegal Argument Errors", 2);
        }
        arch.setXMLFileName(xmlName);
    }

    public String getXMLFileLocation() {
        return this.xmlLocation;
    }

    public void initOnProjectOpen(String xmlFile, String[] path) throws IOException {
        this.tabPanel.clearOnProjectClose();
        this.classPath = "";
        this.setClassPath(path);
        this.tree.setRootVisible(true);
        this.xmlLocation = xmlFile;
        Vector<InfoObject> addFiles = new Vector<InfoObject>();
        InfoObject fileInfo = null;
        XMLEarManager manager = new XMLEarManager();
        EarJob job = null;
        try {
            manager.setPrjFileDir(this.tabPanel.getPrjFileDir());
            job = manager.readXML(xmlFile);
        }
        catch (EARGeneratorException e) {
            throw new IOException(e.toString());
        }
        if (job != null) {
            ((EARDescriptorNode)this.root).setArchiveFileName(job.getOutputname());
            String rootName = null;
            if (job.getOutputname() != null) {
                rootName = job.getOutputname().substring(job.getOutputname().lastIndexOf(File.separator) + 1);
                this.tabPanel.displayNameFromXML = true;
            } else {
                this.tabPanel.displayNameFromXML = false;
                if (this.mainFrame instanceof DeployFrame) {
                    rootName = ((DeployFrame)this.mainFrame).getProjectFileName();
                    if (rootName.lastIndexOf(File.separator) != -1) {
                        rootName = rootName.substring(rootName.lastIndexOf(File.separator) + 1);
                    }
                    if (rootName.lastIndexOf(".") != -1) {
                        rootName = rootName.substring(0, rootName.lastIndexOf("."));
                    }
                }
            }
            ((EARDescriptorNode)this.root).setName(rootName);
            ((EARDescriptorNode)this.root).getModifiedDescriptor().setDisplayName(job.getDisplayname());
            ((EARDescriptorNode)this.root).getModifiedDescriptor().setSmallIconName(job.getSmallIcon() != null ? job.getSmallIcon() : "");
            ((EARDescriptorNode)this.root).getModifiedDescriptor().setLargeIconName(job.getLargeIcon() != null ? job.getLargeIcon() : "");
            ((EARDescriptorNode)this.root).getModifiedDescriptor().setDescription(job.getDescription());
            Enumeration all_objects = job.getEarFiles();
            EarObject obj = null;
            DynamicClassLoader loader = null;
            ArchiveDescriptor archDescr = null;
            while (all_objects.hasMoreElements()) {
                obj = (EarObject)all_objects.nextElement();
                try {
                    archDescr = obj.getArchiveDescriptor(this.classPath);
                    if (!obj.getErrors().isEmpty()) {
                        String message = "Errors while reading ear: \n";
                        Vector errors = obj.getErrors();
                        int i = 0;
                        while (i < errors.size()) {
                            message = message + errors.get(i) + "\n";
                            ++i;
                        }
                        JOptionPane.showConfirmDialog(this.tabPanel.getFrame(), message, "Error", 0, 0);
                    }
                }
                catch (Exception e) {
                    JOptionPane.showConfirmDialog(this.mainFrame, "Errors while reading ear: \n" + e.toString(), "Error", 0);
                }
                if (archDescr != null) {
                    archDescr.setLoaded(obj.getIsLoaded());
                }
                this.classPath = obj.getPathname() + File.pathSeparator + this.classPath + File.pathSeparator;
                loader = new DynamicClassLoader(this.classPath);
                this.tabPanel.setLoader(loader);
                if (obj.getType() == 1) {
                    try {
                        this.loadEJBJar(obj, obj.getPathname(), (EJBJarDescriptor)archDescr, loader, this.getFilesFromArchive(obj));
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not load EJB jar! \n" + obj.getPathname(), "Error", 0);
                    }
                    continue;
                }
                if (obj.getType() == 2) {
                    try {
                        this.loadWeb(obj, obj.getPathname(), (WebDeploymentDescriptor)archDescr, this.getFilesFromArchive(obj), true);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not load Web war! \n" + obj.getPathname(), "Error", 0);
                    }
                    continue;
                }
                if (obj.getType() == 4) {
                    try {
                        this.loadClientJar(obj, obj.getPathname(), (ApplicationClientDescriptor)archDescr, this.getFilesFromArchive(obj));
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not load Client jar! \n" + obj.getPathname(), "Error", 0);
                    }
                    continue;
                }
                if (obj.getType() == 5) {
                    try {
                        this.loadConnectorRar(obj, obj.getPathname(), (JCDescriptor)archDescr, this.getFilesFromArchive(obj));
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not load RAR of resource adapter! \n" + obj.getPathname(), "Error", 0);
                    }
                    continue;
                }
                if (obj.getType() != 3) continue;
                fileInfo = new InfoObject(obj.getEntryname(), obj.getPathname());
                addFiles.addElement(fileInfo);
            }
            if (addFiles != null && addFiles.size() > 0) {
                ((EARDescriptorNode)this.root).setAdditionalFiles(addFiles);
            }
        } else if (this.mainFrame instanceof DeployFrame) {
            String rootName = ((DeployFrame)this.mainFrame).getProjectFileName();
            if (rootName.lastIndexOf(File.separator) != -1) {
                rootName = rootName.substring(rootName.lastIndexOf(File.separator) + 1);
            }
            if (rootName.lastIndexOf(".") != -1) {
                rootName = rootName.substring(0, rootName.lastIndexOf("."));
            }
            ((EARDescriptorNode)this.root).setName(rootName);
        }
        this.passRoles();
    }

    public void setProjectDir(File dir) {
        this.projectDir = dir;
        if (dir != null) {
            this.logFile = dir.getAbsolutePath() + File.separator + "ear_generator_log.txt";
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getFilesFromArchive(EarObject obj) throws Exception {
        ZipFile file;
        Vector<InfoObject> infoes;
        block15: {
            String pathName = obj.getPathname();
            InfoObject currentInfo = null;
            infoes = new Vector<InfoObject>();
            file = null;
            int type = -1;
            type = obj.getType();
            if (type == 2) {
                file = new ZipFile(pathName);
                Enumeration<? extends ZipEntry> enumeration = file.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry entry = enumeration.nextElement();
                    if (entry.getName().endsWith("web.xml") || entry.isDirectory()) continue;
                    currentInfo = new InfoObject(entry.getName(), pathName);
                    infoes.addElement(currentInfo);
                }
                break block15;
            }
            if (type == 1) {
                file = new ZipFile(pathName);
                Enumeration<? extends ZipEntry> enumeration = file.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry entry = enumeration.nextElement();
                    if (entry.getName().endsWith("ejb-jar.xml") && entry.getName().endsWith("storage.xml") && entry.getName().endsWith(".class") || entry.isDirectory()) continue;
                    currentInfo = new InfoObject(entry.getName(), pathName);
                    infoes.addElement(currentInfo);
                }
                break block15;
            }
            if (type != 3) break block15;
            file = new ZipFile(pathName);
            Enumeration<? extends ZipEntry> enumeration = file.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                if (entry.getName().endsWith("client.xml") || entry.isDirectory()) continue;
                currentInfo = new InfoObject(entry.getName(), pathName);
                infoes.addElement(currentInfo);
            }
        }
        Object var10_15 = null;
        if (file == null) return infoes;
        try {
            file.close();
            return infoes;
        }
        catch (Exception e) {
            JOptionPane.showConfirmDialog(this.mainFrame, "Errors while archive file is closing: \n" + e.toString(), "Error", 0);
        }
        return infoes;
        {
            catch (Exception exc) {
                JOptionPane.showConfirmDialog(this.mainFrame, "Errors while geting files from ear: \n" + exc.toString(), "Error", 0);
                Object var10_16 = null;
                if (file == null) return infoes;
                try {
                    file.close();
                    return infoes;
                }
                catch (Exception e) {
                    JOptionPane.showConfirmDialog(this.mainFrame, "Errors while archive file is closing: \n" + e.toString(), "Error", 0);
                }
                return infoes;
            }
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            if (file == null) throw throwable;
            try {
                file.close();
                throw throwable;
            }
            catch (Exception e) {
                JOptionPane.showConfirmDialog(this.mainFrame, "Errors while archive file is closing: \n" + e.toString(), "Error", 0);
            }
            throw throwable;
        }
    }

    public void setIsTransfer(boolean flag) {
        this.isTransfer = flag;
    }

    protected void setClassPath(String[] path) {
        if (path == null) {
            this.classPath = "";
        }
        StringTokenizer classPathOldTokenizer = new StringTokenizer(this.classPath, File.pathSeparator);
        Vector<String> oldClassPathVector = new Vector<String>();
        while (classPathOldTokenizer.hasMoreTokens()) {
            oldClassPathVector.add(classPathOldTokenizer.nextToken());
        }
        if (path != null) {
            int i = 0;
            while (i < path.length) {
                if (!(path[i] == null || path[i].equals("") || path[i].equals("null") || oldClassPathVector.contains(path[i]))) {
                    this.classPath = this.classPath.endsWith(File.pathSeparator) ? this.classPath + path[i] + File.pathSeparator : this.classPath + File.pathSeparator + path[i] + File.pathSeparator;
                }
                ++i;
            }
        }
        DynamicClassLoader loader = new DynamicClassLoader(this.classPath);
        this.tabPanel.setLoader(loader);
    }

    public void setReferenceLink() {
        BasicDescriptorNode root = (BasicDescriptorNode)this.treeModel.getRoot();
        int count = root.getChildCount();
        EJBeanReference[] ejbRef = null;
        if (count != 0) {
            int i = 0;
            while (i < count) {
                ApplicationClientDescriptor clDescr;
                ArchiveDescriptorNode currentNode = (ArchiveDescriptorNode)root.getChildAt(i);
                if (currentNode instanceof EJBJarDescriptorNode) {
                    int childCount = currentNode.getChildCount();
                    if (childCount != 0) {
                        int j = 0;
                        while (j < childCount) {
                            EJBDescriptorNode childNode = (EJBDescriptorNode)currentNode.getChildAt(j);
                            DeploymentDescriptor deplD = (DeploymentDescriptor)childNode.getCurrentDescriptor();
                            if (deplD != null && (ejbRef = deplD.getEJBeanReferences()) != null) {
                                int k = 0;
                                while (k < ejbRef.length) {
                                    this.setDefaultLink(ejbRef[k]);
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                } else if (currentNode instanceof WebDescriptorNode) {
                    WebDeploymentDescriptor webDescr = (WebDeploymentDescriptor)currentNode.getCurrentDescriptor();
                    if (webDescr != null && (ejbRef = webDescr.getEjbRefs()) != null) {
                        int k = 0;
                        while (k < ejbRef.length) {
                            this.setDefaultLink(ejbRef[k]);
                            ++k;
                        }
                    }
                } else if (currentNode instanceof ClientDescriptorNode && (clDescr = (ApplicationClientDescriptor)currentNode.getCurrentDescriptor()) != null && (ejbRef = clDescr.getEJBeanReferences()) != null) {
                    int k = 0;
                    while (k < ejbRef.length) {
                        this.setDefaultLink(ejbRef[k]);
                        ++k;
                    }
                }
                ++i;
            }
        }
    }

    private void setDefaultLink(EJBeanReference ejbRef) {
        String refLink = null;
        String refHome = null;
        String refRemote = null;
        String currHome = null;
        String currRemote = null;
        refLink = ejbRef.getReferenceEjbLink();
        if (refLink == null || refLink.equals("")) {
            refHome = ejbRef.getHomeInterfaceName();
            refRemote = ejbRef.getRemoteInterfaceName();
            if (this.dDescr != null) {
                int i = 0;
                while (i < this.dDescr.size()) {
                    if (this.dDescr.elementAt(i) != null) {
                        currHome = ((DeploymentDescriptor)this.dDescr.elementAt(i)).getRemoteHomeInterface();
                        currRemote = ((DeploymentDescriptor)this.dDescr.elementAt(i)).getRemoteInterface();
                        if (currHome != null && currRemote != null && currHome.equals(refHome) && currRemote.equals(refRemote)) {
                            ejbRef.setReferenceEjbLink(((DeploymentDescriptor)this.dDescr.elementAt(i)).getEjbName());
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public void initDeplDescr() {
        BasicDescriptorNode root = (BasicDescriptorNode)this.treeModel.getRoot();
        int count = root.getChildCount();
        if (count != 0) {
            int i = 0;
            while (i < count) {
                int childCount;
                ArchiveDescriptorNode currentNode = (ArchiveDescriptorNode)root.getChildAt(i);
                if (currentNode instanceof EJBJarDescriptorNode && (childCount = currentNode.getChildCount()) != 0) {
                    int j = 0;
                    while (j < childCount) {
                        EJBDescriptorNode childNode = (EJBDescriptorNode)currentNode.getChildAt(j);
                        DeploymentDescriptor deplD = (DeploymentDescriptor)childNode.getCurrentDescriptor();
                        this.dDescr.add(deplD);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public void passRoles() {
        if (this.root == null) {
            return;
        }
        SecurityRoles[] allRoles = null;
        SecurityRoles[] tempRoles = null;
        allRoles = this.mergeRoles(((EARDescriptorNode)this.root).getModifiedDescriptor().getRoles(), allRoles);
        ArchiveDescriptorNode archNode = null;
        WebDeploymentDescriptor webDescr = null;
        EJBJarDescriptor ejbJarDescr = null;
        if (this.root.getChildCount() == 0) {
            ((EARDescriptorNode)this.root).getModifiedDescriptor().setRoles(null);
            return;
        }
        int i = 0;
        while (i < this.root.getChildCount()) {
            archNode = (ArchiveDescriptorNode)this.root.getChildAt(i);
            if (archNode instanceof EJBJarDescriptorNode) {
                ejbJarDescr = (EJBJarDescriptor)((EJBJarDescriptorNode)archNode).getCurrentDescriptor();
                if (ejbJarDescr != null) {
                    tempRoles = ejbJarDescr.getSecurityRoles();
                    allRoles = this.mergeRoles(tempRoles, allRoles);
                }
            } else if (archNode instanceof WebDescriptorNode && (webDescr = (WebDeploymentDescriptor)((WebDescriptorNode)archNode).getCurrentDescriptor()) != null) {
                tempRoles = webDescr.getSecRoles();
                allRoles = this.mergeRoles(tempRoles, allRoles);
            }
            ++i;
        }
        ((EARDescriptorNode)this.root).getModifiedDescriptor().setRoles(allRoles);
        int i2 = 0;
        while (i2 < this.root.getChildCount()) {
            archNode = (ArchiveDescriptorNode)this.root.getChildAt(i2);
            if (archNode instanceof EJBJarDescriptorNode) {
                ejbJarDescr = (EJBJarDescriptor)((EJBJarDescriptorNode)archNode).getCurrentDescriptor();
                if (ejbJarDescr != null) {
                    ejbJarDescr.setSecurityRoles(allRoles);
                    ((EJBJarDescriptorNode)archNode).setModifiedDescriptor(ejbJarDescr);
                }
            } else if (archNode instanceof WebDescriptorNode && (webDescr = (WebDeploymentDescriptor)((WebDescriptorNode)archNode).getCurrentDescriptor()) != null) {
                webDescr.setSecRoles(allRoles);
                ((WebDescriptorNode)archNode).setModifiedDescriptor(webDescr);
            }
            ++i2;
        }
    }

    private SecurityRoles[] mergeRoles(SecurityRoles[] s1, SecurityRoles[] s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        if (s1 == null && s2 == null) {
            return null;
        }
        Vector<SecurityRoles> elements = new Vector<SecurityRoles>();
        int i = 0;
        while (i < s1.length) {
            if (s1[i] != null) {
                elements.add(s1[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < s2.length) {
            if (s2[i2] != null && !this.containsRole(s2[i2], elements)) {
                elements.add(s2[i2]);
            }
            ++i2;
        }
        if (elements.size() > 0) {
            Object[] concatination = new SecurityRoles[elements.size()];
            elements.copyInto(concatination);
            return concatination;
        }
        return null;
    }

    private boolean containsRole(SecurityRoles role, Vector v) {
        if (v == null || role == null || role.getRoleName() == null) {
            return false;
        }
        SecurityRoles vEl = null;
        String roleDescr = role.getDescription();
        String vElDescr = null;
        int i = 0;
        while (i < v.size()) {
            vEl = (SecurityRoles)v.elementAt(i);
            vElDescr = vEl.getDescription();
            if (role.getRoleName().equals(vEl.getRoleName()) && (roleDescr == null && vElDescr == null || roleDescr == null && vElDescr.trim().equals("") || roleDescr.trim().equals("") && vElDescr == null || roleDescr != null && roleDescr.equals(vElDescr))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasMadeArchive() {
        return this.madeArchive;
    }

    public void setMadeArchive(boolean hasMade) {
        this.madeArchive = hasMade;
    }

    private void renameAction() {
        RenameDialog dialog = new RenameDialog(this.projectDir.getAbsolutePath(), this.mainFrame);
        dialog.setType((byte)3);
        EARDescriptorNode parental = (EARDescriptorNode)this.tree.getModel().getRoot();
        String oldPath = parental.getArchiveFileName();
        if (oldPath == null || oldPath.equals("")) {
            oldPath = this.projectDir.getAbsolutePath() + File.separator + parental.getName() + ".ear";
        }
        dialog.setPath(oldPath);
        ((Component)dialog).setVisible(true);
        String newPath = dialog.getPath();
        if (newPath.equals(oldPath)) {
            return;
        }
        parental.setArchiveFileName(newPath);
        File oldFile = new File(oldPath);
        File newFile = new File(newPath);
        if (oldFile.exists()) {
            if (oldFile.getParent().equals(newFile.getParent())) {
                oldFile.renameTo(newFile);
            } else {
                try {
                    FileUtils.copyFile(oldFile, newFile);
                }
                catch (IOException io) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Rename failed because of: " + io.getMessage(), "Error", 0);
                }
                oldFile.delete();
            }
        }
        newPath = newPath.substring(newPath.lastIndexOf(File.separator) + File.separator.length());
        this.tabPanel.setDisplayName(newPath);
        parental.setName(newPath);
    }

    public File getLogFile() {
        if (this.logFile != null) {
            return new File(this.logFile);
        }
        return null;
    }

    private void initXMLToolkit() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.writer = new StandardDOMWriter();
        this.parser = new StandardDOMParser();
        Thread.currentThread().setContextClassLoader(cl);
    }
}

