/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.deploy.tool.DeployFrame;
import com.sap.engine.deploy.tool.ToolTabPanel;
import com.sap.engine.gui.AboutWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProjectActionManager
implements ActionListener,
ChangeListener {
    public static final String PRJ_NEW_CMD = "PRJ_NEW_CMD";
    public static final String PRJ_OPEN_CMD = "PRJ_OPEN_CMD";
    public static final String PRJ_SAVE_CMD = "PRJ_SAVE_CMD";
    public static final String PRJ_SAVEAS_CMD = "PRJ_SAVEAS_CMD";
    public static final String PRJ_CLOSE_CMD = "PRJ_CLOSE_CMD";
    public static final String PRJ_QUICK_DEPLOY_CMD = "PRJ_QUICK_DEPLOY_CMD";
    public static final String PRJ_OPTIONS_CMD = "PRJ_OPTIONS_CMD";
    public static final String PRJ_ERRORS_CMD = "PRJ_ERRORS_CMD";
    public static final String PRJ_HISTORY_CMD = "PRJ_HISTORY_CMD";
    public static final String PRJ_EXIT_CMD = "PRJ_EXIT_CMD";
    public static final String HL_HELP_CMD = "HL_HELP_CMD";
    public static final String HL_ABOUT_CMD = "HL_ABOUT_CMD";
    public static final String HISTORY_FILE_NAME = "PrjHistory.property";
    public DeployFrame deployFrame;
    protected ToolTabPanel lastSelectedPanel = null;
    protected Runtime runtime = null;
    protected static String parentDir = new File(SystemProperties.getProperty("user.dir")).getParent();
    protected static String HELP_PATH = parentDir + File.separator + "docs" + File.separator + "Help" + File.separator + "Deploy" + File.separator + "index.html";
    private AboutWindow about;
    protected String[] browser = new String[]{"", HELP_PATH};

    public ProjectActionManager(DeployFrame deployFrame) {
        this.deployFrame = deployFrame;
        this.about = new AboutWindow(deployFrame);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(PRJ_NEW_CMD)) {
            this.newAction();
        } else if (cmd.equals(PRJ_OPEN_CMD)) {
            this.openAction();
        } else if (cmd.equals(PRJ_SAVE_CMD)) {
            this.saveAction();
        } else if (cmd.equals(PRJ_SAVEAS_CMD)) {
            this.saveAsAction();
        } else if (cmd.equals(PRJ_CLOSE_CMD)) {
            this.closeAction();
        } else if (cmd.equals(PRJ_OPTIONS_CMD)) {
            this.optionsAction();
        } else if (cmd.equals(PRJ_ERRORS_CMD)) {
            this.errorsAction();
        } else if (cmd.equals(PRJ_QUICK_DEPLOY_CMD)) {
            this.quickDeployAction();
        } else if (cmd.equals(PRJ_EXIT_CMD)) {
            this.exitAction();
        } else if (cmd.equals(HL_ABOUT_CMD)) {
            this.aboutAction();
        } else if (cmd.equals(HL_HELP_CMD)) {
            this.helpAction();
        } else if (e.getSource() instanceof JMenuItem && ((JMenuItem)e.getSource()).getToolTipText() != null && ((JMenuItem)e.getSource()).getToolTipText().equals(cmd)) {
            this.deployFrame.openProject(cmd);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        ToolTabPanel selectedTabPanel = null;
        if (this.deployFrame.getProjectFileName() != null) {
            selectedTabPanel = (ToolTabPanel)((Object)this.deployFrame.getTabPane().getSelectedComponent());
            String transferStatus = "true";
            if (this.lastSelectedPanel != null) {
                this.lastSelectedPanel.lostTabSelection();
                if (this.deployFrame.getProjectProperties() != null) {
                    transferStatus = this.deployFrame.getProjectProperties().getProperty("TransferBetweenTabs");
                }
                if (transferStatus == null) {
                    transferStatus = "true";
                }
                if (transferStatus.equalsIgnoreCase("true")) {
                    this.deployFrame.tabTransfer(this.lastSelectedPanel);
                }
                if (selectedTabPanel != null) {
                    selectedTabPanel.recievedTabSelection();
                }
            }
            this.deployFrame.setAdditionalMenu(selectedTabPanel);
            this.deployFrame.setToolBarButton(selectedTabPanel);
            this.deployFrame.statusLabel.setText("");
            this.deployFrame.progressBar.setValue(0);
            this.deployFrame.progressBar.setString("0%");
        } else {
            this.deployFrame.setAdditionalMenu(null);
            this.deployFrame.setToolBarButton(null);
        }
        this.lastSelectedPanel = selectedTabPanel;
    }

    private void newAction() {
        this.deployFrame.newProject();
    }

    private void openAction() {
        this.deployFrame.openProject();
    }

    private void errorsAction() {
        this.deployFrame.errorsShow();
    }

    private void saveAction() {
        this.deployFrame.storeProject();
    }

    private void saveAsAction() {
        this.deployFrame.saveAsProject();
    }

    private void closeAction() {
        if (this.deployFrame.closeCurrentProject()) {
            this.lastSelectedPanel = null;
        }
    }

    private void optionsAction() {
        this.deployFrame.showOptionsDialog();
    }

    private void exitAction() {
        this.deployFrame.exitAction();
    }

    private void aboutAction() {
        if (!this.about.isShowing()) {
            this.about.show();
        }
    }

    private void quickDeployAction() {
        this.deployFrame.quickDeploy();
    }

    private void helpAction() {
        if (this.runtime == null) {
            this.runtime = Runtime.getRuntime();
        }
        this.browser[0] = this.deployFrame.getOptions().getProperty("BrowserPath");
        if (this.browser[0] != null) {
            this.browser[0] = this.browser[0].trim();
        }
        try {
            this.runtime.exec(this.browser);
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this.deployFrame, "Help file could not be loaded. Make sure that you\nhave specified  browser path  in Additional tab of\n Project Options dialog", "Error", 0);
        }
    }

    static {
        if (parentDir == null) {
            HELP_PATH = SystemProperties.getProperty("user.dir").substring(0, SystemProperties.getProperty("user.dir").lastIndexOf(File.separator));
            HELP_PATH = HELP_PATH + File.separator + "docs" + File.separator + "Help" + File.separator + "Deploy" + File.separator + "index.html";
        }
    }
}

