/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.deploy.QuickDeploy;
import com.sap.engine.deploy.exceptions.DeployToolResourceAccessor;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.DeployFrameOptions;
import com.sap.engine.deploy.tool.DeployPrjDocument;
import com.sap.engine.deploy.tool.MainTabPanel;
import com.sap.engine.deploy.tool.ProjectActionManager;
import com.sap.engine.deploy.tool.ProjectOptionsDialog;
import com.sap.engine.deploy.tool.ToolTabPanel;
import com.sap.engine.deploy.tool.deployer.DeployTab;
import com.sap.engine.deploy.tool.gui.MakeAllStatusWindow;
import com.sap.engine.gui.AboutWindow;
import com.sap.engine.gui.CToolBarSeparator;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.connect.ImageHolder;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.gui.SFileChooser;
import com.sap.engine.services.deploy.gui.common.ErrorReportLocatorDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class DeployFrame
extends JFrame {
    public JMenuItem openItem = new JMenuItem("Open Project");
    public JMenuItem saveItem = new JMenuItem("Save");
    public JMenuItem saveAsItem = new JMenuItem("Save As...");
    public JMenuItem closeItem = new JMenuItem("Close Project");
    public JMenuItem deleteItem = new JMenuItem("Delete Selected");
    public JMenuItem newItem = new JMenuItem("New Project");
    public JMenuItem optionsItem = new JMenuItem("Options...");
    public JMenuItem errorsInProjectItem = new JMenuItem("Errors in Project...");
    public JMenuItem quickDeployItem = new JMenuItem("Make All");
    public JMenuItem exitItem = new JMenuItem("Exit");
    public JMenuItem helpItem = new JMenuItem("Help");
    public JMenuItem aboutItem = new JMenuItem("About");
    public JProgressBar progressBar = new JProgressBar();
    JSeparator aSeparator = new JSeparator();
    protected ProjectActionManager prjActionManager;
    protected DeployFrameOptions deployOptions;
    protected JTabbedPane mainTabPane = new JTabbedPane();
    protected JMenuBar deployMenuBar = new JMenuBar();
    protected JMenu projectMenu = new JMenu("Project");
    protected JMenu helpMenu = new JMenu("Help");
    protected DeployPrjDocument projectDocument = new DeployPrjDocument();
    protected JMenu additionalMenu = new JMenu();
    protected JLabel statusLabel = new JLabel();
    protected JPanel statusBarPanel = new JPanel();
    protected Properties projectProperties = null;
    protected JToolBar deployToolBar = new JToolBar();
    protected JButton[] projectButtons = new JButton[6];
    protected String frameName;
    protected String projectFileName = null;
    protected ProjectOptionsDialog optionsDialog = null;
    protected File projDir = null;
    protected File dlpFileDirectory = null;
    protected String dlpDirectory = null;
    protected boolean needSaveing = false;
    protected boolean hasMissingTabs = false;
    protected String notAvailableTab = null;
    private boolean skipSaveingAsk = false;
    private boolean oldProject = false;
    private boolean withoutCancel = false;
    private boolean newProject = false;
    private SFileChooser newChooser;
    private JProgressBar progress;
    private Properties variables = new Properties();
    private ErrorReportLocatorDialog errorDialog = new ErrorReportLocatorDialog((Frame)this, null);
    static /* synthetic */ Class class$com$sap$engine$deploy$tool$DeployFrame;
    static /* synthetic */ Class array$Ljava$lang$String;

    public DeployFrame(String frameName) {
        this.frameName = frameName;
        this.deployOptions = new DeployFrameOptions("dplOptions.options", "Basic Deploy Frame Options");
        this.prjActionManager = new ProjectActionManager(this);
        try {
            this.setTitle(frameName);
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Visualization of panels cannot be initialized properly\nReason: " + e.toString() + "\nRestart of the tool is recommended.\n We are sorry for the inconvenience.", "Error in visualization", 0);
        }
        this.show();
        DeployToolResourceAccessor.init(null, null);
        if (this.hasMissingTabs) {
            JOptionPane.showMessageDialog(this, "The " + this.notAvailableTab + " tabs cannot be loaded.");
        }
    }

    public void init() throws Exception {
        this.progress = new JProgressBar(0, 100);
        this.progress.setBackground(new Color(15, 77, 106));
        this.progress.setForeground(new Color(247, 182, 16));
        AboutWindow about = new AboutWindow(this, this.progress);
        try {
            about.show();
            this.progress.setValue(1);
            this.newChooser = SFileChooser.getInstance(this);
            int iv = 1;
            while (iv < 6) {
                this.progress.setValue(iv);
                ++iv;
            }
            if (this.newChooser != null) {
                this.newChooser.setFavourites(this.deployOptions.getProperty("Favourites"));
            }
            this.mainTabPane.addChangeListener(this.prjActionManager);
            this.getContentPane().add((Component)this.deployToolBar, "North");
            try {
                ((Frame)this).setIconImage(ImageHolder.logo.getImage());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error occurs while getting logo image.\nReason: " + e.toString(), "Logo Icon", 0);
            }
            this.openItem.setMnemonic(79);
            this.saveItem.setMnemonic(83);
            this.saveAsItem.setMnemonic(65);
            this.closeItem.setMnemonic(67);
            this.newItem.setMnemonic(78);
            this.optionsItem.setMnemonic(84);
            this.quickDeployItem.setMnemonic(77);
            this.exitItem.setMnemonic(88);
            this.helpItem.setMnemonic(69);
            this.aboutItem.setMnemonic(85);
            this.errorsInProjectItem.setMnemonic(82);
            this.projectMenu.setMnemonic(80);
            this.helpMenu.setMnemonic(72);
            this.progress.setValue(7);
            this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
            this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
            this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
            this.exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
            this.helpItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
            LookAndFeelHandler.add(this);
            this.progress.setValue(9);
            this.getContentPane().add((Component)this.mainTabPane, "Center");
            this.statusBarPanel.setLayout(new BorderLayout());
            this.statusBarPanel.setBorder(BorderFactory.createEtchedBorder());
            this.statusLabel.setBorder(BorderFactory.createLoweredBevelBorder());
            this.progressBar.setBorder(BorderFactory.createLoweredBevelBorder());
            this.statusBarPanel.add((Component)this.statusLabel, "Center");
            this.statusBarPanel.add((Component)this.progressBar, "East");
            this.statusBarPanel.setPreferredSize(new Dimension(25, 25));
            this.getContentPane().add((Component)this.statusBarPanel, "South");
            this.progress.setValue(10);
            this.initMenu();
            this.progress.setValue(13);
            this.initDefaultPanels();
            this.setLookAndFeel();
            this.deployOptions.updateFrameLocation(this);
            this.enableTabs(false);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    DeployFrame.this.exitAction();
                }
            });
            this.progress.setValue(100);
            ((Component)about).setVisible(false);
        }
        catch (Throwable e) {
            e.printStackTrace();
            ((Component)about).setVisible(false);
            System.exit(0);
        }
    }

    private void setPrjHistoryItems(String newItem) {
        int menuLength = this.projectMenu.getItemCount();
        JMenuItem item = null;
        String text = null;
        String tmp = null;
        int i = menuLength - 1;
        while (i > -1) {
            item = this.projectMenu.getItem(i);
            if (item instanceof JMenuItem && (text = item.getText()) != null) {
                int j = 5;
                while (j > 0) {
                    tmp = j + ".";
                    if (text.startsWith(tmp)) {
                        this.projectMenu.remove(i);
                        break;
                    }
                    --j;
                }
            }
            --i;
        }
        tmp = null;
        String prjHistoryStr = this.deployOptions.getProperty("prjHistory");
        if (prjHistoryStr == null) {
            prjHistoryStr = "";
        }
        StringTokenizer tok = new StringTokenizer(prjHistoryStr, ";");
        Vector<String> prjHistory = new Vector<String>();
        while (tok.hasMoreTokens()) {
            tmp = tok.nextToken();
            tmp.replace('\\', File.separatorChar);
            tmp.replace('/', File.separatorChar);
            prjHistory.add(tmp);
        }
        boolean isFounded = false;
        int i2 = 0;
        while (i2 < prjHistory.size()) {
            tmp = (String)prjHistory.elementAt(i2);
            if (tmp.startsWith(newItem)) {
                prjHistory.remove(tmp);
                prjHistory.insertElementAt(tmp, 0);
                isFounded = true;
                break;
            }
            ++i2;
        }
        if (!isFounded && newItem != null && !newItem.equals("")) {
            if (prjHistory.size() == 5) {
                prjHistory.removeElementAt(4);
            }
            prjHistory.insertElementAt(newItem, 0);
        }
        prjHistoryStr = "";
        int insertPos = this.projectMenu.getItemCount() - 2;
        int i3 = 0;
        while (i3 < prjHistory.size()) {
            tmp = (String)prjHistory.elementAt(i3);
            prjHistoryStr = prjHistoryStr.equals("") ? prjHistoryStr + tmp : prjHistoryStr + ";" + tmp;
            item = new JMenuItem(i3 + 1 + "." + tmp.substring(tmp.lastIndexOf(File.separator) + 1));
            this.projectMenu.insert(item, insertPos + i3);
            item.addActionListener(this.prjActionManager);
            item.setActionCommand(tmp);
            item.setMnemonic(49 + i3);
            item.setToolTipText(tmp);
            ++i3;
        }
        this.deployOptions.setProperty("prjHistory", prjHistoryStr);
    }

    protected void initMenu() {
        this.newItem.addActionListener(this.prjActionManager);
        this.newItem.setActionCommand("PRJ_NEW_CMD");
        this.openItem.addActionListener(this.prjActionManager);
        this.openItem.setActionCommand("PRJ_OPEN_CMD");
        this.saveItem.addActionListener(this.prjActionManager);
        this.saveItem.setActionCommand("PRJ_SAVE_CMD");
        this.saveAsItem.addActionListener(this.prjActionManager);
        this.saveAsItem.setActionCommand("PRJ_SAVEAS_CMD");
        this.closeItem.addActionListener(this.prjActionManager);
        this.closeItem.setActionCommand("PRJ_CLOSE_CMD");
        this.quickDeployItem.addActionListener(this.prjActionManager);
        this.quickDeployItem.setActionCommand("PRJ_QUICK_DEPLOY_CMD");
        this.optionsItem.addActionListener(this.prjActionManager);
        this.optionsItem.setActionCommand("PRJ_OPTIONS_CMD");
        this.errorsInProjectItem.addActionListener(this.prjActionManager);
        this.errorsInProjectItem.setActionCommand("PRJ_ERRORS_CMD");
        this.exitItem.addActionListener(this.prjActionManager);
        this.exitItem.setActionCommand("PRJ_EXIT_CMD");
        this.helpItem.addActionListener(this.prjActionManager);
        this.helpItem.setActionCommand("HL_HELP_CMD");
        this.aboutItem.addActionListener(this.prjActionManager);
        this.aboutItem.setActionCommand("HL_ABOUT_CMD");
        this.projectMenu.add(this.newItem);
        this.projectMenu.add(this.openItem);
        this.projectMenu.add(this.saveItem);
        this.projectMenu.add(this.saveAsItem);
        this.projectMenu.add(this.closeItem);
        this.projectMenu.addSeparator();
        this.projectMenu.add(this.optionsItem);
        this.projectMenu.add(this.errorsInProjectItem);
        this.projectMenu.add(this.quickDeployItem);
        this.projectMenu.addSeparator();
        this.projectMenu.addSeparator();
        this.projectMenu.add(this.exitItem);
        this.helpMenu.add(this.helpItem);
        this.helpMenu.add(this.aboutItem);
        this.deployMenuBar.add(this.projectMenu);
        this.aSeparator.setVisible(false);
        this.deployMenuBar.add(this.aSeparator);
        this.deployMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.deployMenuBar);
        this.projectButtons[0] = new JButton();
        this.projectButtons[1] = new JButton();
        this.projectButtons[2] = new JButton();
        this.projectButtons[3] = new JButton();
        this.projectButtons[4] = new JButton();
        this.projectButtons[5] = new JButton();
        this.projectButtons[0].setPreferredSize(new Dimension(24, 24));
        this.projectButtons[1].setPreferredSize(new Dimension(24, 24));
        this.projectButtons[2].setPreferredSize(new Dimension(24, 24));
        this.projectButtons[3].setPreferredSize(new Dimension(24, 24));
        this.projectButtons[4].setPreferredSize(new Dimension(24, 24));
        this.projectButtons[5].setPreferredSize(new Dimension(24, 24));
        this.projectButtons[0].setActionCommand("PRJ_NEW_CMD");
        this.projectButtons[1].setActionCommand("PRJ_OPEN_CMD");
        this.projectButtons[2].setActionCommand("PRJ_SAVE_CMD");
        this.projectButtons[3].setActionCommand("PRJ_CLOSE_CMD");
        this.projectButtons[4].setActionCommand("PRJ_OPTIONS_CMD");
        this.projectButtons[5].setActionCommand("PRJ_QUICK_DEPLOY_CMD");
        this.projectButtons[0].addActionListener(this.prjActionManager);
        this.projectButtons[1].addActionListener(this.prjActionManager);
        this.projectButtons[2].addActionListener(this.prjActionManager);
        this.projectButtons[3].addActionListener(this.prjActionManager);
        this.projectButtons[4].addActionListener(this.prjActionManager);
        this.projectButtons[5].addActionListener(this.prjActionManager);
        this.projectButtons[0].setToolTipText("New");
        this.projectButtons[1].setToolTipText("Open");
        this.projectButtons[2].setToolTipText("Save");
        this.projectButtons[3].setToolTipText("Close");
        this.projectButtons[4].setToolTipText("Options");
        this.projectButtons[5].setToolTipText("Make All");
        this.projectButtons[0].setIcon(new ImageIcon((class$com$sap$engine$deploy$tool$DeployFrame == null ? (class$com$sap$engine$deploy$tool$DeployFrame = DeployFrame.class$("com.sap.engine.deploy.tool.DeployFrame")) : class$com$sap$engine$deploy$tool$DeployFrame).getResource("images/new.gif")));
        this.newItem.setIcon(new ImageIcon((class$com$sap$engine$deploy$tool$DeployFrame == null ? (class$com$sap$engine$deploy$tool$DeployFrame = DeployFrame.class$("com.sap.engine.deploy.tool.DeployFrame")) : class$com$sap$engine$deploy$tool$DeployFrame).getResource("images/new.gif")));
        this.projectButtons[1].setIcon(new ImageIcon((class$com$sap$engine$deploy$tool$DeployFrame == null ? (class$com$sap$engine$deploy$tool$DeployFrame = DeployFrame.class$("com.sap.engine.deploy.tool.DeployFrame")) : class$com$sap$engine$deploy$tool$DeployFrame).getResource("images/open.gif")));
        this.openItem.setIcon(new ImageIcon((class$com$sap$engine$deploy$tool$DeployFrame == null ? (class$com$sap$engine$deploy$tool$DeployFrame = DeployFrame.class$("com.sap.engine.deploy.tool.DeployFrame")) : class$com$sap$engine$deploy$tool$DeployFrame).getResource("images/open.gif")));
        this.projectButtons[2].setIcon(new ImageIcon((class$com$sap$engine$deploy$tool$DeployFrame == null ? (class$com$sap$engine$deploy$tool$DeployFrame = DeployFrame.class$("com.sap.engine.deploy.tool.DeployFrame")) : class$com$sap$engine$deploy$tool$DeployFrame).getResource("images/save.gif")));
        this.saveItem.setIcon(new ImageIcon((class$com$sap$engine$deploy$tool$DeployFrame == null ? (class$com$sap$engine$deploy$tool$DeployFrame = DeployFrame.class$("com.sap.engine.deploy.tool.DeployFrame")) : class$com$sap$engine$deploy$tool$DeployFrame).getResource("images/save.gif")));
        this.projectButtons[3].setIcon(new ImageIcon((class$com$sap$engine$deploy$tool$DeployFrame == null ? (class$com$sap$engine$deploy$tool$DeployFrame = DeployFrame.class$("com.sap.engine.deploy.tool.DeployFrame")) : class$com$sap$engine$deploy$tool$DeployFrame).getResource("images/close.gif")));
        this.closeItem.setIcon(new ImageIcon((class$com$sap$engine$deploy$tool$DeployFrame == null ? (class$com$sap$engine$deploy$tool$DeployFrame = DeployFrame.class$("com.sap.engine.deploy.tool.DeployFrame")) : class$com$sap$engine$deploy$tool$DeployFrame).getResource("images/close.gif")));
        this.projectButtons[4].setIcon(new ImageIcon((class$com$sap$engine$deploy$tool$DeployFrame == null ? (class$com$sap$engine$deploy$tool$DeployFrame = DeployFrame.class$("com.sap.engine.deploy.tool.DeployFrame")) : class$com$sap$engine$deploy$tool$DeployFrame).getResource("images/options.gif")));
        this.optionsItem.setIcon(new ImageIcon((class$com$sap$engine$deploy$tool$DeployFrame == null ? (class$com$sap$engine$deploy$tool$DeployFrame = DeployFrame.class$("com.sap.engine.deploy.tool.DeployFrame")) : class$com$sap$engine$deploy$tool$DeployFrame).getResource("images/options.gif")));
        this.projectButtons[5].setIcon(new ImageIcon((class$com$sap$engine$deploy$tool$DeployFrame == null ? (class$com$sap$engine$deploy$tool$DeployFrame = DeployFrame.class$("com.sap.engine.deploy.tool.DeployFrame")) : class$com$sap$engine$deploy$tool$DeployFrame).getResource("images/makeall.gif")));
        this.quickDeployItem.setIcon(new ImageIcon((class$com$sap$engine$deploy$tool$DeployFrame == null ? (class$com$sap$engine$deploy$tool$DeployFrame = DeployFrame.class$("com.sap.engine.deploy.tool.DeployFrame")) : class$com$sap$engine$deploy$tool$DeployFrame).getResource("images/makeall.gif")));
        this.setToolBarButton(null);
        this.setPrjHistoryItems("");
    }

    public void initDefaultPanels() {
        String tabs = this.deployOptions.getProperty("DefaultTabs");
        Vector<ToolTabPanel> panelsVector = new Vector<ToolTabPanel>();
        if (tabs == null || tabs.equals("")) {
            this.deployOptions.initDefaultProperties();
        }
        StringTokenizer tabsTok = new StringTokenizer(tabs, ";");
        String defaultPanel = new String();
        String nextTok = new String();
        Properties panelProps = new Properties();
        panelProps.setProperty(DeployFrameOptions.REMOTE_P4_PORT, this.deployOptions.getProperty(DeployFrameOptions.REMOTE_P4_PORT));
        panelProps.setProperty(DeployFrameOptions.HTTP_TUNNELING_PORT, this.deployOptions.getProperty(DeployFrameOptions.HTTP_TUNNELING_PORT));
        panelProps.setProperty(DeployFrameOptions.SSL_PORT, this.deployOptions.getProperty(DeployFrameOptions.SSL_PORT));
        panelProps.setProperty(DeployFrameOptions.HTTPS_PORT, this.deployOptions.getProperty(DeployFrameOptions.HTTPS_PORT));
        while (tabsTok.hasMoreTokens()) {
            ToolTabPanel panel;
            nextTok = tabsTok.nextToken();
            try {
                defaultPanel = this.deployOptions.getProperty(nextTok);
                if (defaultPanel != null && defaultPanel.startsWith("com.inqmy.deploy")) {
                    defaultPanel = "com.sap.engine" + defaultPanel.substring(9);
                }
                Class<?> c = Class.forName(defaultPanel);
                panel = (ToolTabPanel)c.newInstance();
                panel.setFrame(this);
                if (panel instanceof MainTabPanel) {
                    ((MainTabPanel)((Object)panel)).setErrorDialog(this.errorDialog);
                    ((MainTabPanel)((Object)panel)).setProgress(this.progress);
                    ((MainTabPanel)((Object)panel)).initAllPanels();
                }
                panel.setProjectProperties(panelProps);
            }
            catch (Exception clex) {
                if (this.notAvailableTab == null) {
                    this.hasMissingTabs = true;
                    this.notAvailableTab = new String(nextTok);
                    continue;
                }
                this.notAvailableTab = this.notAvailableTab + ", " + nextTok;
                continue;
            }
            panelsVector.add(panel);
        }
        Object[] panels = new ToolTabPanel[panelsVector.size()];
        panelsVector.copyInto(panels);
        this.setPanels((ToolTabPanel[])panels);
        this.mainTabPane.setSelectedIndex(0);
    }

    public void setProjectProperties() {
        if (this.projectProperties == null) {
            this.projectProperties = new Properties();
        }
        String availableTabs = this.deployOptions.getProperty("AvailableTabs");
        this.projectProperties.setProperty("AvailableTabs", availableTabs);
        String defaultTabs = this.deployOptions.getProperty("DefaultTabs");
        this.projectProperties.setProperty("DefaultTabs", defaultTabs);
        String browserPath = this.deployOptions.getProperty("BrowserPath");
        if (browserPath != null) {
            this.projectProperties.setProperty("BrowserPath", browserPath);
        }
        this.variables = new Properties();
        Enumeration enum12 = ((Hashtable)this.deployOptions).keys();
        while (enum12.hasMoreElements()) {
            String key2 = (String)enum12.nextElement();
            if (!key2.startsWith("Path_Variable:")) continue;
            this.variables.setProperty(key2, this.deployOptions.getProperty(key2));
            this.projectProperties.setProperty(key2, this.deployOptions.getProperty(key2));
        }
        this.deployOptions.loadAvailableLF(this.projectProperties);
    }

    public ToolTabPanel[] getPanels() {
        int panelCount = this.mainTabPane.getTabCount();
        ToolTabPanel[] panels = new ToolTabPanel[panelCount];
        int i = 0;
        while (i < panelCount) {
            panels[i] = (ToolTabPanel)((Object)this.mainTabPane.getComponentAt(i));
            ++i;
        }
        return panels;
    }

    public DeployFrameOptions getOptions() {
        return this.deployOptions;
    }

    public Properties getProjectProperties() {
        return this.projectProperties;
    }

    public boolean closeCurrentProject() {
        ToolTabPanel[] panels1 = this.getPanels();
        boolean needSave = false;
        if (!this.needSaveing) {
            int i = 0;
            while (i < panels1.length) {
                if (panels1[i].needSave()) {
                    needSave = true;
                    break;
                }
                ++i;
            }
        } else {
            needSave = true;
        }
        if (this.projectFileName != null || this.skipSaveingAsk) {
            if (needSave && !this.skipSaveingAsk) {
                int option = 0;
                if (this.withoutCancel) {
                    option = this.newProject ? JOptionPane.showOptionDialog(this, "This poject never was saved! Choose one from following options :\n \"Save\" -  this option will save the project.\n \"Delete\"- this option will delete .dlp file and the whole project directory. \n \"Remove files\" - this  option  will  delete  .dlp  file, log files and all project\n   and alternative xmls. Generated archives and all other information in  \n   project directory won't be deleted.", "WARNING", 0, 2, null, new String[]{"Save", "Delete", "Remove files"}, "Save project") : JOptionPane.showConfirmDialog(this, "Save current project?", "Project close", 0);
                } else if (this.newProject ? (option = JOptionPane.showOptionDialog(this, "This poject never was saved! Choose one from following options :\n \"Save\" -  this option will save the project.\n \"Delete\" - this option will delete .dlp file and the whole working directory. \n \"Remove files\" - this  option  will  delete  .dlp  file, log files and all project\n   and alternative xmls. Generated archives and all other information in  \n   project directory won't be deleted.", "WARNING", 1, 2, null, new String[]{"Save", "Delete", "Remove files", "Cancel"}, "Save project")) == 3 : (option = JOptionPane.showConfirmDialog(this, "Save current project?", "Project close", 1)) == 2) {
                    return false;
                }
                if (option == 0) {
                    this.storeProject(this.projectFileName);
                } else if (option == 1) {
                    if (this.newProject) {
                        this.deleteGeneratedFiles(true);
                    }
                } else if (option == 2) {
                    this.deleteGeneratedFiles(false);
                }
                this.newProject = false;
            }
            ToolTabPanel[] panels = this.getPanels();
            int i = 0;
            while (i < panels.length) {
                panels[i].clearOnProjectClose();
                ++i;
            }
            this.mainTabPane.setSelectedIndex(0);
            this.setAdditionalMenu(null);
            this.setToolBarButton(null);
            this.projectFileName = null;
            this.enableTabs(false);
            this.refreshTabs(false);
            this.setTitle(this.frameName);
            this.projectProperties = new Properties();
            this.setProjectProperties();
        }
        this.needSaveing = false;
        this.oldProject = false;
        return true;
    }

    public void newProject() {
        if (this.projectFileName != null) {
            int option = -1;
            if (this.newProject) {
                option = JOptionPane.showOptionDialog(this, "Current poject never was saved! Choose one from following options :\n \"Save\" -  this option will save the project.\n \"Delete\" - this option will delete .dlp file and the whole working directory. \n \"Remove files\" - this  option  will  delete  .dlp  file, log files and all project\n   and alternative xmls. Generated archives and all other information in  \n   project directory won't be deleted.", "New project", 1, 2, null, new String[]{"Save", "Delete", "Remove files", "Cancel"}, "Save project");
            } else {
                option = JOptionPane.showConfirmDialog(this, "Save current project?", "New project", 1);
                if (option == 2) {
                    return;
                }
            }
            if (option == 3) {
                return;
            }
            if (option == 0) {
                this.storeProject(this.projectFileName);
            } else if (option == 1) {
                if (this.newProject) {
                    this.deleteGeneratedFiles(true);
                }
            } else if (option == 2) {
                this.deleteGeneratedFiles(false);
            }
            this.projectFileName = null;
            this.newProject = false;
            this.newProject();
        } else {
            File f;
            if (this.newChooser == null) {
                this.newChooser = SFileChooser.getInstance(this);
                LookAndFeelHandler.add(this.newChooser);
            }
            if (this.projectProperties != null) {
                ((Hashtable)this.projectProperties).remove("Classpath");
            }
            this.newChooser.setFilters(new String[]{".dlp"});
            String tempPrDir = null;
            if (this.projDir != null) {
                tempPrDir = this.projDir.getAbsolutePath();
            }
            this.newChooser.setProjectDir(tempPrDir);
            this.newChooser.setFilters(new String[]{".dlp"});
            String[] fileName = this.newChooser.showFileDialog("New Project", false, false, true);
            if (fileName == null || fileName[0] == null || fileName[0].trim().equals("")) {
                this.skipSaveingAsk = true;
                this.projectFileName = "";
                this.closeCurrentProject();
                this.skipSaveingAsk = false;
                return;
            }
            if (!fileName[0].endsWith(".dlp")) {
                String ffName = new File(fileName[0]).getName();
                if (ffName.indexOf(".") != -1 && !ffName.endsWith(".")) {
                    JOptionPane.showMessageDialog(this, " Wrong file extension. Select valid file name!", "Warning", 2);
                    this.skipSaveingAsk = true;
                    this.projectFileName = "";
                    this.closeCurrentProject();
                    this.skipSaveingAsk = false;
                    return;
                }
                if (ffName.endsWith(".")) {
                    fileName[0] = fileName[0].substring(0, fileName[0].length() - 1);
                }
                fileName[0] = fileName[0] + ".dlp";
            }
            if ((f = new File(fileName[0])).exists()) {
                int option = JOptionPane.showConfirmDialog(this, "This project already exists. Do you want to replace it?\nReplacing will delete the old project!", "Exisiting Project", 1);
                if (option == 1) {
                    String new_name = "";
                    boolean isCorrectFile = false;
                    while (new_name.trim().equals(SystemProperties.getProperty("user.dir") + File.separator + ".dlp") || fileName[0].equals(new_name.trim()) || !isCorrectFile) {
                        new_name = JOptionPane.showInputDialog(this, (Object)"Enter new name for the project:");
                        if (new_name == null) {
                            this.skipSaveingAsk = true;
                            this.projectFileName = "";
                            this.closeCurrentProject();
                            this.skipSaveingAsk = false;
                            return;
                        }
                        if (!new_name.endsWith(".dlp")) {
                            new_name = new_name + ".dlp";
                        }
                        File testForAbsolute = new File(new_name);
                        if (new_name.indexOf(File.separator) == -1) {
                            new_name = this.projectFileName = SystemProperties.getProperty("user.dir") + File.separator + new_name;
                            isCorrectFile = true;
                            continue;
                        }
                        isCorrectFile = testForAbsolute.getParentFile().exists();
                    }
                    f = new File(this.projectFileName);
                    this.newProject = true;
                }
                if (option == 0) {
                    this.projectFileName = fileName[0];
                }
                if (option == 2) {
                    return;
                }
                if (!this.projectFileName.endsWith(".dlp")) {
                    this.projectFileName = this.projectFileName + ".dlp";
                }
            } else {
                this.projectFileName = fileName[0];
                if (!this.projectFileName.endsWith(".dlp")) {
                    this.projectFileName = this.projectFileName + ".dlp";
                }
            }
            this.newProject = true;
            this.dlpDirectory = f.getParent();
            this.newChooser.setProjectDir(this.dlpDirectory);
            this.dlpFileDirectory = new File(this.dlpDirectory);
            String tempName = null;
            tempName = this.projectFileName.lastIndexOf(File.separator) == -1 ? this.projectFileName : this.projectFileName.substring(this.projectFileName.lastIndexOf(File.separator), this.projectFileName.lastIndexOf("."));
            this.projDir = new File(f.getParent(), tempName);
            if (this.projDir.exists() && this.projDir.isFile()) {
                JOptionPane.showMessageDialog(this, " Project directory: " + this.projDir.getAbsolutePath() + " could not be created. \n" + " A file with the name you specified already exists. \n" + " Specify different file name or replace file!", "Error", 0);
                this.skipSaveingAsk = true;
                this.projectFileName = "";
                this.closeCurrentProject();
                this.skipSaveingAsk = false;
                return;
            }
            if (this.projDir.exists() && this.projDir.isDirectory()) {
                File xmlFile = null;
                String[] xmls = new String[]{"components.xml", "assembler_xml.xml", "Deployer.xml", "ServerComponents.xml"};
                int i = 0;
                while (i < xmls.length) {
                    xmlFile = new File(this.projDir, xmls[i]);
                    if (xmlFile.exists()) {
                        xmlFile.delete();
                    }
                    ++i;
                }
            }
            this.projDir.mkdirs();
            this.projectFileName = this.projDir.getParent().endsWith(File.separator) && f.getName().startsWith(File.separator) ? this.projDir.getParent() + f.getName().substring(1) : (!this.projDir.getParent().endsWith(File.separator) && !f.getName().startsWith(File.separator) ? this.projDir.getParent() + File.separator + f.getName() : this.projDir.getParent() + f.getName());
            if (!this.projectFileName.endsWith(".dlp")) {
                this.projectFileName = this.projectFileName + ".dlp";
            }
            this.enableTabs(true);
            this.refreshTabs(true);
            ToolTabPanel[] panels = this.getPanels();
            int i = 0;
            while (i < panels.length) {
                panels[i].clearOnProjectClose();
                panels[i].newProjectCreated();
                ++i;
            }
            this.setTitle(this.frameName + " - " + this.projectFileName);
        }
        this.needSaveing = true;
    }

    public void saveAsProject() {
        int option;
        File newDlpFile;
        File parDlpDir;
        String newName;
        File newPrjDir;
        if (this.newChooser == null) {
            this.newChooser = SFileChooser.getInstance(this);
            LookAndFeelHandler.add(this.newChooser);
        }
        this.newChooser.setFilters(new String[]{".dlp"});
        String[] fileName = this.newChooser.showFileDialog("SaveAs", true, false, true);
        if (fileName == null || fileName[0] == null) {
            return;
        }
        if (!fileName[0].endsWith(".dlp")) {
            fileName[0] = fileName[0] + ".dlp";
        }
        if ((newPrjDir = new File((newName = (parDlpDir = (newDlpFile = new File(fileName[0])).getParentFile()).getAbsolutePath() + File.separator + newDlpFile.getName()).substring(0, newName.length() - 4))).getAbsolutePath().indexOf(this.projDir.getAbsolutePath()) == 0) {
            JOptionPane.showMessageDialog(this, "You can not move project in current project directory.", "Information", 1);
            return;
        }
        if (newDlpFile.exists() && (option = JOptionPane.showConfirmDialog(this, "The file " + newDlpFile.getAbsolutePath() + " already exists!" + "Do you want to replace it?", "Warning", 0)) != 0) {
            return;
        }
        try {
            if (newPrjDir.exists() && newPrjDir.isDirectory()) {
                option = JOptionPane.showConfirmDialog(this, "The directory " + newPrjDir.getAbsolutePath() + " already exists!" + "Do you want to replace it and continue?", "Warning", 0);
                if (option == 0) {
                    if (newPrjDir.isDirectory()) {
                        FileUtils.deleteDirectory(newPrjDir);
                    } else {
                        newPrjDir.delete();
                    }
                } else {
                    return;
                }
            }
            newPrjDir.mkdirs();
            FileUtils.copyDirectory(this.projDir, newPrjDir);
        }
        catch (IOException ioex) {
            JOptionPane.showMessageDialog(this, "Error", "Error occurred during moving project directory.", 0);
            return;
        }
        this.projDir = newPrjDir;
        this.setTitle(this.frameName + " - " + fileName[0]);
        this.dlpFileDirectory = parDlpDir;
        this.dlpDirectory = this.dlpFileDirectory.getAbsolutePath();
        ToolTabPanel[] panels = this.getPanels();
        if (panels != null) {
            int j = 0;
            while (j < panels.length) {
                panels[j].setProjectDir(this.projDir, this.dlpFileDirectory);
                panels[j].clearOnSaveAs();
                ++j;
            }
        }
        this.projectFileName = fileName[0];
        this.storeProject(fileName[0]);
        this.needSaveing = false;
    }

    public void storeProject() {
        this.storeProject(this.projectFileName);
    }

    public void storeProject(String projectName) {
        ToolTabPanel[] panels = this.getPanels();
        String[] fileLocation = new String[panels.length];
        String[] tabName = new String[panels.length];
        if (!this.oldProject) {
            this.projDir.mkdirs();
        }
        try {
            int i = 0;
            while (i < panels.length) {
                try {
                    panels[i].saveXMLOnProjectSave();
                    if (panels[i] instanceof DeployTab) {
                        boolean state = ((DeployTab)panels[i]).isVerifying();
                        if (state) {
                            this.deployOptions.setProperty("CheckApplicationExistence", "true");
                        } else {
                            this.deployOptions.setProperty("CheckApplicationExistence", "false");
                        }
                    }
                    fileLocation[i] = !this.oldProject ? panels[i].getXMLRelativeLocation() : panels[i].getXMLFileLocation();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                tabName[i] = panels[i].getTabName();
                ++i;
            }
            this.projectDocument.loadTabs(fileLocation, tabName);
            if (this.projectProperties == null) {
                this.setProjectProperties();
            }
            this.projectDocument.loadOptions(ApplicationInformationProvider.parseClassPathToRelative(this.projectProperties.getProperty("Classpath"), ApplicationInformationProvider.removePrefixPath_Variable(this.variables)), null);
            this.projectDocument.writeProjectToXML(projectName);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            JOptionPane.showMessageDialog(this, "Could not save project because of " + exc.toString(), "Error", 2);
            return;
        }
        this.deployOptions.setTabs(this.projectProperties);
        if (this.newChooser != null) {
            this.deployOptions.setProperty("Favourites", this.newChooser.getFavourites());
        }
        this.deployOptions.saveProperties();
        this.needSaveing = false;
        this.newProject = false;
        this.setPrjHistoryItems(projectName);
    }

    public void openProject() {
        if (this.newChooser == null) {
            this.newChooser = SFileChooser.getInstance(this);
            LookAndFeelHandler.add(this.newChooser);
        }
        String tempPrDir = null;
        if (this.projDir != null) {
            tempPrDir = this.projDir.getAbsolutePath();
        }
        this.newChooser.setProjectDir(tempPrDir);
        this.newChooser.setFilters(new String[]{".dlp"});
        String[] fileName = this.newChooser.showFileDialog("Open Project", false, false, false);
        if (fileName == null) {
            return;
        }
        this.withoutCancel = true;
        if (this.projectFileName != null && !this.closeCurrentProject()) {
            this.withoutCancel = false;
            return;
        }
        this.withoutCancel = false;
        File testFile = new File(fileName[0]);
        if (!testFile.exists() || !testFile.isFile()) {
            JOptionPane.showMessageDialog(this, "File does not exists", "Warning", 2);
            return;
        }
        if (this.projectFileName != null) {
            this.closeCurrentProject();
        }
        this.enableTabs(true);
        this.refreshTabs(true);
        this.openProject(fileName[0]);
    }

    public void openProject(String projectName) {
        this.enableTabs(true);
        this.refreshTabs(true);
        boolean closeLastProject = false;
        if (this.projectFileName != null) {
            if (!this.closeCurrentProject()) {
                this.withoutCancel = false;
                return;
            }
            closeLastProject = true;
        }
        try {
            this.projectDocument.readXMLPrjFile(projectName);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Could not open project " + projectName + " because \n" + e.getMessage(), "Error during opening project", 0);
            if (!closeLastProject) {
                this.mainTabPane.setSelectedIndex(0);
                this.setAdditionalMenu(null);
                this.setToolBarButton(null);
                this.projectFileName = null;
                this.enableTabs(false);
                this.refreshTabs(false);
                this.setTitle(this.frameName);
                this.projectProperties = new Properties();
                this.setProjectProperties();
                this.validate();
                this.repaint();
                this.removePrjFromHistory(projectName);
            }
            return;
        }
        String[] tabsXMLLocations = this.projectDocument.getXMLLocationsTabs();
        String[] tabNames = this.projectDocument.getTabsNames();
        this.projectFileName = projectName;
        this.setTitle(this.frameName + " - " + this.projectFileName);
        if (this.projectProperties == null) {
            this.setProjectProperties();
        }
        this.projectProperties.setProperty("Classpath", ApplicationInformationProvider.parseClassPathToAbsolute(this.projectDocument.getClassPath(), ApplicationInformationProvider.removePrefixPath_Variable(this.variables)));
        this.projectProperties.setProperty("TabTransfer", this.projectDocument.getTabTransfer());
        File f = new File(projectName);
        if (tabsXMLLocations != null && tabsXMLLocations[0] != null) {
            File f01 = new File(tabsXMLLocations[0]);
            this.oldProject = f01.exists() && f01.isFile();
        }
        this.projDir = !this.oldProject ? new File(f.getParent() + f.getAbsolutePath().substring(f.getAbsolutePath().lastIndexOf(File.separator), f.getAbsolutePath().lastIndexOf("."))) : new File(f.getParent());
        this.dlpDirectory = f.getParent();
        if (this.newChooser == null) {
            this.newChooser = SFileChooser.getInstance(this);
            LookAndFeelHandler.add(this.newChooser);
        }
        this.newChooser.setProjectDir(this.dlpDirectory);
        this.dlpFileDirectory = new File(this.dlpDirectory);
        ToolTabPanel[] panels = this.getPanels();
        String exc = "";
        String classPaths = this.projectProperties.getProperty("Classpath");
        int tokLen = 0;
        StringTokenizer toks = null;
        if (classPaths != null) {
            toks = new StringTokenizer(classPaths, ";");
            tokLen = toks.countTokens();
        }
        String[] paths = new String[tokLen];
        int i = 0;
        while (i < tokLen) {
            paths[i] = toks.nextToken();
            ++i;
        }
        int j = 0;
        while (j < panels.length) {
            panels[j].setProjectDir(this.projDir, this.dlpFileDirectory);
            panels[j].setAdditionalClasspath(null);
            panels[j].setAdditionalClasspath(paths);
            ++j;
        }
        if (tabsXMLLocations == null || tabNames == null) {
            this.enableTabs(true);
            this.refreshTabs(true);
            this.setPrjHistoryItems(projectName);
            return;
        }
        int i2 = 0;
        while (i2 < tabsXMLLocations.length) {
            int j2 = 0;
            while (j2 < panels.length) {
                if (panels[j2].getTabName().equals(tabNames[i2]) && (tabsXMLLocations[i2] != null || !tabsXMLLocations[i2].trim().equals(""))) {
                    try {
                        File f00 = new File(tabsXMLLocations[i2]);
                        if (f00.isAbsolute()) {
                            if (tabsXMLLocations[i2].startsWith(File.separator)) {
                                File f01 = new File(this.dlpDirectory, tabsXMLLocations[i2]);
                                if (f01.exists()) {
                                    panels[j2].initOnProjectOpen(f01.getAbsolutePath(), paths);
                                    this.oldProject = true;
                                } else {
                                    panels[j2].initOnProjectOpen(tabsXMLLocations[i2], paths);
                                    this.oldProject = false;
                                }
                            } else {
                                panels[j2].initOnProjectOpen(tabsXMLLocations[i2], paths);
                                this.oldProject = true;
                            }
                        } else {
                            panels[j2].initOnProjectOpen(this.dlpDirectory + tabsXMLLocations[i2], paths);
                            this.oldProject = false;
                        }
                        if (panels[j2] instanceof DeployTab) {
                            String state = this.deployOptions.getProperty("CheckApplicationExistence");
                            if (state != null) {
                                if (state.trim().equals("true")) {
                                    ((DeployTab)panels[j2]).setVerifyApplication(true);
                                } else {
                                    ((DeployTab)panels[j2]).setVerifyApplication(false);
                                }
                            } else {
                                ((DeployTab)panels[j2]).setVerifyApplication(true);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        exc = exc + e.toString() + "\n";
                    }
                }
                ++j2;
            }
            ++i2;
        }
        this.setPrjHistoryItems(projectName);
        this.enableTabs(true);
        this.refreshTabs(true);
        if (!exc.trim().equals("")) {
            JOptionPane.showMessageDialog(this, "Error occurred while trying to open project and read all xmls : \n" + exc.toString(), "Error during opening project", 0);
        }
    }

    private void removePrjFromHistory(String prjName) {
        int menuLength = this.projectMenu.getItemCount();
        JMenuItem item = null;
        String text = null;
        String tmp = null;
        int i = menuLength - 1;
        while (i > -1) {
            item = this.projectMenu.getItem(i);
            if (item instanceof JMenuItem && (text = item.getText()) != null) {
                int j = 5;
                while (j > 0) {
                    tmp = j + ".";
                    if (text.startsWith(tmp)) {
                        this.projectMenu.remove(i);
                        break;
                    }
                    --j;
                }
            }
            --i;
        }
        tmp = null;
        String prjHistoryStr = this.deployOptions.getProperty("prjHistory");
        if (prjHistoryStr == null) {
            prjHistoryStr = "";
        }
        StringTokenizer tok = new StringTokenizer(prjHistoryStr, ";");
        Vector<String> prjHistory = new Vector<String>();
        while (tok.hasMoreTokens()) {
            tmp = tok.nextToken();
            tmp.replace('\\', File.separatorChar);
            tmp.replace('/', File.separatorChar);
            if (tmp.startsWith(prjName)) continue;
            prjHistory.add(tmp);
        }
        prjHistoryStr = "";
        int insertPos = this.projectMenu.getItemCount() - 2;
        int i2 = 0;
        while (i2 < prjHistory.size()) {
            tmp = (String)prjHistory.elementAt(i2);
            prjHistoryStr = prjHistoryStr.equals("") ? prjHistoryStr + tmp : prjHistoryStr + ";" + tmp;
            item = new JMenuItem(i2 + 1 + "." + tmp.substring(tmp.lastIndexOf(File.separator) + 1));
            this.projectMenu.insert(item, insertPos + i2);
            item.addActionListener(this.prjActionManager);
            item.setActionCommand(tmp);
            item.setMnemonic(49 + i2);
            item.setToolTipText(tmp);
            ++i2;
        }
        this.deployOptions.setProperty("prjHistory", prjHistoryStr);
    }

    public void exitAction() {
        if (this.projectFileName != null) {
            ToolTabPanel[] panels1 = this.getPanels();
            boolean needSave = false;
            if (!this.needSaveing) {
                int i = 0;
                while (i < panels1.length) {
                    if (panels1[i].needSave()) {
                        needSave = true;
                        break;
                    }
                    ++i;
                }
            } else {
                needSave = true;
            }
            if (needSave) {
                int option = JOptionPane.showConfirmDialog(this, "Save current project", "Project close", 0);
                if (option == 1) {
                    ToolTabPanel[] panels = this.getPanels();
                    int i = 0;
                    while (i < panels.length) {
                        panels[i].clearOnProjectClose();
                        ++i;
                    }
                } else if (option == 0) {
                    this.storeProject(this.projectFileName);
                    ToolTabPanel[] panels = this.getPanels();
                    int i = 0;
                    while (i < panels.length) {
                        panels[i].clearOnProjectClose();
                        ++i;
                    }
                    this.projectFileName = null;
                } else if (option == 2) {
                    return;
                }
            }
        } else {
            ToolTabPanel[] panels = this.getPanels();
            int i = 0;
            while (i < panels.length) {
                panels[i].clearOnProjectClose();
                ++i;
            }
        }
        this.deployOptions.setFrameProperties(this);
        if (this.newChooser != null) {
            this.deployOptions.setProperty("Favourites", this.newChooser.getFavourites());
        }
        this.deployOptions.saveProperties();
        System.exit(0);
    }

    public void setPanels(ToolTabPanel[] panels) {
        if (panels == null || panels.length == 0) {
            return;
        }
        this.mainTabPane.removeAll();
        int i = 0;
        while (i < panels.length) {
            LookAndFeelHandler.add((JPanel)((Object)panels[i]));
            panels[i].setStatusBar(this.statusLabel);
            panels[i].setProjectDir(this.projDir, this.dlpFileDirectory);
            panels[i].setProgressBar(this.progressBar);
            this.mainTabPane.add(panels[i].getTabName(), (JPanel)((Object)panels[i]));
            ++i;
        }
        this.mainTabPane.updateUI();
    }

    public void setLookAndFeel() {
        this.setLookAndFeel(this.deployOptions.getLookAndFeel(), true);
    }

    public boolean setLookAndFeel(String choseLookFeel, boolean isMessage) {
        try {
            this.deployOptions.getLookAndFeelFactory().installLookAndFeel(choseLookFeel);
            LookAndFeelHandler.fireLookAndFeelChanged();
            this.deployOptions.setLookAndFeel(choseLookFeel);
        }
        catch (Exception ex) {
            if (isMessage) {
                JOptionPane.showMessageDialog(this, "This Look and Feel is not available on your system.", "Error", 2);
            }
            return false;
        }
        return true;
    }

    public void setToolBarButton(ToolTabPanel panel) {
        int i;
        this.deployToolBar.removeAll();
        if (panel == null || panel.getToolBarButtons() == null) {
            if (this.projectButtons != null) {
                int i2 = 0;
                while (i2 < this.projectButtons.length) {
                    if (i2 == this.projectButtons.length - 2) {
                        this.deployToolBar.add(new CToolBarSeparator());
                    }
                    if (this.projectButtons[i2] != null) {
                        this.deployToolBar.add(this.projectButtons[i2]);
                    } else {
                        this.deployToolBar.addSeparator();
                    }
                    ++i2;
                }
                this.deployToolBar.repaint();
            }
            return;
        }
        JButton[] buttons = panel.getToolBarButtons();
        this.deployToolBar.removeAll();
        if (this.projectButtons != null) {
            i = 0;
            while (i < this.projectButtons.length) {
                if (i == this.projectButtons.length - 2) {
                    this.deployToolBar.add(new CToolBarSeparator());
                }
                if (this.projectButtons[i] != null) {
                    this.deployToolBar.add(this.projectButtons[i]);
                } else {
                    this.deployToolBar.addSeparator();
                }
                ++i;
            }
            this.deployToolBar.repaint();
        }
        this.deployToolBar.addSeparator();
        if (buttons != null) {
            i = 0;
            while (i < buttons.length) {
                if (buttons[i] != null) {
                    buttons[i].updateUI();
                    this.deployToolBar.add(buttons[i]);
                } else {
                    this.deployToolBar.add(new CToolBarSeparator());
                }
                ++i;
            }
            this.deployToolBar.repaint();
        }
    }

    public void setAdditionalMenu(ToolTabPanel panel) {
        if (panel == null || panel.getContentMenu() == null) {
            if (this.additionalMenu != null) {
                this.additionalMenu = null;
            } else {
                return;
            }
        }
        if (panel != null) {
            this.additionalMenu = panel.getContentMenu();
            LookAndFeelHandler.add(this.additionalMenu);
        }
        this.deployMenuBar.removeAll();
        this.deployMenuBar.add(this.projectMenu);
        if (this.additionalMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.additionalMenu);
            this.deployMenuBar.add(this.additionalMenu);
        }
        this.deployMenuBar.add(this.aSeparator);
        this.deployMenuBar.add(this.helpMenu);
        this.deployMenuBar.validate();
        this.deployMenuBar.repaint();
    }

    private void refreshTabs(boolean flag) {
        if (flag) {
            ToolTabPanel panel = (ToolTabPanel)((Object)this.mainTabPane.getSelectedComponent());
            this.setAdditionalMenu(panel);
            this.setToolBarButton(panel);
            if (this.prjActionManager.lastSelectedPanel == null) {
                this.prjActionManager.lastSelectedPanel = panel;
            }
        } else {
            this.setAdditionalMenu(null);
            this.setToolBarButton(null);
            this.prjActionManager.lastSelectedPanel = null;
        }
    }

    public JTabbedPane getTabPane() {
        return this.mainTabPane;
    }

    public JToolBar getToolBar() {
        return this.deployToolBar;
    }

    public void enableTabs(boolean enable) {
        int tab_count = this.mainTabPane.getTabCount();
        if (!enable) {
            this.projDir = null;
        }
        int i = 0;
        while (i < tab_count) {
            this.mainTabPane.setEnabledAt(i, enable);
            ((ToolTabPanel)((Object)this.mainTabPane.getComponentAt(i))).setProjectDir(this.projDir, this.dlpFileDirectory);
            ++i;
        }
        this.projectButtons[2].setEnabled(enable);
        this.projectButtons[3].setEnabled(enable);
        this.projectButtons[5].setEnabled(enable);
        this.closeItem.setEnabled(enable);
        this.saveItem.setEnabled(enable);
        this.saveAsItem.setEnabled(enable);
        this.quickDeployItem.setEnabled(enable);
    }

    public String getProjectFileName() {
        return this.projectFileName;
    }

    public File getProjectDir() {
        return this.projDir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void quickDeploy() {
        int option;
        if (this.projectFileName == null || !new File(this.projectFileName).exists()) {
            option = JOptionPane.showConfirmDialog(this, "Current project have never been saved. Would you like to save the project?", "Make All", 0);
            if (option != 0) return;
            this.storeProject(this.projectFileName);
        } else {
            option = JOptionPane.showConfirmDialog(this, "Save current project before proceeding?", "Make All", 0);
            if (option == 0) {
                this.storeProject(this.projectFileName);
            }
        }
        QuickDeploy qD = new QuickDeploy(this, this.projectFileName);
        MakeAllStatusWindow mAll = new MakeAllStatusWindow((Frame)this, qD);
        Thread makeAllThread = new Thread((Runnable)mAll, "makeALL");
        makeAllThread.start();
    }

    private static void ebcdicConvert(String[] args) {
        String platform = SystemProperties.getProperty("platform.notASCII");
        if (platform != null && platform.equalsIgnoreCase("false")) {
            System.setErr(System.out);
            String ASCII = "ISO8859_1";
            String EBCDIC = "Cp1047";
            try {
                int i = 0;
                while (i < args.length) {
                    args[i] = new String(args[i].getBytes(ASCII), EBCDIC);
                    ++i;
                }
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    public static void main(String[] args) {
        DeployFrame.updateClassPath();
        DeployFrame.ebcdicConvert(args);
        DeployFrame clientMainFrame = null;
        if (args.length > 0) {
            clientMainFrame = new DeployFrame("Deploy Tool");
            clientMainFrame.openProject(args[0]);
        } else {
            clientMainFrame = new DeployFrame("Deploy Tool");
        }
        SFileChooser.getInstance(clientMainFrame);
        SystemProperties.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl");
        SystemProperties.setProperty("javax.xml.transform.TransformerFactory", "com.sap.engine.lib.jaxp.TransformerFactoryImpl");
        clientMainFrame.show();
    }

    public void showOptionsDialog() {
        if (this.projectProperties == null) {
            this.setProjectProperties();
        }
        ToolTabPanel[] panels = this.getPanels();
        Vector<Object> pathsV = new Vector<Object>();
        Object[] panelsPaths = null;
        if (panels != null) {
            int i = 0;
            while (i < panels.length) {
                panelsPaths = panels[i].getAdditionalClassPaths();
                if (panelsPaths != null) {
                    int j = 0;
                    while (j < panelsPaths.length) {
                        pathsV.add(panelsPaths[j]);
                        ++j;
                    }
                }
                ++i;
            }
            if (pathsV.size() > 0) {
                panelsPaths = new String[pathsV.size()];
                pathsV.copyInto(panelsPaths);
                this.refreshClassPaths((String[])panelsPaths);
            }
        }
        if (this.projectProperties.getProperty("AvailableTabs") == null || this.projectProperties.getProperty("AvailableTabs").trim().equals("")) {
            this.deployOptions.initDefaultProperties();
            this.setProjectProperties();
        }
        this.optionsDialog = new ProjectOptionsDialog(this, this.projectProperties);
        String defTabs = this.projectProperties.getProperty("DefaultTabs");
        String oldLF = this.optionsDialog.getLookAndFeelName();
        String oldClasspath = this.projectProperties.getProperty("Classpath");
        this.optionsDialog.setLocationRelativeTo(this);
        this.optionsDialog.initOK();
        this.optionsDialog.setVariables(this.variables);
        ((Component)this.optionsDialog).setVisible(true);
        if (!this.optionsDialog.getOK()) {
            return;
        }
        this.variables = this.optionsDialog.getVariables();
        this.removeDeadViriables(this.variables);
        this.projectProperties.setProperty("Classpath", ApplicationInformationProvider.parseClassPathToAbsolute(this.projectProperties.getProperty("Classpath"), ApplicationInformationProvider.removePrefixPath_Variable(this.variables)));
        String classPaths = this.projectProperties.getProperty("Classpath");
        if (oldClasspath != null && !oldClasspath.equals(classPaths)) {
            this.needSaveing = true;
        }
        if (classPaths != null) {
            Object[] paths = ApplicationInformationProvider.tokenizerToArray(classPaths, File.pathSeparator);
            int i = 0;
            while (i < panels.length) {
                if (!EqualUtils.equalOrderedArrays(panels[i].getAdditionalClassPaths(), paths)) {
                    panels[i].setAdditionalClasspath(null);
                }
                panels[i].setAdditionalClasspath((String[])paths);
                ++i;
            }
        }
        if (this.projectProperties.getProperty("BrowserPath") != null) {
            this.deployOptions.setBrowserPath(this.projectProperties.getProperty("BrowserPath"));
        }
        this.deployOptions.putAvailableLF(this.projectProperties);
        String lf = this.optionsDialog.getLookAndFeelName();
        if (!oldLF.equals(lf)) {
            this.setLookAndFeel(lf, true);
        }
        Properties varProps = this.optionsDialog.getVariables();
        Enumeration enum1 = ((Hashtable)varProps).keys();
        while (enum1.hasMoreElements()) {
            String key = (String)enum1.nextElement();
            if (!key.startsWith("Path_Variable:")) continue;
            this.deployOptions.setProperty(key, varProps.getProperty(key));
        }
        if (this.projectFileName == null) {
            this.deployOptions.setTabs(this.projectProperties);
            this.refreshPanels();
            this.validate();
            this.repaint();
            return;
        }
        if (!defTabs.endsWith(";")) {
            defTabs = defTabs + ";";
        }
        if (defTabs != null && !defTabs.equals(this.projectProperties.getProperty("DefaultTabs"))) {
            int option = JOptionPane.showConfirmDialog(this, "You changed the selected tabs. This will cause changes in project information! Do you want to continue?", "Warning!", 0, 2);
            if (option == 0) {
                this.deployOptions.setTabs(this.projectProperties);
                this.refreshPanels();
                this.validate();
                this.repaint();
            } else {
                this.projectProperties.setProperty("DefaultTabs", defTabs);
            }
        }
    }

    public void refreshPanels() {
        StringTokenizer tok = new StringTokenizer(this.deployOptions.getProperty("AvailableTabs"), ";");
        int count = tok.countTokens();
        String[] availableTabs = new String[count];
        int i = 0;
        while (i < count) {
            availableTabs[i] = tok.nextToken();
            ++i;
        }
        tok = new StringTokenizer(this.deployOptions.getProperty("DefaultTabs"), ";");
        count = tok.countTokens();
        String[] defaultTabs = new String[count];
        int i2 = 0;
        while (i2 < count) {
            defaultTabs[i2] = tok.nextToken().trim();
            ++i2;
        }
        ToolTabPanel[] panels = new ToolTabPanel[defaultTabs.length];
        ToolTabPanel panel = null;
        int tabCount = this.mainTabPane.getTabCount();
        String addPanel = null;
        Class<?> c = null;
        int i3 = 0;
        while (i3 < defaultTabs.length) {
            boolean exists = false;
            int j = 0;
            while (j < tabCount) {
                if (defaultTabs[i3].equals(this.mainTabPane.getTitleAt(j).trim())) {
                    exists = true;
                    panel = (ToolTabPanel)((Object)this.mainTabPane.getComponentAt(j));
                }
                ++j;
            }
            if (exists) {
                panels[i3] = panel;
            } else {
                try {
                    addPanel = this.deployOptions.getProperty(defaultTabs[i3]);
                    c = Class.forName(addPanel);
                    panel = (ToolTabPanel)c.newInstance();
                    panel.setFrame(this);
                    panel.setProjectProperties(this.projectProperties);
                    if (panel instanceof MainTabPanel) {
                        ((MainTabPanel)((Object)panel)).initAllPanels();
                    }
                }
                catch (Exception refreshex) {
                    refreshex.printStackTrace();
                }
                panels[i3] = panel;
            }
            ++i3;
        }
        this.setPanels(panels);
        if (this.mainTabPane.getComponentAt(0) != null) {
            this.mainTabPane.setSelectedIndex(0);
        }
        if (this.projectFileName == null) {
            this.enableTabs(false);
        }
    }

    public void tabTransfer(ToolTabPanel lastPanel) {
        String[] receiverTabNames = lastPanel.hasResults();
        if (receiverTabNames == null) {
            return;
        }
        ToolTabPanel[] transPanels = this.getPanels();
        Object[] transferObjects = null;
        int i = 0;
        while (i < transPanels.length) {
            if (transPanels[i] != null && transPanels[i] != lastPanel) {
                int j = 0;
                while (j < receiverTabNames.length) {
                    if (receiverTabNames[j] != null && receiverTabNames[j].equals(transPanels[i].getTabName()) && (transferObjects = lastPanel.getValue(receiverTabNames[j])) != null) {
                        transPanels[i].setValue(transferObjects);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void refreshClassPaths(String[] paths) {
        String pp = this.projectProperties.getProperty("Classpath");
        if (pp == null) {
            pp = new String("");
        }
        if (paths == null) {
            return;
        }
        int i = 0;
        while (i < paths.length) {
            if (pp.indexOf(paths[i]) == -1) {
                pp = pp.endsWith(";") || pp.indexOf(";") == -1 ? pp + paths[i] + ";" : pp + ";" + paths[i] + ";";
            }
            ++i;
        }
        this.projectProperties.setProperty("Classpath", pp);
    }

    public void errorsShow() {
        ((MainTabPanel)this.mainTabPane.getSelectedComponent()).showErrors();
    }

    private void deleteGeneratedFiles(boolean deleteDir) {
        if (deleteDir) {
            FileUtils.deleteDirectory(this.projDir);
            if (this.projectFileName != null) {
                new File(this.projectFileName).delete();
            }
            this.projectFileName = null;
            return;
        }
        File xmlFile = null;
        if (this.newProject) {
            ToolTabPanel[] panels = this.getPanels();
            String xmls = null;
            int i = 0;
            while (i < panels.length) {
                xmls = panels[i].getXMLFileLocation();
                if (xmls != null && (xmlFile = new File(xmls)) != null && xmlFile.exists()) {
                    xmlFile.delete();
                }
                panels[i].deleteGeneratedFiles();
                ++i;
            }
            if (this.projectFileName != null) {
                new File(this.projectFileName).delete();
            }
            this.projectFileName = null;
        }
    }

    private void removeDeadViriables(Properties prop) {
        if (prop == null || this.deployOptions == null) {
            return;
        }
        Enumeration enumeration = ((Hashtable)this.deployOptions).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith("Path_Variable:") || ((Hashtable)prop).containsKey(key)) continue;
            ((Hashtable)this.deployOptions).remove(key);
        }
    }

    private static void updateClassPath() {
        String secstoreLibsDir = "../../../SYS/global/security/lib/tools";
        File libdir = new File(secstoreLibsDir);
        if (!libdir.exists() || !libdir.isDirectory()) {
            System.out.println("Secure Store lib Dir does not exist " + secstoreLibsDir);
            return;
        }
        File[] allLibs = DeployFrame.getAllFilesToAdd(libdir);
        String[] allLibPaths = new String[allLibs.length];
        int i = 0;
        while (i < allLibs.length) {
            allLibPaths[i] = allLibs[i].getAbsolutePath();
            System.out.println("ConfigurationManager: found jar for secure store " + allLibPaths[i]);
            ++i;
        }
        try {
            Class<?> fileClassLoaderClass = Class.forName("com.sap.engine.offline.FileClassLoader");
            ClassLoader currentLoader = (class$com$sap$engine$deploy$tool$DeployFrame == null ? (class$com$sap$engine$deploy$tool$DeployFrame = DeployFrame.class$("com.sap.engine.deploy.tool.DeployFrame")) : class$com$sap$engine$deploy$tool$DeployFrame).getClassLoader();
            if (fileClassLoaderClass.isInstance(currentLoader)) {
                try {
                    Method addJarsMethod = fileClassLoaderClass.getMethod("addJars", array$Ljava$lang$String == null ? (array$Ljava$lang$String = DeployFrame.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                    addJarsMethod.invoke((Object)currentLoader, new Object[]{allLibPaths});
                }
                catch (Throwable e) {
                    System.out.println("Current class loader is not of type FileClassLoader - Secure Store libraries can not be dynamically added. Assume libraries are already available");
                }
            } else {
                System.out.println("Current class loader is not of type FileClassLoader - Secure Store libraries can not be dynamically added. Assume libraries are already available");
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("FileClassLoader not available - Secure Store libraries can not be dynamically added. Assume libraries are already available\n" + e);
        }
    }

    private static File[] getAllLibDirFiles(File libDir) {
        File[] files = libDir.listFiles();
        Vector<File> v = new Vector<File>(files.length);
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory()) {
                v.add(files[i]);
            }
            ++i;
        }
        return v.toArray(new File[v.size()]);
    }

    private static File[] getAllFilesToAdd(File libDir) {
        String libPath = libDir.getAbsolutePath();
        File infoDir = new File(libPath + System.getProperty("file.separator") + "info");
        if (!infoDir.exists() || !infoDir.isDirectory()) {
            return DeployFrame.getAllLibDirFiles(libDir);
        }
        File[] infoFiles = infoDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (new File(dir, name).isDirectory()) {
                    return false;
                }
                return name.toLowerCase().endsWith(".lst");
            }
        });
        if (infoFiles.length == 0) {
            return DeployFrame.getAllLibDirFiles(libDir);
        }
        HashSet<File> filesToAdd = new HashSet<File>();
        int i = 0;
        while (i < infoFiles.length) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(infoFiles[i])));
                String ln = null;
                while ((ln = reader.readLine()) != null) {
                    if ((ln = ln.trim()).equals("")) continue;
                    File fileToAdd = new File(libPath + System.getProperty("file.separator") + ln);
                    if (fileToAdd.exists()) {
                        filesToAdd.add(fileToAdd);
                        continue;
                    }
                    System.out.println(infoFiles[i].getName() + " contains entry " + ln + " which does not exist in " + libPath);
                }
                reader.close();
            }
            catch (IOException e) {
                System.out.println("Error occurres while readinig " + infoFiles[i].getName() + "file.\n" + e);
            }
            ++i;
        }
        return ((AbstractCollection)filesToAdd).toArray(new File[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

