/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool;

import com.sap.engine.deploy.tool.tree.ArchiveDescriptorNode;
import com.sap.engine.deploy.tool.tree.ClientDescriptorNode;
import com.sap.engine.deploy.tool.tree.ConnectorDescriptorNode;
import com.sap.engine.deploy.tool.tree.DescriptorNode;
import com.sap.engine.deploy.tool.tree.EARDescriptorNode;
import com.sap.engine.deploy.tool.tree.EJBDescriptorNode;
import com.sap.engine.deploy.tool.tree.EJBJarDescriptorNode;
import com.sap.engine.deploy.tool.tree.FilterDescriptorNode;
import com.sap.engine.deploy.tool.tree.ServletDescriptorNode;
import com.sap.engine.deploy.tool.tree.WebDescriptorNode;
import com.sap.engine.deploy.tool.util.ClassLoadingThread;
import com.sap.engine.deploy.tool.util.LoadedFilesListener;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.ComponentReference;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.extended.ear.EARDescriptor;
import com.sap.engine.services.deploy.gui.common.ErrorReportLocatorDialog;
import com.sap.engine.services.deploy.gui.mapping.MappingObject;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.FilterDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.FilterMapping;
import com.sap.engine.services.servlets_jsp.descriptor.ListenerDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ServletMapping;
import com.sap.engine.services.servlets_jsp.descriptor.WebComponentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import java.awt.Frame;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

public class ApplicationInformationProvider
implements LoadedFilesListener {
    public static final String LOCAL_INTERFACE = "javax.ejb.EJBLocalObject";
    public static final String LOCAL_HOME_INTERFACE = "javax.ejb.EJBLocalHome";
    public static final String REMOTE_INTERFACE = "javax.ejb.EJBObject";
    public static final String REMOTE_HOME_INTERFACE = "javax.ejb.EJBHome";
    public static final String PRIMARY_KEY = "PrimaryKey";
    public static final String BEAN_CLASS = "BeanClass";
    public static final String FILTER_CLASS = "javax.servlet.Filter";
    public static final String LISTENER_CLASS = "LISTENER";
    public static final String SERVLET_CLASS = "SERVLET";
    public static final String EJB_NAMES = "EJB_NAMES";
    public static final String JNDI_NAMES = "JNDI_NAMES";
    private Hashtable beanClassesTable = new Hashtable();
    private DefaultMutableTreeNode root;
    private EARDescriptor earDescriptor;
    private ArchiveDescriptor[] archiveDescriptors;
    private int madeFrom;
    private String classPath;
    private ErrorReportLocatorDialog errorLocatorDilog;
    private Vector alreadyLoadedClass = new Vector();
    private ClassLoadingThread classLoadingThread;
    private Thread t1;
    private Hashtable names = new Hashtable();
    private static Hashtable renamedArchives = new Hashtable();
    private Hashtable allBeansCmpFields = new Hashtable();

    private ApplicationInformationProvider() {
    }

    public ApplicationInformationProvider(DefaultMutableTreeNode root, int madeFrom) {
        this.root = root;
        this.madeFrom = madeFrom;
    }

    private void initData() {
        if ((this.madeFrom == 0 || this.madeFrom == 1 || this.madeFrom == 2 || this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 5) && this.root != null && this.root.getChildCount() > 0) {
            int childCount = this.root.getChildCount();
            this.archiveDescriptors = new ArchiveDescriptor[childCount];
            int i = 0;
            while (i < childCount) {
                if (this.root.getChildAt(i) instanceof ArchiveDescriptorNode) {
                    this.archiveDescriptors[i] = ((ArchiveDescriptorNode)this.root.getChildAt(i)).getCurrentDescriptor();
                }
                ++i;
            }
        }
        if ((this.madeFrom == 4 || this.madeFrom == 3) && this.root != null && this.root instanceof EARDescriptorNode) {
            this.earDescriptor = ((EARDescriptorNode)this.root).getEARDescriptor();
        }
        if (this.archiveDescriptors == null) {
            this.archiveDescriptors = new ArchiveDescriptor[0];
        }
    }

    public ArchiveDescriptor[] getArchiveDescriptors() {
        this.initData();
        return this.archiveDescriptors;
    }

    public EARDescriptor getEarDescriptor() {
        this.initData();
        return this.earDescriptor;
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    public void setRoot(DefaultMutableTreeNode root) {
        this.root = root;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String _classPath) {
        if (_classPath == null) {
            return;
        }
        if (!EqualUtils.equalObjects(this.classPath, _classPath)) {
            if (this.classPath != null && _classPath == null || _classPath != null && this.classPath == null) {
                if (_classPath != null) {
                    if (_classPath.trim().equals("")) {
                        this.classPath = _classPath;
                        return;
                    }
                } else if (this.classPath != null && this.classPath.trim().equals("")) {
                    this.classPath = _classPath;
                    return;
                }
            }
            this.classPath = _classPath;
            this.initBeanClassesTable();
        }
    }

    public void setClassPath(String[] strings) {
        if (strings == null) {
            return;
        }
        String _classPath = ApplicationInformationProvider.arrayToString(strings, File.pathSeparator);
        if (!EqualUtils.equalObjects(this.classPath, _classPath)) {
            if (this.classPath != null && _classPath == null || _classPath != null && this.classPath == null) {
                if (_classPath != null) {
                    if (_classPath.trim().equals("")) {
                        this.classPath = _classPath;
                        return;
                    }
                } else if (this.classPath != null && this.classPath.trim().equals("")) {
                    this.classPath = _classPath;
                    return;
                }
            }
            this.classPath = ApplicationInformationProvider.addToClassPath(this.classPath, _classPath);
        }
    }

    public WebDeploymentDescriptor getWebParentDescriptor(WebComponentDescriptor descr) {
        this.initData();
        if ((this.madeFrom == 0 || this.madeFrom == 1 || this.madeFrom == 2 || this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 5) && descr != null && this.root != null && this.root.getChildCount() > 0) {
            int childCount = this.root.getChildCount();
            int i = 0;
            while (i < childCount) {
                if (this.root.getChildAt(i) instanceof WebDescriptorNode) {
                    int j = 0;
                    while (j < this.root.getChildAt(i).getChildCount()) {
                        if (descr instanceof FilterDescriptor ? this.root.getChildAt(i).getChildAt(j) instanceof FilterDescriptorNode && descr.equals(((FilterDescriptorNode)this.root.getChildAt(i).getChildAt(j)).getCurrentDescriptor()) : descr instanceof ServletDescriptor && this.root.getChildAt(i).getChildAt(j) instanceof ServletDescriptorNode && descr.equals(((ServletDescriptorNode)this.root.getChildAt(i).getChildAt(j)).getCurrentDescriptor())) {
                            return (WebDeploymentDescriptor)((WebDescriptorNode)this.root.getChildAt(i)).getCurrentDescriptor();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public WebDeploymentDescriptor getWebDeploymentDescriptor(String name) {
        this.initData();
        if ((this.madeFrom == 0 || this.madeFrom == 1 || this.madeFrom == 2 || this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 5) && name != null && this.root != null && this.root.getChildCount() > 0) {
            int childCount = this.root.getChildCount();
            int i = 0;
            while (i < childCount) {
                if (this.root.getChildAt(i) instanceof WebDescriptorNode) {
                    int j = 0;
                    while (j < this.root.getChildAt(i).getChildCount()) {
                        if (name.equals(((WebDeploymentDescriptor)((WebDescriptorNode)this.root.getChildAt(i)).getCurrentDescriptor()).getName())) {
                            return (WebDeploymentDescriptor)((WebDescriptorNode)this.root.getChildAt(i)).getCurrentDescriptor();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public ArchiveDescriptor getArchiveDescriptor(Descriptor descr1) {
        block18: {
            block20: {
                block19: {
                    block17: {
                        if (descr1 instanceof ArchiveDescriptor) {
                            return (ArchiveDescriptor)((Object)descr1);
                        }
                        if (!(descr1 instanceof DeploymentDescriptor)) break block17;
                        int i = 0;
                        while (i < this.archiveDescriptors.length) {
                            if (this.archiveDescriptors[i] instanceof EJBJarDescriptor) {
                                DeploymentDescriptor[] ddescrs = ((EJBJarDescriptor)this.archiveDescriptors[i]).getDDescriptors();
                                int j = 0;
                                while (j < ddescrs.length) {
                                    if (ddescrs[j].getEjbName().equals(((DeploymentDescriptor)descr1).getEjbName())) {
                                        return this.archiveDescriptors[i];
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        break block18;
                    }
                    if (!(descr1 instanceof ServletDescriptor)) break block19;
                    int i = 0;
                    while (i < this.archiveDescriptors.length) {
                        if (this.archiveDescriptors[i] instanceof WebDeploymentDescriptor) {
                            ServletDescriptor[] ddescrs = ((WebDeploymentDescriptor)this.archiveDescriptors[i]).getServlets();
                            int j = 0;
                            while (j < ddescrs.length) {
                                if (ddescrs[j].getName().equals(descr1.getName())) {
                                    return this.archiveDescriptors[i];
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    break block18;
                }
                if (!(descr1 instanceof FilterDescriptor)) break block20;
                int i = 0;
                while (i < this.archiveDescriptors.length) {
                    if (this.archiveDescriptors[i] instanceof WebDeploymentDescriptor) {
                        FilterDescriptor[] ddescrs = ((WebDeploymentDescriptor)this.archiveDescriptors[i]).getFilters();
                        int j = 0;
                        while (j < ddescrs.length) {
                            if (ddescrs[j].getName().equals(descr1.getName())) {
                                return this.archiveDescriptors[i];
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                break block18;
            }
            if (!(descr1 instanceof ListenerDescriptor)) break block18;
            int i = 0;
            while (i < this.archiveDescriptors.length) {
                if (this.archiveDescriptors[i] instanceof WebDeploymentDescriptor) {
                    ListenerDescriptor[] ddescrs = ((WebDeploymentDescriptor)this.archiveDescriptors[i]).getListenersDescriptor();
                    int j = 0;
                    while (j < ddescrs.length) {
                        if (ddescrs[j].getName().equals(descr1.getName())) {
                            return this.archiveDescriptors[i];
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public String getArchiveName(Descriptor descr1) {
        block20: {
            block22: {
                block21: {
                    block19: {
                        if (descr1 instanceof ArchiveDescriptor) {
                            int i = 0;
                            while (i < this.root.getChildCount()) {
                                if (((ArchiveDescriptorNode)this.root.getChildAt(i)).getCurrentDescriptor().equals(descr1)) {
                                    return ((ArchiveDescriptorNode)this.root.getChildAt(i)).getName();
                                }
                                ++i;
                            }
                            return null;
                        }
                        if (!(descr1 instanceof DeploymentDescriptor)) break block19;
                        int i = 0;
                        while (i < this.root.getChildCount()) {
                            EJBJarDescriptorNode tempEJBJarNode;
                            DeploymentDescriptor[] ddescrs;
                            if (this.root.getChildAt(i) instanceof EJBJarDescriptorNode && (ddescrs = ((EJBJarDescriptor)(tempEJBJarNode = (EJBJarDescriptorNode)this.root.getChildAt(i)).getCurrentDescriptor()).getDDescriptors()) != null) {
                                int j = 0;
                                while (j < ddescrs.length) {
                                    if (ddescrs[j].getEjbName().equals(((DeploymentDescriptor)descr1).getEjbName())) {
                                        return ((EJBJarDescriptorNode)this.root.getChildAt(i)).getName();
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        break block20;
                    }
                    if (!(descr1 instanceof ServletDescriptor)) break block21;
                    int i = 0;
                    while (i < this.root.getChildCount()) {
                        WebDescriptorNode tempWebWarNode;
                        ServletDescriptor[] ddescrs;
                        if (this.root.getChildAt(i) instanceof WebDescriptorNode && (ddescrs = ((WebDeploymentDescriptor)(tempWebWarNode = (WebDescriptorNode)this.root.getChildAt(i)).getCurrentDescriptor()).getServlets()) != null) {
                            int j = 0;
                            while (j < ddescrs.length) {
                                if (ddescrs[j].getName().equals(((ServletDescriptor)descr1).getName())) {
                                    return ((WebDescriptorNode)this.root.getChildAt(i)).getName();
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    break block20;
                }
                if (!(descr1 instanceof ListenerDescriptor)) break block22;
                int i = 0;
                while (i < this.root.getChildCount()) {
                    WebDescriptorNode tempWebWarNode;
                    ListenerDescriptor[] ddescrs;
                    if (this.root.getChildAt(i) instanceof WebDescriptorNode && (ddescrs = ((WebDeploymentDescriptor)(tempWebWarNode = (WebDescriptorNode)this.root.getChildAt(i)).getCurrentDescriptor()).getListenersDescriptor()) != null) {
                        int j = 0;
                        while (j < ddescrs.length) {
                            if (ddescrs[j].getName().equals(((ListenerDescriptor)descr1).getName())) {
                                return ((WebDescriptorNode)this.root.getChildAt(i)).getName();
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                break block20;
            }
            if (!(descr1 instanceof FilterDescriptor)) break block20;
            int i = 0;
            while (i < this.root.getChildCount()) {
                WebDescriptorNode tempWebWarNode;
                FilterDescriptor[] ddescrs;
                if (this.root.getChildAt(i) instanceof WebDescriptorNode && (ddescrs = ((WebDeploymentDescriptor)(tempWebWarNode = (WebDescriptorNode)this.root.getChildAt(i)).getCurrentDescriptor()).getFilters()) != null) {
                    int j = 0;
                    while (j < ddescrs.length) {
                        if (ddescrs[j].getName().equals(((FilterDescriptor)descr1).getName())) {
                            return ((WebDescriptorNode)this.root.getChildAt(i)).getName();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public FilterMapping[] getFilterMappings(FilterDescriptor descr) {
        WebDeploymentDescriptor wd = this.getWebParentDescriptor(descr);
        return wd == null ? null : wd.getFilterMappings();
    }

    public ServletMapping[] getServletMappings(ServletDescriptor descr) {
        WebDeploymentDescriptor wd = this.getWebParentDescriptor(descr);
        return wd == null ? null : wd.getServletMapping();
    }

    public String[] getFilterNames(WebDeploymentDescriptor descr) {
        return this.getFilterOrservletNames(descr, true);
    }

    public String[] getServletNames(WebDeploymentDescriptor descr) {
        return this.getFilterOrservletNames(descr, false);
    }

    private String[] getFilterOrservletNames(WebDeploymentDescriptor descr, boolean flag) {
        this.initData();
        Vector<String> names = new Vector<String>();
        if ((this.madeFrom == 0 || this.madeFrom == 1 || this.madeFrom == 2 || this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 5) && descr != null && this.root != null && this.root.getChildCount() > 0) {
            int childCount = this.root.getChildCount();
            String nameForAdd = null;
            int i = 0;
            while (i < childCount) {
                if (this.root.getChildAt(i) instanceof WebDescriptorNode && descr.getDisplayName().equals(((WebDeploymentDescriptor)((WebDescriptorNode)this.root.getChildAt(i)).getCurrentDescriptor()).getDisplayName())) {
                    int j = 0;
                    while (j < this.root.getChildAt(i).getChildCount()) {
                        if (this.root.getChildAt(i).getChildAt(j) instanceof FilterDescriptorNode && flag) {
                            nameForAdd = ((FilterDescriptor)((FilterDescriptorNode)this.root.getChildAt(i).getChildAt(j)).getCurrentDescriptor()).getFilterName();
                            if (nameForAdd == null) {
                                nameForAdd = ((FilterDescriptor)((FilterDescriptorNode)this.root.getChildAt(i).getChildAt(j)).getCurrentDescriptor()).getDisplayName();
                            }
                            names.add(nameForAdd);
                        } else if (this.root.getChildAt(i).getChildAt(j) instanceof ServletDescriptorNode && !flag) {
                            nameForAdd = ((ServletDescriptor)((ServletDescriptorNode)this.root.getChildAt(i).getChildAt(j)).getCurrentDescriptor()).getServletName();
                            if (nameForAdd == null) {
                                nameForAdd = ((ServletDescriptor)((ServletDescriptorNode)this.root.getChildAt(i).getChildAt(j)).getCurrentDescriptor()).getDisplayName();
                            }
                            names.add(nameForAdd);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        Object[] mappNames = null;
        if (names.size() != 0) {
            mappNames = new String[names.size()];
            names.copyInto(mappNames);
        }
        return mappNames;
    }

    public DefaultMutableTreeNode getArchiveDescriptorNode(DefaultMutableTreeNode node, Object descr) {
        DefaultMutableTreeNode forReturn = null;
        if (node != null && descr != null) {
            if (node instanceof FilterDescriptorNode && descr instanceof FilterDescriptor ? ((FilterDescriptor)descr).equals(((FilterDescriptorNode)node).getDescriptor()) || ((FilterDescriptor)descr).equals(((FilterDescriptorNode)node).getCurrentDescriptor()) : (node instanceof ServletDescriptorNode && descr instanceof ServletDescriptor ? ((ServletDescriptor)descr).equals(((ServletDescriptorNode)node).getDescriptor()) || ((ServletDescriptor)descr).equals(((ServletDescriptorNode)node).getCurrentDescriptor()) : (node instanceof WebDescriptorNode && descr instanceof WebDeploymentDescriptor ? ((WebDeploymentDescriptor)descr).equals(((WebDescriptorNode)node).getArchiveDescriptor()) || ((WebDeploymentDescriptor)descr).equals(((WebDescriptorNode)node).getCurrentDescriptor()) : (node instanceof EARDescriptorNode && descr instanceof EARDescriptor ? ((EARDescriptor)descr).equals(((EARDescriptorNode)node).getEARDescriptor()) || ((EARDescriptor)descr).equals(((EARDescriptorNode)node).getModifiedDescriptor()) : (node instanceof EJBJarDescriptorNode && descr instanceof EJBJarDescriptor ? ((EJBJarDescriptor)descr).equals(((EJBJarDescriptorNode)node).getArchiveDescriptor()) || ((EJBJarDescriptor)descr).equals(((EJBJarDescriptorNode)node).getCurrentDescriptor()) : (node instanceof EJBDescriptorNode && (descr instanceof EntityDescriptor || descr instanceof MessageDrivenDescriptor || descr instanceof SessionDescriptor) ? ((DeploymentDescriptor)descr).equals(((EJBDescriptorNode)node).getDescriptor()) || ((DeploymentDescriptor)descr).equals(((EJBDescriptorNode)node).getCurrentDescriptor()) : (node instanceof ClientDescriptorNode && descr instanceof ApplicationClientDescriptor ? ((ApplicationClientDescriptor)descr).equals(((ClientDescriptorNode)node).getArchiveDescriptor()) || ((ApplicationClientDescriptor)descr).equals(((ClientDescriptorNode)node).getCurrentDescriptor()) : node instanceof ConnectorDescriptorNode && descr instanceof JCDescriptor && (((JCDescriptor)descr).equals(((ConnectorDescriptorNode)node).getArchiveDescriptor()) || ((JCDescriptor)descr).equals(((ConnectorDescriptorNode)node).getCurrentDescriptor()))))))))) {
                return node;
            }
            int count = node.getChildCount();
            int i = 0;
            while (i < count) {
                forReturn = this.getArchiveDescriptorNode((DefaultMutableTreeNode)node.getChildAt(i), descr);
                if (forReturn != null) {
                    return forReturn;
                }
                ++i;
            }
        }
        return null;
    }

    public ArchiveDescriptorNode getArchiveDescriptorNodeByName(String name) {
        int i = 0;
        while (i < this.root.getChildCount()) {
            if (((ArchiveDescriptorNode)this.root.getChildAt(i)).getName().equals(name)) {
                return (ArchiveDescriptorNode)this.root.getChildAt(i);
            }
            ++i;
        }
        return null;
    }

    public DescriptorNode getDescriptorNodeByName(ArchiveDescriptorNode node, String name) {
        block6: {
            block5: {
                if (node == null || name == null) {
                    return null;
                }
                if (!(node instanceof EJBJarDescriptorNode)) break block5;
                int i = 0;
                while (i < node.getChildCount()) {
                    if (((DeploymentDescriptor)((EJBDescriptorNode)node.getChildAt(i)).getCurrentDescriptor()).getEjbName().equals(name)) {
                        return (EJBDescriptorNode)node.getChildAt(i);
                    }
                    ++i;
                }
                break block6;
            }
            if (!(node instanceof WebDescriptorNode)) break block6;
            int i = 0;
            while (i < node.getChildCount()) {
                if (((DescriptorNode)node.getChildAt(i)).getCurrentDescriptor().getName().equals(name)) {
                    return (DescriptorNode)node.getChildAt(i);
                }
                ++i;
            }
        }
        return null;
    }

    public String getArchiveFile(Object descriptor) {
        DefaultMutableTreeNode node = null;
        node = this.getArchiveDescriptorNode(this.getRoot(), descriptor);
        if (node instanceof DescriptorNode) {
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if (node != null) {
            return ((ArchiveDescriptorNode)node).getArchiveFileName();
        }
        return null;
    }

    public void addAdditionalFiles(Object descr, InfoObject info) {
        if (info == null) {
            return;
        }
        DefaultMutableTreeNode neededNode = this.getArchiveDescriptorNode(this.root, descr);
        if (neededNode != null) {
            if (neededNode instanceof WebDescriptorNode || neededNode instanceof EJBJarDescriptorNode || neededNode instanceof ClientDescriptorNode || neededNode instanceof ConnectorDescriptorNode) {
                ((ArchiveDescriptorNode)neededNode).addAdditionalFile(info);
            } else if (neededNode instanceof FilterDescriptorNode || neededNode instanceof ServletDescriptorNode || neededNode instanceof EJBDescriptorNode) {
                ((ArchiveDescriptorNode)neededNode.getParent()).addAdditionalFile(info);
            }
        }
    }

    public Hashtable getBeanClassesTable() {
        return this.beanClassesTable;
    }

    public void initBeanClassesTable() {
        if (this.classLoadingThread == null) {
            this.classLoadingThread = new ClassLoadingThread(this.beanClassesTable);
            this.classLoadingThread.addLoadedFilesListener(this);
        } else {
            this.classLoadingThread.setBeanClassesTable(this.beanClassesTable);
        }
        if (!this.classLoadingThread.isStopped()) {
            this.classLoadingThread.stopThread();
            int i = 0;
            while (i < 8) {
                if (this.classLoadingThread.isStopped()) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }
        this.classLoadingThread.setClassPath(this.classPath);
        this.classLoadingThread.setAlreadyLoadedFiles(this.alreadyLoadedClass);
        this.t1 = new Thread(this.classLoadingThread);
        this.t1.start();
    }

    private void getNames() {
        Vector<String> tempEJBNames = new Vector<String>();
        Vector<String> tempJNDINames = new Vector<String>();
        int i = 0;
        while (i < this.archiveDescriptors.length) {
            if (this.archiveDescriptors[i] instanceof EJBJarDescriptor && this.archiveDescriptors[i].getDescriptors() != null) {
                int j = 0;
                while (j < this.archiveDescriptors[i].getDescriptors().length) {
                    if (this.archiveDescriptors[i].getDescriptors()[j] != null) {
                        tempEJBNames.add(((DeploymentDescriptor)this.archiveDescriptors[i].getDescriptors()[j]).getEjbName());
                        tempJNDINames.add(((DeploymentDescriptor)this.archiveDescriptors[i].getDescriptors()[j]).getJndiName());
                    }
                    ++j;
                }
            }
            ++i;
        }
        Object[] ejbNames = new String[tempEJBNames.size()];
        tempEJBNames.copyInto(ejbNames);
        Object[] jndiNames = new String[tempJNDINames.size()];
        tempJNDINames.copyInto(jndiNames);
        this.names.put(EJB_NAMES, ejbNames);
        this.names.put(JNDI_NAMES, jndiNames);
    }

    public Hashtable getEjbAndJNDINames() {
        this.initData();
        this.getNames();
        return this.names;
    }

    public SecurityRoles[] getSecurityRoles(Descriptor dd) {
        if (dd != null && this.archiveDescriptors != null) {
            Descriptor[] descriptors = null;
            boolean find = false;
            int i = 0;
            while (i < this.archiveDescriptors.length) {
                descriptors = this.archiveDescriptors[i].getDescriptors();
                find = false;
                if (descriptors != null) {
                    int j = 0;
                    while (j < descriptors.length) {
                        if (dd.equals(descriptors[j])) {
                            find = true;
                            break;
                        }
                        ++j;
                    }
                    if (find) {
                        if (this.archiveDescriptors[i] instanceof EJBJarDescriptor) {
                            return ((EJBJarDescriptor)this.archiveDescriptors[i]).getSecurityRoles();
                        }
                        if (this.archiveDescriptors[i] instanceof WebDeploymentDescriptor) {
                            return ((WebDeploymentDescriptor)this.archiveDescriptors[i]).getSecRoles();
                        }
                    }
                }
                ++i;
            }
        }
        return new SecurityRoles[0];
    }

    public Vector getAllReferenceObjects(Frame mainFrame) {
        Vector<ReferenceObject> refObjs = null;
        Vector compRefs = this.getServerComponentReferences();
        if (compRefs != null && compRefs.size() != 0) {
            ComponentReference compRefObject = null;
            ReferenceObject refObject = null;
            int i = 0;
            while (i < compRefs.size()) {
                compRefObject = (ComponentReference)compRefs.elementAt(i);
                if (compRefObject != null) {
                    if (compRefObject.getJndiName() != null && !compRefObject.getJndiName().trim().equals("")) {
                        refObject = new ReferenceObject(compRefObject.getJndiName(), compRefObject.getType() == 0 ? "service" : "interface", "weak");
                        if (refObjs == null) {
                            refObjs = new Vector<ReferenceObject>();
                        }
                        refObjs.add(refObject);
                    } else {
                        JOptionPane.showConfirmDialog(mainFrame, "There are component references without jndi names,\nthey won't be converted into reference in ear", "Warning", 2);
                    }
                }
                ++i;
            }
        }
        return refObjs;
    }

    private Vector getServerComponentReferences() {
        this.initData();
        Vector compRefs = new Vector();
        ComponentReference[] compRefArr = null;
        if (this.root != null) {
            int childCount = this.root.getChildCount();
            DefaultMutableTreeNode node = null;
            DeploymentDescriptor[] dd = null;
            int i = 0;
            while (i < childCount) {
                compRefArr = null;
                node = (DefaultMutableTreeNode)this.root.getChildAt(i);
                if (node instanceof WebDescriptorNode) {
                    if (((WebDescriptorNode)node).getModifiedDescriptor() != null) {
                        compRefArr = ((WebDeploymentDescriptor)((WebDescriptorNode)node).getModifiedDescriptor()).getServerComponentRefs();
                        this.addArrayToVector(compRefs, compRefArr);
                    }
                } else if (node instanceof EJBJarDescriptorNode) {
                    if (((EJBJarDescriptorNode)node).getModifiedDescriptor() != null && (dd = ((EJBJarDescriptor)((EJBJarDescriptorNode)node).getModifiedDescriptor()).getDDescriptors()) != null) {
                        int k = 0;
                        while (k < dd.length) {
                            if (dd[k] != null) {
                                this.addArrayToVector(compRefs, dd[k].getServerComponentReferences());
                            }
                            ++k;
                        }
                    }
                } else if (node instanceof ClientDescriptorNode && ((ClientDescriptorNode)node).getModifiedDescriptor() != null) {
                    compRefArr = ((ApplicationClientDescriptor)((ClientDescriptorNode)node).getModifiedDescriptor()).getServerComponentRefs();
                    this.addArrayToVector(compRefs, compRefArr);
                }
                ++i;
            }
        }
        return compRefs;
    }

    private void addArrayToVector(Vector vector, ComponentReference[] arr) {
        if (vector == null) {
            vector = new Vector<ComponentReference>();
        }
        if (arr != null) {
            int i = 0;
            while (i < arr.length) {
                if (arr[i] != null) {
                    vector.add(arr[i]);
                }
                ++i;
            }
        }
    }

    public void initRenamedHashtable() {
        renamedArchives = new Hashtable();
    }

    public void saveRenameInformation(String oldPath, String newPath) {
        renamedArchives.put(oldPath, newPath);
    }

    public String getRenamedPath(String oldPath) {
        return this.findNewPath(oldPath);
    }

    private String findNewPath(String old) {
        if (renamedArchives.get(old) == null) {
            return old;
        }
        return this.findNewPath((String)renamedArchives.get(old));
    }

    public boolean hasRenamedArchives() {
        return !renamedArchives.isEmpty();
    }

    public void addToHashTable(String arg0, String arg1) {
        this.addValueToHashTable(arg0, arg1, this.beanClassesTable);
    }

    private synchronized boolean addValueToHashTable(String key, String value, Hashtable target) {
        String[] valueEnum = null;
        if (value == null || target == null) {
            return false;
        }
        valueEnum = (String[])target.get(key);
        if (valueEnum == null) {
            target.put(key, new String[]{value});
            return true;
        }
        if (this.containsString(value, valueEnum) == -1) {
            String[] newArray = new String[valueEnum.length + 1];
            System.arraycopy(valueEnum, 0, newArray, 0, valueEnum.length);
            newArray[valueEnum.length] = value;
            target.put(key, newArray);
            return true;
        }
        return false;
    }

    private synchronized boolean removeValueFromHashTable(String key, Vector value, Hashtable target) {
        String[] valueEnum = null;
        if (value == null || target == null) {
            return false;
        }
        valueEnum = (String[])target.get(key);
        if (valueEnum == null) {
            return false;
        }
        Vector<String> preResult = new Vector<String>();
        int i = 0;
        while (i < valueEnum.length) {
            if (!value.contains(valueEnum[i])) {
                preResult.addElement(valueEnum[i]);
            }
            ++i;
        }
        Object[] newArray = new String[preResult.size()];
        preResult.copyInto(newArray);
        target.put(key, newArray);
        return true;
    }

    public void removeFromHashTable(String key, Vector value) {
        this.removeValueFromHashTable(key, value, this.beanClassesTable);
    }

    public void addLoadedFilesListener(LoadedFilesListener listener) {
        if (this.classLoadingThread == null) {
            this.classLoadingThread = new ClassLoadingThread(this.beanClassesTable);
            this.classLoadingThread.addLoadedFilesListener(this);
        } else {
            this.classLoadingThread.setBeanClassesTable(this.beanClassesTable);
        }
        this.classLoadingThread.addLoadedFilesListener(listener);
    }

    public void clearContent() {
        this.beanClassesTable = new Hashtable();
    }

    private int containsString(String searched, String[] target) {
        if (searched == null || searched.trim().equals("") || target == null || target.length == 0) {
            return -1;
        }
        int i = 0;
        while (i < target.length) {
            if (searched.equals(target[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String parseClassPathToRelative(String path, Properties classPathVariableNames) {
        Properties tempProp = ApplicationInformationProvider.reverseProperties(classPathVariableNames);
        String[] pathArray = ApplicationInformationProvider.tokenizerToArray(path, File.pathSeparator);
        String result = "";
        boolean wasIn = false;
        if (pathArray == null) {
            return result;
        }
        int i = 0;
        while (i < pathArray.length) {
            Enumeration enumeration = ((Hashtable)tempProp).keys();
            String pathReal = null;
            wasIn = false;
            while (enumeration.hasMoreElements()) {
                pathReal = (String)enumeration.nextElement();
                if (!pathArray[i].toLowerCase().startsWith(pathReal.toLowerCase())) continue;
                result = result + ApplicationInformationProvider.concatPath(tempProp.getProperty(pathReal), pathArray[i].substring(pathReal.length())) + File.pathSeparator;
                wasIn = true;
                break;
            }
            if (!wasIn) {
                result = result + pathArray[i] + File.pathSeparator;
            }
            ++i;
        }
        return result;
    }

    public static String getVariableUsed(String path) {
        if (path.indexOf("${") != -1 && path.indexOf("}") != -1 && path.indexOf("}") > path.indexOf("&{")) {
            return path.substring(0, path.indexOf("}") + 1);
        }
        return null;
    }

    public static String concatPath(String prefix, String sufix) {
        if (prefix == null) {
            return sufix;
        }
        if (sufix == null) {
            return prefix;
        }
        String result = "";
        result = prefix.endsWith(File.separator) && sufix.startsWith(File.separator) ? prefix + sufix.substring(1) : (prefix.endsWith(File.separator) ^ sufix.startsWith(File.separator) ? prefix + sufix : prefix + File.separator + sufix);
        return result;
    }

    public static String parseClassPathToAbsolute(String path, Properties classPathVariableNames) {
        String[] pathArray = ApplicationInformationProvider.tokenizerToArray(path, File.pathSeparator);
        String result = "";
        int i = 0;
        while (i < pathArray.length) {
            String varibleTemp = ApplicationInformationProvider.getVariableUsed(pathArray[i]);
            if (varibleTemp != null) {
                if (classPathVariableNames.getProperty(varibleTemp) != null) {
                    result = result + ApplicationInformationProvider.concatPath(classPathVariableNames.getProperty(varibleTemp), pathArray[i].substring(varibleTemp.length())) + File.pathSeparator;
                }
            } else {
                result = result + pathArray[i] + File.pathSeparator;
            }
            ++i;
        }
        return result;
    }

    public static Properties reverseProperties(Properties properties) {
        Properties result = new Properties();
        Enumeration enumeration = ((Hashtable)properties).keys();
        String key = null;
        String value = null;
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            value = properties.getProperty(key);
            if (value == null) continue;
            result.setProperty(value, key);
        }
        return result;
    }

    public static Vector concatVectors(Vector vec1, Vector vec2) {
        Vector result = new Vector();
        if (vec1 == null && vec2 == null) {
            return null;
        }
        if (vec1 == null && vec2 != null) {
            return vec2;
        }
        if (vec2 == null && vec1 != null) {
            return vec1;
        }
        if (vec1 != null && vec2 != null) {
            int i = 0;
            while (i < vec1.size()) {
                result.add(vec1.elementAt(i));
                ++i;
            }
            int i2 = 0;
            while (i2 < vec2.size()) {
                result.add(vec1.elementAt(i2));
                ++i2;
            }
        }
        return result;
    }

    public static String arrayToString(String[] array, String delimeter) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            result.append(array[i] + delimeter);
            ++i;
        }
        return result.toString();
    }

    public static Properties removePrefixPath_Variable(Properties origin) {
        Properties result = new Properties();
        Enumeration enumeration = ((Hashtable)origin).keys();
        String oldKey = "";
        String newKey = "";
        while (enumeration.hasMoreElements()) {
            oldKey = (String)enumeration.nextElement();
            newKey = oldKey.startsWith("Path_Variable:") ? oldKey.substring("Path_Variable:".length()) : oldKey;
            result.setProperty(newKey, origin.getProperty(oldKey));
        }
        return result;
    }

    public static String removePrefixPath_Variable(String origin) {
        if (origin == null) {
            return null;
        }
        if (origin.startsWith("Path_Variable:")) {
            return origin.substring("Path_Variable:".length());
        }
        return origin;
    }

    public ErrorReportLocatorDialog getErrorLocatorDilog() {
        return this.errorLocatorDilog;
    }

    public void setErrorLocatorDilog(ErrorReportLocatorDialog errorLocatorDilog) {
        this.errorLocatorDilog = errorLocatorDilog;
    }

    public static String addToClassPath(String original, String forAdd) {
        if (forAdd == null) {
            return original;
        }
        if (original == null) {
            return forAdd;
        }
        String[] originalArray = ApplicationInformationProvider.tokenizerToArray(original, File.pathSeparator);
        String[] forAddArray = ApplicationInformationProvider.tokenizerToArray(forAdd, File.pathSeparator);
        int i = 0;
        while (i < originalArray.length) {
            int j = 0;
            while (j < forAddArray.length) {
                if (originalArray[i].equals(forAddArray[j])) {
                    forAddArray[j] = null;
                }
                ++j;
            }
            ++i;
        }
        return original.endsWith(File.pathSeparator) ? original + ApplicationInformationProvider.arrayToString(forAddArray, File.pathSeparator) : original + File.pathSeparator + ApplicationInformationProvider.arrayToString(forAddArray, File.pathSeparator);
    }

    public static String[] tokenizerToArray(String str, String delimeter) {
        if (str == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(str, delimeter);
        int tokCount = tok.countTokens();
        String[] clsPaths = new String[tokCount];
        int i = 0;
        while (i < tokCount) {
            clsPaths[i] = tok.nextToken();
            ++i;
        }
        return clsPaths;
    }

    public static String changeFileSeparatorsToOSDependant(String source) {
        source = source.replace('\\', '/');
        return source.replace('/', File.separatorChar);
    }

    public static String changeFileSeparatorsToZipDependant(String source) {
        return source.replace('\\', '/');
    }

    public static String vectorToString(Vector source) {
        String result = "";
        if (source == null) {
            return null;
        }
        int i = 0;
        while (i < source.size()) {
            if (source.elementAt(i) != null) {
                result = result + source.elementAt(i) + File.pathSeparator;
            }
            ++i;
        }
        return result;
    }

    public String[] getAllLibrariesFromAdditionalFiles(Vector allFilesTemp) {
        Vector<File> preResult = new Vector<File>();
        boolean bypassMappingSearch = false;
        boolean getOut = false;
        int i = 0;
        while (i < allFilesTemp.size()) {
            String libMapping;
            File[] tempArray;
            File tempDir;
            if (allFilesTemp.elementAt(i) instanceof MappingObject) {
                Properties mappings;
                String libMapping2;
                if (!bypassMappingSearch && (libMapping2 = (mappings = ((MappingObject)allFilesTemp.elementAt(i)).getMappings()).getProperty(".jar")) != null && this.isWebInfLibrary(libMapping2)) {
                    tempDir = new File(((MappingObject)allFilesTemp.elementAt(i)).getFilePath());
                    tempArray = tempDir.listFiles();
                    int j = 0;
                    while (j < tempArray.length) {
                        if (tempArray[j].getAbsolutePath().toLowerCase().endsWith(".jar")) {
                            preResult.add(tempArray[j]);
                        }
                        ++j;
                    }
                }
            } else if (allFilesTemp.elementAt(i) instanceof InfoObject && (libMapping = ((InfoObject)allFilesTemp.elementAt(i)).getEntryName()) != null && this.isWebInfLibrary(libMapping)) {
                tempDir = new File(((InfoObject)allFilesTemp.elementAt(i)).getFilePath());
                tempArray = tempDir.listFiles();
                if (tempArray == null) {
                    return null;
                }
                int j = 0;
                while (j < tempArray.length) {
                    if (tempArray[j].getAbsolutePath().toLowerCase().endsWith(".jar")) {
                        preResult.add(tempArray[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Object[] result = new String[preResult.size()];
        preResult.copyInto(result);
        return result;
    }

    private boolean isWebInfLibrary(String origin) {
        String[] processing = ApplicationInformationProvider.tokenizerToArray(origin = origin.replace('\\', '/'), "/");
        return processing != null && processing.length == 3 && processing[0].equals("WEB-INF") && processing[1].equals("lib") && processing[2].toLowerCase().endsWith(".jar");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zipHasClassEntry(String fileName, String entry) {
        boolean bl;
        ZipFile zip;
        block11: {
            boolean bl2;
            block10: {
                zip = null;
                String servlet = entry.replace('.', '/');
                try {
                    try {
                        zip = new ZipFile(fileName);
                        if (zip.getEntry(servlet + ".class") == null) {
                            bl2 = false;
                            Object var7_7 = null;
                            break block10;
                        }
                        bl = true;
                        break block11;
                    }
                    catch (Exception e) {
                        boolean bl3 = false;
                        Object var7_9 = null;
                        try {
                            zip.close();
                            return bl3;
                        }
                        catch (Exception e2) {
                            return false;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    try {}
                    catch (Exception e2) {
                        return false;
                    }
                    zip.close();
                    throw throwable;
                }
            }
            try {}
            catch (Exception e2) {
                return false;
            }
            zip.close();
            return bl2;
        }
        Object var7_8 = null;
        try {}
        catch (Exception e2) {
            return false;
        }
        zip.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zipHasEntry(String fileName, String entry) {
        boolean bl;
        ZipFile zip;
        block14: {
            boolean bl2;
            block13: {
                zip = null;
                try {
                    try {
                        zip = new ZipFile(fileName);
                        if (zip.getEntry(entry) == null) {
                            bl2 = false;
                            Object var7_6 = null;
                            break block13;
                        }
                        bl = true;
                        break block14;
                    }
                    catch (Exception e) {
                        try {
                            zip.close();
                        }
                        catch (Exception ex) {
                            boolean bl3 = false;
                            Object var7_8 = null;
                            try {
                                zip.close();
                                return bl3;
                            }
                            catch (Exception e2) {
                                return false;
                            }
                        }
                        boolean bl4 = false;
                        Object var7_9 = null;
                        try {}
                        catch (Exception e2) {
                            return false;
                        }
                        zip.close();
                        return bl4;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    try {}
                    catch (Exception e2) {
                        return false;
                    }
                    zip.close();
                    throw throwable;
                }
            }
            try {}
            catch (Exception e2) {
                return false;
            }
            zip.close();
            return bl2;
        }
        Object var7_7 = null;
        try {}
        catch (Exception e2) {
            return false;
        }
        zip.close();
        return bl;
    }

    private void rekursiveDirectoryLoading(File file, Vector thePlace, Properties pps, String firstDir, boolean isRoot) {
        if (!file.isFile()) {
            if (isRoot) {
                MappingObject map = new MappingObject(file.getAbsolutePath(), this.formMappings(firstDir, file.getAbsolutePath(), pps));
                thePlace.add(map);
            }
            File[] filesList = file.listFiles();
            int i = 0;
            while (i < filesList.length) {
                if (filesList[i].isDirectory()) {
                    MappingObject map = new MappingObject(filesList[i].getAbsolutePath(), this.formMappings(firstDir, filesList[i].getAbsolutePath(), pps));
                    thePlace.add(map);
                    this.rekursiveDirectoryLoading(filesList[i], thePlace, pps, firstDir, false);
                }
                ++i;
            }
        }
    }

    private Properties formMappings(String originalPath, String currentPath, Properties mappings) {
        String addon = currentPath.substring(originalPath.length());
        Properties result = new Properties();
        if (mappings == null) {
            return new Properties();
        }
        Enumeration en = ((Hashtable)mappings).keys();
        String key = "";
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            String mapping = mappings.getProperty(key);
            addon = ApplicationInformationProvider.changeFileSeparatorsToZipDependant(addon);
            addon = ApplicationInformationProvider.removesFileSeparatorsBoth(addon, "/");
            mapping = ApplicationInformationProvider.changeFileSeparatorsToZipDependant(mapping);
            mapping = addon.startsWith(mapping = ApplicationInformationProvider.removesFileSeparatorsBoth(mapping, "/")) ? mapping + "/" + addon.substring(mapping.length()) : mapping + "/" + addon;
            result.setProperty(key, mapping);
        }
        return result;
    }

    public static String removesFileSeparatorsBoth(String origin, String separator) {
        while (origin.startsWith(separator)) {
            origin = origin.substring(1);
        }
        while (origin.endsWith(separator)) {
            origin = origin.substring(0, origin.length() - 1);
        }
        return origin;
    }

    public static String removesFileSeparatorsAtStart(String origin, String separator) {
        while (origin.startsWith(separator)) {
            origin = origin.substring(1);
        }
        return origin;
    }

    public static String removesFileSeparatorsAtEnd(String origin, String separator) {
        while (origin.endsWith(separator)) {
            origin = origin.substring(0, origin.length() - 1);
        }
        return origin;
    }

    public Vector getAllMappings(String directory, Properties mapping, Vector result) {
        this.rekursiveDirectoryLoading(new File(directory), result, mapping, directory, true);
        return result;
    }

    public Hashtable getCMP1_1Fields(ClassLoader loader, String className, String beanName) {
        Hashtable<String, StringBuffer> fields = (Hashtable<String, StringBuffer>)this.allBeansCmpFields.get(beanName);
        if (loader == null) {
            loader = new DynamicClassLoader(this.classPath);
        }
        if (fields == null) {
            fields = new Hashtable<String, StringBuffer>();
            Field[] allFields = new Field[]{};
            if (className == null) {
                return null;
            }
            try {
                allFields = loader != null ? loader.loadClass(className).getFields() : Class.forName(className).getFields();
            }
            catch (ClassNotFoundException exc) {
                return null;
            }
            Field currentField = null;
            StringBuffer typeName = null;
            int i = 0;
            while (i < allFields.length) {
                currentField = allFields[i];
                if (Modifier.isPublic(currentField.getModifiers()) && !Modifier.isTransient(currentField.getModifiers())) {
                    typeName = new StringBuffer(currentField.getType().getName());
                    fields.put(currentField.getName(), typeName);
                }
                ++i;
            }
            this.allBeansCmpFields.put(beanName, fields);
        }
        return fields;
    }

    public Hashtable getAllCMP2_0Fields(ClassLoader loader, String className, String beanName) {
        Hashtable<String, StringBuffer> fields = (Hashtable<String, StringBuffer>)this.allBeansCmpFields.get(beanName);
        if (loader == null) {
            loader = new DynamicClassLoader(this.classPath);
        }
        if (fields == null) {
            fields = new Hashtable<String, StringBuffer>();
            Method[] methods = null;
            if (className == null) {
                return null;
            }
            String methodName = null;
            String fieldName = null;
            StringBuffer fieldType = null;
            String lower = "";
            if (loader != null) {
                try {
                    methods = loader.loadClass(className).getMethods();
                }
                catch (ClassNotFoundException exc) {
                    return null;
                }
                catch (NoClassDefFoundError err) {
                    err.printStackTrace();
                    return null;
                }
                int i = 0;
                while (i < methods.length) {
                    if (Modifier.isAbstract(methods[i].getModifiers()) && (methodName = methods[i].getName()).startsWith("get")) {
                        lower = "" + methodName.charAt(3);
                        fieldName = lower.toLowerCase() + methodName.substring(4);
                        fieldType = new StringBuffer(methods[i].getReturnType().getName());
                        if (fieldType != null && this.isNonSimpleClass(fieldType.toString())) {
                            fields.put(fieldName, fieldType);
                        }
                    }
                    ++i;
                }
            }
            this.allBeansCmpFields.put(beanName, fields);
        }
        return fields;
    }

    public boolean isNonSimpleClass(String className) {
        if (className == null) {
            return false;
        }
        if (className.equalsIgnoreCase("int")) {
            return false;
        }
        if (className.equalsIgnoreCase("byte")) {
            return false;
        }
        if (className.equalsIgnoreCase("char")) {
            return false;
        }
        if (className.equalsIgnoreCase("short")) {
            return false;
        }
        if (className.equalsIgnoreCase("long")) {
            return false;
        }
        if (className.equalsIgnoreCase("double")) {
            return false;
        }
        if (className.equalsIgnoreCase("float")) {
            return false;
        }
        return !className.equalsIgnoreCase("boolean");
    }
}

