/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.server;

import com.sap.engine.deploy.server.CPropertyObject;
import com.sap.engine.deploy.server.LibrarySDA630Helper;
import com.sap.engine.deploy.server.SComponentObject;
import com.sap.engine.deploy.server.ServerComponentDocument;
import com.sap.engine.deploy.server.provider.LibProviderDocument;
import com.sap.engine.deploy.tool.server.ServerComponentsActionManager;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.lib.xml.StandardDOMParser;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.w3c.dom.Document;

public class SComponentGenerator {
    public static String NO_JARS = "Component contains no jars!";
    String xmlFile = null;
    SComponentObject[] components = null;
    File tempFile = null;
    File originalFile = null;
    ServerComponentsActionManager actionManager;

    public SComponentGenerator() {
    }

    public SComponentGenerator(String xmlFileName) {
        this.xmlFile = xmlFileName;
    }

    public void setXmlFile(String xmlFileName) {
        this.xmlFile = xmlFileName;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public void parseXML() throws IOException {
        try {
            StandardDOMParser parser = new StandardDOMParser();
            Document doc = parser.parse(this.xmlFile);
            ServerComponentDocument document = new ServerComponentDocument();
            this.components = document.loadFieldsFromDocument(doc);
        }
        catch (Exception e) {
            throw new IOException("Cannot parse xml file: " + this.xmlFile + " ! Reason: \n" + e.getMessage());
        }
    }

    public void makeAllJars() throws Exception {
        if (this.components == null) {
            throw new Exception("There is no components set.");
        }
        Vector<String> messages = new Vector<String>();
        int i = 0;
        while (i < this.components.length) {
            try {
                this.makeComponent(this.components[i], false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                messages.add("Cannot make component " + this.components[i].getFileName() + " . " + ex.getMessage());
            }
            ++i;
        }
        String message = "";
        if (messages.size() > 0) {
            int i2 = 0;
            while (i2 < messages.size()) {
                message = message + messages.elementAt(i2) + "\n";
                ++i2;
            }
            throw new Exception(message);
        }
    }

    public void makeJarByFileName(String jarFileName, boolean isSDA) throws Exception {
        if (this.components == null) {
            throw new Exception("There is no components set.");
        }
        int i = 0;
        while (i < this.components.length) {
            if (this.components[i].getFileName() != null && this.components[i].getFileName().equals(jarFileName)) {
                try {
                    this.makeComponent(this.components[i], isSDA);
                    break;
                }
                catch (Exception ex) {
                    throw new Exception("Cannot make component " + this.components[i].getFileName() + " . " + ex.getMessage());
                }
            }
            ++i;
        }
    }

    public void makeComponent(SComponentObject comp, boolean isSDA) throws Exception {
        this.setBeckUpInfo(comp);
        try {
            this.make(comp, isSDA);
        }
        catch (Exception e) {
            this.revert();
            throw e;
        }
        this.commit();
    }

    private void make(SComponentObject comp, boolean isSDA) throws IllegalArgumentException, IOException {
        int i;
        Vector<InfoObject> entries = new Vector<InfoObject>();
        InfoObject[] temp = comp.getJars();
        InfoObject tempInfo = null;
        CPropertyObject[] temp1 = null;
        if (temp == null || temp.length == 0) {
            if (comp.getCompType().equalsIgnoreCase("interface")) {
                temp = new InfoObject[]{};
            } else {
                throw new IllegalArgumentException(NO_JARS + " Name: " + comp.getName() + ".");
            }
        }
        int i2 = 0;
        while (i2 < temp.length) {
            if (temp[i2].getEntryName() == null || temp[i2].getEntryName().trim().equals("")) {
                temp[i2].setEntryName(new File(temp[i2].getFilePath()).getName());
            }
            if (entries.contains(temp[i2])) {
                throw new IllegalArgumentException("Duplicated jar entry " + temp[i2]);
            }
            entries.add(temp[i2]);
            ++i2;
        }
        temp1 = comp.getProviderXMLs();
        if (temp1 == null || temp1.length == 0) {
            throw new IllegalArgumentException("Components contains no provider xmls!");
        }
        int i3 = 0;
        while (i3 < temp1.length) {
            tempInfo = new InfoObject(temp1[i3].getTargetEntry() + "/provider.xml", temp1[i3].getFilePath());
            if (entries.contains(temp1[i3])) {
                throw new IllegalArgumentException("Duplicated jar entry " + temp1[i3]);
            }
            entries.add(tempInfo);
            ++i3;
        }
        temp1 = comp.getPropertyFiles();
        if (temp1 != null) {
            String propFileName = null;
            File propFile = null;
            i = 0;
            while (i < temp1.length) {
                propFile = new File(temp1[i].getFilePath());
                if (propFile.exists()) {
                    propFileName = propFile.getName();
                    tempInfo = new InfoObject(temp1[i].getTargetEntry() + "/" + propFileName, temp1[i].getFilePath());
                    if (!entries.contains(temp1[i])) {
                        entries.add(tempInfo);
                    } else {
                        throw new IllegalArgumentException("Duplicated jar entry " + temp1[i]);
                    }
                }
                ++i;
            }
        }
        if ((temp1 = comp.getServiceDirs()) != null) {
            File serviceDir = null;
            File[] fileList = null;
            i = 0;
            while (i < temp1.length) {
                serviceDir = new File(temp1[i].getFilePath());
                if (serviceDir.exists()) {
                    fileList = serviceDir.listFiles();
                    int i1 = 0;
                    while (i1 < fileList.length) {
                        if (fileList[i1].isFile()) {
                            entries.add(new InfoObject(temp1[i].getTargetEntry() + "/persistent/" + fileList[i1].getName(), fileList[i1].getAbsolutePath()));
                        }
                        ++i1;
                    }
                } else {
                    throw new IllegalArgumentException("Dir entry " + temp1[i].getFilePath() + " does not exists!");
                }
                ++i;
            }
        }
        File tmpFiles = null;
        if (isSDA && comp.getCompType().equalsIgnoreCase("library")) {
            tmpFiles = this.createLib630SDA(entries, comp);
        }
        JarUtils jarUtil = new JarUtils();
        String jarName = comp.getFileName();
        if (!isSDA) {
            if (!jarName.endsWith(".jar")) {
                comp.setFileName(jarName + ".jar");
            }
        } else if (jarName.endsWith(".jar")) {
            comp.setFileName(jarName.substring(0, jarName.length() - 4) + ".sda");
        } else if (!jarName.endsWith(".sda")) {
            comp.setFileName(jarName + ".sda");
        }
        jarUtil.makeJarFromFiles(comp.getFileName(), entries);
        this.deleteFiles(tmpFiles);
    }

    private File createLib630SDA(Vector entries, SComponentObject comp) {
        LibrarySDA630Helper lib630 = new LibrarySDA630Helper(comp.getFileName().substring(0, comp.getFileName().lastIndexOf(File.separator)));
        try {
            return lib630.createLibraryObjects(entries, comp.getFileName().substring(comp.getFileName().lastIndexOf(File.separator) + 1, comp.getFileName().length()), this.getLibVendor(comp), comp.getName(), comp.getJars());
        }
        catch (IOException ioEx) {
            this.actionManager.toLog("Cannot create library SDA. \n" + this.actionManager.loadStackTrace(ioEx));
            return null;
        }
    }

    private String getLibVendor(SComponentObject comp) {
        String vendor = "SAP AG";
        String xmlFile = comp.getProviderXMLs()[0].getFilePath();
        LibProviderDocument doc = new LibProviderDocument();
        try {
            doc = this.actionManager.parseLibXML(xmlFile);
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            this.actionManager.toLog("Cannot parse library xml while getting library provider. \n" + this.actionManager.loadStackTrace(ioEx));
        }
        vendor = doc.getProviderName();
        return vendor;
    }

    private void deleteFiles(File file) {
        if (file != null) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.deleteFiles(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
            file.delete();
        }
    }

    private void setBeckUpInfo(SComponentObject comp) {
        this.originalFile = new File(comp.getFileName());
        this.tempFile = new File(comp.getFileName() + System.currentTimeMillis());
        if (!this.originalFile.exists()) {
            this.tempFile = null;
        } else {
            try {
                FileUtils.copyFile(this.originalFile, this.tempFile);
            }
            catch (Exception e) {
                this.actionManager.toLog("Backup information is not saved correctly:\n" + e.toString());
            }
        }
    }

    private void revert() {
        this.originalFile.delete();
        try {
            FileUtils.copyFile(this.tempFile, this.originalFile);
        }
        catch (Exception e) {
            this.actionManager.toLog("Error occurred while processing revert for server components generation:\n" + e.toString());
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    public void setServerComponentsActionManager(ServerComponentsActionManager scem) {
        this.actionManager = scem;
    }

    private void commit() {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }
}

