/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.server;

import com.sap.engine.lib.jar.InfoObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class LibrarySDA630Helper {
    private static final String NAME = "Name: ";
    private static final String ATT_CONTENT = "content: ";
    private static final String ATT_ADD_INFO = "Manifest-Version: 1.0\nCreated-By: Ant 1.4.1";
    private static final String SDA_XML = "sda_javalib.xml";
    private static final String MANIFEST = "MANIFEST.MF";
    private static final String SAP_MANIFEST = "SAP_MANIFEST.MF";
    private static final String META = "META-INF";
    private Vector sap_m = new Vector();
    private String tmpPath;
    private String[] SAP_XML_CONTENT = new String[]{"<?xml version=\"1.0\" ?>", "<SDA>", "  <!-- generic SDA deployment descriptor for java libraries -->", "  <SoftwareType>JAVA-LIB</SoftwareType>", "</SDA>"};
    private String[] MANIFEST_CONTENT = new String[]{"Manifest-Version: 1.0", "Specification-Title: ", "Specification-Vendor: ", "Implementation-Vendor-Id: 000", "Implementation-Vendor: localmake", "Specification-Version: 6.20", "Implementation-Version: 0.0.0", "Implementation-Title: ", "Implementation-Version: 6.3004.00.0000." + this.calcDate() + ".0000"};
    private String[] SAP_MANIFEST_CONTENT = new String[]{"Manifest-Version: 1.0", "SDM-SDA-Comp-Version: 1", "Ext-SDM-SDA-Comp-Version: 1", "softwaretype: JAVA-LIB", "JarSAP-Version: 20020805.1605", "JarSAPProcessing-Version: 20021104.1705.620", "changelistnumber: 0000", "perforceserver: 0000", "deployfile: sda_javalib.xml", "keyname: ", "keyvendor: sap.com", "keylocation: SAP AG", "keycounter: 6.3004.00.0000." + this.calcDate() + ".0000", "JarSL-Version: 20021004.1205.620", "compress: true"};

    public LibrarySDA630Helper(String projectPath) {
        this.tmpPath = projectPath + File.separator + "tmp" + System.currentTimeMillis();
    }

    public File createLibraryObjects(Vector entries, String jarName, String vendor, String libName, InfoObject[] jars) throws IOException {
        File tmp = new File(this.tmpPath);
        if (vendor == null || vendor.equals("")) {
            vendor = "SAP AG";
        }
        if (!tmp.mkdirs()) {
            throw new IOException("Needed entries for SDA archive cannot be made because of error in this path:\n" + tmp);
        }
        InfoObject xml = this.createSDA_XML();
        entries.addElement(xml);
        entries.addElement(this.createManifest(jarName, vendor, libName));
        entries.addElement(this.createSAPManifest(jars, xml.getFilePath(), vendor, libName));
        return tmp;
    }

    public InfoObject createSDA_XML() throws IOException {
        return this.writeFile(SDA_XML, this.SAP_XML_CONTENT);
    }

    public InfoObject createManifest(String jar, String vendor, String lib) throws IOException {
        this.MANIFEST_CONTENT[1] = this.MANIFEST_CONTENT[1] + jar;
        this.MANIFEST_CONTENT[2] = this.MANIFEST_CONTENT[2] + vendor;
        this.MANIFEST_CONTENT[7] = this.MANIFEST_CONTENT[7] + lib;
        return this.writeFile(MANIFEST, this.MANIFEST_CONTENT);
    }

    public InfoObject createSAPManifest(InfoObject[] jars, String xmlPath, String vendor, String libName) throws IOException {
        int i = 0;
        while (i < this.SAP_MANIFEST_CONTENT.length) {
            if (i == 9) {
                this.sap_m.addElement(this.SAP_MANIFEST_CONTENT[i] + vendor + "." + libName);
            } else {
                this.sap_m.addElement(this.SAP_MANIFEST_CONTENT[i]);
            }
            ++i;
        }
        this.createAdditionalInfo(jars);
        this.SAP_MANIFEST_CONTENT = new String[this.sap_m.size()];
        this.sap_m.copyInto(this.SAP_MANIFEST_CONTENT);
        return this.writeFile(SAP_MANIFEST, this.SAP_MANIFEST_CONTENT);
    }

    /*
     * Loose catch block
     */
    private InfoObject writeFile(String name, String[] content) throws IOException {
        RandomAccessFile sdaEntry = null;
        String _ = File.separator;
        String fileName = this.tmpPath + _ + META + _ + name;
        new File(this.tmpPath + _ + META).mkdirs();
        sdaEntry = new RandomAccessFile(fileName, "rw");
        int i = 0;
        while (i < content.length) {
            sdaEntry.write((content[i] + "\n").getBytes());
            ++i;
        }
        Object var10_7 = null;
        sdaEntry.close();
        {
            catch (FileNotFoundException fnfEx) {
                throw fnfEx;
            }
            catch (IOException ioEx) {
                throw ioEx;
            }
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            sdaEntry.close();
            throw throwable;
        }
        return new InfoObject(META + _ + name, fileName);
    }

    public boolean createAdditionalInfo(InfoObject[] filelist) {
        int i = 0;
        while (i < filelist.length) {
            InfoObject nextfile = filelist[i];
            String entryname = nextfile.getEntryName();
            this.sap_m.addElement("");
            this.sap_m.addElement(NAME + entryname);
            this.sap_m.addElement(ATT_ADD_INFO);
            this.sap_m.addElement("");
            this.sap_m.addElement(NAME + entryname);
            this.sap_m.addElement(ATT_CONTENT);
            ++i;
        }
        this.sap_m.addElement("");
        this.sap_m.addElement("Name: META-INF/sda_javalib.xml");
        this.sap_m.addElement(ATT_CONTENT);
        return true;
    }

    private String calcDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        Date currTime = new Date();
        return df.format(currTime);
    }
}

