/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.manager.component;

import com.sap.engine.deploy.ToolBundle;
import com.sap.engine.deploy.manager.DeployManagerException;
import com.sap.engine.deploy.manager.LoginInfo;
import com.sap.engine.deploy.manager.component.ComponentInfo;
import com.sap.engine.deploy.manager.component.LibraryUpdater;
import com.sap.engine.deploy.manager.component.SComponentsXmlDocument;
import com.sap.engine.deploy.server.provider.LibProviderDocument;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.file.FileTransfer;
import com.sap.engine.services.file.RemoteFile;
import com.sap.engine.services.rmi_p4.P4ObjectBroker;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.w3c.dom.Document;

public class ServerComponentsManager {
    private ComponentInfo[] components = null;
    private Properties substitutions = null;
    private String tempDir;
    private String xmlFile = null;
    private SComponentsXmlDocument document = null;
    private P4ObjectBroker broker = null;
    private InitialContext ctx = null;
    private DeployService deployService = null;
    private FileTransfer fileTransfer = null;
    private LoginInfo login = null;
    private StringWriter strWr = new StringWriter();
    private boolean debug = false;
    private StandardDOMParser parser = null;
    private StandardDOMWriter writer = null;
    private String systemVoilationMessage = null;

    public ServerComponentsManager() {
        this.initXMLToolkit();
    }

    public ServerComponentsManager(String xmlFile) {
        this.setXmlFile(xmlFile);
        this.initXMLToolkit();
    }

    public void setComponents(ComponentInfo[] components) {
        this.components = components;
    }

    public ComponentInfo[] getComponents() {
        return this.components;
    }

    public void loadXMLFile() throws IOException {
        Document doc = null;
        this.document = new SComponentsXmlDocument();
        try {
            doc = this.parser.parse(this.xmlFile);
            this.document.loadFieldsFromDocument(doc);
            this.components = this.document.getComponemnts();
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public String[] makeXml() {
        if (this.document == null) {
            return null;
        }
        Vector<String> errors = new Vector<String>();
        ComponentInfo[] compInfo = this.document.getComponemnts();
        if (compInfo != null) {
            int i = 0;
            while (i < compInfo.length) {
                try {
                    if (compInfo[i].getCompType().equals("library")) {
                        this.makeComponent(null, compInfo[i].getName(), compInfo[i].getFileName(), compInfo[i].getActionType(), compInfo[i].getCompType());
                    } else if (compInfo[i].getCompType().equals("service")) {
                        this.makeComponent(null, compInfo[i].getName(), compInfo[i].getFileName(), compInfo[i].getActionType(), compInfo[i].getCompType());
                    } else if (compInfo[i].getCompType().equals("interface")) {
                        this.makeComponent(null, compInfo[i].getName(), compInfo[i].getFileName(), compInfo[i].getActionType(), compInfo[i].getCompType());
                    }
                }
                catch (DeployManagerException dme) {
                    errors.add(ToolBundle.getResourceString("dm_err_msg_0026", new Object[]{compInfo[i].getFileName(), dme.getMessage()}));
                }
                ++i;
            }
        } else {
            return null;
        }
        if (errors.size() > 0) {
            Object[] result = new String[errors.size()];
            errors.copyInto(result);
            return result;
        }
        return null;
    }

    public void deployLibrary(String name, String libJar) throws DeployManagerException {
        this.makeComponent(null, name, libJar, "deploy", "library");
    }

    public void removeLibrary(String libName) throws DeployManagerException {
        this.makeComponent(null, libName, null, "remove", "library");
    }

    public void removeLibrary(String providerName, String libName) throws DeployManagerException {
        this.makeComponent(providerName, libName, null, "remove", "library");
    }

    public void deployService(String name, String serviceJar) throws DeployManagerException {
        throw new DeployManagerException("dm_err_msg_0027");
    }

    public void removeService(String serviceName) throws DeployManagerException {
        throw new DeployManagerException("dm_err_msg_0028");
    }

    public void deployInterface(String name, String intfJar) throws DeployManagerException {
        throw new DeployManagerException("dm_err_msg_0027");
    }

    public void removeInterface(String intfName) throws DeployManagerException {
        throw new DeployManagerException("dm_err_msg_0028");
    }

    public void makeComponent(String providerName, String compName, String compJar, String action, String type) throws DeployManagerException {
        String c;
        block15: {
            DeployService deploy = null;
            String message = null;
            c = action.equals("remove") ? compName : compJar;
            String substFile = null;
            try {
                String serverSideLocation = null;
                if (!"remove".equals(action)) {
                    LibraryUpdater updater = new LibraryUpdater();
                    String newCompJar = new File(this.tempDir, "temp_" + new File(compJar).getName()).getAbsolutePath();
                    updater.setSubstitutions(this.substitutions);
                    updater.setSystemVarViolations(null);
                    substFile = updater.checkSubstitutions(compJar, newCompJar);
                    this.proccesSystemVarVoilations(updater);
                    File compJarFile = null;
                    compJarFile = new File(substFile);
                    if (!compJarFile.exists()) {
                        throw new DeployManagerException(type + " jar does not exist!");
                    }
                    serverSideLocation = "./temp/deploy/work/deploying/" + compJarFile.getName();
                }
                deploy = this.obtainDeployService();
                this.fileTransfer = this.obtainFileTransfer();
                RemoteFile remoteF = null;
                if (action.equals("deploy")) {
                    remoteF = this.fileTransfer.createRemoteFile(substFile, serverSideLocation);
                    remoteF.upload();
                    if (type.equals("library")) {
                        deploy.deployLibrary(serverSideLocation, compName);
                        break block15;
                    }
                    if (type.equals("service")) {
                        throw new DeployManagerException("dm_err_msg_0027");
                    }
                    if (type.equals("interface")) {
                        throw new DeployManagerException("dm_err_msg_0027");
                    }
                    throw new DeployManagerException("dm_err_msg_0024");
                }
                if (action.equals("remove")) {
                    if (type.equals("library")) {
                        if (providerName != null) {
                            deploy.removeLibrary(providerName, compName);
                        } else {
                            deploy.removeLibrary(compName);
                        }
                        break block15;
                    }
                    if (type.equals("service")) {
                        deploy.removeService(compName);
                        break block15;
                    }
                    if (type.equals("interface")) {
                        deploy.removeInterface(compName);
                        break block15;
                    }
                    throw new DeployManagerException("dm_err_msg_0024");
                }
                if (action.equals("update")) {
                    throw new DeployManagerException("Not implemented action type update.");
                }
                throw new DeployManagerException("dm_err_msg_0025");
            }
            catch (Exception e) {
                message = e.getMessage();
                this.strWr = new StringWriter();
                e.printStackTrace(new PrintWriter(this.strWr));
                this.toLog("dm_msg_0065", new Object[]{action, type, c, message, this.strWr.getBuffer()});
                message = ToolBundle.getResourceString("dm_msg_0065", new Object[]{action, type, c, this.strWr.getBuffer()});
                throw new DeployManagerException(message);
            }
        }
        this.toLog("Action " + action + " over " + type + " component " + c + " finished successfully!");
    }

    public void makeReferences(String fromAplication, String providerName, ReferenceObject[] refs) throws DeployManagerException {
        if (fromAplication == null || fromAplication.trim().equals("") || refs == null || refs.length == 0) {
            throw new DeployManagerException("dm_err_msg_0021");
        }
        DeployService deploy = null;
        Object messsage = null;
        String eToString = null;
        String to = null;
        String p = refs[0].getReferenceProviderName();
        to = p == null ? refs[0].getReferenceTarget() : p + "/" + refs[0].getReferenceTarget();
        int i = 0;
        while (i < refs.length) {
            to = to + ", " + (p == null || p.trim().equals("") ? refs[i].getReferenceTarget() : p + "/" + refs[i].getReferenceTarget());
            ++i;
        }
        try {
            deploy = this.obtainDeployService();
            deploy.makeReferences(providerName, fromAplication, refs);
        }
        catch (DeployManagerException dme) {
            eToString = dme.toString();
        }
        catch (NamingException ne) {
            eToString = ne.toString();
        }
        catch (Exception e1) {
            eToString = e1.toString();
        }
        if (eToString != null) {
            this.toLog("dm_err_msg_0022", new Object[]{fromAplication, to, eToString});
            throw new DeployManagerException("dm_err_msg_0022", new Object[]{fromAplication, to, eToString});
        }
        this.toLog("dm_msg_0066", new Object[]{fromAplication, to});
    }

    public void makeReferences(String fromLoader, String[] toLoaders) throws DeployManagerException {
        DeployService deploy = null;
        Object messsage = null;
        String eToString = null;
        String to = null;
        try {
            if (fromLoader == null || fromLoader.equals("") || toLoaders == null || toLoaders.length == 0) {
                throw new DeployManagerException("dm_err_msg_0021");
            }
            to = toLoaders[0];
            int i = 1;
            while (i < toLoaders.length) {
                to = to + ", " + toLoaders[i];
                ++i;
            }
            deploy = this.obtainDeployService();
            deploy.makeReferences(fromLoader, toLoaders);
        }
        catch (DeployManagerException dme) {
            eToString = dme.toString();
        }
        catch (NamingException ne) {
            eToString = ne.toString();
        }
        catch (Exception e1) {
            eToString = e1.toString();
        }
        if (eToString != null) {
            this.toLog("dm_err_msg_0022", new Object[]{fromLoader, to, eToString});
            throw new DeployManagerException("dm_err_msg_0022", new Object[]{fromLoader, to, eToString});
        }
        this.toLog("dm_msg_0066", new Object[]{fromLoader, to});
    }

    public void removeReferences(String providerName, String fromApplication, ReferenceObject[] references) throws RemoteException, DeployManagerException {
        DeployService deploy = null;
        Object messsage = null;
        Object eToString = null;
        String to = null;
        if (fromApplication == null || references == null || references.length == 0) {
            throw new DeployManagerException("dm_err_msg_0021");
        }
        to = references[0].toString();
        int i = 0;
        while (i < references.length) {
            to = to + "," + references[i];
            ++i;
        }
        try {
            deploy = this.obtainDeployService();
            deploy.removeReferences(providerName, fromApplication, references);
        }
        catch (WarningException wex) {
            this.toLog("WarningException occurred while removing references.\n" + wex.toString());
        }
        catch (Exception e) {
            this.strWr = new StringWriter();
            e.printStackTrace(new PrintWriter(this.strWr));
            this.toLog("dm_err_msg_0023", new Object[]{fromApplication, to, this.strWr});
            throw new DeployManagerException("dm_err_msg_0023", new Object[]{fromApplication, to, this.strWr});
        }
        this.toLog("dm_msg_0067", new Object[]{fromApplication, to});
    }

    public void removeReferences(String fromLoader, String[] toLoaders) throws DeployManagerException {
        DeployService deploy = null;
        Object messsage = null;
        String eToString = null;
        String to = null;
        try {
            if (fromLoader == null || fromLoader.equals("") || toLoaders == null || toLoaders.length == 0) {
                throw new DeployManagerException("dm_err_msg_0021");
            }
            to = toLoaders[0];
            int i = 1;
            while (i < toLoaders.length) {
                to = to + ", " + toLoaders[i];
                ++i;
            }
            deploy = this.obtainDeployService();
            deploy.removeReferences(fromLoader, toLoaders);
        }
        catch (DeployManagerException dme) {
            eToString = dme.toString();
        }
        catch (NamingException ne) {
            eToString = ne.toString();
        }
        catch (WarningException wex) {
            this.toLog("WarningException occurred while removing references.\n" + wex.toString());
        }
        catch (Exception e1) {
            eToString = e1.toString();
        }
        if (eToString != null) {
            this.toLog("dm_err_msg_0023", new Object[]{fromLoader, to, eToString});
            throw new DeployManagerException("dm_err_msg_0023", new Object[]{fromLoader, to, eToString});
        }
        this.toLog("dm_msg_0067", new Object[]{fromLoader, to});
    }

    public String updateLibrary(String jar, String libraryName, String providerName, String tempDir) throws Exception {
        ZipFile zip = null;
        JarEntry entry = null;
        String entryName = null;
        InputStream xmlIs = null;
        FileOutputStream fos = null;
        ZipOutputStream jos = null;
        File tempFile = new File(tempDir, "temp_" + new File(jar).getName());
        File tempProviderXml = new File(tempDir, "temp_provider.xml");
        BufferedInputStream bis = null;
        JarEntry newEntry = null;
        byte[] bytes = null;
        CRC32 crc = null;
        if (!new File(tempDir).exists()) {
            new File(tempDir).mkdirs();
        }
        try {
            fos = new FileOutputStream(tempFile);
            jos = new JarOutputStream(fos);
            zip = new JarFile(jar);
            Enumeration<JarEntry> enumeration = ((JarFile)zip).entries();
            while (enumeration.hasMoreElements()) {
                entry = enumeration.nextElement();
                entryName = entry.getName();
                if (entryName.replace('\\', '/').equalsIgnoreCase("server/provider.xml")) {
                    xmlIs = ((JarFile)zip).getInputStream(entry);
                    LibProviderDocument libDoc = new LibProviderDocument();
                    this.parser.setSystemId(jar + "#server/provider.xml");
                    libDoc.setMainDocument(this.parser.parse(xmlIs));
                    libDoc.loadFieldsFromDocument();
                    libDoc.setProviderName(providerName);
                    libDoc.setComponentName(libraryName);
                    libDoc.loadDocumentFromFields();
                    this.writer.write(libDoc.getMainDocument(), tempProviderXml.getAbsolutePath(), "<!DOCTYPE provider-descriptor SYSTEM \"library.provider.dtd\">", "UTF-8");
                    bis = new BufferedInputStream(new FileInputStream(tempProviderXml));
                    xmlIs.close();
                } else {
                    bis = new BufferedInputStream(((JarFile)zip).getInputStream(entry));
                }
                newEntry = new JarEntry(entryName);
                newEntry.setMethod(0);
                bytes = new byte[bis.available()];
                bis.read(bytes, 0, bytes.length);
                bis.close();
                newEntry.setSize(bytes.length);
                crc = new CRC32();
                crc.update(bytes);
                newEntry.setCrc(crc.getValue());
                ((JarOutputStream)jos).putNextEntry(newEntry);
                jos.write(bytes, 0, bytes.length);
                jos.closeEntry();
            }
            Object var20_20 = null;
        }
        catch (Throwable throwable) {
            Object var20_21 = null;
            jos.close();
            fos.close();
            zip.close();
            tempProviderXml.delete();
            throw throwable;
        }
        jos.close();
        fos.close();
        zip.close();
        tempProviderXml.delete();
        return tempFile.getAbsolutePath();
    }

    public void setXmlFile(String file) {
        this.xmlFile = file;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    private void toLog(String str, String param) {
        this.toLog(ToolBundle.getResourceString(str, param));
    }

    private void toLog(String str, Object[] params) {
        this.toLog(ToolBundle.getResourceString(str, params));
    }

    public void toLog(String message) {
        if (this.debug) {
            System.out.println("log: " + message);
        }
    }

    private DeployService obtainDeployService() throws Exception {
        if (this.ctx == null || this.deployService == null) {
            this.setBroker();
            this.deployService = (DeployService)this.ctx.lookup("deploy");
            this.fileTransfer = (FileTransfer)this.ctx.lookup("file");
        }
        return this.deployService;
    }

    private FileTransfer obtainFileTransfer() throws Exception {
        if (this.ctx == null || this.fileTransfer == null) {
            this.setBroker();
            this.deployService = (DeployService)this.ctx.lookup("deploy");
            this.fileTransfer = (FileTransfer)this.ctx.lookup("file");
        }
        return this.fileTransfer;
    }

    public void setLoginInfo(LoginInfo info) {
        this.ctx = null;
        this.login = info;
    }

    private void setBroker() throws DeployManagerException {
        try {
            Properties ctxProp = new Properties();
            ((Hashtable)ctxProp).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
            ((Hashtable)ctxProp).put("java.naming.provider.url", this.login.getRemoteHost() + ":" + this.login.getRemotePort());
            ((Hashtable)ctxProp).put("java.naming.security.principal", this.login.getUserName());
            ((Hashtable)ctxProp).put("java.naming.security.credentials", this.login.getUserPassword());
            if (this.debug) {
                System.out.println("LOGIN in USERMANAGER Host :" + this.login.getRemoteHost());
                System.out.println("LOGIN in USERMANAGER name :" + this.login.getUserName());
            }
            this.broker = P4ObjectBroker.init();
            this.ctx = new InitialContext(ctxProp);
        }
        catch (Exception e) {
            this.strWr = new StringWriter();
            e.printStackTrace(new PrintWriter(this.strWr));
            throw new DeployManagerException("dm_err_msg_0012", new Object[]{this.login.getRemoteHost(), this.login.getUserName(), this.strWr.toString()});
        }
    }

    private void initXMLToolkit() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.writer = new StandardDOMWriter();
        this.parser = new StandardDOMParser();
        Thread.currentThread().setContextClassLoader(cl);
    }

    public void setSubstitutions(Properties substitutions) {
        this.substitutions = substitutions;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    private void proccesSystemVarVoilations(LibraryUpdater updater) {
        this.systemVoilationMessage = null;
        String[] voilations = updater.getSystemVarViolations();
        this.systemVoilationMessage = "";
        if (voilations != null && voilations.length > 0) {
            int i = 0;
            while (i < voilations.length) {
                this.systemVoilationMessage = this.systemVoilationMessage + "\n";
                ++i;
            }
        }
    }

    public String getSystemVoilationMessage() {
        return this.systemVoilationMessage;
    }
}

