/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.manager;

import com.sap.engine.deploy.SimpleEARClassLoader;
import com.sap.engine.deploy.manager.LoginInfo;
import com.sap.engine.deploy.manager.UserInfo;
import com.sap.engine.deploy.manager.UserRoleMappings;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.lib.xml.dom.NodeListImpl;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.ContextParam;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.extended.ear.EARDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DeployManagerDocument {
    private String earPath;
    private String prjDir;
    private LoginInfo info = new LoginInfo();
    private String[] supports;
    private EntityDescriptor[] descriptors;
    private SecurityRoles[] roles;
    private String logFile = null;
    private Hashtable descrTable;
    private Properties deployProp;
    private String containerType = "B";
    protected static final String TYPE_A = "A";
    protected static final String TYPE_B = "B";
    public static final String ACTION_TYPE_DEPLOY = "deploy";
    public static final String ACTION_TYPE_UPDATE = "update";
    private String action_type;
    private UserRoleMappings roleMapTable;
    private String versionId = null;
    private String[] referenced_library;
    private Hashtable deployable_library;
    private Hashtable addRefs = null;
    private StandardDOMParser parser = null;
    public static final String dtd = "<!DOCTYPE DeployMgmInf [\n<!ELEMENT DeployMgmInf (project-dir?, xml-ear-path, supports, storage-properties?, user-role-mapping, version-id?, additional-info?,login-info, log-file?, library-info?, deployment-properties?)>\n<!ELEMENT project-dir (#PCDATA)>\n<!ELEMENT xml-ear-path (#PCDATA)>\n<!ATTLIST xml-ear-path action-type (deploy|update) #REQUIRED>\n<!ELEMENT supports (support+)>\n<!ELEMENT support (#PCDATA)>\n<!ELEMENT type (#PCDATA)>\n<!ELEMENT storage-properties (EntityEJBStorages)>\n<!ELEMENT EntityEJBStorages (EntityEJB)*>\n<!ELEMENT EntityEJB (Storage)>\n<!ATTLIST EntityEJB Name CDATA #REQUIRED>\n<!ELEMENT Storage (RDBStorageProps)>\n<!ATTLIST Storage StorageName CDATA #REQUIRED ClassName CDATA #REQUIRED>\n<!ELEMENT RDBStorageProps (FieldColumnMap*, rdbFinderDescriptor*)>\n<!ATTLIST RDBStorageProps PoolName CDATA #REQUIRED  TableName CDATA #REQUIRED>\n<!ELEMENT FieldColumnMap (#PCDATA)>\n<!ATTLIST FieldColumnMap Field CDATA #REQUIRED Table CDATA #REQUIRED Column CDATA #REQUIRED Key CDATA #REQUIRED>\n<!ELEMENT rdbFinderDescriptor (MethodArgument*)>\n<!ATTLIST rdbFinderDescriptor MethodName CDATA #REQUIRED Criteria CDATA #REQUIRED >\n<!ELEMENT MethodArgument (#PCDATA)>\n<!ELEMENT user-role-mapping (role-name+)>\n<!ELEMENT role-name (#PCDATA|mapping)*>\n<!ELEMENT mapping (name,type)>\n<!ELEMENT name (#PCDATA)>\n<!ELEMENT login-info (host, port, transport-protocol*, user-name, user-password)>\n<!ELEMENT host (#PCDATA)>\n<!ELEMENT port (#PCDATA)>\n<!ELEMENT transport-protocol (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT user-password (#PCDATA)>\n<!ELEMENT version-id (#PCDATA)>\n<!ELEMENT additional-info (archives)>\n<!ELEMENT archives (ejb-jar*, war*, client-jar*)>\n<!ELEMENT ejb-jar (archive-name, ejbean+)>\n<!ELEMENT ejbean (bean-name, ejb-ref*, res-ref*, entry*)>\n<!ELEMENT war (archive-name, ejb-ref*, res-ref*, entry*, context-param*)>\n<!ELEMENT client-jar (archive-name, ejb-ref*, res-ref*, entry*)>\n<!ELEMENT archive-name (#PCDATA)>\n<!ELEMENT bean-name (#PCDATA)>\n<!ELEMENT entry (entry-name, value)>\n<!ELEMENT entry-name (#PCDATA)>\n<!ELEMENT value (#PCDATA)>\n<!ELEMENT res-ref (ref-name, ref-link)>\n<!ELEMENT ref-name (#PCDATA)>\n<!ELEMENT ref-link (#PCDATA)>\n<!ELEMENT ejb-ref (ref-name, ref-link)>\n<!ELEMENT context-param (param-name, param-value, description)>\n<!ELEMENT param-name (#PCDATA)>\n<!ELEMENT param-value (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT log-file (#PCDATA)>\n<!ELEMENT library-info (referenced-library*, deployable-library*)>\n<!ELEMENT referenced-library (#PCDATA)>\n<!ELEMENT deployable-library (lib-name, lib-jar*)>\n<!ELEMENT lib-name (#PCDATA)>\n<!ELEMENT lib-jar (#PCDATA)>\n<!ATTLIST lib-jar server-map-name CDATA #REQUIRED>\n<!ELEMENT deployment-properties (property*)>\n<!ELEMENT property (#PCDATA)>\n]>";
    protected Document mainDocument;
    protected Element mainElement;

    public DeployManagerDocument() {
        this.initXMLToolkit();
    }

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public void setMainDocument(Document doc) {
        this.mainDocument = doc;
    }

    public Document loadDocumentFromFields() throws Exception {
        Element tempElement = null;
        this.mainDocument = StandardDOMParser.createDocument();
        this.mainElement = this.mainDocument.createElement("DeployMgmInf");
        this.mainDocument.appendChild(this.mainElement);
        if (this.prjDir != null) {
            this.load(this.mainElement, this.prjDir, "project-dir");
        }
        if (this.earPath != null) {
            this.earPath = this.getRelativePath(this.earPath);
            tempElement = this.load(this.mainElement, this.earPath, "xml-ear-path");
            tempElement.setAttribute("action-type", this.action_type);
        }
        tempElement = this.mainDocument.createElement("supports");
        this.loadSupport(tempElement);
        this.mainElement.appendChild(tempElement);
        tempElement = this.mainDocument.createElement("user-role-mapping");
        this.loadUserRole(tempElement);
        this.mainElement.appendChild(tempElement);
        this.load(this.mainElement, this.versionId, "version-id");
        if (this.descrTable != null && !this.descrTable.isEmpty()) {
            tempElement = this.mainDocument.createElement("additional-info");
            this.loadAdditionalInfo(tempElement);
            this.mainElement.appendChild(tempElement);
        }
        tempElement = this.mainDocument.createElement("login-info");
        this.loadLoginInfo(tempElement);
        this.mainElement.appendChild(tempElement);
        if (this.logFile != null) {
            this.load(this.mainElement, this.getRelativePath(this.logFile), "log-file");
        }
        tempElement = this.mainDocument.createElement("library-info");
        if (this.deployable_library != null) {
            this.loadDeployableLibrary(tempElement);
        }
        if (this.referenced_library != null) {
            this.loadReferencedLibrary(tempElement);
        }
        if (this.addRefs != null) {
            this.loadAddRefs(tempElement);
        }
        this.mainElement.appendChild(tempElement);
        tempElement = this.mainDocument.createElement("deployment-properties");
        this.loadDeployProps(tempElement);
        this.mainElement.appendChild(tempElement);
        return this.mainDocument;
    }

    protected void loadReferencedLibrary(Element el) {
        int i = 0;
        while (i < this.referenced_library.length) {
            this.load(el, this.referenced_library[i], "referenced-library");
            ++i;
        }
    }

    protected void loadAddRefs(Element el) {
        String key = null;
        String[] value = null;
        Element refEl = null;
        Enumeration enumeration = this.addRefs.keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            value = (String[])this.addRefs.get(key);
            refEl = this.mainDocument.createElement("add-refs");
            this.load(refEl, key, "fromLoader");
            int i = 0;
            while (i < value.length) {
                this.load(refEl, value[i], "toLoader");
                ++i;
            }
            el.appendChild(refEl);
        }
    }

    protected void loadDeployableLibrary(Element el) {
        Element dplLibEl = null;
        Element tempEl = null;
        String libName = null;
        InfoObject[] jars = null;
        Enumeration enumeration = this.deployable_library.keys();
        while (enumeration.hasMoreElements()) {
            dplLibEl = this.mainDocument.createElement("deployable-library");
            libName = (String)enumeration.nextElement();
            this.load(dplLibEl, libName, "lib-name");
            jars = (InfoObject[])this.deployable_library.get(libName);
            int j = 0;
            while (j < jars.length) {
                tempEl = this.load(dplLibEl, jars[j].getFilePath(), "lib-jar");
                if (jars[j].getEntryName() != null && !jars[j].getEntryName().equals("")) {
                    tempEl.setAttribute("server-map-name", jars[j].getEntryName().trim());
                }
                ++j;
            }
            el.appendChild(dplLibEl);
        }
    }

    protected void loadDeployProps(Element propsEl) {
        if (this.deployProp == null || ((Hashtable)this.deployProp).size() == 0) {
            return;
        }
        String key = null;
        String value = null;
        Enumeration enumeration = ((Hashtable)this.deployProp).keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            value = this.deployProp.getProperty(key);
            this.load(propsEl, key + " = " + value, "property");
        }
        if (this.deployProp.getProperty("container_type") == null) {
            if (this.containerType == null) {
                this.containerType = TYPE_B;
            }
            this.deployProp.setProperty("container_type", this.containerType);
        }
    }

    protected void loadAdditionalInfo(Element addInfoEl) {
        Hashtable archivesTable = this.descrTable;
        Element archivesEl = this.mainDocument.createElement("archives");
        ArchiveDescriptor archDescr = null;
        DeploymentDescriptor[] beanDescr = null;
        String archName = null;
        EJBeanReference[] ejbRef = null;
        ResourceReference[] resRef = null;
        EnvironmentEntry[] envEntr = null;
        ContextParam[] contextParam = null;
        Element ejbJarEl = null;
        Element ejBeanEl = null;
        Element warEl = null;
        Element clientJarEl = null;
        Enumeration enumeration = archivesTable.keys();
        while (enumeration.hasMoreElements()) {
            archName = (String)enumeration.nextElement();
            archDescr = (ArchiveDescriptor)archivesTable.get(archName);
            if (archName.indexOf(File.separator) != -1) {
                archName = archName.substring(archName.lastIndexOf(File.separator) + 1);
            }
            if (!(archDescr instanceof EJBJarDescriptor)) continue;
            beanDescr = ((EJBJarDescriptor)archDescr).getDDescriptors();
            ejbJarEl = this.mainDocument.createElement("ejb-jar");
            this.load(ejbJarEl, archName, "archive-name");
            if (beanDescr != null) {
                int j = 0;
                while (j < beanDescr.length) {
                    ejBeanEl = this.mainDocument.createElement("ejbean");
                    this.load(ejBeanEl, beanDescr[j].getName(), "bean-name");
                    ejbRef = beanDescr[j].getEJBeanReferences();
                    resRef = beanDescr[j].getResourceReferences();
                    envEntr = beanDescr[j].getEnvironmentEntries();
                    if (ejbRef != null) {
                        this.loadEJBRef(ejBeanEl, ejbRef);
                    }
                    if (resRef != null) {
                        this.loadResourceRef(ejBeanEl, resRef);
                    }
                    if (envEntr != null) {
                        this.loadEnvEntr(ejBeanEl, envEntr);
                    }
                    ejbJarEl.appendChild(ejBeanEl);
                    ++j;
                }
            }
            archivesEl.appendChild(ejbJarEl);
        }
        enum = archivesTable.keys();
        while (enum.hasMoreElements()) {
            archName = (String)enum.nextElement();
            archDescr = (ArchiveDescriptor)archivesTable.get(archName);
            if (archName.indexOf(File.separator) != -1) {
                archName = archName.substring(archName.lastIndexOf(File.separator) + 1);
            }
            if (!(archDescr instanceof WebDeploymentDescriptor)) continue;
            warEl = this.mainDocument.createElement("war");
            this.load(warEl, archName, "archive-name");
            resRef = ((WebDeploymentDescriptor)archDescr).getResReferences();
            ejbRef = ((WebDeploymentDescriptor)archDescr).getEjbRefs();
            envEntr = ((WebDeploymentDescriptor)archDescr).getEnvEntries();
            contextParam = ((WebDeploymentDescriptor)archDescr).getContextParams();
            if (ejbRef != null) {
                this.loadEJBRef(warEl, ejbRef);
            }
            if (resRef != null) {
                this.loadResourceRef(warEl, resRef);
            }
            if (envEntr != null) {
                this.loadEnvEntr(warEl, envEntr);
            }
            if (contextParam != null) {
                this.loadContextParam(warEl, contextParam);
            }
            archivesEl.appendChild(warEl);
        }
        enum = archivesTable.keys();
        while (enum.hasMoreElements()) {
            archName = (String)enum.nextElement();
            archDescr = (ArchiveDescriptor)archivesTable.get(archName);
            if (archName.indexOf(File.separator) != -1) {
                archName = archName.substring(archName.lastIndexOf(File.separator) + 1);
            }
            if (!(archDescr instanceof ApplicationClientDescriptor)) continue;
            clientJarEl = this.mainDocument.createElement("client-jar");
            this.load(clientJarEl, archName, "archive-name");
            resRef = ((ApplicationClientDescriptor)archDescr).getResourceReferences();
            ejbRef = ((ApplicationClientDescriptor)archDescr).getEJBeanReferences();
            envEntr = ((ApplicationClientDescriptor)archDescr).getEnvironmentProperties();
            if (ejbRef != null) {
                this.loadEJBRef(clientJarEl, ejbRef);
            }
            if (resRef != null) {
                this.loadResourceRef(clientJarEl, resRef);
            }
            if (envEntr != null) {
                this.loadEnvEntr(clientJarEl, envEntr);
            }
            archivesEl.appendChild(clientJarEl);
        }
        addInfoEl.appendChild(archivesEl);
    }

    protected void loadLoginInfo(Element el) {
        this.load(el, this.info.getRemoteHost(), "host");
        this.load(el, String.valueOf(this.info.getRemotePort()), "port");
        String[] transportProtocol = this.info.getTransportProtocol();
        int i = 0;
        while (i < transportProtocol.length) {
            this.load(el, transportProtocol[i], "transport-protocol");
            ++i;
        }
        this.load(el, this.info.getUserName(), "user-name");
        this.load(el, this.info.getUserPassword(), "user-password");
    }

    protected void loadUserRole(Element el) {
        Element mappingEl = null;
        String roleName = null;
        Element tempEl = null;
        boolean oneAdd = false;
        if (this.roles != null && this.roles.length != 0) {
            int i = 0;
            while (i < this.roles.length) {
                if (this.roles[i] != null) {
                    String[] groupName;
                    String[] userName;
                    roleName = this.roles[i].getRoleName();
                    tempEl = this.load(el, roleName, "role-name");
                    if (!oneAdd) {
                        oneAdd = true;
                    }
                    if ((userName = this.roles[i].getUserNames()) != null) {
                        int j = 0;
                        while (j < userName.length) {
                            mappingEl = this.mainDocument.createElement("mapping");
                            this.load(mappingEl, userName[j], "name");
                            this.load(mappingEl, "user", "type");
                            tempEl.appendChild(mappingEl);
                            ++j;
                        }
                    }
                    if ((groupName = this.roles[i].getUserGroup()) != null) {
                        int j = 0;
                        while (j < groupName.length) {
                            mappingEl = this.mainDocument.createElement("mapping");
                            this.load(mappingEl, groupName[j], "name");
                            this.load(mappingEl, "group", "type");
                            tempEl.appendChild(mappingEl);
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (tempEl != null) {
                el.appendChild(tempEl);
            }
        } else {
            tempEl = this.load(el, "unknown role", "role-name");
            el.appendChild(tempEl);
            oneAdd = true;
        }
        if (!oneAdd) {
            tempEl = this.load(el, "unknown role", "role-name");
            el.appendChild(tempEl);
        }
    }

    protected void loadSupport(Element suppEl) {
        if (this.supports != null) {
            int i = 0;
            while (i < this.supports.length) {
                this.load(suppEl, this.supports[i], "support");
                ++i;
            }
        } else {
            this.load(suppEl, "P4", "support");
        }
    }

    protected Element load(Element el, String value, String tagName) {
        if (value == null) {
            value = "";
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    public void loadFieldsFromDocument(Document document) throws WrongStructureException {
        Element elm = document.getDocumentElement();
        NodeList list = elm.getChildNodes();
        Element element = null;
        String tag = null;
        SimpleEARClassLoader loader = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("xml-ear-path")) {
                    this.earPath = this.getTextValue(element);
                    this.earPath = this.getAbsolutePath(this.earPath);
                    this.action_type = element.getAttribute("action-type");
                    if (this.action_type == null || !this.action_type.equalsIgnoreCase(ACTION_TYPE_UPDATE)) {
                        this.action_type = ACTION_TYPE_DEPLOY;
                    }
                    loader = new SimpleEARClassLoader(null, this.earPath);
                } else if (tag.equals("supports")) {
                    this.supports = this.initSupport(element);
                } else if (tag.equals("storage-properties")) {
                    NodeList listing = element.getElementsByTagName("EntityEJBStorages");
                    Element subEl = (Element)listing.item(0);
                } else if (tag.equals("user-role-mapping")) {
                    this.roles = this.initUserRoles(element);
                } else if (tag.equals("login-info")) {
                    this.initLoginInfo(element);
                } else if (tag.equals("version-id")) {
                    this.versionId = this.getTextValue(element);
                } else if (tag.equals("project-dir")) {
                    if (this.prjDir == null) {
                        this.prjDir = this.getTextValue(element);
                    }
                } else if (tag.equals("container_type")) {
                    this.containerType = null;
                    this.containerType = this.getTextValue(element);
                } else if (tag.equals("deployment-properties")) {
                    this.initDeployProp(element);
                } else if (tag.equals("log-file")) {
                    this.logFile = this.getTextValue(element);
                    if (this.logFile != null) {
                        this.logFile = this.getAbsolutePath(this.logFile);
                    }
                } else if (tag.equals("library-info")) {
                    this.loadLibFromDocument(element);
                    this.LoadAddRefsFromDocument(element);
                }
            }
            ++i;
        }
        if (loader != null) {
            loader.clear();
        }
    }

    protected void LoadAddRefsFromDocument(Element el) {
        this.addRefs = null;
        NodeList list = this.getElementsByTagName(el, "add-refs");
        Element refEl = null;
        NodeList tempList = null;
        String key = null;
        String[] values = null;
        if (list != null) {
            this.addRefs = new Hashtable();
            int i = 0;
            while (i < list.getLength()) {
                refEl = (Element)list.item(i);
                tempList = this.getElementsByTagName(refEl, "fromLoader");
                if (tempList != null && tempList.getLength() > 0) {
                    key = this.getTextValue((Element)tempList.item(0));
                    tempList = this.getElementsByTagName(refEl, "toLoader");
                    if (tempList != null && tempList.getLength() > 0) {
                        values = new String[tempList.getLength()];
                        int j = 0;
                        while (j < tempList.getLength()) {
                            values[j] = this.getTextValue((Element)tempList.item(j));
                            ++j;
                        }
                        this.addRefs.put(key, values);
                    }
                }
                ++i;
            }
        }
    }

    protected void loadLibFromDocument(Element el) {
        int i;
        String libName = null;
        InfoObject[] libJars = null;
        this.deployable_library = null;
        this.referenced_library = null;
        NodeList list = el.getElementsByTagName("deployable-library");
        if (list != null) {
            this.deployable_library = new Hashtable();
            i = 0;
            while (i < list.getLength()) {
                Element tmpEl = (Element)list.item(i);
                NodeList list1 = tmpEl.getElementsByTagName("lib-name");
                if (list1 != null && list1.getLength() > 0 && list1.item(0) != null) {
                    libName = this.getTextValue((Element)list1.item(0));
                }
                if ((list1 = tmpEl.getElementsByTagName("lib-jar")) != null) {
                    libJars = new InfoObject[list1.getLength()];
                    int j = 0;
                    while (j < list1.getLength()) {
                        libJars[j] = new InfoObject();
                        libJars[j].setFilePath(this.getTextValue((Element)list1.item(j)));
                        if (((Element)list1.item(j)).getAttribute("server-map-name") != null) {
                            libJars[j].setEntryName(((Element)list1.item(j)).getAttribute("server-map-name"));
                        }
                        ++j;
                    }
                    this.deployable_library.put(libName, libJars);
                }
                ++i;
            }
        }
        if ((list = el.getElementsByTagName("referenced-library")) != null) {
            this.referenced_library = new String[list.getLength()];
            i = 0;
            while (i < list.getLength()) {
                this.referenced_library[i] = this.getTextValue((Element)list.item(i));
                ++i;
            }
        }
    }

    protected void initDeployProp(Element el) {
        try {
            Element pEl = null;
            NodeList propList = el.getChildNodes();
            if (propList == null || propList.getLength() == 0) {
                this.deployProp = null;
                return;
            }
            this.deployProp = new Properties();
            if (this.containerType != null) {
                this.deployProp.setProperty("container_type", this.containerType);
            }
            ByteArrayInputStream stream = null;
            String value = null;
            int i = 0;
            while (i < propList.getLength()) {
                if (propList.item(i).getNodeType() == 1 && (value = this.getTextValue(pEl = (Element)propList.item(i))) != null) {
                    stream = new ByteArrayInputStream(value.getBytes());
                    try {
                        this.deployProp.load(stream);
                    }
                    catch (IOException ioe) {
                        this.toLog(ioe);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.toLog(e);
        }
    }

    protected void initLoginInfo(Element el) {
        NodeList loginList = el.getChildNodes();
        if (loginList != null) {
            Element loginEl = null;
            String nextElTag = null;
            String value = null;
            Vector<String> protocol = new Vector<String>();
            int i = 0;
            while (i < loginList.getLength()) {
                if (loginList.item(i).getNodeType() == 1) {
                    loginEl = (Element)loginList.item(i);
                    nextElTag = loginEl.getNodeName();
                    if (nextElTag.equals("host")) {
                        value = this.getTextValue(loginEl);
                        this.info.setRemoteHost(value);
                    } else if (nextElTag.equals("port")) {
                        value = this.getTextValue(loginEl);
                        this.info.setRemotePort(Integer.parseInt(value));
                    } else if (nextElTag.equals("transport-protocol")) {
                        value = this.getTextValue(loginEl);
                        protocol.add(value);
                    } else if (nextElTag.equals("user-name")) {
                        value = this.getTextValue(loginEl);
                        this.info.setUserName(value);
                    } else if (nextElTag.equals("user-password")) {
                        value = this.getTextValue(loginEl);
                        this.info.setUserPassword(value);
                    }
                }
                ++i;
            }
            Object[] transportProtocol = new String[protocol.size()];
            protocol.copyInto(transportProtocol);
            this.info.setTransportProtocol((String[])transportProtocol);
        }
    }

    protected SecurityRoles[] initUserRoles(Element el) {
        NodeList roleNameList = el.getChildNodes();
        Vector<SecurityRoles> roleV = new Vector<SecurityRoles>();
        Object[] securityRoles = null;
        String tag = null;
        Element userEl = null;
        Element typeEl = null;
        this.roleMapTable = new UserRoleMappings();
        Vector<UserInfo> userInfo = null;
        UserInfo info = null;
        Object[] infoes = null;
        if (roleNameList != null) {
            Element roleEl = null;
            int i = 0;
            while (i < roleNameList.getLength()) {
                if (roleNameList.item(i).getNodeType() == 1) {
                    roleEl = (Element)roleNameList.item(i);
                    SecurityRoles role = new SecurityRoles();
                    if (!this.getTextValue(roleEl).equals("unknown role")) {
                        role.setRoleName(this.getTextValue(roleEl));
                        userInfo = new Vector<UserInfo>();
                        NodeList mappingList = roleEl.getChildNodes();
                        if (mappingList != null) {
                            Element mappingEl = null;
                            int j = 0;
                            while (j < mappingList.getLength()) {
                                if (mappingList.item(j).getNodeType() == 1) {
                                    mappingEl = (Element)mappingList.item(j);
                                    tag = mappingEl.getTagName();
                                    if (tag.equals("mapping")) {
                                        userEl = this.getFirstElement(mappingEl);
                                        typeEl = this.getLastElement(mappingEl);
                                        info = new UserInfo(this.getTextValue(userEl), true);
                                        if (this.getTextValue(typeEl).equalsIgnoreCase("user")) {
                                            role.setUserName(this.getTextValue(userEl));
                                        } else if (this.getTextValue(typeEl).equalsIgnoreCase("group")) {
                                            role.setUserGroup(this.getTextValue(userEl));
                                            info.setType(false);
                                        }
                                    }
                                    userInfo.add(info);
                                }
                                ++j;
                            }
                            infoes = new UserInfo[userInfo.size()];
                            userInfo.copyInto(infoes);
                            this.roleMapTable.addRole(this.getTextValue(roleEl), (UserInfo[])infoes);
                        }
                        roleV.add(role);
                    }
                }
                ++i;
            }
        }
        securityRoles = new SecurityRoles[roleV.size()];
        roleV.copyInto(securityRoles);
        return securityRoles;
    }

    protected String[] initSupport(Element el) {
        NodeList supportList = el.getChildNodes();
        Object[] support = null;
        Vector<String> supportV = new Vector<String>();
        if (supportList != null) {
            Element supportEl = null;
            int i = 0;
            while (i < supportList.getLength()) {
                if (supportList.item(i).getNodeType() == 1) {
                    supportEl = (Element)supportList.item(i);
                    supportV.add(this.getTextValue(supportEl));
                }
                ++i;
            }
        }
        support = new String[supportV.size()];
        supportV.copyInto(support);
        return support;
    }

    protected String getTextValue(Element element) {
        Node node;
        if (element != null && (node = element.getFirstChild()) != null && node.getNodeType() == 3) {
            String value = node.getNodeValue();
            if (value.trim().equals("") || value.trim().equals("null")) {
                return null;
            }
            return value.trim();
        }
        return null;
    }

    private Element getFirstElement(Element parent) {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                return (Element)list.item(i);
            }
            ++i;
        }
        return null;
    }

    private Element getLastElement(Element parent) {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return null;
        }
        int i = list.getLength() - 1;
        while (i >= 0) {
            if (list.item(i) instanceof Element) {
                return (Element)list.item(i);
            }
            --i;
        }
        return null;
    }

    public EntityDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(EntityDescriptor[] descriptors) {
        this.descriptors = descriptors;
        if (descriptors == null) {
            return;
        }
    }

    public String getEarPath() {
        return this.earPath;
    }

    public void setEarPath(String earPath) {
        this.earPath = earPath;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public SecurityRoles[] getRoles() {
        return this.roles;
    }

    public void setRoles(SecurityRoles[] roles) {
        this.roles = roles;
    }

    public void setAdditionalInfo(Hashtable _hashTable) {
        this.descrTable = _hashTable;
    }

    public String[] getSupports() {
        return this.supports;
    }

    public void setSupports(String[] supports) {
        this.supports = supports;
    }

    public void addToDeployProperties(String key, String value) {
        if (this.deployProp == null) {
            this.deployProp = new Properties();
        }
        this.deployProp.setProperty(key, value);
    }

    public Properties getDeployProperties() {
        return this.deployProp;
    }

    public void setDeployProperties(Properties _deployProp) {
        this.deployProp = _deployProp;
    }

    public void setProjectDirectory(String prjDir) {
        this.prjDir = prjDir;
    }

    public String getProjectDirectory() {
        return this.prjDir;
    }

    private String getRelativePath(String path) throws Exception {
        String result;
        if (path == null) {
            return null;
        }
        if (this.prjDir == null) {
            throw new Exception("Project directory is not set.");
        }
        if (path.indexOf(this.prjDir) == -1) {
            result = path;
        } else {
            int i = this.prjDir.length();
            result = path.substring(i);
        }
        return result;
    }

    private String getAbsolutePath(String path) {
        String result;
        if (this.prjDir == null || this.prjDir.trim().equals("")) {
            return path;
        }
        File f = new File(path);
        if (!f.isAbsolute()) {
            if (this.prjDir.endsWith(File.separator) && this.prjDir.length() > 0) {
                this.prjDir = this.prjDir.substring(0, this.prjDir.length() - 1);
            }
            if (!path.startsWith(File.separator)) {
                path = File.separator + path;
            }
            result = this.prjDir + path;
        } else {
            File absFile;
            result = f.getAbsolutePath().startsWith(File.separator) ? ((absFile = new File(this.prjDir, path)).exists() ? absFile.getAbsolutePath() : (f.exists() ? f.getAbsolutePath() : absFile.getAbsolutePath())) : path;
        }
        return result;
    }

    private void loadResourceRef(Element parentEl, ResourceReference[] ref) {
        int i = 0;
        while (i < ref.length) {
            Element refEl = this.mainDocument.createElement("res-ref");
            this.load(refEl, ref[i].getResourceName(), "ref-name");
            this.load(refEl, ref[i].getResourceLink(), "ref-link");
            parentEl.appendChild(refEl);
            ++i;
        }
    }

    private void loadEJBRef(Element parentEl, EJBeanReference[] ref) {
        int i = 0;
        while (i < ref.length) {
            Element refEl = this.mainDocument.createElement("ejb-ref");
            this.load(refEl, ref[i].getReferenceName(), "ref-name");
            this.load(refEl, ref[i].getReferenceJndiLink(), "ref-link");
            parentEl.appendChild(refEl);
            ++i;
        }
    }

    private void loadEnvEntr(Element parentEl, EnvironmentEntry[] envEntr) {
        int i = 0;
        while (i < envEntr.length) {
            Element envEl = this.mainDocument.createElement("entry");
            this.load(envEl, envEntr[i].getEntryName(), "entry-name");
            if (envEntr[i].getEntryValue() != null) {
                this.load(envEl, envEntr[i].getEntryValue().toString(), "value");
            } else {
                this.load(envEl, "", "value");
            }
            parentEl.appendChild(envEl);
            ++i;
        }
    }

    private void loadContextParam(Element parentEl, ContextParam[] param) {
        int i = 0;
        while (i < param.length) {
            Element paramEl = this.mainDocument.createElement("context-param");
            this.load(paramEl, param[i].getParamName(), "param-name");
            this.load(paramEl, param[i].getParamValue(), "param-value");
            this.load(paramEl, param[i].getDescription(), "description");
            parentEl.appendChild(paramEl);
            ++i;
        }
    }

    public void updateEARDescriptor(EARDescriptor _descr) {
        if (_descr == null) {
            return;
        }
        Hashtable archTable = _descr.getArchiveTable();
        if (archTable == null) {
            return;
        }
        ArchiveDescriptor archDescr = null;
        DeploymentDescriptor[] beanDescr = null;
        String archName = null;
        Enumeration enumeration = archTable.keys();
        while (enumeration.hasMoreElements()) {
            archName = (String)enumeration.nextElement();
            archDescr = (ArchiveDescriptor)archTable.get(archName);
            if (archName.indexOf(File.separator) != -1) {
                archName = archName.substring(archName.lastIndexOf(File.separator) + 1);
            }
            if (archDescr instanceof EJBJarDescriptor) {
                beanDescr = ((EJBJarDescriptor)archDescr).getDDescriptors();
                int i = 0;
                while (i < beanDescr.length) {
                    this.updateBean(archName, beanDescr[i]);
                    ++i;
                }
            }
            if (archDescr instanceof WebDeploymentDescriptor) {
                String oldName = archDescr.getDisplayName();
                archDescr.setDisplayName(archName);
                this.updateWar(archDescr);
                if (oldName != null) {
                    archDescr.setDisplayName(oldName);
                }
            }
            if (!(archDescr instanceof ApplicationClientDescriptor)) continue;
            this.updateClientJar(archDescr);
        }
    }

    private void updateBean(String archName, DeploymentDescriptor dd) {
        if (this.getMainDocument() == null || archName == null || dd == null) {
            return;
        }
        Element docEl = this.getMainDocument().getDocumentElement();
        Element addInfoEl = this.getFirstElementByName(docEl, "additional-info");
        if (addInfoEl == null) {
            return;
        }
        Element archivesEl = this.getFirstElementByName(addInfoEl, "archives");
        if (archivesEl == null) {
            return;
        }
        Element jarEl = null;
        NodeList jarList = archivesEl.getElementsByTagName("ejb-jar");
        NodeList beanList = null;
        int i = 0;
        while (i < jarList.getLength()) {
            jarEl = (Element)jarList.item(i);
            Element nameEl = this.getFirstElementByName((Element)jarList.item(i), "archive-name");
            String jarName = this.getTextValue(nameEl);
            if (archName.equals(jarName) && (beanList = jarEl.getElementsByTagName("ejbean")) != null) {
                int j = 0;
                while (j < beanList.getLength()) {
                    Element beanEl = (Element)beanList.item(j);
                    beanEl = (Element)beanList.item(i);
                    Element beanNameEl = this.getFirstElementByName(beanEl, "bean-name");
                    String beanName = this.getTextValue(beanNameEl);
                    if (beanName != null && beanName.equals(dd.getName())) {
                        this.updateEjbRef(dd.getEJBeanReferences(), beanEl.getElementsByTagName("ejb-ref"));
                        this.updateResRef(dd.getResourceReferences(), beanEl.getElementsByTagName("res-ref"));
                        this.updateEnvEntr(dd.getEnvironmentEntries(), beanEl.getElementsByTagName("entry"));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void updateWar(ArchiveDescriptor archDescr) {
        if (!(archDescr instanceof WebDeploymentDescriptor)) {
            return;
        }
        if (this.getMainDocument() == null) {
            return;
        }
        Element docEl = this.getMainDocument().getDocumentElement();
        Element addInfoEl = this.getFirstElementByName(docEl, "additional-info");
        if (addInfoEl == null) {
            return;
        }
        Element archivesEl = this.getFirstElementByName(addInfoEl, "archives");
        if (archivesEl == null) {
            return;
        }
        Element warElement = null;
        Element warNameEl = null;
        String displayName = null;
        NodeList warList = archivesEl.getElementsByTagName("war");
        String warName = null;
        int i = 0;
        while (i < warList.getLength()) {
            warNameEl = this.getFirstElementByName((Element)warList.item(i), "archive-name");
            if (warNameEl != null) {
                warName = this.getTextValue(warNameEl);
                warElement = (Element)warList.item(i);
                displayName = archDescr.getDisplayName();
                if (displayName != null && warName != null && warName.equals(displayName.substring(displayName.lastIndexOf(File.separator) + 1, displayName.length()))) {
                    NodeList list = warElement.getElementsByTagName("ejb-ref");
                    this.updateEjbRef(((WebDeploymentDescriptor)archDescr).getEjbRefs(), list);
                    list = warElement.getElementsByTagName("res-ref");
                    this.updateResRef(((WebDeploymentDescriptor)archDescr).getResReferences(), list);
                    list = warElement.getElementsByTagName("entry");
                    this.updateEnvEntr(((WebDeploymentDescriptor)archDescr).getEnvEntries(), list);
                    list = warElement.getElementsByTagName("context-param");
                    this.updateContextParam(((WebDeploymentDescriptor)archDescr).getContextParams(), list);
                }
            }
            ++i;
        }
    }

    private void updateClientJar(ArchiveDescriptor archDescr) {
        if (!(archDescr instanceof ApplicationClientDescriptor)) {
            return;
        }
        if (this.getMainDocument() == null) {
            return;
        }
        Element docEl = this.getMainDocument().getDocumentElement();
        Element addInfoEl = this.getFirstElementByName(docEl, "additional-info");
        if (addInfoEl == null) {
            return;
        }
        Element archivesEl = this.getFirstElementByName(addInfoEl, "archives");
        Element clientNameElement = null;
        Element clientElement = null;
        String displayName = null;
        if (archivesEl == null) {
            return;
        }
        NodeList clientList = archivesEl.getElementsByTagName("client-jar");
        String clientName = null;
        int i = 0;
        while (i < clientList.getLength()) {
            clientNameElement = this.getFirstElementByName((Element)clientList.item(i), "archive-name");
            if (clientNameElement != null) {
                clientName = this.getTextValue(clientNameElement);
                clientElement = (Element)clientList.item(i);
                displayName = archDescr.getDisplayName();
                if (clientName != null && clientName.equals(displayName.substring(displayName.lastIndexOf(File.separator) + 1, displayName.length()))) {
                    NodeList list = clientElement.getElementsByTagName("ejb-ref");
                    this.updateEjbRef(((ApplicationClientDescriptor)archDescr).getEJBeanReferences(), list);
                    list = clientElement.getElementsByTagName("res-ref");
                    this.updateResRef(((ApplicationClientDescriptor)archDescr).getResourceReferences(), list);
                    list = clientElement.getElementsByTagName("entry");
                    this.updateEnvEntr(((ApplicationClientDescriptor)archDescr).getEnvironmentProperties(), list);
                }
            }
            ++i;
        }
    }

    private void updateEjbRef(EJBeanReference[] ref, NodeList list) {
        if (ref == null || list == null) {
            return;
        }
        int i = 0;
        while (i < ref.length) {
            String refName = ref[i].getReferenceName();
            if (refName != null) {
                int j = 0;
                while (j < list.getLength()) {
                    Element refNameEl = this.getFirstElementByName((Element)list.item(j), "ref-name");
                    if (refName.equals(this.getTextValue(refNameEl))) {
                        ref[i].setReferenceJndiLink(this.getTextValue(this.getFirstElementByName((Element)list.item(j), "ref-link")));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void updateResRef(ResourceReference[] ref, NodeList list) {
        if (ref == null || list == null) {
            return;
        }
        int i = 0;
        while (i < ref.length) {
            String refName = ref[i].getResourceName();
            if (refName != null) {
                int j = 0;
                while (j < list.getLength()) {
                    Element refNameEl = this.getFirstElementByName((Element)list.item(j), "ref-name");
                    if (refName.equals(this.getTextValue(refNameEl))) {
                        ref[i].setResourceLink(this.getTextValue(this.getFirstElementByName((Element)list.item(j), "ref-link")));
                        if (this.getFirstElementByName((Element)list.item(j), "res-user") == null) {
                            // empty if block
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void updateEnvEntr(EnvironmentEntry[] entr, NodeList list) {
        if (entr == null || list == null) {
            return;
        }
        int i = 0;
        while (i < entr.length) {
            String entrName = entr[i].getEntryName();
            if (entrName != null) {
                int j = 0;
                while (j < list.getLength()) {
                    Element entrNameEl = this.getFirstElementByName((Element)list.item(j), "entry-name");
                    if (entrName.equals(this.getTextValue(entrNameEl))) {
                        entr[i].setEntryValue(this.getTextValue(this.getFirstElementByName((Element)list.item(j), "value")));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void updateContextParam(ContextParam[] param, NodeList list) {
        if (param == null || list == null) {
            return;
        }
        int i = 0;
        while (i < param.length) {
            String paramName = param[i].getParamName();
            if (paramName != null) {
                int j = 0;
                while (j < list.getLength()) {
                    Element paramNameEl = this.getFirstElementByName((Element)list.item(j), "param-name");
                    if (paramName.equals(this.getTextValue(paramNameEl))) {
                        param[i].setParamValue(this.getTextValue(this.getFirstElementByName((Element)list.item(j), "param-value")));
                        param[i].setDescription(this.getTextValue(this.getFirstElementByName((Element)list.item(j), "description")));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public String getContainerType() {
        return this.deployProp.getProperty("container_type");
    }

    private Element getFirstElementByName(Element el, String name) {
        if (el == null) {
            return null;
        }
        NodeList list = el.getElementsByTagName(name);
        if (list == null) {
            return null;
        }
        return (Element)list.item(0);
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public LoginInfo getInfo() {
        return this.info;
    }

    public void setInfo(LoginInfo info) {
        this.info = info;
    }

    public UserRoleMappings getRoleMapTable() {
        return this.roleMapTable;
    }

    public void setRoleMapTable(UserRoleMappings roleMapTable) {
        this.roleMapTable = roleMapTable;
    }

    public String getAction_type() {
        return this.action_type;
    }

    public void setAction_type(String action_type) {
        this.action_type = action_type;
    }

    public Hashtable getAddReferences() {
        return this.addRefs;
    }

    public void setAddReferences(Hashtable _addRefs) {
        this.addRefs = _addRefs;
    }

    public Hashtable getDeployable_library() {
        return this.deployable_library;
    }

    public void setDeployable_library(Hashtable deployable_library) {
        this.deployable_library = deployable_library;
    }

    public String[] getReferenced_library() {
        return this.referenced_library;
    }

    public void setReferenced_library(String[] referenced_library) {
        this.referenced_library = referenced_library;
    }

    private NodeList getElementsByTagName(Element el, String name) {
        NodeListImpl resultList = new NodeListImpl();
        NodeList c = el.getChildNodes();
        int i = 0;
        while (i < c.getLength()) {
            Node x = c.item(i);
            if (x.getNodeType() == 1 && name.equals(((Element)x).getTagName())) {
                resultList.add(x);
            }
            ++i;
        }
        return resultList;
    }

    private void initXMLToolkit() {
        if (this.parser == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.parser = new StandardDOMParser();
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private void toLog(Exception e) {
        e.printStackTrace();
    }
}

