/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.manager;

import com.sap.engine.deploy.SimpleEARClassLoader;
import com.sap.engine.deploy.manager.DeployableModul;
import com.sap.engine.deploy.manager.LoginInfo;
import com.sap.engine.deploy.manager.UserInfo;
import com.sap.engine.deploy.manager.UserRoleMappings;
import com.sap.engine.deploy.manager.WebServiceRelated;
import com.sap.engine.deploy.manager.component.LibraryInfo;
import com.sap.engine.deploy.manager.component.SComponentsXmlDocument;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.security.core.server.secstorefs.SecStoreFS;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DeployConfigDocument {
    public static final String YES = "yes";
    public static final String NO = "no";
    private String versionId = null;
    private String prjDir = null;
    private InfoObject[] ear_fileAltDD = null;
    private String[] useAltEar = null;
    private String earPath = null;
    private String displayName = null;
    private Vector entryName = new Vector();
    private Hashtable aliases = new Hashtable();
    public static final String ACTION_TYPE_DEPLOY = "deploy";
    public static final String ACTION_TYPE_UPDATE = "update";
    public static final String J2EE_MODULE = "Module";
    public static final String EAR = "Ear";
    private String dObjectType = null;
    private String action_type = "deploy";
    private Vector elementAltDD = new Vector();
    private String[] useAltElem = null;
    private LoginInfo info = new LoginInfo();
    private SecurityRoles[] roles;
    private UserRoleMappings roleMapTable;
    private Vector service = new Vector();
    private LibraryInfo[] libInfo = new LibraryInfo[0];
    private Hashtable refInfo = new Hashtable();
    private DeployableModul module = null;
    private String components_xml = null;
    private SComponentsXmlDocument compXmlDoc = null;
    private String[] supports;
    private Properties deployProp;
    private Properties substProps = null;
    private String containerType = "B";
    private String pswFile = null;
    protected static final String TYPE_A = "A";
    protected static final String TYPE_B = "B";
    private String logFile = null;
    private StandardDOMWriter writer = null;
    private StandardDOMParser parser = null;
    public static final String dtd = "<!DOCTYPE deploy-manager-config [\n<!ELEMENT deploy-manager-config (version-id, project-dir?, deployable-object,  element*, login-info, user-role-mapping?, server-components-xml?, library-info?, supports, deployment-properties?, repl-var-properties?, log-file?)>\n<!ELEMENT version-id (#PCDATA)>\n<!ELEMENT project-dir (#PCDATA)>\n<!ELEMENT deployable-object (ear-file|j2ee-module)>\n<!ATTLIST deployable-object action-type (deploy|update) #REQUIRED>\n<!ELEMENT ear-file (ear-path, display-name?, altdd*)>\n<!ELEMENT ear-path (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT j2ee-module (archive-path, altdd*)>\n<!ELEMENT archive-path (#PCDATA)>\n<!ATTLIST j2ee-module container (appclient|connector|EJB_Container|servlet_jsp) #REQUIRED>\n<!ELEMENT element (entry-name, context-root?, altdd*, web-service-related?)>\n<!ELEMENT context-root (#PCDATA)>\n<!ELEMENT altdd (pathname, entry-name)>\n<!ATTLIST altdd use-alternative (yes|no) #REQUIRED>\n<!ELEMENT pathname (#PCDATA)>\n<!ELEMENT entry-name (#PCDATA)>\n<!ELEMENT web-service-related (web-service?, web-service-client?)>\n<!ELEMENT web-service (altdd?, wsdl-files*)>\n<!ELEMENT wsdl-files (pathname, entry-name)>\n<!ELEMENT web-service-client (altdd?)>\n<!ELEMENT login-info (host, port, transport-protocol*, user-name, user-password)>\n<!ELEMENT host (#PCDATA)>\n<!ELEMENT port (#PCDATA)>\n<!ELEMENT transport-protocol (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!--user-password can content PCDATA for background compatibility.  psw-file is the name of the file with the encrypted password. If you specify more than 1 elements the first element will be taken. If specify zero elements password will be empty String.  -->\n<!ELEMENT user-password (#PCDATA | psw-file)*>\n<!ELEMENT psw-file (#PCDATA)>\n<!ELEMENT user-role-mapping (role-name+)>\n<!ELEMENT role-name (#PCDATA | mapping)*>\n<!ELEMENT mapping (name, type)>\n<!ELEMENT name (#PCDATA)>\n<!ELEMENT type (#PCDATA)>\n<!ELEMENT server-components-xml (#PCDATA)>\n<!ELEMENT library-info (library*, reference*)>\n<!ELEMENT library (lib-name, lib-jar+)>\n<!ELEMENT lib-name (#PCDATA)>\n<!ELEMENT lib-jar (#PCDATA)>\n<!ATTLIST lib-jar server-map-name CDATA #REQUIRED>\n<!ELEMENT reference (from-loader, to-loader+)>\n<!ELEMENT from-loader (#PCDATA)>\n<!ELEMENT to-loader (#PCDATA)>\n<!ELEMENT supports (support+)>\n<!ELEMENT support (#PCDATA)>\n<!ELEMENT repl-var-properties (property*)>\n<!ELEMENT deployment-properties (property*)>\n<!ELEMENT property (#PCDATA)>\n<!ELEMENT log-file (#PCDATA)>\n]>";
    protected Document mainDocument;
    protected Element mainElement;

    public DeployConfigDocument() {
        this.initXMLToolkit();
    }

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public void setMainDocument(Document doc) {
        this.mainDocument = doc;
    }

    protected void loadUserRole(Element el) {
        Element mappingEl = null;
        String roleName = null;
        Element tempEl = null;
        boolean oneAdd = false;
        if (this.roles != null && this.roles.length != 0) {
            int i = 0;
            while (i < this.roles.length) {
                if (this.roles[i] != null) {
                    String[] groupName;
                    String[] userName;
                    roleName = this.roles[i].getRoleName();
                    tempEl = this.load(el, roleName, "role-name");
                    if (!oneAdd) {
                        oneAdd = true;
                    }
                    if ((userName = this.roles[i].getUserNames()) != null) {
                        int j = 0;
                        while (j < userName.length) {
                            mappingEl = this.mainDocument.createElement("mapping");
                            this.load(mappingEl, userName[j], "name");
                            this.load(mappingEl, "user", "type");
                            tempEl.appendChild(mappingEl);
                            ++j;
                        }
                    }
                    if ((groupName = this.roles[i].getUserGroup()) != null) {
                        int j = 0;
                        while (j < groupName.length) {
                            mappingEl = this.mainDocument.createElement("mapping");
                            this.load(mappingEl, groupName[j], "name");
                            this.load(mappingEl, "group", "type");
                            tempEl.appendChild(mappingEl);
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (tempEl != null) {
                el.appendChild(tempEl);
            }
        } else {
            tempEl = this.load(el, "unknown role", "role-name");
            el.appendChild(tempEl);
            oneAdd = true;
        }
        if (!oneAdd) {
            tempEl = this.load(el, "unknown role", "role-name");
            el.appendChild(tempEl);
        }
    }

    protected SecurityRoles[] initUserRoles(Element el) {
        NodeList roleNameList = el.getChildNodes();
        Vector<SecurityRoles> roleV = new Vector<SecurityRoles>();
        Object[] securityRoles = null;
        String tag = null;
        Element userEl = null;
        Element typeEl = null;
        this.roleMapTable = new UserRoleMappings();
        Vector<UserInfo> userInfo = null;
        UserInfo info = null;
        Object[] infoes = null;
        if (roleNameList != null) {
            Element roleEl = null;
            int i = 0;
            while (i < roleNameList.getLength()) {
                if (roleNameList.item(i).getNodeType() == 1) {
                    roleEl = (Element)roleNameList.item(i);
                    SecurityRoles role = new SecurityRoles();
                    if (!this.getTextValue(roleEl).equals("unknown role")) {
                        role.setRoleName(this.getTextValue(roleEl));
                        userInfo = new Vector<UserInfo>();
                        NodeList mappingList = roleEl.getChildNodes();
                        if (mappingList != null) {
                            Element mappingEl = null;
                            int j = 0;
                            while (j < mappingList.getLength()) {
                                if (mappingList.item(j).getNodeType() == 1) {
                                    mappingEl = (Element)mappingList.item(j);
                                    tag = mappingEl.getTagName();
                                    if (tag.equals("mapping")) {
                                        userEl = this.getFirstElement(mappingEl);
                                        typeEl = this.getLastElement(mappingEl);
                                        info = new UserInfo(this.getTextValue(userEl), true);
                                        if (this.getTextValue(typeEl).equalsIgnoreCase("user")) {
                                            role.setUserName(this.getTextValue(userEl));
                                        } else if (this.getTextValue(typeEl).equalsIgnoreCase("group")) {
                                            role.setUserGroup(this.getTextValue(userEl));
                                            info.setType(false);
                                        }
                                    }
                                    userInfo.add(info);
                                }
                                ++j;
                            }
                            infoes = new UserInfo[userInfo.size()];
                            userInfo.copyInto(infoes);
                            this.roleMapTable.addRole(this.getTextValue(roleEl), (UserInfo[])infoes);
                        }
                        roleV.add(role);
                    }
                }
                ++i;
            }
        }
        securityRoles = new SecurityRoles[roleV.size()];
        roleV.copyInto(securityRoles);
        return securityRoles;
    }

    private Element getFirstElement(Element parent) {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) instanceof Element) {
                return (Element)list.item(i);
            }
            ++i;
        }
        return null;
    }

    private Element getLastElement(Element parent) {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return null;
        }
        int i = list.getLength() - 1;
        while (i >= 0) {
            if (list.item(i) instanceof Element) {
                return (Element)list.item(i);
            }
            --i;
        }
        return null;
    }

    private void loadModule(Element moduleEl) throws Exception {
        this.load(moduleEl, this.getRelativePath(this.module.getFilePath()), "archive-path");
        InfoObject[] infoes = this.module.getAltDD();
        if (infoes != null) {
            Element altDDEl = null;
            int i = 0;
            while (i < infoes.length) {
                altDDEl = this.mainDocument.createElement("altdd");
                this.load(altDDEl, infoes[i].getFilePath(), "pathname");
                this.load(altDDEl, infoes[i].getEntryName(), "entry-name");
                altDDEl.setAttribute("use-alternative", YES);
                moduleEl.appendChild(altDDEl);
                ++i;
            }
        }
        moduleEl.setAttribute("container", this.module.getCotainer());
    }

    protected void loadEarFile(Element earFileEl) {
        Element altddEl = null;
        try {
            this.load(earFileEl, this.getRelativePath(this.earPath), "ear-path");
            if (this.displayName != null && !this.displayName.equals("")) {
                this.load(earFileEl, this.displayName, "display-name");
            }
            if (this.ear_fileAltDD != null) {
                int j = 0;
                while (j < this.ear_fileAltDD.length) {
                    if (this.ear_fileAltDD[j] != null) {
                        altddEl = this.mainDocument.createElement("altdd");
                        if (this.useAltEar != null && this.useAltEar.length != 0 && j < this.useAltEar.length && this.useAltEar[j] != null) {
                            altddEl.setAttribute("use-alternative", this.useAltEar[j]);
                        } else {
                            altddEl.setAttribute("use-alternative", YES);
                        }
                        this.load(altddEl, this.getRelativePath(this.ear_fileAltDD[j].getFilePath()), "pathname");
                        this.load(altddEl, this.ear_fileAltDD[j].getEntryName(), "entry-name");
                        earFileEl.appendChild(altddEl);
                    }
                    ++j;
                }
            }
        }
        catch (Exception e) {
            this.toLog(e);
        }
    }

    protected void initEarFile(Element earFileEl) {
        NodeList earfileList = earFileEl.getChildNodes();
        Vector<InfoObject> altddV = new Vector<InfoObject>();
        Vector<String> useAltV = new Vector<String>();
        String type = null;
        if (earfileList != null) {
            Element earEl = null;
            int i = 0;
            while (i < earfileList.getLength()) {
                if (earfileList.item(i).getNodeType() == 1) {
                    earEl = (Element)earfileList.item(i);
                    if (earEl.getNodeName().equals("ear-path")) {
                        String earPath = null;
                        earPath = new File(this.getTextValue(earEl)).exists() ? this.getTextValue(earEl) : ApplicationInformationProvider.concatPath(this.prjDir, this.getTextValue(earEl));
                        this.setEarPath(earPath);
                        type = earEl.getAttribute("action-type");
                        if (type != null) {
                            this.action_type = !type.equalsIgnoreCase(ACTION_TYPE_UPDATE) ? ACTION_TYPE_DEPLOY : ACTION_TYPE_UPDATE;
                        }
                    } else if (earEl.getNodeName().equals("display-name")) {
                        this.setDisplayName(this.getTextValue(earEl));
                    } else if (earEl.getNodeName().equals("altdd") && earEl.getChildNodes() != null) {
                        altddV.add(this.getInfoFromElement(earEl));
                        useAltV.add(earEl.getAttribute("use-alternative"));
                    }
                }
                ++i;
            }
            this.useAltEar = new String[useAltV.size()];
            useAltV.copyInto(this.useAltEar);
            this.ear_fileAltDD = new InfoObject[altddV.size()];
            altddV.copyInto(this.ear_fileAltDD);
        }
    }

    protected void loadElement(Element main) {
        try {
            if (this.entryName.size() == this.elementAltDD.size()) {
                Element elementEl = null;
                String alias = null;
                int r = 0;
                while (r < this.entryName.size()) {
                    elementEl = this.mainDocument.createElement("element");
                    Element altddEl = null;
                    this.load(elementEl, (String)this.entryName.elementAt(r), "entry-name");
                    alias = (String)this.aliases.get(this.entryName.elementAt(r));
                    if (alias != null && !alias.equals("")) {
                        this.load(elementEl, alias, "context-root");
                    }
                    int j = 0;
                    while (j < ((InfoObject[])this.elementAltDD.elementAt(r)).length) {
                        if (((InfoObject[])this.elementAltDD.elementAt(r))[j] != null) {
                            altddEl = this.mainDocument.createElement("altdd");
                            if (this.useAltElem != null && j < this.useAltElem.length) {
                                altddEl.setAttribute("use-alternative", this.useAltElem[j]);
                            } else {
                                altddEl.setAttribute("use-alternative", YES);
                            }
                            this.load(altddEl, this.getRelativePath(((InfoObject[])this.elementAltDD.elementAt(r))[j].getFilePath()), "pathname");
                            this.load(altddEl, ((InfoObject[])this.elementAltDD.elementAt(r))[j].getEntryName(), "entry-name");
                            elementEl.appendChild(altddEl);
                        }
                        ++j;
                    }
                    main.appendChild(elementEl);
                    ++r;
                }
            }
        }
        catch (Exception e) {
            this.toLog(e);
        }
    }

    protected void initElement(Element elementEl) {
        NodeList elementList = elementEl.getChildNodes();
        Vector<InfoObject> altddV = new Vector<InfoObject>();
        Vector<String> useAltV = new Vector<String>();
        WebServiceRelated currentServ = null;
        String elementName = null;
        if (elementList != null) {
            Element elemEl = null;
            int i = 0;
            while (i < elementList.getLength()) {
                if (elementList.item(i).getNodeType() == 1) {
                    elemEl = (Element)elementList.item(i);
                    if (elemEl.getNodeName().equals("entry-name")) {
                        elementName = this.getTextValue(elemEl);
                        if (elementName != null && !elementName.equals("")) {
                            this.entryName.add(elementName);
                        }
                    } else if (elemEl.getNodeName().equals("context-root")) {
                        if (elementName != null && !elementName.equals("")) {
                            this.aliases.put(elementName, this.getTextValue(elemEl));
                        }
                    } else if (elemEl.getNodeName().equals("altdd")) {
                        NodeList altddList = elemEl.getChildNodes();
                        if (altddList != null) {
                            Element altddEl = null;
                            InfoObject info = new InfoObject();
                            int j = 0;
                            while (j < altddList.getLength()) {
                                if (altddList.item(j).getNodeType() == 1) {
                                    altddEl = (Element)altddList.item(j);
                                    if (altddEl.getNodeName().equals("pathname")) {
                                        String textValue = this.getTextValue(altddEl);
                                        if (new File(textValue).exists()) {
                                            info.setFilePath(textValue);
                                        } else {
                                            info.setFilePath(ApplicationInformationProvider.concatPath(this.prjDir, textValue));
                                        }
                                    } else if (altddEl.getNodeName().equals("entry-name")) {
                                        info.setEntryName(this.getTextValue(altddEl));
                                    }
                                }
                                ++j;
                            }
                            useAltV.add(elemEl.getAttribute("use-alternative"));
                            altddV.add(info);
                        }
                    } else if (elemEl.getNodeName().equals("web-service-related")) {
                        NodeList webServRelList = elemEl.getChildNodes();
                        currentServ = new WebServiceRelated();
                        Vector<InfoObject> wsdlVect = new Vector<InfoObject>();
                        if (webServRelList != null) {
                            Element webServRelEl = null;
                            int p = 0;
                            while (p < webServRelList.getLength()) {
                                if (webServRelList.item(p).getNodeType() == 1) {
                                    NodeList webServClientList;
                                    String textValue;
                                    Element altDDEl;
                                    NodeList altDDList;
                                    InfoObject temp;
                                    int j;
                                    webServRelEl = (Element)webServRelList.item(p);
                                    if (webServRelEl.getNodeName().equals("web-service")) {
                                        NodeList webServList = webServRelEl.getChildNodes();
                                        if (webServList != null) {
                                            Element webServEl = null;
                                            j = 0;
                                            while (j < webServList.getLength()) {
                                                if (webServList.item(j).getNodeType() == 1) {
                                                    NodeList wsdlList;
                                                    webServEl = (Element)webServList.item(j);
                                                    temp = new InfoObject();
                                                    if (webServEl.getNodeName().equals("altdd")) {
                                                        altDDList = webServEl.getChildNodes();
                                                        if (altDDList != null) {
                                                            altDDEl = null;
                                                            int w = 0;
                                                            while (w < altDDList.getLength()) {
                                                                if (altDDList.item(w).getNodeType() == 1) {
                                                                    altDDEl = (Element)altDDList.item(w);
                                                                    if (altDDEl.getNodeName().equals("pathname")) {
                                                                        textValue = this.getTextValue(altDDEl);
                                                                        if (new File(textValue).exists()) {
                                                                            temp.setFilePath(textValue);
                                                                        } else {
                                                                            temp.setFilePath(ApplicationInformationProvider.concatPath(this.prjDir, textValue));
                                                                        }
                                                                    } else if (altDDEl.getNodeName().equals("entry-name")) {
                                                                        temp.setEntryName(this.getTextValue(altDDEl));
                                                                    }
                                                                }
                                                                ++w;
                                                            }
                                                        }
                                                        currentServ.setWebServAltDDAtribute(webServEl.getAttribute("use-alternative").equals(YES));
                                                        if (temp.getEntryName().equalsIgnoreCase("META-INF/webservices.xml")) {
                                                            currentServ.setWebServAltDD(temp);
                                                        } else if (temp.getEntryName().equalsIgnoreCase("META-INF/sapwebservices.xml")) {
                                                            currentServ.setSapWebServAltDD(temp);
                                                        }
                                                    } else if (webServEl.getNodeName().equals("wsdl-files") && (wsdlList = webServEl.getChildNodes()) != null) {
                                                        Element wsdlEl = null;
                                                        InfoObject tempr = new InfoObject();
                                                        int w = 0;
                                                        while (w < wsdlList.getLength()) {
                                                            if (wsdlList.item(w).getNodeType() == 1) {
                                                                wsdlEl = (Element)wsdlList.item(w);
                                                                if (wsdlEl.getNodeName().equals("pathname")) {
                                                                    String textValue2 = this.getTextValue(wsdlEl);
                                                                    if (new File(textValue2).exists()) {
                                                                        tempr.setFilePath(textValue2);
                                                                    } else {
                                                                        tempr.setFilePath(ApplicationInformationProvider.concatPath(this.prjDir, textValue2));
                                                                    }
                                                                } else if (wsdlEl.getNodeName().equals("entry-name")) {
                                                                    tempr.setEntryName(this.getTextValue(wsdlEl));
                                                                }
                                                            }
                                                            ++w;
                                                        }
                                                        wsdlVect.add(tempr);
                                                    }
                                                }
                                                ++j;
                                            }
                                        }
                                    } else if (webServRelEl.getNodeName().equals("web-service-client") && (webServClientList = webServRelEl.getChildNodes()) != null) {
                                        Element webServClientEl = null;
                                        j = 0;
                                        while (j < webServClientList.getLength()) {
                                            if (webServClientList.item(j).getNodeType() == 1) {
                                                webServClientEl = (Element)webServClientList.item(j);
                                                temp = new InfoObject();
                                                if (webServClientEl.getNodeName().equals("altdd")) {
                                                    altDDList = webServClientEl.getChildNodes();
                                                    if (altDDList != null) {
                                                        altDDEl = null;
                                                        int w = 0;
                                                        while (w < altDDList.getLength()) {
                                                            if (altDDList.item(w).getNodeType() == 1) {
                                                                altDDEl = (Element)altDDList.item(w);
                                                                if (altDDEl.getNodeName().equals("pathname")) {
                                                                    textValue = this.getTextValue(altDDEl);
                                                                    if (new File(textValue).exists()) {
                                                                        temp.setFilePath(textValue);
                                                                    } else {
                                                                        temp.setFilePath(ApplicationInformationProvider.concatPath(this.prjDir, textValue));
                                                                    }
                                                                } else if (altDDEl.getNodeName().equals("entry-name")) {
                                                                    temp.setEntryName(this.getTextValue(altDDEl));
                                                                }
                                                            }
                                                            ++w;
                                                        }
                                                    }
                                                    currentServ.setWebServClientAttribute(webServClientEl.getAttribute("use-alternative").equals(YES));
                                                    currentServ.setWebServClientAltDD(temp);
                                                }
                                            }
                                            ++j;
                                        }
                                    }
                                }
                                ++p;
                            }
                        }
                        Object[] tempWsdl = new InfoObject[wsdlVect.size()];
                        wsdlVect.copyInto(tempWsdl);
                        currentServ.setWebServWsdlFiles((InfoObject[])tempWsdl);
                    }
                }
                ++i;
            }
            this.useAltElem = new String[useAltV.size()];
            useAltV.copyInto(this.useAltElem);
            Object[] temp = new InfoObject[altddV.size()];
            altddV.copyInto(temp);
            this.elementAltDD.add(temp);
            this.service.add(currentServ);
        }
    }

    protected void loadsubstProps(Element propsEl) {
        if (this.substProps == null || ((Hashtable)this.substProps).size() == 0) {
            return;
        }
        String key = null;
        String value = null;
        Enumeration enumeration = ((Hashtable)this.substProps).keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            value = this.substProps.getProperty(key);
            this.load(propsEl, key + " = " + value, "property");
        }
    }

    protected void loadDeployProps(Element propsEl) {
        if (this.deployProp == null || ((Hashtable)this.deployProp).size() == 0) {
            return;
        }
        String key = null;
        String value = null;
        Enumeration enumeration = ((Hashtable)this.deployProp).keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            if (!key.startsWith("web:")) continue;
            String newKey = "web\\:" + key.substring(key.indexOf(":") + 1);
            value = this.deployProp.getProperty(key);
            ((Hashtable)this.deployProp).remove(key);
            this.deployProp.setProperty(newKey, value);
        }
        enumeration = ((Hashtable)this.deployProp).keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            value = this.deployProp.getProperty(key);
            this.load(propsEl, key + " = " + value, "property");
        }
        if (this.deployProp.getProperty("container_type") == null) {
            if (this.containerType == null) {
                this.containerType = TYPE_B;
            }
            this.deployProp.setProperty("container_type", this.containerType);
        }
    }

    protected void initSubstProp(Element el) {
        try {
            Element pEl = null;
            NodeList propList = el.getChildNodes();
            if (propList == null || propList.getLength() == 0) {
                this.substProps = null;
                return;
            }
            this.substProps = new Properties();
            ByteArrayInputStream stream = null;
            String value = null;
            int i = 0;
            while (i < propList.getLength()) {
                if (propList.item(i).getNodeType() == 1 && (value = this.getTextValue(pEl = (Element)propList.item(i))) != null) {
                    stream = new ByteArrayInputStream(value.getBytes());
                    try {
                        this.substProps.load(stream);
                    }
                    catch (IOException ioe) {
                        this.toLog(ioe);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.toLog(e);
        }
    }

    protected void initDeployProp(Element el) {
        try {
            Element pEl = null;
            NodeList propList = el.getChildNodes();
            if (propList == null || propList.getLength() == 0) {
                this.deployProp = null;
                return;
            }
            this.deployProp = new Properties();
            if (this.containerType != null) {
                this.deployProp.setProperty("container_type", this.containerType);
            }
            ByteArrayInputStream stream = null;
            String value = null;
            int i = 0;
            while (i < propList.getLength()) {
                if (propList.item(i).getNodeType() == 1 && (value = this.getTextValue(pEl = (Element)propList.item(i))) != null) {
                    stream = new ByteArrayInputStream(value.getBytes());
                    try {
                        this.deployProp.load(stream);
                    }
                    catch (IOException ioe) {
                        this.toLog(ioe);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.toLog(e);
        }
    }

    protected void loadSupport(Element suppEl) {
        if (this.supports != null) {
            int i = 0;
            while (i < this.supports.length) {
                this.load(suppEl, this.supports[i], "support");
                ++i;
            }
        } else {
            this.load(suppEl, "P4", "support");
        }
    }

    protected String[] initSupport(Element el) {
        NodeList supportList = el.getChildNodes();
        Object[] support = null;
        Vector<String> supportV = new Vector<String>();
        if (supportList != null) {
            Element supportEl = null;
            int i = 0;
            while (i < supportList.getLength()) {
                if (supportList.item(i).getNodeType() == 1) {
                    supportEl = (Element)supportList.item(i);
                    supportV.add(this.getTextValue(supportEl));
                }
                ++i;
            }
        }
        support = new String[supportV.size()];
        supportV.copyInto(support);
        return support;
    }

    protected Element load(Element el, String value, String tagName) {
        if (value == null) {
            value = "";
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    protected void loadLoginInfo(Element el) {
        this.load(el, this.info.getRemoteHost(), "host");
        this.load(el, String.valueOf(this.info.getRemotePort()), "port");
        String[] transportProtocol = this.info.getTransportProtocol();
        int i = 0;
        while (i < transportProtocol.length) {
            this.load(el, transportProtocol[i], "transport-protocol");
            ++i;
        }
        this.load(el, this.info.getUserName(), "user-name");
        if (this.pswFile != null) {
            Element temp = this.mainDocument.createElement("user-password");
            this.load(temp, this.pswFile, "psw-file");
            this.setProperties(this.pswFile, "user-password", this.info.getUserPassword());
            el.appendChild(temp);
        } else {
            this.load(el, this.info.getUserPassword(), "user-password");
        }
    }

    protected void initLoginInfo(Element el) {
        NodeList loginList = el.getChildNodes();
        if (loginList != null) {
            Element loginEl = null;
            String nextElTag = null;
            String value = null;
            Vector<String> protocol = new Vector<String>();
            Element temp = null;
            int i = 0;
            while (i < loginList.getLength()) {
                if (loginList.item(i).getNodeType() == 1) {
                    loginEl = (Element)loginList.item(i);
                    nextElTag = loginEl.getNodeName();
                    if (nextElTag.equals("host")) {
                        value = this.getTextValue(loginEl);
                        this.info.setRemoteHost(value);
                    } else if (nextElTag.equals("port")) {
                        value = this.getTextValue(loginEl);
                        this.info.setRemotePort(Integer.parseInt(value));
                    } else if (nextElTag.equals("transport-protocol")) {
                        value = this.getTextValue(loginEl);
                        protocol.add(value);
                    } else if (nextElTag.equals("user-name")) {
                        value = this.getTextValue(loginEl);
                        this.info.setUserName(value);
                    } else if (nextElTag.equals("user-password")) {
                        temp = this.getFirstElement(loginEl);
                        value = temp != null ? this.getPropertyValue(this.getTextValue(temp), "user-password") : this.getTextValue(loginEl);
                        this.info.setUserPassword(value);
                    }
                }
                ++i;
            }
            Object[] transportProtocol = new String[protocol.size()];
            protocol.copyInto(transportProtocol);
            this.info.setTransportProtocol((String[])transportProtocol);
        }
    }

    protected String getTextValue(Element element) {
        Node node;
        if (element != null && (node = element.getFirstChild()) != null && node.getNodeType() == 3) {
            String value = node.getNodeValue();
            if (value.trim().equals("") || value.trim().equals("null")) {
                return null;
            }
            return value.trim();
        }
        return null;
    }

    private String getRelativePath(String path) throws Exception {
        if (path == null) {
            return null;
        }
        if (this.prjDir == null) {
            throw new Exception("Project directory is not set.");
        }
        String result = path.indexOf(this.prjDir) == -1 ? path : path.substring(this.prjDir.length());
        return result;
    }

    public String[] getUseAltEar() {
        return this.useAltEar;
    }

    public void setUseAltEar(String[] useAltEar) {
        this.useAltEar = useAltEar;
    }

    public String[] getUseAltElem() {
        return this.useAltElem;
    }

    public void setUseAltElem(String[] useAltElem) {
        this.useAltElem = useAltElem;
    }

    private String getAbsolutePath(String path) {
        String result;
        if (this.prjDir == null || this.prjDir.trim().equals("")) {
            return path;
        }
        File f = new File(path);
        if (!f.isAbsolute()) {
            if (this.prjDir.endsWith(File.separator) && this.prjDir.length() > 0) {
                this.prjDir = this.prjDir.substring(0, this.prjDir.length() - 1);
            }
            if (!path.startsWith(File.separator)) {
                path = File.separator + path;
            }
            result = this.prjDir + path;
        } else {
            File absFile;
            result = f.getAbsolutePath().startsWith(File.separator) ? ((absFile = new File(this.prjDir, path)).exists() ? absFile.getAbsolutePath() : (f.exists() ? f.getAbsolutePath() : absFile.getAbsolutePath())) : path;
        }
        return result;
    }

    public LoginInfo getInfo() {
        return this.info;
    }

    public void setInfo(LoginInfo info) {
        this.info = info;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public void setProjectDirectory(String prjDir) {
        this.prjDir = prjDir;
    }

    public String getProjectDirectory() {
        return this.prjDir;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String[] getSupports() {
        return this.supports;
    }

    public void setSupports(String[] supports) {
        this.supports = supports;
    }

    public void addToDeployProperties(String key, String value) {
        if (this.deployProp == null) {
            this.deployProp = new Properties();
        }
        this.deployProp.setProperty(key, value);
    }

    public Properties getDeployProperties() {
        return this.deployProp;
    }

    public void setDeployProperties(Properties pr1) {
        this.deployProp = pr1;
    }

    public String getContainerType() {
        return this.deployProp.getProperty("container_type");
    }

    public void setJ2EEModule(DeployableModul module) {
        this.module = module;
        this.dObjectType = J2EE_MODULE;
    }

    public DeployableModul getJ2EEModule() {
        return this.module;
    }

    public String getEarPath() {
        return this.earPath;
    }

    public void setEarPath(String earPath) {
        this.earPath = earPath;
        this.dObjectType = EAR;
    }

    public String getDeplObjectType() {
        return this.dObjectType;
    }

    public String getFullEarPath() {
        String dir = this.prjDir;
        if (dir != null && !new File(this.earPath).exists()) {
            dir = dir.replace('\\', File.separatorChar);
            if ((dir = dir.replace('/', File.separatorChar)).endsWith(File.separator)) {
                return dir + this.earPath;
            }
            return dir + File.separator + this.earPath;
        }
        return this.earPath;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public Vector getEntryName() {
        return this.entryName;
    }

    public void setEntryName(Vector entryName) {
        this.entryName = entryName;
        if (entryName == null) {
            this.entryName = new Vector();
        }
    }

    public Hashtable getAliases() {
        return this.aliases;
    }

    public void setAliases(Hashtable alias) {
        this.aliases = alias;
        if (this.aliases == null) {
            this.aliases = new Hashtable();
        }
    }

    public void setAlias(String war, String alias) {
        if (war != null && alias != null) {
            this.aliases.put(war, alias);
        }
    }

    public WebServiceRelated[] getService() {
        Object[] web = new WebServiceRelated[this.service.size()];
        this.service.copyInto(web);
        return web;
    }

    public void setService(WebServiceRelated[] service) {
        Vector<WebServiceRelated> temp = null;
        if (service != null) {
            temp = new Vector<WebServiceRelated>();
            int i = 0;
            while (i < service.length) {
                temp.add(service[i]);
                ++i;
            }
        }
        this.service = temp;
    }

    public String getAction_type() {
        return this.action_type;
    }

    public void setAction_type(String action_type) {
        this.action_type = action_type;
    }

    public void setComponentsXml(String xml) {
        this.components_xml = xml;
    }

    public String getComponentsXml() {
        return this.components_xml;
    }

    public SecurityRoles[] getRoles() {
        return this.roles;
    }

    public void setRoles(SecurityRoles[] roles) {
        this.roles = roles;
    }

    public UserRoleMappings getRoleMapTable() {
        return this.roleMapTable;
    }

    public void setRoleMapTable(UserRoleMappings roleMapTable) {
        this.roleMapTable = roleMapTable;
    }

    public InfoObject[] getEarFileAltDD() {
        return this.ear_fileAltDD;
    }

    public void setEarFileAltDD(InfoObject[] altDD) {
        this.ear_fileAltDD = altDD;
    }

    public void addEarFileAltDD(InfoObject altDD) {
        if (altDD == null || altDD.getEntryName() == null || altDD.getEntryName().equals("")) {
            return;
        }
        if (this.ear_fileAltDD == null) {
            this.ear_fileAltDD = new InfoObject[1];
            this.ear_fileAltDD[0] = altDD;
        } else {
            int i = 0;
            while (i < this.ear_fileAltDD.length) {
                if (this.ear_fileAltDD[i] != null && this.ear_fileAltDD[i].getEntryName() != null && this.ear_fileAltDD[i].getEntryName().equals(altDD.getEntryName())) {
                    this.ear_fileAltDD[i] = altDD;
                    return;
                }
                ++i;
            }
            InfoObject[] newAltDDs = new InfoObject[this.ear_fileAltDD.length + 1];
            System.arraycopy(this.ear_fileAltDD, 0, newAltDDs, 0, this.ear_fileAltDD.length);
            newAltDDs[this.ear_fileAltDD.length] = altDD;
            this.ear_fileAltDD = newAltDDs;
        }
    }

    public Vector getElementAltDD() {
        return this.elementAltDD;
    }

    public void setElementAltDD(Vector altDD) {
        this.elementAltDD = altDD;
    }

    public void setComponentXmlDoc(SComponentsXmlDocument doc) {
        this.compXmlDoc = doc;
    }

    public SComponentsXmlDocument getComponentXmlDoc() {
        return this.compXmlDoc;
    }

    public void writeComponentsXml() throws IOException {
        Document doc = this.compXmlDoc.loadDocumentFromFields();
        this.writer.write(doc, this.components_xml, "<!DOCTYPE server-components-management [\n<!ELEMENT server-components-management (component*)>\n<!ELEMENT component (component-name, component-file)>\n<!ATTLIST component action (deploy|update|remove) \"deploy\">\n<!ATTLIST component type (library|service|interface) #REQUIRED>\n<!ELEMENT component-name (#PCDATA)>\n<!ELEMENT component-file (archive-file-location, server-mapping-location?)>\n<!ELEMENT archive-file-location (#PCDATA)>\n<!ELEMENT server-mapping-location (#PCDATA)>\n]>", "UTF-8");
    }

    public SComponentsXmlDocument readComponentXML() throws IOException {
        if (this.components_xml == null) {
            return null;
        }
        Document doc = null;
        try {
            doc = this.parser.parse(this.components_xml);
        }
        catch (SAXException sax) {
            throw new IOException(sax.getMessage());
        }
        this.compXmlDoc = new SComponentsXmlDocument();
        this.compXmlDoc.loadFieldsFromDocument(doc);
        return this.compXmlDoc;
    }

    public Document loadDocumentFromFields() throws Exception {
        Element tempElement = null;
        this.mainDocument = StandardDOMParser.createDocument();
        this.mainElement = this.mainDocument.createElement("deploy-manager-config");
        this.mainDocument.appendChild(this.mainElement);
        this.load(this.mainElement, this.versionId, "version-id");
        if (this.prjDir != null) {
            this.load(this.mainElement, this.prjDir, "project-dir");
        }
        if (this.earPath != null) {
            tempElement = this.mainDocument.createElement("deployable-object");
            Element earEl = this.mainDocument.createElement("ear-file");
            this.loadEarFile(earEl);
            tempElement.setAttribute("action-type", this.action_type);
            tempElement.appendChild(earEl);
            this.mainElement.appendChild(tempElement);
        } else if (this.module != null) {
            tempElement = this.mainDocument.createElement("deployable-object");
            Element moduleEl = this.mainDocument.createElement("j2ee-module");
            this.loadModule(moduleEl);
            tempElement.setAttribute("action-type", this.action_type);
            tempElement.appendChild(moduleEl);
            this.mainElement.appendChild(tempElement);
        }
        if (this.entryName != null) {
            this.loadElement(this.mainElement);
        }
        tempElement = this.mainDocument.createElement("login-info");
        this.loadLoginInfo(tempElement);
        this.mainElement.appendChild(tempElement);
        tempElement = this.mainDocument.createElement("user-role-mapping");
        this.loadUserRole(tempElement);
        this.mainElement.appendChild(tempElement);
        tempElement = this.mainDocument.createElement("components-info");
        if (this.components_xml != null && !this.components_xml.equals("")) {
            this.load(this.mainElement, this.components_xml, "server-components-xml");
        }
        if (this.libInfo != null || this.refInfo != null) {
            tempElement = this.mainDocument.createElement("library-info");
            this.loadLibrary(tempElement);
            this.loadReferences(tempElement);
            this.mainElement.appendChild(tempElement);
        }
        tempElement = this.mainDocument.createElement("supports");
        this.loadSupport(tempElement);
        this.mainElement.appendChild(tempElement);
        tempElement = this.mainDocument.createElement("deployment-properties");
        this.loadDeployProps(tempElement);
        this.mainElement.appendChild(tempElement);
        tempElement = this.mainDocument.createElement("repl-var-properties");
        this.loadsubstProps(tempElement);
        this.mainElement.appendChild(tempElement);
        if (this.logFile != null) {
            this.load(this.mainElement, this.getRelativePath(this.logFile), "log-file");
        }
        return this.mainDocument;
    }

    public void loadFieldsFromDocument(Document document) throws WrongStructureException {
        Element elm = document.getDocumentElement();
        NodeList list = elm.getChildNodes();
        Element element = null;
        String tag = null;
        SimpleEARClassLoader loader = null;
        this.entryName.clear();
        this.elementAltDD.clear();
        this.service.clear();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("version-id")) {
                    this.versionId = this.getTextValue(element);
                } else if (tag.equals("project-dir")) {
                    if (this.prjDir == null) {
                        this.prjDir = this.getTextValue(element);
                    }
                } else if (tag.equals("deployable-object")) {
                    this.initDeployableObject(element);
                } else if (tag.equals("ear-file")) {
                    this.initEarFile(element);
                    String earFileName = this.earPath;
                    if (this.prjDir != null && !new File(this.earPath).exists()) {
                        this.prjDir = this.replaceSeparator(this.prjDir);
                        earFileName = this.prjDir.endsWith(File.separator) ? this.prjDir + this.earPath : this.prjDir + File.separator + this.earPath;
                    }
                    loader = new SimpleEARClassLoader(null, earFileName);
                } else if (tag.equals("element")) {
                    this.initElement(element);
                } else if (tag.equals("login-info")) {
                    this.initLoginInfo(element);
                } else if (tag.equals("user-role-mapping")) {
                    this.roles = this.initUserRoles(element);
                } else if (tag.equals("server-components-xml")) {
                    this.components_xml = this.getTextValue(element);
                } else if (tag.equals("supports")) {
                    this.supports = this.initSupport(element);
                } else if (tag.equals("deployment-properties")) {
                    this.initDeployProp(element);
                } else if (tag.equals("repl-var-properties")) {
                    this.initSubstProp(element);
                } else if (tag.equals("log-file")) {
                    this.logFile = this.getTextValue(element);
                    if (this.logFile != null) {
                        this.logFile = this.getAbsolutePath(this.logFile);
                    }
                } else if (tag.equals("library-info")) {
                    this.initLibraries(element);
                    this.initReferences(element);
                }
            }
            ++i;
        }
        if (loader != null) {
            loader.clear();
        }
        if (this.earPath == null && this.elementAltDD.size() > 1 && this.entryName.size() > 1) {
            throw new WrongStructureException("The ear path in deployer xml is null so there must be only one element!");
        }
    }

    private String replaceSeparator(String path) {
        String newPath = path.replace('\\', File.separatorChar);
        return newPath.replace('/', File.separatorChar);
    }

    public Hashtable getWebServicesFiles() {
        Hashtable res = new Hashtable();
        Vector<Object> temp = new Vector<Object>();
        WebServiceRelated wsr = null;
        Object[] infsTemp = null;
        int i = 0;
        while (i < this.entryName.size()) {
            if (this.service.elementAt(i) != null) {
                wsr = (WebServiceRelated)this.service.elementAt(i);
                if (wsr.getWebServAltDD() != null) {
                    temp.add(wsr.getWebServAltDD());
                }
                if (wsr.getSapWebServAltDD() != null) {
                    temp.add(wsr.getSapWebServAltDD());
                }
                if (wsr.getWebServClientAltDD() != null) {
                    temp.add(wsr.getWebServClientAltDD());
                }
                if (wsr.getWebServWsdlFiles() != null) {
                    infsTemp = wsr.getWebServWsdlFiles();
                    int i1 = 0;
                    while (i1 < infsTemp.length) {
                        if (infsTemp[i1] != null) {
                            temp.add(infsTemp[i1]);
                        }
                        ++i1;
                    }
                }
                infsTemp = new InfoObject[temp.size()];
                temp.copyInto(infsTemp);
                res.put(this.entryName.elementAt(i), infsTemp);
            }
            ++i;
        }
        return res;
    }

    public Hashtable getAltDDAsHahstable() {
        Hashtable res = new Hashtable();
        int i = 0;
        while (i < this.entryName.size()) {
            if (this.entryName != null && this.entryName.elementAt(i) != null && this.elementAltDD != null && this.elementAltDD.elementAt(i) != null) {
                res.put(this.entryName.elementAt(i), this.elementAltDD.elementAt(i));
            }
            ++i;
        }
        return res;
    }

    public void setLibraries(LibraryInfo[] info) {
        this.libInfo = info;
    }

    public LibraryInfo[] getLibraries() {
        return this.libInfo;
    }

    public void setRefInfo(Hashtable info) {
        this.refInfo = info;
    }

    public Hashtable getRefInfo() {
        return this.refInfo;
    }

    public void loadLibrary(Element el) {
        Element libEl = null;
        Element tempEl = null;
        int r = 0;
        while (r < this.libInfo.length) {
            libEl = this.mainDocument.createElement("library");
            if (this.libInfo[r] != null && this.libInfo[r].getLibraryName() != null) {
                this.load(libEl, this.libInfo[r].getLibraryName(), "lib-name");
                if (this.libInfo[r].getLibraryFile() != null) {
                    int i = 0;
                    while (i < this.libInfo[r].getLibraryFile().length) {
                        tempEl = this.load(libEl, this.libInfo[r].getLibraryFile()[i].getFilePath(), "lib-jar");
                        if (this.libInfo[r].getLibraryFile()[i].getEntryName() != null) {
                            tempEl.setAttribute("server-map-name", this.libInfo[r].getLibraryFile()[i].getEntryName());
                        }
                        ++i;
                    }
                }
                el.appendChild(libEl);
            }
            ++r;
        }
    }

    public void loadReferences(Element el) {
        if (this.refInfo == null) {
            return;
        }
        Element refEl = null;
        String key = null;
        String[] values = null;
        Enumeration enumeration = this.refInfo.keys();
        while (enumeration.hasMoreElements()) {
            refEl = this.mainDocument.createElement("reference");
            key = (String)enumeration.nextElement();
            values = (String[])this.refInfo.get(key);
            this.load(refEl, key, "from-loader");
            int i = 0;
            while (i < values.length) {
                this.load(refEl, values[i], "to-loader");
                ++i;
            }
            el.appendChild(refEl);
        }
    }

    public void initLibraries(Element libInfoEl) {
        NodeList list = libInfoEl.getChildNodes();
        if (list == null) {
            this.libInfo = null;
            return;
        }
        Vector<LibraryInfo> libV = new Vector<LibraryInfo>();
        LibraryInfo libInf = null;
        Element libEl = null;
        String libName = null;
        String libJar = null;
        String mapping = null;
        NodeList list1 = null;
        InfoObject[] infoes = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1 && (libEl = (Element)list.item(i)) != null && libEl.getNodeName().equals("library") && (list1 = libEl.getElementsByTagName("lib-name")) != null && list1.getLength() != 0) {
                libName = this.getTextValue((Element)list1.item(0));
                list1 = libEl.getElementsByTagName("lib-jar");
                if (list1 != null && list1.getLength() != 0) {
                    infoes = new InfoObject[list1.getLength()];
                    int i1 = 0;
                    while (i1 < list1.getLength()) {
                        libJar = this.getTextValue((Element)list1.item(i1));
                        mapping = ((Element)list1.item(i1)).getAttribute("server-map-name");
                        infoes[i1] = new InfoObject(mapping, libJar);
                        ++i1;
                    }
                    libInf = new LibraryInfo();
                    libInf.setLibraryName(libName);
                    libInf.setLibraryFile(infoes);
                    libV.add(libInf);
                }
            }
            ++i;
        }
        this.libInfo = new LibraryInfo[libV.size()];
        libV.copyInto(this.libInfo);
    }

    public void initReferences(Element libInfoEl) {
        NodeList list = libInfoEl.getElementsByTagName("reference");
        if (list == null || list.getLength() == 0) {
            this.refInfo = null;
            return;
        }
        this.refInfo = new Hashtable();
        Element refEl = null;
        String fromLoader = null;
        String[] toLoaders = null;
        NodeList list1 = null;
        int i1 = 0;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1 && (list1 = (refEl = (Element)list.item(i)).getElementsByTagName("from-loader")) != null && list1.getLength() != 0) {
                fromLoader = this.getTextValue((Element)list1.item(0));
                list1 = refEl.getElementsByTagName("to-loader");
                if (list1 != null && list1.getLength() != 0) {
                    toLoaders = new String[list1.getLength()];
                    i1 = 0;
                    while (i1 < list1.getLength()) {
                        toLoaders[i1] = this.getTextValue((Element)list1.item(i1));
                        ++i1;
                    }
                    this.refInfo.put(fromLoader, toLoaders);
                }
            }
            ++i;
        }
    }

    public void initDeployableObject(Element element) {
        NodeList list = element.getChildNodes();
        if (list == null || list.getLength() == 0) {
            return;
        }
        String tagName = null;
        Element el = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                el = (Element)list.item(i);
                tagName = el.getTagName();
                if (tagName.equals("ear-file")) {
                    this.initEarFile(el);
                } else if (tagName.equals("j2ee-module")) {
                    this.initModule(el);
                }
            }
            ++i;
        }
        this.action_type = element.getAttribute("action-type");
    }

    public void initModule(Element element) {
        NodeList list = element.getChildNodes();
        if (list == null || list.getLength() == 0) {
            return;
        }
        this.module = new DeployableModul();
        String name = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                name = el.getNodeName();
                if (name.equals("archive-path")) {
                    this.module.setFilePath(this.getTextValue(el));
                } else if (name.equals("altdd") && el.getChildNodes() != null) {
                    this.module.addAltDD(this.getInfoFromElement(el));
                }
            }
            ++i;
        }
        this.module.setContainer(element.getAttribute("container"));
        this.setJ2EEModule(this.module);
    }

    public void setDeployable_library(Hashtable deployable_library) {
        if (deployable_library != null && deployable_library.size() != 0) {
            Vector<LibraryInfo> libInfoVector = new Vector<LibraryInfo>();
            LibraryInfo libObj = null;
            Enumeration enumeration = deployable_library.keys();
            while (enumeration.hasMoreElements()) {
                libObj = new LibraryInfo();
                libObj.setLibraryName((String)enumeration.nextElement());
                libObj.setLibraryNameAttribute(ACTION_TYPE_DEPLOY);
                libObj.setLibraryFile((InfoObject[])deployable_library.get(libObj.getLibraryName()));
                libInfoVector.add(libObj);
            }
            this.libInfo = new LibraryInfo[libInfoVector.size()];
            libInfoVector.copyInto(this.libInfo);
        } else {
            this.libInfo = new LibraryInfo[0];
        }
    }

    public void setReferenced_library(String displayName, String[] referenced_library) {
        if (this.refInfo == null) {
            this.refInfo = new Hashtable();
        }
        if (referenced_library == null) {
            referenced_library = new String[]{};
        }
        this.refInfo.put(displayName, referenced_library);
    }

    private InfoObject getInfoFromElement(Element el) {
        InfoObject info = new InfoObject();
        NodeList altddList = el.getChildNodes();
        Element altddEl = null;
        int j = 0;
        while (j < altddList.getLength()) {
            if (altddList.item(j).getNodeType() == 1) {
                altddEl = (Element)altddList.item(j);
                if (altddEl.getNodeName().equals("pathname")) {
                    info.setFilePath(this.getAbsolutePath(this.getTextValue(altddEl)));
                } else if (altddEl.getNodeName().equals("entry-name")) {
                    info.setEntryName(this.getTextValue(altddEl));
                }
            }
            ++j;
        }
        return info;
    }

    public void setSubstProps(Properties p) {
        this.substProps = p;
    }

    public Properties getSubstProps() {
        return this.substProps;
    }

    private void initXMLToolkit() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.writer = new StandardDOMWriter();
        this.parser = new StandardDOMParser();
        Thread.currentThread().setContextClassLoader(cl);
    }

    public void setPasswordFile(String filePath) {
        this.pswFile = filePath;
    }

    private String getPropertyValue(String file, String key) {
        Properties p = new Properties();
        SecStoreFS store = new SecStoreFS();
        try {
            store.setFilenames(file, null);
            SecStoreFS.setSID((String)"DeployTool");
            store.openExistingStore();
            p = store.getStringPairs();
        }
        catch (Exception e) {
            return "";
        }
        return p.getProperty(key);
    }

    private void setProperties(String file, String key, String value) {
        SecStoreFS store = new SecStoreFS();
        try {
            store.setFilenames(file, null);
            SecStoreFS.setSID((String)"DeployTool");
            try {
                store.openExistingStore();
            }
            catch (Exception e1) {
                if (store.isEncryptionPossible()) {
                    try {
                        store.createStoreWithEncryption();
                    }
                    catch (Exception e2) {
                        store.createStoreWithoutEncryption();
                    }
                }
                store.createStoreWithoutEncryption();
            }
            try {
                store.updatePair(key, value);
            }
            catch (Exception e1) {
                store.insertPair(key, value);
            }
        }
        catch (Exception e) {
            this.toLog(e);
        }
    }

    private void toLog(Exception e) {
        e.printStackTrace();
    }
}

