/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.generator;

import com.sap.engine.deploy.ToolBundle;
import com.sap.engine.deploy.generator.AltDD;
import com.sap.engine.deploy.generator.EARGeneratorException;
import com.sap.engine.deploy.generator.EarJob;
import com.sap.engine.deploy.generator.EarObject;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLEarManager {
    public static final String EAR = "ear";
    public static final String PRJDIRECTORY = "project-dir";
    public static final String DISPLAYNAME = "displayname";
    public static final String SMALLICON = "small-icon";
    public static final String LARGEICON = "large-icon";
    public static final String DESCRIPTION = "description";
    public static final String USEALTDD = "use-alternative";
    public static final String PATHNAME = "pathname";
    public static final String ENTRYNAME = "entryname";
    public static final String ELNAME = "elname";
    public static final String ALTDD = "altdd";
    public static final String CONTEXTROOT = "contextroot";
    public static final String WAR = "war";
    public static final String YES = "yes";
    public static final String FILE = "file";
    public static final String NO = "no";
    public static final String JAR = "jar";
    public static final String CLIENT = "client";
    public static final String CONNECTOR = "rar";
    public static final String IS_LOADED = "is-loaded";
    public static final String dtd = "<!DOCTYPE ear-generator [\n<!ELEMENT ear-generator (ear)+>\n<!ELEMENT ear (project-dir?, pathname, displayname, small-icon?, large-icon?, description?, (jar|war|client|file|rar)+)>\n<!ELEMENT project-dir (#PCDATA)>\n<!ELEMENT jar (pathname, entryname, is-loaded, altdd*)>\n<!ELEMENT war (pathname, entryname, contextroot, is-loaded, altdd*)>\n<!ELEMENT client (pathname, entryname, is-loaded, altdd*)>\n<!ELEMENT file (pathname, entryname)>\n<!ELEMENT rar (pathname, entryname, is-loaded, altdd*)>\n<!ELEMENT altdd (pathname, elname)>\n<!ATTLIST altdd use-alternative (yes|no) #REQUIRED>\n<!ELEMENT is-loaded (#PCDATA)>\n<!ELEMENT elname (#PCDATA)>\n<!ELEMENT pathname (#PCDATA)>\n<!ELEMENT entryname (#PCDATA)>\n<!ELEMENT displayname (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT contextroot (#PCDATA)>\n]>";
    StandardDOMWriter writer = new StandardDOMWriter();
    private boolean logStarted = false;
    private RandomAccessFile out = null;
    private String prjFileDir = null;
    private boolean hasLogFile = true;
    private boolean isLoaded = false;

    public XMLEarManager() {
    }

    public XMLEarManager(RandomAccessFile out) {
        this.setLog(out);
    }

    public XMLEarManager(String s) {
        this.startLog(s);
    }

    public void setPrjFileDir(String prjFileDir) {
        this.prjFileDir = prjFileDir;
    }

    public void writeJob(EarJob job, String xmlname) throws EARGeneratorException {
        String description;
        String largeIcon;
        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0037"));
        Document doc = StandardDOMParser.createDocument();
        this.setRelativePaths(job);
        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0038"));
        Element root = doc.createElement("ear-generator");
        doc.appendChild(root);
        Element ear = doc.createElement(EAR);
        root.appendChild(ear);
        Element el = doc.createElement(PRJDIRECTORY);
        Text tx = doc.createTextNode(this.prjFileDir);
        el.appendChild(tx);
        ear.appendChild(el);
        el = doc.createElement(PATHNAME);
        tx = doc.createTextNode(job.getOutputname());
        el.appendChild(tx);
        ear.appendChild(el);
        el = doc.createElement(DISPLAYNAME);
        tx = doc.createTextNode(job.getDisplayname());
        el.appendChild(tx);
        ear.appendChild(el);
        String smallIcon = job.getSmallIcon();
        if (smallIcon != null && !smallIcon.trim().equals("")) {
            el = doc.createElement(SMALLICON);
            el.appendChild(doc.createTextNode(smallIcon));
            ear.appendChild(el);
        }
        if ((largeIcon = job.getLargeIcon()) != null && !largeIcon.trim().equals("")) {
            el = doc.createElement(LARGEICON);
            el.appendChild(doc.createTextNode(largeIcon));
            ear.appendChild(el);
        }
        if ((description = job.getDescription()) != null && !description.trim().equals("")) {
            el = doc.createElement(DESCRIPTION);
            el.appendChild(doc.createTextNode(description));
            ear.appendChild(el);
        }
        Enumeration enumeration = job.getEarFiles();
        EarObject eob = null;
        while (enumeration.hasMoreElements()) {
            Element el1;
            eob = (EarObject)enumeration.nextElement();
            switch (eob.getType()) {
                case 1: {
                    el1 = doc.createElement(JAR);
                    break;
                }
                case 2: {
                    el1 = doc.createElement(WAR);
                    break;
                }
                case 4: {
                    el1 = doc.createElement(CLIENT);
                    break;
                }
                case 5: {
                    el1 = doc.createElement(CONNECTOR);
                    break;
                }
                default: {
                    el1 = doc.createElement(FILE);
                }
            }
            Element el2 = doc.createElement(PATHNAME);
            Text tx1 = this.isLoaded ? doc.createTextNode(this.prjFileDir + eob.getPathname()) : doc.createTextNode(eob.getPathname());
            el2.appendChild(tx1);
            el1.appendChild(el2);
            el2 = doc.createElement(ENTRYNAME);
            tx1 = doc.createTextNode(eob.getEntryname());
            el2.appendChild(tx1);
            el1.appendChild(el2);
            if (eob.getType() == 2) {
                el2 = doc.createElement(CONTEXTROOT);
                tx1 = doc.createTextNode(eob.getContextroot());
                el2.appendChild(tx1);
                el1.appendChild(el2);
            }
            if (eob.getType() == 5 || eob.getType() == 1 || eob.getType() == 4 || eob.getType() == 2) {
                el2 = doc.createElement(IS_LOADED);
                tx1 = doc.createTextNode(eob.getIsLoaded() ? "true" : "false");
                el2.appendChild(tx1);
                el1.appendChild(el2);
            }
            Enumeration enumalt = eob.getAlternativeDD();
            AltDD altdd = null;
            while (enumalt.hasMoreElements()) {
                altdd = (AltDD)enumalt.nextElement();
                el2 = doc.createElement(ALTDD);
                Element el3 = doc.createElement(PATHNAME);
                tx = doc.createTextNode(altdd.getPath());
                el3.appendChild(tx);
                el2.appendChild(el3);
                el3 = doc.createElement(ELNAME);
                tx = doc.createTextNode(altdd.getElname());
                el3.appendChild(tx);
                el2.appendChild(el3);
                el2.setAttribute(USEALTDD, altdd.getUse() ? YES : NO);
                el1.appendChild(el2);
            }
            ear.appendChild(el1);
        }
        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0039"));
        try {
            this.writer.write(doc, xmlname, dtd, "UTF-8");
            this.toLog(ToolBundle.getResourceString("ear_gen_msg_0040"));
        }
        catch (IOException e) {
            throw new EARGeneratorException("ear_gen_err_msg_0011", new String[]{xmlname, e.getMessage()});
        }
    }

    protected String getElementText(Element el, String name) throws EARGeneratorException {
        NodeList nl = el.getElementsByTagName(name);
        Node node = nl.item(0);
        if (node == null) {
            return null;
        }
        if (node.getNodeType() != 1) {
            throw new EARGeneratorException("ear_gen_err_msg_0014");
        }
        nl = node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node nn = nl.item(i);
            if (nn.getNodeType() == 3) {
                StandardDOMParser.trimWhiteSpaces((Node)nn);
                if (((Text)nn).getData().length() != 0) {
                    return ((Text)nn).getData();
                }
            }
            ++i;
        }
        return "";
    }

    private void scanEar(Element ear, EarJob job) throws Exception {
        Object earpathname = null;
        Object eardisplayname = null;
        job.setDisplayname(this.getElementText(ear, DISPLAYNAME));
        job.setSmallIcon(this.getElementText(ear, SMALLICON));
        job.setLargeIcon(this.getElementText(ear, LARGEICON));
        job.setDescription(this.getElementText(ear, DESCRIPTION));
        job.setOutputname(this.getElementText(ear, PATHNAME));
        if (this.prjFileDir == null) {
            try {
                this.prjFileDir = this.getElementText(ear, PRJDIRECTORY);
            }
            catch (Exception oldprjexc) {
                this.prjFileDir = null;
            }
        }
        NodeList nl = ear.getChildNodes();
        Vector earobjects = new Vector();
        int i = 0;
        while (i < nl.getLength()) {
            Element subnode;
            EarObject eob = new EarObject();
            if (!(nl.item(i).getNodeType() != 1 || (subnode = (Element)nl.item(i)).getNodeName().equals(DISPLAYNAME) || subnode.getNodeName().equals(SMALLICON) || subnode.getNodeName().equals(LARGEICON) || subnode.getNodeName().equals(DESCRIPTION) || subnode.getNodeName().equals(PATHNAME) || subnode.getNodeName().equals(PRJDIRECTORY))) {
                eob.reuse();
                eob.setEntryname(this.getElementText(subnode, ENTRYNAME));
                eob.setPathname(this.getElementText(subnode, PATHNAME));
                NodeList nn = subnode.getElementsByTagName(IS_LOADED);
                if (nn.getLength() > 0) {
                    eob.setIsLoaded(new Boolean(this.getElementText(subnode, IS_LOADED)));
                }
                NodeList nl2 = subnode.getElementsByTagName(ALTDD);
                int j = 0;
                while (j < nl2.getLength()) {
                    Element el2 = (Element)nl2.item(j);
                    eob.addAlternateDD(this.getElementText(el2, PATHNAME), this.getElementText(el2, ELNAME), el2.getAttribute(USEALTDD).equals(YES));
                    ++j;
                }
                if (subnode.getNodeName().equals(WAR)) {
                    eob.setContextroot(this.getElementText(subnode, CONTEXTROOT));
                    eob.setType(2);
                } else if (subnode.getNodeName().equals(JAR)) {
                    eob.setType(1);
                } else if (subnode.getNodeName().equals(CLIENT)) {
                    eob.setType(4);
                } else if (subnode.getNodeName().equals(CONNECTOR)) {
                    eob.setType(5);
                } else if (subnode.getNodeName().equals(FILE)) {
                    eob.setType(3);
                }
                job.addEarObject(eob);
            }
            ++i;
        }
        this.setAbsolutePaths(job);
    }

    public void readXML(EarJob job, String xmlname) throws EARGeneratorException {
        try {
            StandardDOMParser parser = new StandardDOMParser();
            parser.setValidation(true);
            Document doc = parser.parse(xmlname);
            Element root = doc.getDocumentElement();
            NodeList nl = root.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                if (node.getNodeType() == 1 && node.getNodeName().equals(EAR)) {
                    this.scanEar((Element)node, job);
                }
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            throw new EARGeneratorException("ear_gen_err_msg_0013", new String[]{xmlname, e.getMessage()});
        }
        catch (Exception e) {
            throw new EARGeneratorException("ear_gen_err_msg_0012", new String[]{xmlname, e.getMessage()});
        }
    }

    public EarJob readXML(String xmlname) throws EARGeneratorException {
        EarJob job = new EarJob();
        this.readXML(job, xmlname);
        return job;
    }

    private void toLog(String str) {
        try {
            if (!this.logStarted) {
                return;
            }
            String logDate = DateFormat.getTimeInstance().format(new Date());
            String s = logDate + ": " + str + "\r\n";
            this.out.write(s.getBytes());
        }
        catch (Exception e) {
            System.out.println(ToolBundle.getResourceString("ear_gen_msg_0017", e.getMessage()));
            System.out.println(ToolBundle.getResourceString("ear_gen_msg_0041"));
            System.exit(0);
        }
    }

    public void setLog(RandomAccessFile out) {
        this.out = out;
        this.logStarted = true;
    }

    public void startLog(String s) {
        try {
            this.out = new RandomAccessFile(s, "rw");
            this.out.seek(this.out.length());
            this.logStarted = true;
            Date d = new Date();
            String ss = "---------- Log Started on: " + d;
            this.out.write(s.getBytes());
        }
        catch (Exception e) {
            System.out.println(ToolBundle.getResourceString("ear_gen_msg_0017", e.getMessage()));
        }
    }

    public void startLog() {
        System.out.println(ToolBundle.getResourceString("ear_gen_msg_0018"));
        this.startLog("logfile.txt");
    }

    private String getRelativPath(String prjDir, String path) {
        String result;
        if (path == null) {
            return null;
        }
        if (prjDir == null || prjDir.trim().equals("")) {
            return path;
        }
        if (path.indexOf(prjDir) != -1) {
            int i = prjDir.length();
            result = path.substring(i);
        } else {
            result = path;
        }
        return result;
    }

    private void setRelativePaths(EarJob job) {
        String path = job.getOutputname();
        job.setOutputname(this.getRelativPath(this.prjFileDir, path));
        Enumeration enumeration = job.getEarFiles();
        Enumeration enumDD = null;
        AltDD altDD = null;
        while (enumeration.hasMoreElements()) {
            EarObject earObj = (EarObject)enumeration.nextElement();
            path = earObj.getPathname();
            earObj.setPathname(this.getRelativPath(this.prjFileDir, path));
            enumDD = earObj.getAlternativeDD();
            while (enumDD.hasMoreElements()) {
                altDD = (AltDD)enumDD.nextElement();
                path = altDD.getPath();
                altDD.setPath(this.getRelativPath(this.prjFileDir, path));
            }
        }
    }

    private void setAbsolutePaths(EarJob job) {
        job.setOutputname(this.getAbsolutePath(job.getOutputname()));
        File f1 = new File(job.getDisplayname());
        Enumeration enumeration = job.getEarFiles();
        Enumeration enumDD = null;
        AltDD altDD = null;
        while (enumeration.hasMoreElements()) {
            EarObject earObj = (EarObject)enumeration.nextElement();
            earObj.setPathname(this.getAbsolutePath(earObj.getPathname()));
            enumDD = earObj.getAlternativeDD();
            while (enumDD.hasMoreElements()) {
                altDD = (AltDD)enumDD.nextElement();
                altDD.setPath(this.getAbsolutePath(altDD.getPath()));
            }
        }
    }

    private String getAbsolutePath(String path) {
        File absFile;
        if (this.prjFileDir == null || this.prjFileDir.equals("")) {
            return path;
        }
        File f = new File(path);
        String returnValue = f.isAbsolute() && !path.startsWith(File.separator) ? f.getAbsolutePath() : ((absFile = new File(this.prjFileDir, path)).exists() ? absFile.getAbsolutePath() : (f.exists() ? f.getAbsolutePath() : absFile.getAbsolutePath()));
        return returnValue;
    }

    public boolean getHasLogFile() {
        return this.hasLogFile;
    }

    public void setHasLogFile(boolean hasLogFile) {
        this.hasLogFile = hasLogFile;
    }
}

