/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.generator;

import com.sap.engine.deploy.ejb.descriptors.jar.ReadEjbJar;
import com.sap.engine.deploy.generator.AltDD;
import com.sap.engine.deploy.generator.EARGeneratorException;
import com.sap.engine.services.appclient.descriptor.ClientJar;
import com.sap.engine.services.connector.jca.deploy.descriptor.jar.ReadRar;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.jar.WebWar;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EarObject {
    private String entryName;
    private String pathName;
    private String contextRoot;
    private String originalName = null;
    public static final int EJB = 1;
    public static final int WEB = 2;
    public static final int JAVA = 4;
    public static final int OTHER = 3;
    public static final int CONNECTOR = 5;
    private int type = 1;
    private Hashtable deploymentDescriptors = new Hashtable();
    private ArchiveDescriptor archiveDescriptor = null;
    private Hashtable altdd = new Hashtable();
    private boolean changed = false;
    private boolean isLoaded;
    private Vector errors = new Vector();

    public static String mkPath(String path) {
        return path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public EarObject() {
    }

    public EarObject reuse() {
        this.altdd.clear();
        this.entryName = null;
        this.pathName = null;
        this.contextRoot = null;
        this.changed = true;
        return this;
    }

    public EarObject(String entry, String path, int type) throws FileNotFoundException {
        this.entryName = EarObject.mkPath(entry);
        this.pathName = EarObject.mkPath(path);
        File f = new File(this.pathName);
        this.pathName = f.getAbsolutePath();
        this.type = type;
    }

    public EarObject(String entry, String path, String root) throws FileNotFoundException {
        this.entryName = EarObject.mkPath(entry);
        this.pathName = EarObject.mkPath(path);
        File f = new File(this.pathName);
        this.pathName = f.getAbsolutePath();
        this.setContextroot(root);
        this.type = 2;
    }

    public void addAlternateDD(String path, String elname, boolean use) {
        this.altdd.put(elname, new AltDD(EarObject.mkPath(path), elname, use));
    }

    public int getType() {
        return this.type;
    }

    public void setType(int value) {
        this.type = value;
    }

    public String getContextroot() {
        return this.contextRoot;
    }

    public void setContextroot(String context) {
        if (context == null || context.equals("")) {
            context = "/";
        }
        context = context.replace(':', '_');
        context = context.replace('*', '_');
        context = context.replace('?', '_');
        context = context.replace('\"', '_');
        context = context.replace('<', '_');
        context = context.replace('>', '_');
        context = context.replace('|', '_');
        if ((context = context.replace('\\', '/')).endsWith(".")) {
            context = context.substring(0, context.length() - 1) + "_";
        }
        while (context.length() > 1 && context.startsWith("/")) {
            context = context.substring(1, context.length());
        }
        StringBuffer temp = new StringBuffer();
        int i = 0;
        while (i < context.length()) {
            if (context.charAt(i) != '/' || context.charAt(i) == '/' && (temp.length() == 0 || temp.charAt(temp.length() - 1) != '/')) {
                temp.append(context.charAt(i));
            }
            ++i;
        }
        this.contextRoot = context = new String(temp);
    }

    public String getEntryname() {
        return this.entryName;
    }

    public void setEntryname(String entryName) {
        this.entryName = EarObject.mkPath(entryName);
    }

    public String getPathname() {
        return this.pathName;
    }

    public void setPathname(String pathName) {
        this.pathName = EarObject.mkPath(pathName);
    }

    public Enumeration getAlternativeDD() {
        return this.altdd.elements();
    }

    public void setArchiveDescriptor(ArchiveDescriptor ad) {
        this.archiveDescriptor = ad;
        this.deploymentDescriptors.clear();
        this.changed = true;
    }

    public void setDeploymentDescriptor(Descriptor dd) {
        this.deploymentDescriptors.put(dd.getName(), dd);
        this.changed = true;
    }

    public ArchiveDescriptor getArchiveDescriptor(String classPath) throws EARGeneratorException {
        try {
            if (this.type == 2 && this.archiveDescriptor == null) {
                WebWar ww = new WebWar(this.pathName);
                WebDeploymentDescriptor wd = ww.getWebDescriptor();
                if (wd == null) {
                    throw new EARGeneratorException("ear_gen_err_msg_0008", this.getOriginalName());
                }
                this.archiveDescriptor = wd;
                this.archiveDescriptor.setDisplayName(wd.getDisplayName());
            } else if (this.type == 1 && this.archiveDescriptor == null) {
                ReadEjbJar ej = new ReadEjbJar(this.pathName);
                ej.setClassPath(classPath);
                this.archiveDescriptor = ej.getEjbJarDescriptor();
                this.errors = ej.getErrors();
                if (this.archiveDescriptor == null) {
                    throw new EARGeneratorException("ear_gen_err_msg_0009", this.getOriginalName());
                }
            } else if (this.type == 4 && this.archiveDescriptor == null) {
                ClientJar cj = new ClientJar(this.pathName);
                this.archiveDescriptor = cj.getDescriptor();
                if (this.archiveDescriptor == null) {
                    throw new EARGeneratorException("ear_gen_err_msg_0019", this.getOriginalName());
                }
            } else if (this.type == 5 && this.archiveDescriptor == null) {
                ReadRar readRar = new ReadRar(this.pathName);
                this.archiveDescriptor = readRar.getDescriptor();
                if (this.archiveDescriptor == null) {
                    throw new EARGeneratorException("ear_gen_err_msg_0020", this.getOriginalName());
                }
            }
            return this.archiveDescriptor;
        }
        catch (EARGeneratorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EARGeneratorException("ear_gen_err_msg_0010", new String[]{this.getOriginalName(), e.getMessage()});
        }
    }

    public Descriptor getDeploymentDescriptor(String name) throws EARGeneratorException {
        Descriptor desc = (Descriptor)this.deploymentDescriptors.get(name);
        if (desc != null) {
            return desc;
        }
        if (this.archiveDescriptor == null) {
            this.getArchiveDescriptor(".");
        }
        if (this.archiveDescriptor == null) {
            return null;
        }
        Descriptor[] dds = this.archiveDescriptor.getDescriptors();
        int i = 0;
        while (i < dds.length) {
            if (dds[i].getName().equals(name)) {
                return dds[i];
            }
            ++i;
        }
        return null;
    }

    public boolean getChanged() {
        return this.changed;
    }

    public void setChanged(boolean value) {
        this.changed = value;
    }

    public void packDescriptor() throws EARGeneratorException {
        this.getArchiveDescriptor(".");
        if (this.archiveDescriptor == null) {
            return;
        }
        if (this.type == 1) {
            Descriptor[] dds = this.archiveDescriptor.getDescriptors();
            int i = 0;
            while (i < dds.length) {
                if (this.deploymentDescriptors.containsKey(dds[i].getName())) {
                    dds[i] = (Descriptor)this.deploymentDescriptors.get(dds[i].getName());
                }
                ++i;
            }
            ((EJBJarDescriptor)this.archiveDescriptor).setDescriptors((DeploymentDescriptor[])dds);
        }
    }

    public AltDD getAlternativeDD(String name) {
        return (AltDD)this.altdd.get(name);
    }

    public String getOriginalName() {
        if (this.originalName == null) {
            return this.pathName;
        }
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public void setIsLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }

    public boolean getIsLoaded() {
        return this.isLoaded;
    }

    public Vector getErrors() {
        return this.errors;
    }
}

