/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.generator;

import com.sap.engine.deploy.generator.EarObject;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Vector;

public class EarJob {
    private String outputname;
    private String displayname;
    private String smallIcon;
    private String largeIcon;
    private String description;
    private Vector files = new Vector();

    public EarJob(String outputname, String displayname) {
        this.reuse(outputname, displayname);
    }

    public EarJob() {
    }

    public void reuse(String outputname, String displayname) {
        this.outputname = EarObject.mkPath(outputname);
        this.displayname = displayname;
        this.files.clear();
    }

    public void addJar(String path, String entry) throws FileNotFoundException {
        this.files.add(new EarObject(EarObject.mkPath(entry), EarObject.mkPath(path), 1));
    }

    public void addWar(String path, String entry, String context) throws FileNotFoundException {
        this.files.add(new EarObject(EarObject.mkPath(entry), EarObject.mkPath(path), context));
    }

    public void addOtherFile(String path, String entry) throws FileNotFoundException {
        this.files.add(new EarObject(EarObject.mkPath(entry), EarObject.mkPath(path), 3));
    }

    public void addEarObject(EarObject eob) {
        this.files.add(eob);
    }

    public void removeEntry(String entry) {
        entry = EarObject.mkPath(entry);
        int i = 0;
        while (i < this.files.size()) {
            if (((EarObject)this.files.get(i)).getEntryname().equals(entry)) {
                this.files.remove(i);
            }
            ++i;
        }
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    public String getOutputname() {
        return this.outputname;
    }

    public void setOutputname(String outputname) {
        this.outputname = EarObject.mkPath(outputname);
    }

    public Enumeration getEarFiles() {
        return this.files.elements();
    }
}

