/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.persistent.model;

import com.sap.engine.deploy.ejb.gui.persistent.model.CMPBooleanRenderer;
import com.sap.engine.deploy.ejb.gui.persistent.model.CMPTableCellRenderer;
import com.sap.engine.gui.LocaleSettings;
import com.sap.engine.services.deploy.gui.common.DescriptionPanel;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ContainerManageFieldTableModel
extends AbstractTableModel
implements ListSelectionListener {
    private String[] colnames = new String[]{LocaleSettings.getInstance("EJB").getResourceString("Storage_EJBField", "EJB Field"), LocaleSettings.getInstance("EJB").getResourceString("Container_managed", "Container-Managed")};
    private String[] fieldNames;
    private String[] descriptions;
    private Boolean[] isStored;
    private Boolean[] isPrimaryKey;
    private int lastSelectedIndex = -1;
    private CMPTableCellRenderer renderer;
    private DescriptionPanel descrPanel = new DescriptionPanel();
    public JTable table;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public void initModel(String[] allFields, PersistentField[] stored, PersistentField[] primaryKeys) {
        this.lastSelectedIndex = -1;
        String cmpDescription = null;
        this.fieldNames = allFields;
        int size = this.fieldNames.length;
        this.isStored = new Boolean[size];
        this.isPrimaryKey = new Boolean[size];
        this.descriptions = new String[size];
        int i = 0;
        while (i < size) {
            this.isStored[i] = this.findField(this.fieldNames[i], stored);
            if (this.isStored[i].booleanValue() && (cmpDescription = this.findDescription(this.fieldNames[i], stored)) != null) {
                this.descriptions[i] = cmpDescription;
            }
            if (this.findField(this.fieldNames[i], primaryKeys).booleanValue()) {
                this.isStored[i] = new Boolean(true);
                this.isPrimaryKey[i] = new Boolean(true);
            } else {
                this.isPrimaryKey[i] = new Boolean(false);
            }
            ++i;
        }
        this.fireTableDataChanged();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.descriptions == null) {
            return;
        }
        int index = this.table.getSelectionModel().getLeadSelectionIndex();
        if (this.lastSelectedIndex > -1 && !this.table.getSelectionModel().isSelectionEmpty()) {
            this.descriptions[this.lastSelectedIndex] = this.descriptions[this.lastSelectedIndex] != null && this.descriptions[this.lastSelectedIndex].equals(this.descrPanel.getText()) ? this.descrPanel.getText() : this.descrPanel.getText();
        }
        this.lastSelectedIndex = index;
        if (index > -1) {
            if (((Boolean)this.table.getValueAt(index, 1)).booleanValue()) {
                this.descrPanel.setEnabled(true);
                if (this.descriptions[index] != null) {
                    this.descrPanel.setText(this.descriptions[index]);
                } else {
                    this.descrPanel.setText("");
                }
            } else {
                this.descrPanel.setText("");
                this.descrPanel.setEnabled(false);
                this.descriptions[index] = "";
            }
        }
        if (this.table.getSelectionModel().isSelectionEmpty()) {
            this.descrPanel.setText("");
            this.descrPanel.setEnabled(false);
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        if (this.fieldNames != null) {
            return this.fieldNames.length;
        }
        return 0;
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.fieldNames[row];
            }
            case 1: {
                return this.isStored[row];
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        return this.colnames[column];
    }

    public Class getColumnClass(int col) {
        if (col == 1) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ContainerManageFieldTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        return class$java$lang$String == null ? (class$java$lang$String = ContainerManageFieldTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        return col != 1 || this.isPrimaryKey[row] == false;
    }

    public void setValueAt(Object aValue, int row, int column) {
        if (aValue == null) {
            return;
        }
        switch (column) {
            case 0: {
                break;
            }
            case 1: {
                this.isStored[row] = (Boolean)aValue;
                this.fireTableDataChanged();
                this.table.getSelectionModel().setSelectionInterval(row, row);
            }
        }
    }

    public void setTable(JTable table) {
        this.table = table;
        table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = ContainerManageFieldTableModel.class$("java.lang.String")) : class$java$lang$String, new CMPTableCellRenderer());
        table.setDefaultRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ContainerManageFieldTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, new CMPBooleanRenderer());
        table.getSelectionModel().addListSelectionListener(this);
    }

    public void setDescriptionAt(String descr, int row) {
        this.descriptions[row] = descr;
    }

    public String getDescriptionAt(int row) {
        return this.descriptions[row];
    }

    private Boolean findField(String f, PersistentField[] fields) {
        if (fields != null && f != null) {
            int i = 0;
            while (i < fields.length) {
                if (f != null && fields[i] != null && f.equals(fields[i].getFieldName())) {
                    return new Boolean(true);
                }
                ++i;
            }
        }
        return new Boolean(false);
    }

    private String findDescription(String f, PersistentField[] fields) {
        if (fields != null && f != null) {
            int i = 0;
            while (i < fields.length) {
                if (f != null && f != null && fields[i] != null && f.equals(fields[i].getFieldName()) && fields[i].getDescription() != null) {
                    return fields[i].getDescription();
                }
                ++i;
            }
        }
        return null;
    }

    public Boolean[] getStored() {
        return this.isStored;
    }

    public void clear() {
    }

    public CMPTableCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CMPTableCellRenderer renderer) {
        this.renderer = renderer;
    }

    public DescriptionPanel getDescrPanel() {
        return this.descrPanel;
    }

    public void setDescrPanel(DescriptionPanel descrPanel) {
        this.descrPanel = descrPanel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

