/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.persistent;

import com.sap.engine.deploy.ejb.gui.additional.BeanSettings;
import com.sap.engine.deploy.ejb.gui.persistent.ContainerManageFieldPanel;
import com.sap.engine.deploy.ejb.gui.persistent.FinderDescriptorPanel;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.common.MadeFromConstants;
import com.sap.engine.services.deploy.gui.common.DescriptorPanel;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StoragePanel
extends DescriptorPanel
implements ChangeListener,
MadeFromConstants {
    protected ErrorReportObject[] errorsFromSubPanels;
    private ContainerManageFieldPanel aContainerPanel;
    private FinderDescriptorPanel aFinderDescriptorPanel;
    private ClassLoader loader;
    private DeploymentDescriptor newdd = null;
    private JTabbedPane aStorageTabbedPane = new JTabbedPane();
    private BorderLayout borderLayout1 = new BorderLayout();
    private ApplicationInformationProvider appProvider;
    public int madeFrom;
    private boolean classNotFoundError = false;

    public StoragePanel() {
        try {
            this.init(this.madeFrom);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Visualization of panels cannot be initialized properly\nReason: " + e.toString() + "\nRestart of the tool is recommended.\n We are sorry for the inconvenience.", "Error in visualization", 0);
        }
    }

    public StoragePanel(ClassLoader classLoader, int _madeFrom) {
        this.loader = classLoader;
        this.madeFrom = _madeFrom;
        this.loader = classLoader == null ? new DynamicClassLoader(".") : classLoader;
        try {
            this.init(this.madeFrom);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Visualization of panels cannot be initialized properly\nReason: " + e.toString() + "\nRestart of the tool is recommended.\n We are sorry for the inconvenience.", "Error in visualization", 0);
        }
        this.setLoader(this.loader);
        LookAndFeelHandler.add(this);
    }

    public void init(int madeFrom) {
        this.setLayout(this.borderLayout1);
        this.aStorageTabbedPane.setTabPlacement(1);
        if (this.aContainerPanel == null) {
            this.aContainerPanel = new ContainerManageFieldPanel(this.loader);
        }
        this.aContainerPanel.setLoader(this.loader);
        if (this.aStorageTabbedPane.indexOfTab(BeanSettings.getResourceString("CMPFieldsPanel", "CMP Fields")) == -1) {
            this.aStorageTabbedPane.addTab(BeanSettings.getResourceString("CMPFieldsPanel", "CMP Fields"), this.aContainerPanel);
        } else {
            this.aContainerPanel.repaint();
            this.aContainerPanel.validate();
        }
        this.aContainerPanel.init(madeFrom);
        if (this.aFinderDescriptorPanel == null) {
            this.aFinderDescriptorPanel = new FinderDescriptorPanel(this.mainFrame, madeFrom);
        }
        this.aFinderDescriptorPanel.init(madeFrom);
        if (this.aStorageTabbedPane.indexOfTab(BeanSettings.getResourceString("FindMethods", "Find Methods")) == -1) {
            this.aStorageTabbedPane.addTab(BeanSettings.getResourceString("FindMethods", "Find Methods"), this.aFinderDescriptorPanel);
        } else {
            this.aContainerPanel.repaint();
            this.aContainerPanel.validate();
        }
        this.add((Component)this.aStorageTabbedPane, "Center");
        this.aStorageTabbedPane.addChangeListener(this);
        this.aStorageTabbedPane.setSelectedIndex(0);
        this.repaint();
        this.validate();
    }

    public void setDescriptor(Descriptor descr) {
        this.classNotFoundError = false;
        this.newdd = (DeploymentDescriptor)descr;
        if (this.aContainerPanel != null) {
            this.aContainerPanel.setDescriptor((CMPEntityDescriptor)this.newdd);
        }
        if (this.aFinderDescriptorPanel == null) {
            this.aFinderDescriptorPanel = new FinderDescriptorPanel(this.mainFrame, this.madeFrom);
        }
        if (this.madeFrom == 1) {
            this.aFinderDescriptorPanel.setFinderDescriptors(this.getAllFinderDescriptors(((CMPEntityDescriptor)this.newdd).getFinderDescriptors()));
        } else {
            this.aFinderDescriptorPanel.setFinderDescriptors(((CMPEntityDescriptor)this.newdd).getFinderDescriptors());
        }
    }

    public Descriptor getDescriptor() {
        return this.newdd;
    }

    public void setLoader(ClassLoader cLoader) {
        this.loader = cLoader;
    }

    public ErrorReportObject[] getErrorsFromSubPanels() {
        return this.errorsFromSubPanels;
    }

    public void stateChanged(ChangeEvent e) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
        this.aContainerPanel.setApplicationInformationProvider(appProvider);
        this.aFinderDescriptorPanel.setApplicationInformationProvider(appProvider);
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void clear() {
        this.aContainerPanel.clear();
        this.aFinderDescriptorPanel.clear();
    }

    public int isCorrect() {
        int isOK = 0;
        int temp = 0;
        if (this.aContainerPanel != null) {
            temp = this.aContainerPanel.isCorrect();
        }
        if (temp > isOK) {
            isOK = temp;
        }
        if (this.aFinderDescriptorPanel != null) {
            temp = this.aFinderDescriptorPanel.isCorrect();
        }
        if (temp > isOK) {
            isOK = temp;
        }
        return isOK;
    }

    public void commitChange() {
        if (this.classNotFoundError) {
            return;
        }
        if (this.aContainerPanel != null) {
            this.aContainerPanel.commitChange();
        }
        if (this.aFinderDescriptorPanel != null) {
            this.aFinderDescriptorPanel.commitChange();
        }
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
    }

    private FinderDescriptor[] getAllFinderDescriptors(FinderDescriptor[] old) {
        Method[] all = null;
        Vector<FinderDescriptor> finders = new Vector<FinderDescriptor>();
        FinderDescriptor current = null;
        Class<?> remHomeClass = null;
        Class<?> locHomeClass = null;
        try {
            if (this.newdd.getRemoteHomeInterface() != null) {
                remHomeClass = this.loader.loadClass(this.newdd.getRemoteHomeInterface());
            }
            if (this.newdd.getLocalHomeInterface() != null) {
                locHomeClass = this.loader.loadClass(this.newdd.getLocalHomeInterface());
            }
        }
        catch (ClassNotFoundException cnfe) {
            return old;
        }
        if (remHomeClass != null) {
            try {
                all = remHomeClass.getMethods();
            }
            catch (Throwable t) {
                all = null;
                this.classNotFoundError = true;
            }
            if (all != null) {
                int p = 0;
                while (p < all.length) {
                    if (all[p].getName().startsWith("find") && !all[p].getName().equals("findByPrimaryKey") && Modifier.isPublic(all[p].getModifiers())) {
                        current = new FinderDescriptor(all[p]);
                        current.setRemote();
                        finders.add(current);
                    }
                    ++p;
                }
            }
        }
        if (locHomeClass != null) {
            try {
                all = locHomeClass.getMethods();
            }
            catch (Throwable t) {
                this.classNotFoundError = true;
                all = null;
            }
            if (all != null) {
                int p = 0;
                while (p < all.length) {
                    if (all[p].getName().startsWith("find") && !all[p].getName().equals("findByPrimaryKey") && Modifier.isPublic(all[p].getModifiers())) {
                        current = new FinderDescriptor(all[p]);
                        current.setLocal();
                        finders.add(current);
                    }
                    ++p;
                }
            }
        }
        FinderDescriptor[] allFinders = new FinderDescriptor[finders.size()];
        allFinders = finders.toArray(allFinders);
        if (old == null || old.length == 0) {
            return allFinders;
        }
        int i = 0;
        while (i < allFinders.length) {
            int j = 0;
            while (j < old.length) {
                if (allFinders[i].isLocal() == old[j].isLocal() && allFinders[i].getMethodName().equals(old[j].getMethodName()) && EqualUtils.equalOrderedArrays(allFinders[i].getParamsTypes(), old[j].getParamsTypes()) && allFinders[i].getReturnType().equals(old[j].getReturnType()) && EqualUtils.equalOrderedArrays(allFinders[i].getExceptions(), old[j].getExceptions())) {
                    allFinders[i] = old[j];
                    break;
                }
                ++j;
            }
            ++i;
        }
        return allFinders;
    }

    public FinderDescriptor[] getFinders() {
        return this.aFinderDescriptorPanel.getFinders();
    }
}

