/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.persistent;

import com.sap.engine.deploy.ejb.gui.persistent.model.KeyColumnMappingTableModel;
import com.sap.engine.deploy.ejb.gui.persistent.model.M2MRelationFieldColumnMappingTableModel;
import com.sap.engine.deploy.ejb.gui.persistent.model.RelationFieldMappingTableModel;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.LocaleSettings;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.M2MRelationFieldMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RRelationFieldMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RelationFieldMappingPanel
extends BasicPanelView
implements ListSelectionListener {
    private RelationFieldMappingTableModel relationModel = new RelationFieldMappingTableModel();
    private M2MRelationFieldColumnMappingTableModel firstFieldModel = new M2MRelationFieldColumnMappingTableModel();
    private M2MRelationFieldColumnMappingTableModel secondFieldModel = new M2MRelationFieldColumnMappingTableModel();
    private KeyColumnMappingTableModel leftModel = new KeyColumnMappingTableModel(0);
    private KeyColumnMappingTableModel rightModel = new KeyColumnMappingTableModel(1);
    private JTable relationTable = new JTable(this.relationModel);
    private JTable firstFieldTable = new JTable(this.firstFieldModel);
    private JTable secondFieldTable = new JTable(this.secondFieldModel);
    private JTable emptyTable = new JTable();
    private JPanel topSplitPanel = new JPanel();
    private JPanel bottomSplitPanel = new JPanel();
    private JSplitPane splitPane = new JSplitPane(0);
    private JScrollPane relationFieldsScroll = new JScrollPane();
    private JScrollPane firstFieldScroll = new JScrollPane();
    private JScrollPane secondFieldScroll = new JScrollPane();
    private GridBagLayout layout = new GridBagLayout();
    private BorderLayout topLayout = new BorderLayout();
    private BorderLayout bottomLayout = new BorderLayout();
    private TitledBorder relationFieldBorder = new TitledBorder(new EtchedBorder());
    private TitledBorder m2mBorder1 = new TitledBorder(new EtchedBorder());
    private TitledBorder m2mBorder2 = new TitledBorder(new EtchedBorder());
    private Vector m2mRelationship = new Vector();
    private Vector nonNullRelations = new Vector();
    private int lastSelectedIndex = -1;
    private int whoIsVisibleTable = -1;
    private RelationDescriptor[] relations = null;
    private CMPEntityDescriptor[] descriptors = null;
    private ApplicationInformationProvider appProvider;

    public RelationFieldMappingPanel(Frame frame) {
        this.setFrame(frame);
        try {
            this.init();
            this.relationTable.getSelectionModel().addListSelectionListener(this);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Visualization of panels cannot be initialized properly\nReason: " + e.toString() + "\nRestart of the tool is recommended.\n We are sorry for the inconvenience.", "Error in visualization", 0);
        }
    }

    private void init() throws Exception {
        this.relationFieldBorder.setTitle(LocaleSettings.getInstance("EJB").getResourceString("Relations", "Relations"));
        this.relationFieldsScroll.getViewport().add(this.relationTable);
        this.relationTable.setSelectionMode(0);
        this.topSplitPanel.setLayout(this.topLayout);
        this.topSplitPanel.setBorder(this.relationFieldBorder);
        this.topSplitPanel.add((Component)this.relationFieldsScroll, "Center");
        this.firstFieldScroll.getViewport().add(this.emptyTable);
        this.firstFieldTable.setSelectionMode(0);
        this.bottomSplitPanel.setLayout(this.layout);
        this.firstFieldScroll.setBorder(this.m2mBorder1);
        this.bottomSplitPanel.add((Component)this.firstFieldScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.secondFieldScroll.getViewport().add(this.emptyTable);
        this.secondFieldTable.setSelectionMode(0);
        this.secondFieldScroll.setBorder(this.m2mBorder2);
        this.bottomSplitPanel.add((Component)this.secondFieldScroll, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.splitPane.setTopComponent(this.topSplitPanel);
        this.splitPane.setBottomComponent(this.bottomSplitPanel);
        this.splitPane.setDividerLocation(300);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void init(int madeFromConstant) {
    }

    public void clear() {
        this.m2mRelationship = new Vector();
        this.lastSelectedIndex = -1;
        this.relationModel.clear();
        this.firstFieldModel.clear();
        this.secondFieldModel.clear();
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        this.stopEditingTable(this.relationTable);
        this.stopEditingTable(this.firstFieldTable);
        this.stopEditingTable(this.secondFieldTable);
        int[] firstFieldKeys = this.relationModel.getFirstFieldKeyTypes();
        int[] secondFieldKeys = this.relationModel.getSecondFieldKeyTypes();
        String[] helpTableNames = this.relationModel.getHelpTableNames();
        Object currentMappings = null;
        Object currentFields = null;
        RRelationFieldMap firstFieldMap = null;
        RRelationFieldMap secondFieldMap = null;
        RelationDescriptor tempRelation = null;
        M2MRelationFieldMap m2m = null;
        int i = 0;
        while (i < this.nonNullRelations.size()) {
            tempRelation = (RelationDescriptor)this.nonNullRelations.get(i);
            firstFieldMap = tempRelation.getSide1().getFieldDBMap();
            m2m = tempRelation.getM2MMap();
            if (m2m != null) {
                m2m.setHelpTable(helpTableNames[i]);
            }
            secondFieldMap = tempRelation.getSide2().getFieldDBMap();
            ++i;
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public ErrorReportObject getErrorObject() {
        return null;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setCMPDescriptors(CMPEntityDescriptor[] cmpDescriptors) {
        this.clear();
        this.descriptors = cmpDescriptors;
    }

    private String getKeyTypeAsString(int type) {
        if (type == 0) {
            return "NO_KEY";
        }
        if (type == 1) {
            return "PRIMARY_KEY";
        }
        if (type == 3) {
            return "UNIQUE_KEY";
        }
        if (type == 2) {
            return "FOREIGN_KEY";
        }
        return null;
    }

    private void stopEditingTable(JTable table) {
        if (table.getCellEditor() != null) {
            table.getCellEditor().stopCellEditing();
            ChangeEvent chan = new ChangeEvent(table);
            table.editingStopped(chan);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int index = this.relationTable.getSelectedRow();
        if (index == this.lastSelectedIndex) {
            return;
        }
        if (index == -1) {
            this.applyChanges();
            this.lastSelectedIndex = index;
            return;
        }
        if (this.lastSelectedIndex != -1) {
            this.applyChanges();
        }
        this.lastSelectedIndex = index;
        RelationDescriptor selectedRelation = (RelationDescriptor)this.nonNullRelations.get(index);
        this.m2mBorder1.setTitle(LocaleSettings.getInstance("EJB").getResourceString("Bean", "Bean") + " <" + this.relationModel.getBeanName(index) + "> " + LocaleSettings.getInstance("EJB").getResourceString("Table", "Table") + " <" + this.descriptors[selectedRelation.getSide1().getEjbId()].getTableName() + ">");
        this.m2mBorder2.setTitle(LocaleSettings.getInstance("EJB").getResourceString("Bean", "Bean") + " <" + this.relationModel.getTargetBeanName(index) + "> " + LocaleSettings.getInstance("EJB").getResourceString("Table", "Table") + " <" + this.descriptors[selectedRelation.getSide2().getEjbId()].getTableName() + ">");
        if (((Boolean)this.m2mRelationship.get(index)).booleanValue()) {
            this.firstFieldScroll.getViewport().removeAll();
            this.secondFieldScroll.getViewport().removeAll();
            this.firstFieldTable = new JTable(this.firstFieldModel);
            this.secondFieldTable = new JTable(this.secondFieldModel);
            this.firstFieldScroll.getViewport().add(this.firstFieldTable);
            this.secondFieldScroll.getViewport().add(this.secondFieldTable);
            this.whoIsVisibleTable = -1;
            selectedRelation = (RelationDescriptor)this.nonNullRelations.get(index);
            RRelationFieldMap temp = selectedRelation.getSide1().getFieldDBMap();
            CMPEntityDescriptor cmpDescr = this.descriptors[selectedRelation.getSide1().getEjbId()];
            String[] pkNames = this.getPKColumnNames(cmpDescr.getPKCmpFields());
            this.firstFieldModel.setHelpTableColumnNames(pkNames, selectedRelation.getM2MMap().getColumns1());
            temp = selectedRelation.getSide2().getFieldDBMap();
            cmpDescr = this.descriptors[selectedRelation.getSide2().getEjbId()];
            pkNames = this.getPKColumnNames(cmpDescr.getPKCmpFields());
            this.secondFieldModel.setHelpTableColumnNames(pkNames, selectedRelation.getM2MMap().getColumns2());
        } else {
            RRelationFieldMap relFieldMap = null;
            CMPEntityDescriptor cmpDescr = null;
            this.firstFieldScroll.getViewport().removeAll();
            this.secondFieldScroll.getViewport().removeAll();
            String keyType = (String)this.relationTable.getValueAt(index, 2);
            if (keyType.equals(this.getKeyTypeAsString(0)) || keyType.equals(this.getKeyTypeAsString(2))) {
                this.whoIsVisibleTable = 0;
                this.firstFieldTable = new JTable(this.leftModel);
                this.firstFieldScroll.getViewport().add(this.firstFieldTable);
                this.secondFieldScroll.getViewport().add(this.emptyTable);
                relFieldMap = selectedRelation.getSide1().getFieldDBMap();
                cmpDescr = this.descriptors[selectedRelation.getSide2().getEjbId()];
                this.leftModel.setColumnNames(relFieldMap.getColumn(), this.getPKColumnNames(cmpDescr.getPKCmpFields()));
            } else {
                this.whoIsVisibleTable = 1;
                this.secondFieldTable = new JTable(this.rightModel);
                this.secondFieldScroll.getViewport().add(this.secondFieldTable);
                this.firstFieldScroll.getViewport().add(this.emptyTable);
                relFieldMap = selectedRelation.getSide2().getFieldDBMap();
                cmpDescr = this.descriptors[selectedRelation.getSide1().getEjbId()];
                this.rightModel.setColumnNames(relFieldMap.getColumn(), this.getPKColumnNames(cmpDescr.getPKCmpFields()));
            }
        }
        this.repaint();
        this.validate();
    }

    private void applyChanges() {
        if (!((Boolean)this.m2mRelationship.get(this.lastSelectedIndex)).booleanValue()) {
            if (this.whoIsVisibleTable == 0) {
                this.stopEditingTable(this.firstFieldTable);
                ((RelationDescriptor)this.nonNullRelations.get(this.lastSelectedIndex)).getSide1().getFieldDBMap().setColumn(((KeyColumnMappingTableModel)this.firstFieldTable.getModel()).getForeignKeyColumns());
            }
            if (this.whoIsVisibleTable == 1) {
                this.stopEditingTable(this.secondFieldTable);
                ((RelationDescriptor)this.nonNullRelations.get(this.lastSelectedIndex)).getSide2().getFieldDBMap().setColumn(((KeyColumnMappingTableModel)this.secondFieldTable.getModel()).getForeignKeyColumns());
            }
            this.leftModel.clear();
            this.rightModel.clear();
        } else {
            this.stopEditingTable(this.firstFieldTable);
            this.stopEditingTable(this.secondFieldTable);
            ((RelationDescriptor)this.nonNullRelations.get(this.lastSelectedIndex)).getM2MMap().setColumns1(this.firstFieldModel.getHelpTableColumnNames());
            ((RelationDescriptor)this.nonNullRelations.get(this.lastSelectedIndex)).getM2MMap().setColumns2(this.secondFieldModel.getHelpTableColumnNames());
            this.firstFieldModel.clear();
            this.secondFieldModel.clear();
        }
    }

    public void setRelations(RelationDescriptor[] rel) {
        this.relations = rel;
        if (rel == null) {
            return;
        }
        this.nonNullRelations = new Vector();
        Vector beans = new Vector();
        Vector cmrs = new Vector();
        Vector tables = new Vector();
        Vector targetEJBs = new Vector();
        Vector targetCMRs = new Vector();
        Vector keys = new Vector();
        Vector targetKeys = new Vector();
        int i = 0;
        while (i < this.relations.length) {
            if (this.relations[i] != null) {
                this.getInfoFromDescriptor(this.relations[i], beans, cmrs, tables, targetEJBs, targetCMRs, keys, targetKeys);
            }
            ++i;
        }
        this.relationModel.set(beans, cmrs, this.m2mRelationship, tables, targetEJBs, targetCMRs, keys, targetKeys);
        this.firstFieldScroll.getViewport().removeAll();
        this.firstFieldScroll.getViewport().add(this.emptyTable);
        this.secondFieldScroll.getViewport().removeAll();
        this.secondFieldScroll.getViewport().add(this.emptyTable);
    }

    private void getInfoFromDescriptor(RelationDescriptor rel, Vector beans, Vector cmrs, Vector tables, Vector targetEJBs, Vector targetCMRs, Vector keys, Vector targetKeys) {
        this.nonNullRelations.add(rel);
        OneSideRelationDescriptor side = rel.getSide1();
        beans.add(this.descriptors[side.getEjbId()].getEjbName());
        String name = null;
        if (side.getCmrId() != -1) {
            name = this.descriptors[side.getEjbId()].getCmrFields()[side.getCmrId()].getFieldName();
        }
        cmrs.add(name == null ? "" : name);
        keys.add(this.getKeyTypeAsString(side.getFieldDBMap().getKey()));
        this.m2mRelationship.add(new Boolean(side.getMultiplicityType() == 4));
        if (side.getMultiplicityType() == 4) {
            tables.add(rel.getM2MMap().getHelpTable());
        } else {
            tables.add("");
        }
        side = rel.getSide2();
        targetEJBs.add(this.descriptors[side.getEjbId()].getEjbName());
        name = side.getCmrId() != -1 ? this.descriptors[side.getEjbId()].getCmrFields()[side.getCmrId()].getFieldName() : "";
        targetCMRs.add(name == null ? "" : name);
        targetKeys.add(this.getKeyTypeAsString(side.getFieldDBMap().getKey()));
    }

    private String[] getPKColumnNames(PersistentField[] persistentField) {
        if (persistentField == null) {
            return new String[0];
        }
        String[] result = new String[persistentField.length];
        int i = 0;
        while (i < persistentField.length) {
            result[i] = persistentField[i].getFieldDBMap().getColumnName();
            ++i;
        }
        return result;
    }
}

