/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.persistent;

import com.sap.engine.deploy.ejb.gui.persistent.DependentValueMappingsPanel;
import com.sap.engine.deploy.ejb.gui.persistent.model.DipendentValueFieldsMapTableModel;
import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.LocaleSettings;
import com.sap.engine.services.ejb.deploy.descriptors.DependentValueDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RDependentValueMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;

public class DependentValueDialog
extends CEscapeDialog
implements ActionListener {
    public static final String OK_CMD = "OK_CMD";
    public static final String CANCEL_CMD = "CANCEL_CMD";
    private BorderLayout borderLayout1 = new BorderLayout();
    private GridBagLayout layout = new GridBagLayout();
    private JPanel mainPanel = new JPanel();
    private JPanel tablePanel = new JPanel();
    private JScrollPane scrollPane = new JScrollPane();
    private DipendentValueFieldsMapTableModel model = new DipendentValueFieldsMapTableModel();
    private JTable table = new JTable(this.model);
    private JPanel buttonsPanel = new JPanel();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private boolean okAction = false;
    private RDependentValueMap mapping;
    private int row = -1;
    private Vector dependentPanels = new Vector();

    public DependentValueDialog(Frame frame) {
        super(frame);
        try {
            this.init();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Visualization of panels cannot be initialized properly\nReason: " + e.toString() + "\nRestart of the tool is recommended.\n We are sorry for the inconvenience.", "Error in visualization", 0);
        }
    }

    private void init() throws Exception {
        this.scrollPane.getViewport().add(this.table);
        this.tablePanel.setLayout(this.borderLayout1);
        this.tablePanel.add(this.scrollPane);
        this.mainPanel.setLayout(this.layout);
        this.mainPanel.add((Component)this.tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(this.cancelButton);
        this.mainPanel.add((Component)this.buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.initListeners();
        this.getContentPane().add(this.mainPanel);
        this.setModal(true);
    }

    private void initListeners() throws Exception {
        this.okButton.setText(LocaleSettings.getInstance("EJB").getResourceString("OK_Button", "OK"));
        this.okButton.setActionCommand(OK_CMD);
        this.okButton.addActionListener(this);
        this.cancelButton.setText(LocaleSettings.getInstance("EJB").getResourceString("Cancel_Button", "Cancel"));
        this.cancelButton.setActionCommand(CANCEL_CMD);
        this.cancelButton.addActionListener(this);
        this.dependentPanels = new Vector();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(OK_CMD)) {
            this.okAction();
        } else {
            this.cancelAction();
        }
    }

    private void stopEditingTable() {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
            ChangeEvent chan = new ChangeEvent(this.table);
            this.table.editingStopped(chan);
        }
    }

    private void okAction() {
        this.stopEditingTable();
        this.model.actionConfirmed();
        ((Component)this).setVisible(false);
    }

    private void cancelAction() {
        this.stopEditingTable();
        this.model.actionCanceled();
        ((Component)this).setVisible(false);
    }

    public void addActionListener(ActionListener AL) {
        this.okButton.addActionListener(AL);
        if (AL instanceof DependentValueMappingsPanel) {
            this.dependentPanels.add(AL);
        }
    }

    public void setDependentValues(DependentValueDescriptor descriptor, RDependentValueMap map, int row) {
        this.okAction = false;
        this.model.clear();
        this.model.setDependentValue(descriptor, (RDependentValueMap)map.clone());
        this.validate();
        this.repaint();
        this.mapping = map;
        this.row = row;
    }

    public RDependentValueMap getMapping() {
        return this.model.getMapping();
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201 && this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
            ChangeEvent chan = new ChangeEvent(this.table);
            this.table.editingStopped(chan);
        }
    }

    public int getRow() {
        return this.row;
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
        RDependentValueMap map = this.model.getMapping();
        int i = 0;
        while (i < this.dependentPanels.size()) {
            ((DependentValueMappingsPanel)this.dependentPanels.get(i)).setMapping(this.row, map);
            ++i;
        }
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }
}

