/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.logic;

import com.sap.engine.deploy.ejb.gui.additional.ImageHolder;
import com.sap.engine.deploy.ejb.gui.logic.AccessControlPanelLogical;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.LocaleSettings;
import com.sap.engine.gui.UserNode;
import com.sap.engine.services.deploy.ear.common.MadeFromConstants;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.SecurityRolesPanelLogical;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SecurityIdentity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SecurityPanel
extends BasicPanelView
implements ChangeListener,
MadeFromConstants {
    protected BorderLayout borderLayout = new BorderLayout();
    protected JTabbedPane theTabbedPane = new JTabbedPane();
    protected AccessControlPanelLogical accessPanel;
    protected SecurityRolesPanelLogical securityPanel;
    private int previousIndex = 0;
    private EJBJarDescriptor jarDescriptor = null;
    private ClassLoader loader;
    private Frame mainFrame;
    private UserNode node = null;
    private int madeFrom = 0;
    private ApplicationInformationProvider appProvider;

    public SecurityPanel() {
        try {
            this.accessPanel = new AccessControlPanelLogical(this.mainFrame, ImageHolder.aJarSmallIcon, this.loader);
            this.securityPanel = new SecurityRolesPanelLogical(this.mainFrame);
            this.init();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Visualization of panels cannot be initialized properly\nReason: " + ex.toString() + "\nRestart of the tool is recommended.\n We are sorry for the inconvenience.", "Error in visualization", 0);
        }
    }

    public SecurityPanel(ClassLoader loader, Frame frame) {
        this(loader, frame, 0);
        this.mainFrame = frame;
    }

    public SecurityPanel(ClassLoader loader, Frame frame, int madeFromConstant) {
        this.loader = loader;
        this.mainFrame = frame;
        this.madeFrom = madeFromConstant;
        this.securityPanel = new SecurityRolesPanelLogical(this.mainFrame);
        this.securityPanel.init(this.madeFrom);
        this.accessPanel = new AccessControlPanelLogical(this.mainFrame, ImageHolder.aJarSmallIcon, loader);
        this.accessPanel.initAvailableList(this.securityPanel.getSecurityRolesNames());
        this.init();
        this.accessPanel.init(this.madeFrom);
        this.securityPanel.init(this.madeFrom);
    }

    private RunAsIdentity[] getRunAsIdentity() {
        RunAsIdentity runAsIdentity = null;
        Vector<RunAsIdentity> runAs = new Vector<RunAsIdentity>();
        DeploymentDescriptor[] descriptors = (DeploymentDescriptor[])this.jarDescriptor.getDescriptors();
        if (descriptors == null) {
            return null;
        }
        SecurityIdentity identity = null;
        int i = 0;
        while (i < descriptors.length) {
            identity = descriptors[i].getSecurityIdentity();
            if (identity != null && !identity.isCallerIdentity()) {
                runAsIdentity = descriptors[i].getSecurityIdentity().getRunAsIdentity();
                if (runAsIdentity == null) {
                    runAsIdentity = new RunAsIdentity();
                }
                runAsIdentity.setComponentName(descriptors[i].getEjbName());
                runAs.add(runAsIdentity);
            }
            ++i;
        }
        Object[] runAsIdentities = new RunAsIdentity[runAs.size()];
        runAs.copyInto(runAsIdentities);
        return runAsIdentities;
    }

    public void setDescriptor(EJBJarDescriptor descr) {
        this.jarDescriptor = descr;
        SecurityRoles[] secRoles = this.jarDescriptor.getSecurityRoles();
        RunAsIdentity[] runAs = this.getRunAsIdentity();
        if (this.securityPanel == null) {
            this.securityPanel = new SecurityRolesPanelLogical(this.mainFrame);
        }
        this.securityPanel.setSecurityRoles(secRoles);
        if (this.accessPanel == null) {
            this.accessPanel = new AccessControlPanelLogical(this.mainFrame, ImageHolder.anEJBeanIcon, this.loader);
        }
        this.accessPanel.setLoader(this.loader);
        this.accessPanel.setDescriptor(this.jarDescriptor);
        this.accessPanel.initAvailableList(this.securityPanel.getSecurityRolesNames());
    }

    public void commitChange() {
        this.securityPanel.commitChange();
        SecurityRoles[] roles = this.securityPanel.getSecurityRoles();
        Vector roleNames = this.securityPanel.getSecurityRolesNames();
        this.jarDescriptor.setSecurityRoles(roles);
        this.accessPanel.initAvailableList(roleNames);
        this.accessPanel.commitChange();
    }

    private void init() {
        this.setLayout(this.borderLayout);
        this.theTabbedPane.addChangeListener(this);
        this.add((Component)this.theTabbedPane, "Center");
        this.theTabbedPane.setTabPlacement(1);
        this.theTabbedPane.addTab(LocaleSettings.getInstance("EJB").getResourceString("MethodAccess", "Access to Methods"), this.accessPanel);
        this.theTabbedPane.addTab(LocaleSettings.getInstance("EJB").getResourceString("SecurityRoles", "Security Roles"), this.securityPanel);
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
        if (this.accessPanel != null) {
            this.accessPanel.init(this.madeFrom);
        }
        if (this.securityPanel != null) {
            this.securityPanel.init(this.madeFrom);
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.theTabbedPane.getSelectedIndex() != 1 && this.previousIndex == 1) {
            this.tabsChanged();
        }
        this.previousIndex = this.theTabbedPane.getSelectedIndex();
    }

    private void tabsChanged() {
        if (this.securityPanel.isChanged()) {
            this.securityPanel.commitChange();
            this.accessPanel.initAvailableList(this.securityPanel.getSecurityRolesNames());
            this.accessPanel.commitChange();
        }
        this.securityPanel.reset();
        this.repaint();
        this.validate();
    }

    public void setLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
    }

    public int isCorrect() {
        int isCorrectIndex = -1;
        int secondIndex = -1;
        if (this.accessPanel != null) {
            secondIndex = this.accessPanel.isCorrect();
            int n = isCorrectIndex = isCorrectIndex < secondIndex ? secondIndex : isCorrectIndex;
        }
        if (this.securityPanel != null) {
            secondIndex = this.securityPanel.isCorrect();
            isCorrectIndex = isCorrectIndex < secondIndex ? secondIndex : isCorrectIndex;
        }
        return isCorrectIndex;
    }

    public void clear() {
        if (this.accessPanel != null) {
            this.accessPanel.clear();
        }
        if (this.securityPanel != null) {
            this.securityPanel.clear();
        }
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
        if (this.accessPanel != null) {
            this.accessPanel.setApplicationInformationProvider(appProvider);
        }
        if (this.securityPanel != null) {
            this.securityPanel.setApplicationInformationProvider(appProvider);
        }
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }
}

