/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.logic;

import com.sap.engine.deploy.ejb.gui.logic.RelationshipRolePanel;
import com.sap.engine.deploy.ejb.gui.visual.RelationshipPanel;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationField;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class RelationshipPanelLogical
extends RelationshipPanel
implements Runnable {
    private Vector listValues = null;
    private RelationDescriptor[] relations = null;
    private AbstractSchema schema = null;
    private ClassLoader loader;
    private ApplicationInformationProvider appProvider;
    int isEjbNameCorrect;
    private Hashtable beansInfo = new Hashtable();

    public RelationshipPanelLogical(Frame frame, int made_from, ClassLoader loader) {
        super(frame, made_from);
        this.loader = loader;
        this.setEnabled(false);
        this.disableFields();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addActionPerformed(true);
            this.clear();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeActionPerformed();
        } else if (cmd.equals("CLEAR_CMD")) {
            this.clearActionPerformed();
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyActionPerformed();
        } else if (cmd.equals("SELECT_CMD")) {
            this.cascadeActionPerformed();
        } else if (cmd.equals("SOURCE_1_CMD")) {
            this.fillCMPFields(this.role1);
        } else if (cmd.equals("SOURCE_2_CMD")) {
            this.fillCMPFields(this.role2);
        }
    }

    private RelationDescriptor[] addRelationDescriptor(RelationDescriptor descr) {
        Vector<RelationDescriptor> temp = new Vector<RelationDescriptor>();
        if (this.relations != null && this.relations.length != 0) {
            int i = 0;
            while (i < this.relations.length) {
                temp.add(this.relations[i]);
                ++i;
            }
        }
        temp.add(descr);
        Object[] result = new RelationDescriptor[temp.size()];
        temp.copyInto(result);
        return result;
    }

    private void removeRelationDescriptor(RelationDescriptor descr) {
        CMPEntityDescriptor descriptor = null;
        CMPEntityDescriptor[] cmpDescr = this.schema.getDescriptors();
        int index = -1;
        int i = 0;
        while (i < this.relations.length) {
            if (this.relations[i] != null && this.relations[i].equals(descr)) {
                index = i;
                break;
            }
            ++i;
        }
        descriptor = cmpDescr[this.relations[index].getSide1().getEjbId()];
        this.removeRelationField(descriptor, index);
        descriptor = cmpDescr[this.relations[index].getSide2().getEjbId()];
        this.removeRelationField(descriptor, index);
        this.relations[index] = null;
    }

    private void removeRelationField(CMPEntityDescriptor descriptor, int index) {
        RelationField[] relFields = descriptor.getCmrFields();
        Vector<RelationField> temp = new Vector<RelationField>();
        int i = 0;
        while (i < relFields.length) {
            if (i != index) {
                temp.add(relFields[i]);
            }
            ++i;
        }
        Object[] result = new RelationField[temp.size()];
        temp.copyInto(result);
        descriptor.setCmrFields((RelationField[])result);
    }

    private int addRelationField(RelationField relElem, String ejbName, int index) {
        CMPEntityDescriptor[] cmpDescr = null;
        RelationField[] rel = null;
        if (this.schema != null && relElem != null && (cmpDescr = this.schema.getDescriptors()) != null) {
            int j = 0;
            while (j < cmpDescr.length) {
                if (cmpDescr[j].getEjbName().equals(ejbName)) {
                    rel = cmpDescr[j].getCmrFields();
                    relElem.setRelationId(index);
                    cmpDescr[j].setCmrFields(this.addRelationField(relElem, rel));
                    return this.getRelationFieldIndex(cmpDescr[j].getCmrFields(), relElem);
                }
                ++j;
            }
        }
        return -1;
    }

    private int getRelationFieldIndex(RelationField[] rels, RelationField rel1) {
        if (rels == null || rels.length == 0) {
            return -1;
        }
        int i = 0;
        while (i < rels.length) {
            if (rels[i].equals(rel1)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void addActionPerformed(boolean isAdd) {
        String ejbName;
        RelationDescriptor newDescriptor = new RelationDescriptor();
        int selIndex = -1;
        int ejbId = -1;
        if (!isAdd) {
            selIndex = this.relationList.getSelectedIndex();
            newDescriptor = this.relations[selIndex];
        }
        newDescriptor.setRelationName(this.nameTextField.getText());
        newDescriptor.setRelationDescription(this.descrPanel.getText());
        RelationField fieldOne = new RelationField();
        RelationField fieldTwo = new RelationField();
        OneSideRelationDescriptor side1 = new OneSideRelationDescriptor();
        side1.setRoleName(this.role1.getRoleName());
        if (this.role1.getMultiplicity() == 0) {
            if (this.role2.getMultiplicity() == 0) {
                side1.setMultiplicityType(1);
            } else {
                side1.setMultiplicityType(2);
            }
        } else if (this.role2.getMultiplicity() == 0) {
            side1.setMultiplicityType(3);
        } else {
            side1.setMultiplicityType(4);
        }
        side1.setCascade(this.role1.getDelete());
        ejbId = this.findEjbId(this.role1.getSource().trim());
        side1.setEjbId(ejbId);
        OneSideRelationDescriptor side2 = new OneSideRelationDescriptor();
        side2.setRoleName(this.role2.getRoleName());
        if (this.role2.getMultiplicity() == 0) {
            if (this.role1.getMultiplicity() == 0) {
                side2.setMultiplicityType(1);
            } else {
                side2.setMultiplicityType(2);
            }
        } else if (this.role1.getMultiplicity() == 0) {
            side2.setMultiplicityType(3);
        } else {
            side2.setMultiplicityType(4);
        }
        side2.setCascade(this.role2.getDelete());
        ejbId = this.findEjbId(this.role2.getSource().trim());
        side2.setEjbId(ejbId);
        int index = 0;
        index = this.relations == null || this.relations.length == 0 ? 0 : this.relations.length;
        if (this.role1.getField() == null || this.role1.getField() != null && this.role1.getField().trim().equals("")) {
            fieldOne = null;
        }
        if (this.role2.getField() == null || this.role2.getField() != null && this.role2.getField().trim().equals("")) {
            fieldTwo = null;
        }
        if (fieldOne != null) {
            fieldOne.setFieldName(this.role1.getField());
            fieldOne.setFieldType(this.getFieldType(this.role1.getSource(), this.role1.getField()));
            fieldOne.setRelationId(index);
            ejbName = this.role1.getSource();
            int cmpId = this.addRelationField(fieldOne, ejbName, index);
            side1.setCmrId(cmpId);
        }
        if (fieldTwo != null) {
            fieldTwo.setFieldName(this.role2.getField());
            fieldTwo.setFieldType(this.getFieldType(this.role2.getSource(), this.role2.getField()));
            fieldTwo.setRelationId(index);
            ejbName = this.role2.getSource();
            int cmrId = this.addRelationField(fieldTwo, ejbName, index);
            side2.setCmrId(cmrId);
        }
        newDescriptor.setSide1(side1);
        newDescriptor.setSide2(side2);
        if (isAdd) {
            this.relations = this.addRelationDescriptor(newDescriptor);
        } else {
            this.relations[selIndex] = newDescriptor;
        }
        this.initList(this.relations);
    }

    private String getFieldType(String ejbName, String fieldName) {
        CMPEntityDescriptor descr;
        Vector fieldInfo;
        if (this.schema != null && ejbName != null && fieldName != null && (fieldInfo = this.getAllCMPFieldsInfo(descr = this.schema.getDescriptor(ejbName))) != null) {
            int i = 0;
            while (i < fieldInfo.size()) {
                if (fieldInfo.elementAt(i) != null && fieldName.equals(((InfoObject)fieldInfo.elementAt(i)).getEntryName())) {
                    return ((InfoObject)fieldInfo.elementAt(i)).getFilePath();
                }
                ++i;
            }
        }
        return "";
    }

    private int findEjbId(String ejbName) {
        int index = -1;
        CMPEntityDescriptor[] descriptors = this.schema.getDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getEjbName().equals(ejbName)) {
                return i;
            }
            ++i;
        }
        return index;
    }

    private RelationField[] addRelationField(RelationField rel, RelationField[] relArr) {
        if (relArr != null) {
            Vector<RelationField> relVector = new Vector<RelationField>();
            int i = 0;
            while (i < relArr.length) {
                if (relArr[i] != null) {
                    relVector.add(relArr[i]);
                }
                ++i;
            }
            if (rel != null && !relVector.contains(rel)) {
                relVector.add(rel);
            }
            if (relVector.size() > 0) {
                relArr = new RelationField[relVector.size()];
                relVector.copyInto(relArr);
            } else {
                relArr = null;
            }
        } else {
            relArr = rel != null ? new RelationField[]{rel} : new RelationField[]{};
        }
        return relArr;
    }

    private void removeActionPerformed() {
        RelationDescriptor temp = null;
        if (!this.relationList.isSelectionEmpty()) {
            temp = ((ListValues)this.relationList.getSelectedValue()).getRelationDescriptor();
            this.removeRelationDescriptor(temp);
            this.initList(this.relations);
            this.clear();
        }
    }

    private void clearActionPerformed() {
        this.clear();
    }

    private void modifyActionPerformed() {
        this.addActionPerformed(false);
        this.clear();
    }

    private void cascadeActionPerformed() {
        if (this.role1.getMultiplicity() == 0) {
            if (this.role2.getMultiplicity() == 0) {
                if (this.schema != null && this.schema.getDescriptors() != null && this.schema.getDescriptors().length != 0) {
                    this.role1.setDeleteEnabled(true);
                    this.role2.setDeleteEnabled(true);
                }
            } else {
                this.role1.setDelete(false);
                this.role1.setDeleteEnabled(false);
                this.role2.setDeleteEnabled(true);
            }
        } else if (this.role2.getMultiplicity() == 0) {
            this.role1.setDeleteEnabled(true);
            this.role2.setDelete(false);
            this.role2.setDeleteEnabled(false);
        } else {
            this.role1.setDelete(false);
            this.role2.setDelete(false);
            this.role1.setDeleteEnabled(false);
            this.role2.setDeleteEnabled(false);
        }
    }

    private void fillEjbNames() {
        CMPEntityDescriptor[] descr = this.schema.getDescriptors();
        if (descr != null) {
            Vector<String> ejbs = new Vector<String>();
            int i = 0;
            while (i < descr.length) {
                if (descr[i] != null) {
                    ejbs.add(descr[i].getEjbName());
                }
                ++i;
            }
            this.role1.setSource(ejbs);
            this.role2.setSource(ejbs);
        }
    }

    private void fillCMPFields(RelationshipRolePanel role) {
        CMPEntityDescriptor descr = this.schema.getDescriptor(role.getSource());
        if (descr != null) {
            Vector vec = this.getAllCMPFields(descr);
            if (vec != null) {
                role.setField(vec);
            } else {
                role.clear();
            }
        } else {
            role.setField((String)null);
        }
    }

    private Vector getAllCMPFieldsInfo(CMPEntityDescriptor dd) {
        Vector fieldInfo = null;
        if (this.beansInfo != null && dd != null && !this.beansInfo.containsKey(dd.getEjbName())) {
            fieldInfo = new Vector();
            Method[] methods = null;
            String methodName = null;
            String fieldName = null;
            String fieldType = null;
            String lower = "";
            if (this.loader != null) {
                if (dd.getClassName() == null) {
                    JOptionPane.showMessageDialog(this, "There are no class name for this bean defined.", "Incorrect bean", 0);
                    return null;
                }
                try {
                    methods = this.loader.loadClass(dd.getClassName()).getMethods();
                }
                catch (ClassNotFoundException exc) {
                    JOptionPane.showMessageDialog(this, "Class " + dd.getClassName() + " not found.", "Class Not Found", 0);
                    return null;
                }
                if (methods != null) {
                    int i = 0;
                    while (i < methods.length) {
                        if (Modifier.isAbstract(methods[i].getModifiers()) && (methodName = methods[i].getName()).startsWith("get")) {
                            lower = "" + methodName.charAt(3);
                            fieldName = lower.toLowerCase() + methodName.substring(4);
                            fieldType = methods[i].getReturnType().toString();
                            if (fieldType != null && fieldType.indexOf(" ") != -1) {
                                fieldType = fieldType.substring(fieldType.indexOf(" ") + 1);
                            }
                            fieldInfo.add(new InfoObject(fieldName, fieldType));
                        }
                        ++i;
                    }
                }
                this.beansInfo.put(dd.getEjbName(), fieldInfo);
            }
        } else if (dd != null && this.beansInfo != null) {
            fieldInfo = (Vector)this.beansInfo.get(dd.getEjbName());
        }
        return fieldInfo;
    }

    private Vector getAllCMPFields(CMPEntityDescriptor dd) {
        Vector<String> temp = new Vector<String>();
        Vector fieldInfo = this.getAllCMPFieldsInfo(dd);
        if (fieldInfo != null) {
            int i = 0;
            while (i < fieldInfo.size()) {
                if (fieldInfo.elementAt(i) != null) {
                    temp.add(((InfoObject)fieldInfo.elementAt(i)).getEntryName());
                }
                ++i;
            }
        } else {
            return null;
        }
        return temp;
    }

    private void initList(RelationDescriptor[] relations) {
        this.listValues = new Vector();
        if (relations != null && relations.length != 0) {
            int i = 0;
            while (i < relations.length) {
                if (relations[i] != null) {
                    this.listValues.addElement(new ListValues(relations[i], 16));
                }
                ++i;
            }
        }
        this.relationList.setListData(this.listValues);
        this.relationList.repaint();
        this.relationList.validate();
    }

    private void initFields(RelationDescriptor rel) {
        if (rel != null) {
            Vector vec;
            int idEjb1 = rel.getSide1().getEjbId();
            int idEjb2 = rel.getSide2().getEjbId();
            CMPEntityDescriptor descr1 = this.schema.getDescriptor(idEjb1);
            CMPEntityDescriptor descr2 = this.schema.getDescriptor(idEjb2);
            int cmrId1 = rel.getSide1().getCmrId();
            int cmrId2 = rel.getSide2().getCmrId();
            this.nameTextField.setText(rel.getRelationName());
            this.descrPanel.setText(rel.getRelationDescription());
            this.role1.setRoleName(rel.getSide1().getRoleName());
            this.setMultiplicity(rel.getSide1().getMultiplicityType());
            this.role1.setDelete(rel.getSide1().isCascade());
            if (descr1 != null) {
                this.role1.setSource(descr1.getEjbName());
                vec = this.getAllCMPFields(descr1);
                if (vec != null) {
                    this.role1.setField(vec);
                } else {
                    this.role1.clear();
                }
            }
            if (cmrId1 != -1) {
                this.role1.setField(descr1.getCmrFields()[cmrId1].getFieldName());
            } else {
                this.role1.setField("");
            }
            this.role2.setRoleName(rel.getSide2().getRoleName());
            if (descr2 != null) {
                this.role2.setSource(descr2.getEjbName());
                vec = this.getAllCMPFields(descr2);
                if (vec != null) {
                    this.role2.setField(vec);
                } else {
                    this.role2.clear();
                }
            }
            if (cmrId2 != -1) {
                this.role2.setField(descr2.getCmrFields()[cmrId2].getFieldName());
            } else {
                this.role2.setField("");
            }
            if (rel.getSide2() != null) {
                this.role2.setDelete(rel.getSide2().isCascade());
            } else {
                this.role2.setDelete(false);
            }
        }
    }

    private void setMultiplicity(int i) {
        if (i == 1) {
            this.role1.setMultiplicity(0);
            this.role2.setMultiplicity(0);
        } else if (i == 2) {
            this.role1.setMultiplicity(0);
            this.role2.setMultiplicity(1);
        } else if (i == 3) {
            this.role1.setMultiplicity(1);
            this.role2.setMultiplicity(0);
        } else if (i == 4) {
            this.role1.setMultiplicity(1);
            this.role2.setMultiplicity(1);
        }
    }

    private void disableFields() {
        if (this.madeFrom == 2 || this.madeFrom == 3) {
            if (this.relationList.isSelectionEmpty()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        } else {
            this.setEnabled(true);
        }
    }

    public void insertUpdate(DocumentEvent e) {
        SwingUtilities.invokeLater(this);
    }

    public void removeUpdate(DocumentEvent e) {
        SwingUtilities.invokeLater(this);
    }

    public void changedUpdate(DocumentEvent e) {
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        this.checkDisabled();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.relationList.isSelectionEmpty()) {
            if (this.madeFrom != 3) {
                this.addButton.setEnabled(false);
                this.modifyButton.setEnabled(true);
                this.removeButton.setEnabled(true);
                this.clearButton.setEnabled(true);
            }
            RelationDescriptor temp = ((ListValues)this.relationList.getSelectedValue()).getRelationDescriptor();
            this.initFields(temp);
        } else {
            this.clear();
        }
        this.disableFields();
        this.cascadeActionPerformed();
    }

    private void checkDisabled() {
        this.addButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        if (!this.relationList.isSelectionEmpty()) {
            if (this.isEnough()) {
                RelationDescriptor rel = ((ListValues)this.relationList.getSelectedValue()).getRelationDescriptor();
                if (rel != null) {
                    if (rel.getRelationName() != null) {
                        if (rel.getRelationName().equals(this.nameTextField.getText())) {
                            this.addButton.setEnabled(false);
                        } else {
                            this.addButton.setEnabled(true);
                        }
                    } else if (this.nameTextField.getText() != null && !this.nameTextField.getText().trim().equals("")) {
                        this.addButton.setEnabled(true);
                    } else {
                        this.addButton.setEnabled(false);
                    }
                }
                this.modifyButton.setEnabled(true);
                this.removeButton.setEnabled(true);
                this.clearButton.setEnabled(true);
            }
        } else if (this.isEnough()) {
            this.addButton.setEnabled(true);
            this.modifyButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.clearButton.setEnabled(true);
        }
        this.disableFields();
    }

    private boolean isEnough() {
        return this.role1.getSource() != null && !this.role1.getSource().trim().equals("") && this.role2.getSource() != null && !this.role2.getSource().trim().equals("") && (this.role1.getField() != null && !this.role1.getField().trim().equals("") || this.role2.getField() != null && !this.role2.getField().trim().equals(""));
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
        this.nameTextField.setText("");
        this.descrPanel.setText("");
        this.role1.clear();
        this.role2.clear();
        if (!this.relationList.isSelectionEmpty()) {
            this.relationList.clearSelection();
        }
        this.addButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        this.schema.setRelDescriptors(this.relations);
        this.clearUselessRelationField();
    }

    private void clearUselessRelationField() {
        CMPEntityDescriptor[] cmpDescr = null;
        RelationField[] rel = null;
        if (this.schema != null && (cmpDescr = this.schema.getDescriptors()) != null) {
            int j = 0;
            while (j < cmpDescr.length) {
                rel = cmpDescr[j].getCmrFields();
                cmpDescr[j].setCmrFields(this.addRelationField(null, rel));
                ++j;
            }
        }
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setDescriptor(EJBJarDescriptor descr) {
        this.disableFields();
        this.beansInfo = new Hashtable();
        if (descr != null) {
            this.schema = descr.getAbstractSchema();
            this.clear();
            this.relations = this.schema.getRelDescriptors();
            this.initList(this.relations);
            if (this.schema != null && this.schema.getDescriptors() != null && this.schema.getDescriptors().length != 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            if (this.schema != null) {
                this.fillEjbNames();
            }
        } else {
            this.clear();
        }
    }

    public ErrorReportObject getErrorObject() {
        return null;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public AbstractSchema getAbstractSchema() {
        return this.schema;
    }

    public void setEnabled(boolean b) {
        this.nameTextField.setEnabled(b);
        this.descrPanel.setEnabled(b);
        this.role1.setEnabled(b);
        this.role2.setEnabled(b);
    }

    public void itemStateChanged(ItemEvent e) {
        this.checkDisabled();
    }
}

