/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.logic;

import com.sap.engine.deploy.ejb.gui.logic.SecurityIdentityPanel;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.LocaleSettings;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.gui.common.DescriptorPanel;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.SecurityRoleRefsPanelLogical;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

public class EJBSecurityPanel
extends DescriptorPanel {
    private SecurityRoleRefsPanelLogical referencesPanel = null;
    private SecurityIdentityPanel identityPanel = null;
    private BorderLayout borderLayout = new BorderLayout();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JTabbedPane tabPane = new JTabbedPane();
    private DeploymentDescriptor descriptor = null;
    private int madeFrom = -1;
    private int correct = 2;
    private ApplicationInformationProvider appProvider;

    public EJBSecurityPanel(Frame mainFrame, int madeFrom) {
        this.mainFrame = mainFrame;
        this.madeFrom = madeFrom;
        this.referencesPanel = new SecurityRoleRefsPanelLogical(mainFrame, madeFrom);
        this.identityPanel = new SecurityIdentityPanel(mainFrame, madeFrom);
        try {
            this.init();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Visualization of panels cannot be initialized properly\nReason: " + e.toString() + "\nRestart of the tool is recommended.\n We are sorry for the inconvenience.", "Error in visualization", 0);
        }
    }

    private void init() throws Exception {
        this.setLayout(this.borderLayout);
        this.add(this.tabPane);
        this.tabPane.add(LocaleSettings.getInstance("EJB").getResourceString("Security Role References", "Security Role References"), this.referencesPanel);
        this.tabPane.add(LocaleSettings.getInstance("EJB").getResourceString("Security Identity", "Security Identity"), this.identityPanel);
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
        this.referencesPanel.init(madeFromConstant);
        this.identityPanel.init(madeFromConstant);
    }

    public void clear() {
        this.referencesPanel.clear();
        this.identityPanel.clear();
    }

    public int isCorrect() {
        this.correct = this.referencesPanel.isCorrect();
        int secIndex = this.correct = this.identityPanel.isCorrect();
        return this.correct;
    }

    public void commitChange() {
        this.referencesPanel.commitChange();
        SecurityRoleReference[] refs = this.referencesPanel.getSecurityRoleRefs();
        Hashtable<String, SecurityRoleReference> references = new Hashtable<String, SecurityRoleReference>();
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                if (refs[i].getRoleName() != null) {
                    references.put(refs[i].getRoleName(), refs[i]);
                }
                ++i;
            }
        }
        this.descriptor.setRoleReferences(references);
        this.identityPanel.commitChange();
        this.descriptor.setSecurityIdentity(this.identityPanel.getSecurityIdentity());
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setDescriptor(Descriptor descr) {
        this.clear();
        this.descriptor = (DeploymentDescriptor)descr;
        SecurityRoleReference[] refs = this.descriptor.getRoleReferences().values().toArray(new SecurityRoleReference[0]);
        SecurityRoles[] roles = this.appProvider != null ? this.appProvider.getSecurityRoles(this.descriptor) : new SecurityRoles[]{};
        this.referencesPanel.setSecurityRoles(roles);
        this.referencesPanel.setSecurityRoleRefs(refs);
        this.identityPanel.setSecurityRoles(roles);
        this.identityPanel.setSecurityIdentity(this.descriptor.getSecurityIdentity());
        this.identityPanel.setMessageDriveBeanType(this.descriptor instanceof MessageDrivenDescriptor);
        this.identityPanel.setEJBName(this.descriptor.getEjbName());
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }
}

