/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.logic;

import com.sap.engine.deploy.ejb.gui.visual.EJBPropertiesPanel;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class EJBPropertiesPanelLogical
extends EJBPropertiesPanel {
    private Properties props;
    private int passiveTimeout = -1;
    private int lrulimit = -1;
    private boolean keepsOpenResources = false;
    private boolean usePassivation = false;
    private int sessionTimeout = -1;
    private int unknownPkInterval = -1;
    private int initialCacheSize = -1;
    private boolean changed = false;
    private int correct = 0;
    private ApplicationInformationProvider appProvider;

    public EJBPropertiesPanelLogical(Frame mainFrame, int madeFrom) {
        this.mainFrame = mainFrame;
        this.init(madeFrom);
    }

    private void setProperties(Properties props) {
        this.model.removeAllElements();
        this.props = props;
        if (props == null) {
            return;
        }
        Enumeration enumeration = ((Hashtable)props).keys();
        ListValues value = null;
        String name = "";
        while (enumeration.hasMoreElements()) {
            name = (String)enumeration.nextElement();
            if (name == null || name.equals("")) continue;
            value = new ListValues(name, 25);
            value.setPropertyValue(props.getProperty(name));
            this.model.addElement(value);
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public int getSessionTimeout() {
        if (this.sessionTimeout < 0) {
            this.sessionTimeout = 0;
        }
        return this.sessionTimeout;
    }

    public int getInitialCacheSize() {
        if (this.initialCacheSize < 0) {
            this.initialCacheSize = 0;
        }
        return this.initialCacheSize;
    }

    public boolean isKeepsOpenResources() {
        return this.keepsOpenResources;
    }

    public int getLrulimit() {
        if (this.lrulimit < 0) {
            this.lrulimit = 0;
        }
        return this.lrulimit;
    }

    public int getPassiveTimeout() {
        if (this.passiveTimeout < 0) {
            this.passiveTimeout = 0;
        }
        return this.passiveTimeout;
    }

    public int getUnknownPkInterval() {
        if (this.unknownPkInterval < 0) {
            this.unknownPkInterval = 0;
        }
        return this.unknownPkInterval;
    }

    public boolean usePassivation() {
        return this.usePassivation;
    }

    public void setMessageDrivenBeanProps(Properties prop) {
        this.setMessageBeanType();
        if (prop != null) {
            this.destinationNameField.setText(prop.getProperty("DestinationName"));
            ((Hashtable)prop).remove("DestinationName");
            this.connectionFactoryNameField.setText(prop.getProperty("ConnectionFactoryName"));
            ((Hashtable)prop).remove("ConnectionFactoryName");
        }
        this.setProperties(prop);
    }

    public void setStatelessBeanProps(int timeout, Properties prop) {
        this.setSessionBeanType(false);
        this.clear();
        if (timeout >= 0) {
            this.sessionTimeoutField.setText(String.valueOf(timeout));
        }
        this.sessionTimeout = timeout;
        this.setProperties(prop);
    }

    public void setStatefullBeanProps(int sesTimeout, boolean keepsOpenResources, Properties prop) {
        this.setSessionBeanType(true);
        this.clear();
        if (sesTimeout >= 0) {
            this.sessionTimeoutField.setText(String.valueOf(sesTimeout));
        }
        this.keepsOpenResources = keepsOpenResources;
        if (keepsOpenResources) {
            this.keepsOpenResourceAction();
        } else {
            this.noneAction();
        }
        this.setProperties(prop);
    }

    public void setStatefullBeanProps(int sesTimeout, int passiveTimeout, int lrulimit, Properties prop) {
        this.setSessionBeanType(true);
        this.clear();
        this.sessionTimeout = sesTimeout;
        if (sesTimeout >= 0) {
            this.sessionTimeoutField.setText(String.valueOf(sesTimeout));
        }
        this.passiveTimeout = passiveTimeout;
        this.lrulimit = lrulimit;
        this.passivationAction();
        if (passiveTimeout >= 0) {
            this.passiveTimeoutField.setText(String.valueOf(passiveTimeout));
        }
        if (lrulimit >= 0) {
            this.lrulimitField.setText(String.valueOf(lrulimit));
        }
        this.setProperties(prop);
    }

    public void setEntityBeanProps(Properties prop) {
        this.setEntityBeanType(false);
        this.clear();
        this.setProperties(prop);
    }

    public void setCMPEntityBeanProps(int unPK, int casheSize, Properties prop) {
        this.setEntityBeanType(true);
        this.clear();
        this.unknownPkInterval = unPK;
        if (this.unknownPkInterval >= 0) {
            this.unknownPKIntervalField.setText(String.valueOf(unPK));
        }
        this.initialCacheSize = casheSize;
        if (casheSize >= 0) {
            this.initialCacheSizeField.setText(String.valueOf(casheSize));
        }
        this.setProperties(prop);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void clear() {
        this.clearFields();
        this.clearBeanTypePanels();
        this.model.removeAllElements();
        this.props = null;
        this.initialCacheSize = -1;
        this.sessionTimeout = -1;
        this.passiveTimeout = -1;
        this.lrulimit = -1;
        this.keepsOpenResources = false;
        this.unknownPkInterval = -1;
    }

    public int isCorrect() {
        return this.correct;
    }

    public void commitChange() {
        Enumeration enumeration = this.model.elements();
        ListValues elem = null;
        this.props = new Properties();
        while (enumeration.hasMoreElements()) {
            elem = (ListValues)enumeration.nextElement();
            ((Hashtable)this.props).put(elem.getName(), elem.getPropertyValue());
        }
        if (this.type == 0 || this.type == 1) {
            this.commitSession();
        } else {
            if (this.type == 2) {
                return;
            }
            if (this.type == 3) {
                this.commitCMPEnity();
            } else if (this.type == 4) {
                this.commitMessage();
            }
        }
    }

    private void commitMessage() {
        if (this.props == null) {
            this.props = new Properties();
        }
        ((Hashtable)this.props).put("DestinationName", this.destinationNameField.getText());
        ((Hashtable)this.props).put("ConnectionFactoryName", this.connectionFactoryNameField.getText());
    }

    private void commitCMPEnity() {
        try {
            this.unknownPkInterval = Integer.valueOf(this.unknownPKIntervalField.getText());
            if (this.unknownPkInterval < 0) {
                this.unknownPkInterval = -1;
            }
        }
        catch (NumberFormatException nfe) {
            this.unknownPkInterval = -1;
        }
        try {
            this.initialCacheSize = Integer.valueOf(this.initialCacheSizeField.getText());
            if (this.initialCacheSize < 0) {
                this.initialCacheSize = -1;
            }
        }
        catch (NumberFormatException nfe) {
            this.initialCacheSize = -1;
        }
    }

    private void commitSession() {
        try {
            this.sessionTimeout = Integer.valueOf(this.sessionTimeoutField.getText());
            if (this.sessionTimeout < 0) {
                this.sessionTimeout = -1;
            }
        }
        catch (NumberFormatException nfe) {
            this.sessionTimeout = -1;
        }
        if (this.type == 1) {
            this.keepsOpenResources = this.keepsOpenResourceRadio.isSelected();
            if (this.passivationRadio.isSelected()) {
                try {
                    this.passiveTimeout = Integer.valueOf(this.passiveTimeoutField.getText());
                    if (this.passiveTimeout < 0) {
                        this.passiveTimeout = -1;
                    }
                }
                catch (NumberFormatException nfe) {
                    this.passiveTimeout = -1;
                }
                try {
                    this.lrulimit = Integer.valueOf(this.lrulimitField.getText());
                    if (this.lrulimit < 0) {
                        this.lrulimit = -1;
                    }
                }
                catch (NumberFormatException nfe) {
                    this.lrulimit = -1;
                }
                if (this.passiveTimeout == -1 && this.lrulimit == -1) {
                    this.usePassivation = false;
                }
            }
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String name = this.nameTextField.getText().trim();
        if (cmd.equals("ADD_CMD")) {
            this.addAction();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeAction(this.propetiesList.getSelectedValue());
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyAction();
        } else if (cmd.equals("CLEAR_CMD")) {
            this.clearAction();
        } else if (cmd.equals("NONE_CMD")) {
            this.noneAction();
        } else if (cmd.equals("PASSIVATION_CMD")) {
            this.passivationAction();
        } else if (cmd.equals("KEEPSONRESOURCE_CMD")) {
            this.keepsOpenResourceAction();
        }
    }

    private void clearAction() {
        if (!this.propetiesList.isSelectionEmpty()) {
            this.propetiesList.clearSelection();
        }
        this.clearFields();
    }

    private void addAction() {
        ListValues value = new ListValues(this.nameTextField.getText(), 25);
        value.setPropertyValue(this.valueTextField.getText());
        this.model.addElement(value);
        this.changed = true;
        this.clearFields();
    }

    private void modifyAction() {
        ListValues value = (ListValues)this.propetiesList.getSelectedValue();
        value.setPropertyValue(this.valueTextField.getText());
        this.clearAction();
    }

    private void removeAction(Object value) {
        this.clearFields();
        this.model.removeElement(value);
        this.changed = true;
    }

    private void keepsOpenResourceAction() {
        this.passiveTimeoutField.setText("");
        this.passiveTimeoutField.setEnabled(false);
        this.lrulimitField.setText("");
        this.lrulimitField.setEnabled(false);
        this.keepsOpenResourceRadio.setSelected(true);
        this.keepsOpenResources = true;
        this.usePassivation = false;
    }

    private void passivationAction() {
        this.passiveTimeoutField.setText("");
        this.passiveTimeoutField.setEnabled(true);
        this.lrulimitField.setText("");
        this.lrulimitField.setEnabled(true);
        this.passivationRadio.setSelected(true);
        this.usePassivation = true;
    }

    private void noneAction() {
        this.passiveTimeoutField.setText("");
        this.passiveTimeoutField.setEnabled(false);
        this.lrulimitField.setText("");
        this.lrulimitField.setEnabled(false);
        this.noneRadio.setSelected(true);
        this.usePassivation = false;
    }

    public void insertUpdate(DocumentEvent e) {
        this.manageEnableing();
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.manageEnableing();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.manageEnableing();
        }
    }

    private void manageEnableing() {
        String name = this.nameTextField.getText().trim();
        this.selectWithMouse = false;
        if (!this.propetiesList.isSelectionEmpty()) {
            this.propetiesList.clearSelection();
        }
        if (name.equals("")) {
            this.clearFields();
        } else {
            ListValues propValue = this.findProperty(name);
            if (propValue == null) {
                this.addButton.setEnabled(true);
                this.modifyButton.setEnabled(false);
                this.removeButton.setEnabled(false);
            } else {
                this.propetiesList.setSelectedValue(propValue, true);
                this.removeButton.setEnabled(true);
                this.modifyButton.setEnabled(true);
                this.addButton.setEnabled(false);
            }
            this.valueTextField.setEnabled(true);
            this.clearButton.setEnabled(true);
        }
        this.selectWithMouse = true;
    }

    public void valueChanged(ListSelectionEvent e) {
        Object temp = null;
        Object name = null;
        if (this.selectWithMouse) {
            this.checPanel();
        }
        if (!this.propetiesList.isSelectionEmpty()) {
            this.clearButton.setEnabled(true);
            this.modifyButton.setEnabled(true);
            this.removeButton.setEnabled(true);
            this.addButton.setEnabled(false);
            this.show((ListValues)this.propetiesList.getSelectedValue());
            this.valueTextField.setEnabled(true);
        } else {
            this.clearFields();
        }
    }

    private void show(ListValues listValue) {
        String propValue;
        if (this.selectWithMouse) {
            this.setText = true;
            this.nameTextField.setText(listValue.getName());
            this.setText = false;
        }
        if ((propValue = listValue.getPropertyValue()) != null) {
            this.valueTextField.setText(propValue);
        } else {
            this.valueTextField.setText("");
        }
    }

    private void checPanel() {
        String name = this.nameTextField.getText().trim();
        if (!name.equals("")) {
            String fromValueTextField = this.valueTextField.getText();
            ListValues value = this.findProperty(name);
            int answer = 1;
            if (value != null) {
                String propertyValue = value.getPropertyValue();
                if (propertyValue != null && !propertyValue.equals(fromValueTextField)) {
                    answer = JOptionPane.showConfirmDialog(this.mainFrame, "The property <" + name + "> has changed his value.\n Would you like to modify it?", "Warning", 0, 2);
                    if (answer == 0) {
                        this.modifyAction();
                    } else {
                        this.clearFields();
                    }
                }
            } else {
                answer = JOptionPane.showConfirmDialog(this.mainFrame, "There is new property <" + name + "> described.\n Would you like to add it?", "Warning", 0, 2);
                if (answer == 0) {
                    this.addAction();
                } else {
                    this.clearFields();
                }
            }
        }
    }

    private ListValues findProperty(String name) {
        int size = this.model.size();
        int i = 0;
        while (i < size) {
            if (name.equals(((ListValues)this.model.get(i)).getName().trim())) {
                return (ListValues)this.model.get(i);
            }
            ++i;
        }
        return null;
    }

    public void reset() {
        this.changed = false;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }
}

