/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.descriptors.xml;

import com.sap.engine.deploy.exceptions.ToolDeploymentException;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DataBaseProperties;
import com.sap.engine.services.ejb.deploy.descriptors.DependentValueDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.M2MRelationFieldMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RDependentValueMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RPersistentFieldMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RRelationFieldMap;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLPersistentGenerator {
    public static final String dtd = " <!DOCTYPE persistent-ejb-map SYSTEM 'persistent.dtd'>";
    private static final String NOKEY = "NoKey";
    private static final String PRIMARYKEY = "PrimaryKey";
    private static final String FOREIGNKEY = "ForeignKey";
    private static final String UNIQUEKEY = "UniqueKey";
    private static final String PERSISTENTEJBMAP = "persistent-ejb-map";
    private static final String DBPROPERTIES = "db-properties";
    private static final String DSNAME = "data-source-name";
    private static final String ENTITYBEANS = "entity-beans";
    private static final String ENTITYBEAN = "entity-bean";
    private static final String EJBNAME = "ejb-name";
    private static final String READONLY = "read-only";
    private static final String SELECTFORUPDATE = "select-for-update";
    private static final String TABLENAME = "table-name";
    private static final String FIELDMAP = "field-map";
    private static final String FIELDNAME = "field-name";
    private static final String SUBFIELDNAME = "subfield-name";
    private static final String FINDERDESCRIPTOR = "finder-descriptor";
    private static final String CRITERIA = "criteria";
    private static final String METHODNAME = "method-name";
    private static final String METHODPARAMS = "method-params";
    private static final String METHODPARAM = "method-param";
    private static final String SWITCHOFF = "switch-off-storing";
    private static final String COLUMNNAME = "column-name";
    private static final String RELATIONSHIPS = "relationships";
    private static final String TABLERELATION = "table-relation";
    private static final String HELPTABLE = "help-table";
    private static final String TABLERELATIONSHIPROLE = "table-relationship-role";
    private static final String COLUMN = "column";
    private static final String DVCOLUMN = "dv-column";
    private static final String CMRFIELD = "cmr-field";
    private static final String SWITCHOFFVERIFICATION = "switch-off-verification";
    private Document mainDocument = null;
    private Vector errors = new Vector();
    private boolean compliance = false;

    public void generateXml(EJBJarDescriptor ejbjarDescriptor, String fileName) throws DeploymentException {
        this.generateDocument(ejbjarDescriptor);
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            new StandardDOMWriter().write(this.mainDocument, fileName, dtd, "UTF-8");
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (IOException ioe) {
            Object[] args = new String[]{"persistent", ioe.toString()};
            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4001", args, ioe);
            toThrow.log();
            throw toThrow;
        }
    }

    public Document generateDocument(EJBJarDescriptor ejbjarDescriptor) throws DeploymentException {
        RelationDescriptor[] relations = null;
        CMPEntityDescriptor[] entityDescriptors = null;
        Object entityDescriptor = null;
        AbstractSchema abstractSchema = null;
        DataBaseProperties dbProperties = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Element persMap = null;
        Element relationships = null;
        Element tableRelation = null;
        Element dbPropertiesEl = null;
        Element entityBeans = null;
        Element entityBeanMap = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcfe) {
            Object[] args = new String[]{"persistent"};
            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4000", args, pcfe);
            toThrow.log();
            throw toThrow;
        }
        this.mainDocument = builder.newDocument();
        abstractSchema = ejbjarDescriptor.getAbstractSchema();
        persMap = this.mainDocument.createElement(PERSISTENTEJBMAP);
        this.mainDocument.appendChild(persMap);
        if (abstractSchema.isVerificationSwitchedOff()) {
            Element switchOffVerify = this.mainDocument.createElement(SWITCHOFFVERIFICATION);
            persMap.appendChild(switchOffVerify);
        }
        if (abstractSchema.haveToCreateTables()) {
            Element createTables = this.mainDocument.createElement("create-tables-at-deploy");
            persMap.appendChild(createTables);
        }
        Element lockingEl = this.mainDocument.createElement("locking");
        int lockingTypeId = abstractSchema.getLockingType();
        String lockingType = this.getStringLockingType(lockingTypeId);
        lockingEl.setAttribute("type", lockingType);
        persMap.appendChild(lockingEl);
        dbProperties = abstractSchema.getDBProperties();
        dbPropertiesEl = this.generateDBProps(dbProperties);
        persMap.appendChild(dbPropertiesEl);
        entityBeans = this.mainDocument.createElement(ENTITYBEANS);
        persMap.appendChild(entityBeans);
        entityDescriptors = abstractSchema.getDescriptors();
        int i = 0;
        while (i < entityDescriptors.length) {
            entityBeanMap = this.generateEntityBean(entityDescriptors[i]);
            entityBeans.appendChild(entityBeanMap);
            ++i;
        }
        relationships = this.mainDocument.createElement(RELATIONSHIPS);
        persMap.appendChild(relationships);
        relations = abstractSchema.getRelDescriptors();
        if (relations != null) {
            int i2 = 0;
            while (i2 < relations.length) {
                tableRelation = this.generateTableRelation(relations[i2], abstractSchema);
                relationships.appendChild(tableRelation);
                ++i2;
            }
        }
        return this.mainDocument;
    }

    private String getStringLockingType(int type) {
        switch (type) {
            case 1: {
                return "Table";
            }
            case 2: {
                return "Local";
            }
        }
        return "Administrative";
    }

    private Element generateEntityBean(CMPEntityDescriptor entityDescriptor) throws DeploymentException {
        Element entityBeanMap = this.mainDocument.createElement(ENTITYBEAN);
        PersistentField[] cmpFields = entityDescriptor.getCmpFields();
        PersistentField[] pkCmpFields = entityDescriptor.getPKCmpFields();
        FinderDescriptor[] finderDescriptors = null;
        Object fieldDBMap = null;
        Element cmpFieldElement = null;
        Object cmpColumnElement = null;
        Element finderElement = null;
        Element paramsEl = null;
        Element readOnlyElement = null;
        Element selectForUpdateElement = null;
        String[] params = null;
        String sqlCriteria = null;
        Object descr = null;
        this.load(entityBeanMap, entityDescriptor.getEjbName(), EJBNAME);
        this.load(entityBeanMap, entityDescriptor.getTableName(), TABLENAME);
        if (entityDescriptor.isReadOnly()) {
            readOnlyElement = this.mainDocument.createElement(READONLY);
            entityBeanMap.appendChild(readOnlyElement);
        } else if (entityDescriptor.useSelectForUpdate()) {
            selectForUpdateElement = this.mainDocument.createElement(SELECTFORUPDATE);
            entityBeanMap.appendChild(selectForUpdateElement);
        }
        int j = 0;
        while (j < pkCmpFields.length) {
            cmpFieldElement = this.generateCmpMap(pkCmpFields[j]);
            entityBeanMap.appendChild(cmpFieldElement);
            ++j;
        }
        int j2 = 0;
        while (j2 < cmpFields.length) {
            cmpFieldElement = this.generateCmpMap(cmpFields[j2]);
            entityBeanMap.appendChild(cmpFieldElement);
            ++j2;
        }
        finderDescriptors = entityDescriptor.getFinderDescriptors();
        if (finderDescriptors != null) {
            boolean addFinder = false;
            int j3 = 0;
            while (j3 < finderDescriptors.length) {
                Element selectObj;
                addFinder = false;
                sqlCriteria = finderDescriptors[j3].getSQLStatement();
                sqlCriteria = finderDescriptors[j3].getSQLStatement();
                finderElement = this.mainDocument.createElement(FINDERDESCRIPTOR);
                if (sqlCriteria != null && !sqlCriteria.equals("")) {
                    this.load(finderElement, sqlCriteria, CRITERIA);
                    addFinder = true;
                }
                this.load(finderElement, finderDescriptors[j3].getMethodName(), METHODNAME);
                paramsEl = this.mainDocument.createElement(METHODPARAMS);
                finderElement.appendChild(paramsEl);
                params = finderDescriptors[j3].getParamsTypes();
                int p = 0;
                while (p < params.length) {
                    this.load(paramsEl, params[p], METHODPARAM);
                    ++p;
                }
                if (!finderDescriptors[j3].getStoringMode()) {
                    Element mode = this.mainDocument.createElement(SWITCHOFF);
                    finderElement.appendChild(mode);
                    addFinder = true;
                }
                if (finderDescriptors[j3].toLoadSelectedObjects()) {
                    selectObj = this.mainDocument.createElement("load-selected-objects");
                    String lockMode = finderDescriptors[j3].getLockMode();
                    if (lockMode != null) {
                        selectObj.setAttribute("lock", lockMode);
                    }
                    finderElement.appendChild(selectObj);
                    addFinder = true;
                }
                if (finderDescriptors[j3].getLazyLoading()) {
                    Element lazyLoading = this.mainDocument.createElement("lazy-loading");
                    finderElement.appendChild(lazyLoading);
                }
                if (finderDescriptors[j3].getFetchSize() != 0) {
                    this.load(finderElement, String.valueOf(finderDescriptors[j3].getFetchSize()), "fetch-size");
                }
                if (finderDescriptors[j3].isQLVersion2_1()) {
                    selectObj = this.mainDocument.createElement("ql-2.1-compatible");
                    finderElement.appendChild(selectObj);
                    addFinder = true;
                }
                if (addFinder) {
                    entityBeanMap.appendChild(finderElement);
                }
                ++j3;
            }
        }
        return entityBeanMap;
    }

    private Element generateCmpMap(PersistentField cmp) {
        RPersistentFieldMap fieldDBMap = cmp.getFieldDBMap();
        Element cmpFieldElement = this.mainDocument.createElement(FIELDMAP);
        Element cmpColumnElement = null;
        RDependentValueMap dv = null;
        String[] types = null;
        String[] subfields = null;
        Object defaultSqlType = null;
        this.load(cmpFieldElement, cmp.getFieldName(), FIELDNAME);
        if (fieldDBMap instanceof RDependentValueMap) {
            dv = (RDependentValueMap)fieldDBMap;
            types = ((DependentValueDescriptor)cmp).getValueFieldTypes();
            subfields = ((DependentValueDescriptor)cmp).getValueFieldNames();
            int k = 0;
            while (k < dv.getDvColumnName().length) {
                cmpColumnElement = this.mainDocument.createElement(DVCOLUMN);
                this.load(cmpColumnElement, subfields[k], SUBFIELDNAME);
                cmpFieldElement.appendChild(cmpColumnElement);
                this.load(cmpColumnElement, dv.getDvColumnName()[k], COLUMNNAME);
                ++k;
            }
        } else {
            cmpColumnElement = this.mainDocument.createElement(COLUMN);
            cmpFieldElement.appendChild(cmpColumnElement);
            this.load(cmpColumnElement, fieldDBMap.getColumnName(), COLUMNNAME);
        }
        if (cmp.isMutable()) {
            Element mutable = this.mainDocument.createElement("mutable");
            cmpFieldElement.appendChild(mutable);
        }
        cmpFieldElement.setAttribute("key-type", this.intToStringKeyMap(fieldDBMap.getKey()));
        return cmpFieldElement;
    }

    private Element generateDBProps(DataBaseProperties dbProperties) {
        Element dbPropertiesEl = this.mainDocument.createElement(DBPROPERTIES);
        if (dbProperties == null || dbProperties.getDataSourceName() == null || dbProperties.getDataSourceName().equals("")) {
            this.load(dbPropertiesEl, "defaultDSName", DSNAME);
        } else {
            this.load(dbPropertiesEl, dbProperties.getDataSourceName(), DSNAME);
            if (dbProperties.getDBVendorId() != -1) {
                Element dbVendorEl = this.mainDocument.createElement("database-vendor");
                dbVendorEl.setAttribute("name", dbProperties.getDBVendorName());
                dbPropertiesEl.appendChild(dbVendorEl);
            }
        }
        return dbPropertiesEl;
    }

    private Element generateTableRelation(RelationDescriptor relation, AbstractSchema schema) throws DeploymentException {
        boolean manyToMany;
        Element tableRelation = this.mainDocument.createElement(TABLERELATION);
        M2MRelationFieldMap m2mMap = relation.getM2MMap();
        boolean bl = manyToMany = m2mMap != null;
        if (manyToMany) {
            String tableName = m2mMap.getHelpTable();
            if (tableName == null) {
                if (this.compliance) {
                    ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4003");
                    toThrow.log();
                    throw toThrow;
                }
                this.errors.add("For relation Many to Many you must defined help table.");
            }
            this.load(tableRelation, tableName, HELPTABLE);
        }
        Element tableRelationshipRole1 = this.mainDocument.createElement(TABLERELATIONSHIPROLE);
        tableRelation.appendChild(tableRelationshipRole1);
        OneSideRelationDescriptor side1 = relation.getSide1();
        CMPEntityDescriptor descr1 = schema.getDescriptor(side1.getEjbId());
        PersistentField[] pk1 = descr1.getPKCmpFields();
        OneSideRelationDescriptor side2 = relation.getSide2();
        CMPEntityDescriptor descr2 = schema.getDescriptor(side2.getEjbId());
        PersistentField[] pk2 = descr2.getPKCmpFields();
        this.createOneSideOfRelation(tableRelationshipRole1, side1, schema, pk2, manyToMany);
        Element tableRelationshipRole2 = this.mainDocument.createElement(TABLERELATIONSHIPROLE);
        tableRelation.appendChild(tableRelationshipRole2);
        this.createOneSideOfRelation(tableRelationshipRole2, side2, schema, pk1, manyToMany);
        if (manyToMany) {
            String[] foreignKeyColumns1 = m2mMap.getColumns1();
            this.createFkColumnElements(tableRelationshipRole1, foreignKeyColumns1, pk1);
            String[] foreignKeyColumns2 = m2mMap.getColumns2();
            this.createFkColumnElements(tableRelationshipRole2, foreignKeyColumns2, pk2);
        }
        return tableRelation;
    }

    private void createFkColumnElements(Element tableRelationshipRole1, String[] fkColumns, PersistentField[] refPkFields) {
        int i = 0;
        while (i < fkColumns.length) {
            Element fkColumnEl = this.mainDocument.createElement("fk-column");
            this.load(fkColumnEl, fkColumns[i], COLUMNNAME);
            this.load(fkColumnEl, refPkFields[i].getFieldName(), "pk-field-name");
            tableRelationshipRole1.appendChild(fkColumnEl);
            ++i;
        }
    }

    private Element load(Element el, String value, String tagName) {
        if (value == null) {
            value = new String("");
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    private String intToStringKeyMap(int i) {
        switch (i) {
            case 1: {
                return PRIMARYKEY;
            }
            case 2: {
                return FOREIGNKEY;
            }
            case 3: {
                return UNIQUEKEY;
            }
        }
        return NOKEY;
    }

    public void setCompliance(boolean compliance) {
        this.compliance = compliance;
    }

    public Vector getErrors() {
        return this.errors;
    }

    private void createOneSideOfRelation(Element tableRelationshipRole, OneSideRelationDescriptor side, AbstractSchema schema, PersistentField[] refPkFields, boolean manyToMany) {
        String[] columns;
        CMPEntityDescriptor descr = schema.getDescriptor(side.getEjbId());
        this.load(tableRelationshipRole, descr.getEjbName(), EJBNAME);
        if (side.getCmrId() != -1) {
            this.load(tableRelationshipRole, descr.getRelationField(side.getCmrId()).getFieldName(), CMRFIELD);
        }
        RRelationFieldMap sideMap = side.getFieldDBMap();
        tableRelationshipRole.setAttribute("key-type", this.intToStringKeyMap(sideMap.getKey()));
        if (!manyToMany && (columns = sideMap.getColumn()) != null) {
            this.createFkColumnElements(tableRelationshipRole, columns, refPkFields);
        }
    }
}

