/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.descriptors.xml;

import com.sap.engine.deploy.exceptions.ToolDeploymentException;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.ComponentReference;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.IORDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SecurityIdentity;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class InqmyEjbGenerator {
    public static final String dtd = "<!DOCTYPE ejb-j2ee-engine SYSTEM 'ejb-j2ee-engine.dtd'>";
    private Document mainDocument = null;
    private DocumentBuilder builder = null;
    private DocumentBuilderFactory factory = null;
    private DeploymentDescriptor[] descriptors = null;
    private int length = -1;
    private Element inqmyEjb = null;
    private Vector errors = new Vector();
    private String currEJBName = null;

    public InqmyEjbGenerator() throws DeploymentException {
        this.newDocument();
    }

    public void newDocument() throws DeploymentException {
        this.factory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcfe) {
            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4000", (Throwable)pcfe);
            toThrow.log();
            throw toThrow;
        }
        this.mainDocument = this.builder.newDocument();
        this.inqmyEjb = this.mainDocument.createElement("ejb-j2ee-engine");
    }

    public void generateXML(EJBJarDescriptor ejbJar, String fileName) throws DeploymentException {
        this.generateXML(ejbJar);
        this.writeXML(fileName);
    }

    public Document generateXML(EJBJarDescriptor ejbJar) throws DeploymentException {
        this.newDocument();
        this.descriptors = ejbJar.getDDescriptors();
        boolean create = false;
        if (this.descriptors != null && (this.length = this.descriptors.length) != 0) {
            SecurityRoles[] roles;
            String inqmyDescription = ejbJar.getInqmyDescription();
            if (inqmyDescription != null && !inqmyDescription.trim().equals("") && this.load(this.inqmyEjb, inqmyDescription, "description")) {
                create = true;
            }
            if (this.createEnterpriseBeans()) {
                create = true;
            }
            if (this.createTransactionDescriptors()) {
                create = true;
            }
            if ((roles = ejbJar.getSecurityRoles()) != null && roles.length != 0 && this.createSecurityPermitions(roles)) {
                create = true;
            }
        }
        if (create) {
            this.mainDocument.appendChild(this.inqmyEjb);
        }
        return this.mainDocument;
    }

    public void writeXML(String xmlName) throws DeploymentException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            new StandardDOMWriter().write(this.mainDocument, xmlName, dtd, "UTF-8");
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (IOException ioe) {
            Object[] args = new String[]{"ejb-j2ee-engine", ioe.toString()};
            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4001", args, ioe);
            toThrow.log();
            throw toThrow;
        }
    }

    private boolean load(Element el, String value, String tagName) {
        if (value == null || value.trim().equals("")) {
            return false;
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return true;
    }

    private boolean createEnterpriseBeans() {
        Element ejbs = this.mainDocument.createElement("enterprise-beans");
        Element ejb = null;
        boolean add = false;
        DeploymentDescriptor dd = null;
        int i = 0;
        while (i < this.length) {
            dd = this.descriptors[i];
            if (dd != null && this.load(ejb = this.mainDocument.createElement("enterprise-bean"), dd.getEjbName(), "ejb-name")) {
                this.currEJBName = dd.getEjbName();
                this.load(ejb, dd.getJndiName(), "jndi-name");
                Properties bProps = dd.getBeanProperties();
                this.load(ejb, String.valueOf(dd.getContainerSize()), "container-size");
                this.createEjbRef(ejb, dd.getEJBeanReferences());
                this.createEjbLocalRef(ejb, dd.getEJBeanLocalReferences());
                this.createResourceRef(ejb, dd.getResourceReferences());
                this.createResEnvRef(ejb, dd.getResourceEnvReferences());
                this.createComponentRef(ejb, dd.getServerComponentReferences());
                SecurityIdentity identity = dd.getSecurityIdentity();
                if (identity != null && !identity.isCallerIdentity()) {
                    this.createRunAsIdentityMap(ejb, identity.getRunAsIdentity());
                }
                this.createIORSecurity(ejb, dd.getIORDescriptors());
                if (dd instanceof SessionDescriptor) {
                    this.createSessionProps(ejb, (SessionDescriptor)dd, bProps);
                } else if (dd instanceof EntityDescriptor) {
                    this.createEntityProps(ejb, (EntityDescriptor)dd, bProps);
                } else if (dd instanceof MessageDrivenDescriptor) {
                    this.createMessageDrivenProps(ejb, (MessageDrivenDescriptor)dd, bProps);
                }
                ejbs.appendChild(ejb);
                add = true;
            }
            ++i;
        }
        if (add) {
            this.inqmyEjb.appendChild(ejbs);
            return true;
        }
        return false;
    }

    private void createIORSecurity(Element el, IORDescriptor[] value) {
        int size = -1;
        if (value == null || (size = value.length) == 0) {
            return;
        }
        boolean add = false;
        Element iorConfig = null;
        IORDescriptor ior = null;
        int i = 0;
        while (i < size) {
            add = false;
            ior = value[i];
            iorConfig = this.mainDocument.createElement("ior-security-config");
            if (this.createTransportConfig(iorConfig, ior)) {
                add = true;
            }
            if (this.createAsContext(iorConfig, ior)) {
                add = true;
            }
            if (this.createSasContext(iorConfig, ior)) {
                add = true;
            }
            if (add) {
                el.appendChild(iorConfig);
            }
            ++i;
        }
    }

    private boolean createTransportConfig(Element el, IORDescriptor ior) {
        Element transportConfig = this.mainDocument.createElement("transport-config");
        if (!this.load(transportConfig, ior.getIntegrity(), "integrity")) {
            this.errors.add(" EJB \"" + this.currEJBName + "\": Incorrect transport-config tag: integrity not set");
            return false;
        }
        if (!this.load(transportConfig, ior.getConfidentiality(), "confidentiality")) {
            this.errors.add(" EJB \"" + this.currEJBName + "\": Incorrect transport-config tag: confidentiality not set");
            return false;
        }
        if (!this.load(transportConfig, ior.getEstablishTrustInTarget(), "establish-trust-in-target")) {
            this.errors.add(" EJB \"" + this.currEJBName + "\": Incorrect transport-config tag: establish-trust-in-target not set");
            return false;
        }
        if (!this.load(transportConfig, ior.getEstablishTrustInClient(), "establish-trust-in-client")) {
            this.errors.add(" EJB \"" + this.currEJBName + "\": Incorrect transport-config tag: establish-trust-in-client not set");
            return false;
        }
        el.appendChild(transportConfig);
        return true;
    }

    private boolean createAsContext(Element el, IORDescriptor ior) {
        Element asContext = this.mainDocument.createElement("as-context");
        if (!this.load(asContext, ior.getAuthenticationMethod(), "auth-method")) {
            this.errors.add(" EJB \"" + this.currEJBName + "\": Incorrect as-context tag: auth-method not set");
            return false;
        }
        if (!this.load(asContext, ior.getRealmName(), "realm")) {
            this.errors.add(" EJB \"" + this.currEJBName + "\": Incorrect as-context tag: realm not set");
            return false;
        }
        if (ior.isAuthMethodRequired()) {
            if (!this.load(asContext, "true", "required")) {
                this.errors.add(" EJB \"" + this.currEJBName + "\": Incorrect as-context tag: required not set");
                return false;
            }
        } else if (!this.load(asContext, "false", "required")) {
            this.errors.add(" EJB \"" + this.currEJBName + "\": Incorrect as-context tag: required not set");
            return false;
        }
        el.appendChild(asContext);
        return true;
    }

    private boolean createSasContext(Element el, IORDescriptor ior) {
        Element sasContext = this.mainDocument.createElement("sas-context");
        if (!this.load(sasContext, ior.getCallerPropagation(), "caller-propagation")) {
            this.errors.add(" EJB \"" + this.currEJBName + "\": Incorrect sas-context tag: caller-propagation not set");
            return false;
        }
        el.appendChild(sasContext);
        return true;
    }

    private void createSessionProps(Element el, SessionDescriptor sessD, Properties bProp) {
        boolean hasProps = false;
        Element session = this.mainDocument.createElement("session-props");
        if (sessD.getSessionTimeout() != 0 && this.load(session, String.valueOf(sessD.getSessionTimeout()), "session-timeout")) {
            hasProps = true;
        }
        if (sessD.usePassivation()) {
            if (this.createPassivation(session, sessD)) {
                hasProps = true;
            }
        } else if (sessD.keepsOpenResources()) {
            Element keeps = this.mainDocument.createElement("keeps-open-resources");
            session.appendChild(keeps);
            hasProps = true;
        }
        if (bProp != null && this.createProperties(session, bProp)) {
            hasProps = true;
        }
        if (hasProps) {
            el.appendChild(session);
        }
    }

    private boolean createPassivation(Element el, SessionDescriptor sessD) {
        Element passivation = this.mainDocument.createElement("passivation");
        if (!this.load(passivation, String.valueOf(sessD.getStatefulTimeout()), "passive-timeout")) {
            this.errors.add(" EJB \"" + this.currEJBName + "\": Incorrect passivation tag: passive-timeout not set");
            return false;
        }
        if (!this.load(passivation, String.valueOf(sessD.getStatefulTimeout()), "lrulimit")) {
            this.errors.add(" EJB \"" + this.currEJBName + "\": Incorrect passivation tag: lrulimit not set");
            return false;
        }
        el.appendChild(passivation);
        return true;
    }

    private void createEntityProps(Element el, EntityDescriptor entD, Properties bProp) {
        boolean hasProps = false;
        Element entity = this.mainDocument.createElement("entity-props");
        if (entD instanceof CMPEntityDescriptor) {
            if (this.load(entity, String.valueOf(((CMPEntityDescriptor)entD).getUnknownPKInterval()), "unknown-pk-interval")) {
                hasProps = true;
            }
            if (this.load(entity, String.valueOf(((CMPEntityDescriptor)entD).getCacheSize()), "initial-cache-size")) {
                hasProps = true;
            }
        }
        if (bProp != null && this.createProperties(entity, bProp)) {
            hasProps = true;
        }
        if (hasProps) {
            el.appendChild(entity);
        }
    }

    private void createMessageDrivenProps(Element el, MessageDrivenDescriptor messD, Properties bProp) {
        boolean hasProps = false;
        Element message = this.mainDocument.createElement("message-props");
        if (bProp != null) {
            String connectionFactoryName;
            String destinationName = bProp.getProperty("DestinationName");
            if (this.load(message, destinationName, "destination-name")) {
                hasProps = true;
            }
            if (this.load(message, connectionFactoryName = bProp.getProperty("ConnectionFactoryName"), "connection-factory-name")) {
                hasProps = true;
            }
            if (((Hashtable)bProp).size() > 2 && this.createProperties(message, bProp)) {
                hasProps = true;
            }
        }
        if (hasProps) {
            el.appendChild(message);
        }
    }

    private boolean createProperties(Element el, Properties props) {
        Enumeration keys = ((Hashtable)props).keys();
        String name = null;
        String value = null;
        Element property = null;
        boolean add = false;
        while (keys.hasMoreElements()) {
            name = (String)keys.nextElement();
            if (name.equals("DestinationName") || name.equals("ConnectionFactoryName")) continue;
            property = this.mainDocument.createElement("property");
            if (!this.load(property, name, "property-name")) {
                this.errors.add(" EJB \"" + this.currEJBName + "\": Incorect " + el.getNodeName() + "tag:  Incorrect property tag: property-name not set");
                continue;
            }
            value = props.getProperty(name);
            if (!this.load(property, value, "property-value")) {
                this.errors.add(" EJB \"" + this.currEJBName + "\": Incorect " + el.getNodeName() + "tag:  Incorrect property tag: property-value not set");
                continue;
            }
            add = true;
            el.appendChild(property);
        }
        return add;
    }

    private void createResourceRef(Element el, ResourceReference[] value) {
        int size = -1;
        if (value == null || (size = value.length) == 0) {
            return;
        }
        Element resRef = null;
        ResourceReference tempRef = null;
        Element nonTxSupport = null;
        int i = 0;
        while (i < size) {
            tempRef = value[i];
            String jndiName = tempRef.getResourceLink();
            if (jndiName != null) {
                resRef = this.mainDocument.createElement("resource-ref");
                if (!this.load(resRef, tempRef.getResourceName(), "res-ref-name")) {
                    this.errors.add(" EJB \"" + this.currEJBName + "\": Incorect tag resource-ref: res-ref-name not set.");
                } else if (!this.load(resRef, jndiName, "res-link")) {
                    this.errors.add(" EJB \"" + this.currEJBName + "\": Incorect tag resource-ref: res-link not set.");
                } else {
                    if (!tempRef.isTransactional()) {
                        nonTxSupport = this.mainDocument.createElement("non-transactional");
                        resRef.appendChild(nonTxSupport);
                    }
                    el.appendChild(resRef);
                }
            }
            ++i;
        }
    }

    private void createEjbRef(Element el, EJBeanReference[] value) {
        int size = -1;
        if (value == null || (size = value.length) == 0) {
            return;
        }
        Element ref = null;
        EJBeanReference temp = null;
        int i = 0;
        while (i < size) {
            temp = value[i];
            String jndiName = temp.getReferenceJndiLink();
            if (jndiName != null) {
                ref = this.mainDocument.createElement("ejb-ref");
                if (!this.load(ref, temp.getReferenceName(), "ejb-ref-name")) {
                    this.errors.add(" EJB \"" + this.currEJBName + "\": Incorect tag ejb-ref: ejb-ref-name not set.");
                } else if (!this.load(ref, jndiName, "jndi-name")) {
                    this.errors.add(" EJB \"" + this.currEJBName + "\": Incorect tag ejb-ref: jndi-name not set.");
                } else {
                    el.appendChild(ref);
                }
            }
            ++i;
        }
    }

    private void createEjbLocalRef(Element el, EJBeanLocalReference[] value) {
        int size = -1;
        if (value == null || (size = value.length) == 0) {
            return;
        }
        Element ref = null;
        EJBeanLocalReference temp = null;
        int i = 0;
        while (i < size) {
            temp = value[i];
            String jndiName = temp.getReferenceJndiLink();
            if (jndiName != null) {
                ref = this.mainDocument.createElement("ejb-local-ref");
                if (!this.load(ref, temp.getReferenceName(), "ejb-ref-name")) {
                    this.errors.add(" EJB \"" + this.currEJBName + "\": Incorect tag ejb-ref: ejb-ref-name not set.");
                } else if (!this.load(ref, jndiName, "jndi-name")) {
                    this.errors.add(" EJB \"" + this.currEJBName + "\": Incorect tag ejb-ref: jndi-name not set.");
                } else {
                    el.appendChild(ref);
                }
            }
            ++i;
        }
    }

    private void createResEnvRef(Element el, ResourceEnvReference[] value) {
        int size = -1;
        if (value == null || (size = value.length) == 0) {
            return;
        }
        Element ref = null;
        ResourceEnvReference temp = null;
        int i = 0;
        while (i < size) {
            temp = value[i];
            String jndiName = temp.getJndiName();
            if (jndiName != null) {
                ref = this.mainDocument.createElement("resource-env-ref");
                if (!this.load(ref, temp.getName(), "resource-env-ref-name")) {
                    this.errors.add(" EJB \"" + this.currEJBName + "\": Incorect tag resource-env-ref: res-env-ref-name not set.");
                } else if (!this.load(ref, jndiName, "jndi-name")) {
                    this.errors.add(" EJB \"" + this.currEJBName + "\": Incorect tag resource-env-ref: jndi-name not set.");
                } else {
                    el.appendChild(ref);
                }
            }
            ++i;
        }
    }

    private void createComponentRef(Element el, ComponentReference[] value) {
        int size = -1;
        if (value == null || (size = value.length) == 0) {
            return;
        }
        Element ref = null;
        ComponentReference temp = null;
        int i = 0;
        while (i < size) {
            temp = value[i];
            ref = this.mainDocument.createElement("server-component-ref");
            this.load(ref, temp.getDescription(), "description");
            if (!this.load(ref, temp.getName(), "name")) {
                this.errors.add(" EJB \"" + this.currEJBName + "\": Incorrect tag server-component-ref: name not set");
            } else if (!this.load(ref, temp.getType() == 1 ? "Interface" : "Service", "type")) {
                this.errors.add(" EJB \"" + this.currEJBName + "\": Incorrect tag server-component-ref: type not set");
            } else if (!this.load(ref, temp.getJndiName(), "jndi-name")) {
                this.errors.add(" EJB \"" + this.currEJBName + "\": Incorrect tag server-component-ref: jndi-name not set");
            } else {
                el.appendChild(ref);
            }
            ++i;
        }
    }

    private void createRunAsIdentityMap(Element el, RunAsIdentity value) {
        Element runAs;
        if (value == null) {
            this.errors.add(" EJB \"" + this.currEJBName + "\": Incorect tag run-as-identity-map: user-name not set");
            return;
        }
        if (value.getUserName() != null && !value.getUserName().equals("") && this.load(runAs = this.mainDocument.createElement("run-as-identity-map"), value.getUserName(), "user-name")) {
            el.appendChild(runAs);
            return;
        }
        this.errors.add(" EJB \"" + this.currEJBName + "\": Incorect tag run-as-identity-map: user-name not set");
    }

    private boolean createTransactionDescriptors() {
        int size = -1;
        Element transaction = this.mainDocument.createElement("transaction-descriptor");
        ControlDescriptor[] controls = null;
        Vector committed = new Vector();
        Vector uncommitted = new Vector();
        Vector repeatable = new Vector();
        Vector serializable = new Vector();
        int i = 0;
        while (i < this.length) {
            controls = this.descriptors[i].getTransactionDescriptors();
            if (controls != null && (size = controls.length) != 0) {
                int j = 0;
                while (j < size) {
                    this.addMethodToIsolationList(controls[j], committed, uncommitted, repeatable, serializable);
                    ++j;
                }
            }
            ++i;
        }
        if (this.addIsolationLevels(transaction, committed, uncommitted, repeatable, serializable)) {
            this.inqmyEjb.appendChild(transaction);
            return true;
        }
        return false;
    }

    private void addMethodToIsolationList(ControlDescriptor control, Vector committed, Vector uncommitted, Vector repeatable, Vector serializable) {
        int level = control.getIsolationLevel();
        if (level == 2) {
            committed.add(control.getMethodEntry());
        } else if (level == 1) {
            uncommitted.add(control.getMethodEntry());
        } else if (level == 4) {
            repeatable.add(control.getMethodEntry());
        } else if (level == 8) {
            serializable.add(control.getMethodEntry());
        }
    }

    private boolean addIsolationLevels(Element transaction, Vector committed, Vector uncommitted, Vector repeatable, Vector serializable) {
        boolean add = false;
        if (this.makeList(transaction, committed, "Committed")) {
            add = true;
        }
        if (this.makeList(transaction, uncommitted, "Uncommitted")) {
            add = true;
        }
        if (this.makeList(transaction, repeatable, "Repeatable")) {
            add = true;
        }
        if (this.makeList(transaction, serializable, "Serializable")) {
            add = true;
        }
        return add;
    }

    private boolean makeList(Element trans, Vector methods, String type) {
        int size = -1;
        size = methods.size();
        if (size == 0) {
            return false;
        }
        Element level = this.mainDocument.createElement("isolation-level");
        MethodEntry entry = null;
        Object methodParams = null;
        boolean add = false;
        int i = 0;
        while (i < size) {
            entry = (MethodEntry)methods.get(i);
            String methodName = entry.getMethodName();
            if (methodName == null || methodName.equals("*") || methodName.equals("Entire EJB")) {
                if (this.load(level, entry.getEjbName(), "ejb-name")) {
                    add = true;
                }
            } else if (this.createMethod(level, entry)) {
                add = true;
            }
            ++i;
        }
        if (add) {
            this.load(level, type, "isolation-attribute");
            trans.appendChild(level);
            return true;
        }
        return false;
    }

    private boolean createMethod(Element el, MethodEntry entry) {
        Element method = this.mainDocument.createElement("method");
        if (!this.load(method, entry.getEjbName(), "ejb-name")) {
            this.errors.add(" Incorect tag method: ejb-name not set");
            return false;
        }
        this.load(method, entry.getMethodInterface(), "method-intf");
        if (!this.load(method, entry.getMethodName(), "method-name")) {
            this.errors.add(" Incorect tag method: method-name not set");
            return false;
        }
        String[] params = entry.getParameters();
        if (params != null) {
            Element methodParams = this.mainDocument.createElement("method-params");
            int j = 0;
            while (j < params.length) {
                if (!this.load(methodParams, params[j], "method-param")) {
                    this.errors.add(" Incorect tag method: method-param not set");
                    return false;
                }
                ++j;
            }
            method.appendChild(methodParams);
        }
        el.appendChild(method);
        return true;
    }

    private boolean createSecurityPermitions(SecurityRoles[] roles) {
        boolean add = false;
        Element secPerm = this.mainDocument.createElement("security-permission");
        int size = roles.length;
        String[] users = null;
        String[] groups = null;
        SecurityRoles temp = null;
        String name = null;
        int i = 0;
        while (i < size) {
            temp = roles[i];
            users = temp.getUserNames();
            groups = temp.getUserGroup();
            name = temp.getName();
            if (temp.getServerRoleName() != null) {
                if (this.createSecurityRoleMap(secPerm, name, temp.getServerRoleName())) {
                    add = true;
                }
            } else if (this.createSecurityRoleMap(secPerm, name, users, groups)) {
                add = true;
            }
            ++i;
        }
        if (add) {
            this.inqmyEjb.appendChild(secPerm);
        }
        return add;
    }

    private boolean createSecurityRoleMap(Element secPerm, String name, String servSecRoleName) {
        int size = -1;
        Element map = this.mainDocument.createElement("security-role-map");
        if (!this.load(map, name, "role-name")) {
            this.errors.add(" Incorect tag security-role-map: security-role not set");
            return false;
        }
        boolean add = false;
        if (!this.load(map, servSecRoleName, "server-role-name")) {
            this.errors.add(" Incorect tag security-role-map: server-role-name not set");
            return false;
        }
        secPerm.appendChild(map);
        return true;
    }

    private boolean createSecurityRoleMap(Element secPerm, String name, String[] users, String[] groups) {
        int i;
        boolean res = false;
        int size = -1;
        Element map = this.mainDocument.createElement("security-role-map");
        if (!this.load(map, name, "role-name")) {
            this.errors.add(" Incorect tag security-role-map: role-name not set");
            return false;
        }
        boolean add = false;
        if (users != null && (size = users.length) != 0) {
            i = 0;
            while (i < size) {
                if (this.load(map, users[i], "user-name")) {
                    add = true;
                }
                ++i;
            }
            if (add) {
                res = true;
            }
        }
        if (groups != null && (size = groups.length) != 0) {
            add = false;
            i = 0;
            while (i < size) {
                if (this.load(map, groups[i], "group-name")) {
                    add = true;
                }
                ++i;
            }
            if (add) {
                res = true;
            }
        }
        if (res) {
            secPerm.appendChild(map);
        }
        return res;
    }

    public Vector getErrors() {
        return this.errors;
    }
}

