/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.descriptors.xml;

import com.sap.engine.deploy.exceptions.BaseClassNotFoundException;
import com.sap.engine.deploy.exceptions.ToolDeploymentException;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.dom.TextImpl;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.ejb.deploy.descriptors.AccessControls;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DependentValueDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationField;
import com.sap.engine.services.ejb.deploy.descriptors.SecurityIdentity;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class EJBJarParser {
    public static final String BEAN_PERSISTENT = "Bean";
    public static final String CONTAINER_PERSISTENT = "Container";
    public static final String STATEFUL_SESSION = "Stateful";
    public static final String STATELESS_SESSION = "Stateless";
    public static final String BEAN_TRANSACTION = "Bean";
    public static final String CONTAINER_TRANSACTION = "Container";
    public static final String RESOURCE_SHAREABLE = "Shareable";
    public static final String RESOURCE_UNSHAREABLE = "Unshareable";
    public static final String DEFAULT_PK_TYPE = "java.lang.Long";
    public static final String DEFAULT_PK_NAME = "ejb_pk";
    private static final String STR_CMP_2_VERSION = "2.x";
    private static final String STR_CMP_1_VERSION = "1.x";
    private static final String[] EJBOBJECT_METHODS = new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical"};
    private static final String[] EJBLOCALOBJECT_METHODS = new String[]{"getEJBLocalHome", "getPrimaryKey", "isIdentical"};
    private static final String[] EJBHOME_METHODS = new String[]{"getEJBMetaData", "getHomeHandle"};
    private int xmlType = 2;
    private boolean compliance = true;
    private Vector errors = null;
    private Vector warnings = null;

    public EJBJarDescriptor parseXml(BufferedInputStream xmlStream, Vector warnings, ClassLoader loader, String appName, String xmlName) throws DeploymentException {
        Document document = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            StandardDOMParser domParser = new StandardDOMParser();
            Thread.currentThread().setContextClassLoader(cl);
            domParser.setSystemId(xmlName);
            document = domParser.parse((InputStream)xmlStream);
            xmlStream.close();
        }
        catch (IOException ioe) {
            Object[] args = new String[]{"ejb-jar", ioe.toString()};
            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4004", args, ioe);
            toThrow.log();
            throw toThrow;
        }
        catch (SAXException sax) {
            Object[] args = new String[]{"ejb-jar", sax.toString()};
            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4004", args, sax);
            toThrow.log();
            throw toThrow;
        }
        return this.parseXml(document, warnings, loader, appName);
    }

    public EJBJarDescriptor parseXml(Document document, Vector warnings, ClassLoader loader, String appName) throws DeploymentException {
        EJBJarDescriptor result = new EJBJarDescriptor();
        DocumentType dt = document.getDoctype();
        this.errors = new Vector();
        this.warnings = new Vector();
        if (dt == null) {
            throw new ToolDeploymentException("xml_ejb_4036");
        }
        String dtd = dt.getSystemId();
        if (dtd == null) {
            warnings.add("System identifier must be specified in the DOCTYPE declaration of an ejb-jar deployment descriptor. See: EJB 1.1 spec, page 244; EJB 2.0 spec, page 461. The bean will be deployed as 2.x bean.");
            System.out.println("System identifier must be specified in the DOCTYPE declaration of an ejb-jar deployment descriptor. See: EJB 1.1 spec, page 244; EJB 2.0 spec, page 461. The bean will be deployed as 2.x bean.");
            this.xmlType = 2;
        } else if (dtd.indexOf("ejb-jar_1_1.dtd") != -1) {
            this.xmlType = 1;
        } else if (dtd.indexOf("ejb-jar_2_0.dtd") != -1) {
            this.xmlType = 2;
        } else {
            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4016");
            toThrow.log();
            throw toThrow;
        }
        Node ejbjar = document.getElementsByTagName("ejb-jar").item(0);
        NodeList ejbjarList = ejbjar.getChildNodes();
        int i = 0;
        while (i < ejbjarList.getLength()) {
            if (ejbjarList.item(i).getNodeType() == 1) {
                Element el = (Element)ejbjarList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    result.setDescription(this.getTextValue(el));
                } else if (tag.equals("display-name")) {
                    result.setDisplayName(this.getTextValue(el));
                } else if (tag.equals("small-icon")) {
                    result.setSmallIcon(this.processString(this.getTextValue(el), false));
                } else if (tag.equals("large-icon")) {
                    result.setLargeIcon(this.processString(this.getTextValue(el), false));
                } else if (tag.equals("enterprise-beans")) {
                    result.setDescriptors(this.processBeans(el, appName, warnings));
                } else if (tag.equals("relationships")) {
                    this.processRelationships(el, result);
                } else if (tag.equals("assembly-descriptor")) {
                    this.processAssemblyDescriptor(el, result, loader, warnings);
                } else if (tag.equals("ejb-client-jar")) {
                    result.setClientJarName(this.processString(this.getTextValue(el), false));
                }
            }
            ++i;
        }
        if (result.getAbstractSchema().getRelDescriptors() == null) {
            result.getAbstractSchema().setRelDescriptors(new RelationDescriptor[0]);
        }
        if (!this.compliance) {
            result = this.fillIfNecessary(result);
        }
        this.parseFields(result, loader);
        this.parseFinders(result, loader);
        return result;
    }

    protected DeploymentDescriptor[] processBeans(Element beansEl, String appName, Vector warnings) throws DeploymentException {
        NodeList beansList = beansEl.getChildNodes();
        Vector<DeploymentDescriptor> result = new Vector<DeploymentDescriptor>();
        int i = 0;
        while (i < beansList.getLength()) {
            if (beansList.item(i).getNodeType() == 1) {
                Element el = (Element)beansList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("session")) {
                    result.add(this.processSession(el, appName));
                } else if (tag.equals("entity")) {
                    result.add(this.processEntity(el, appName));
                } else if (tag.equals("message-driven")) {
                    result.add(this.processMessageDriven(el, appName, warnings));
                }
            }
            ++i;
        }
        return result.toArray(new DeploymentDescriptor[result.size()]);
    }

    protected DeploymentDescriptor processEntity(Element entityEl, String appName) throws DeploymentException {
        EntityDescriptor result = null;
        NodeList persistence = entityEl.getElementsByTagName("persistence-type");
        String value = this.getTextValue((Element)persistence.item(0));
        if (value.equals("Bean")) {
            result = new EntityDescriptor();
        } else if (value.equals("Container")) {
            result = new CMPEntityDescriptor();
            if (this.xmlType == 1) {
                ((CMPEntityDescriptor)result).setCmpVersion(this.xmlType);
            }
        } else {
            Object[] args = new String[]{"persistence-type", "bean", result.getEjbName(), "Bean or Container"};
            if (this.compliance) {
                ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4017", args);
                toThrow.log();
                throw toThrow;
            }
            this.errors.add("Incerrect value of element \"" + (String)args[0] + "\" for " + (String)args[1] + "\"" + (String)args[2] + "\". Must be one of the following: " + (String)args[3] + ".");
        }
        NodeList entityList = entityEl.getChildNodes();
        Vector<PersistentField> cmpFields = new Vector<PersistentField>();
        Vector<EnvironmentEntry> envEntries = new Vector<EnvironmentEntry>();
        Vector<EJBeanReference> ejbRefs = new Vector<EJBeanReference>();
        Vector<EJBeanLocalReference> ejbLocalRefs = new Vector<EJBeanLocalReference>();
        Hashtable<String, SecurityRoleReference> securityRoleRefs = new Hashtable<String, SecurityRoleReference>();
        Vector<ResourceReference> resourceRefs = new Vector<ResourceReference>();
        Vector<ResourceEnvReference> resourceEnvRefs = new Vector<ResourceEnvReference>();
        Vector<FinderDescriptor> queries = new Vector<FinderDescriptor>();
        String ejbName = null;
        int i = 0;
        while (i < entityList.getLength()) {
            if (entityList.item(i).getNodeType() == 1) {
                Object[] args;
                Element el = (Element)entityList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    result.setDescription(this.getTextValue(el));
                } else if (tag.equals("display-name")) {
                    result.setDisplayName(this.getTextValue(el));
                } else if (tag.equals("small-icon")) {
                    result.setSmallIcon(this.processString(this.getTextValue(el), false));
                } else if (tag.equals("large-icon")) {
                    result.setLargeIcon(this.processString(this.getTextValue(el), false));
                } else if (tag.equals("ejb-name")) {
                    ejbName = this.getTextValue(el);
                    result.setBeanName(ejbName, appName);
                } else if (tag.equals("home")) {
                    result.setRemoteHomeInterface(this.getTextValue(el));
                } else if (tag.equals("remote")) {
                    result.setRemoteInterface(this.getTextValue(el));
                } else if (tag.equals("local-home")) {
                    result.setLocalHomeInterface(this.getTextValue(el));
                } else if (tag.equals("local")) {
                    result.setLocalInterface(this.getTextValue(el));
                } else if (tag.equals("ejb-class")) {
                    result.setClassName(this.getTextValue(el));
                } else if (tag.equals("persistence-type")) {
                    String persistanceType = this.getTextValue(el);
                    if (persistanceType.equals("Bean")) {
                        result.setPersistenceType(0);
                    } else if (persistanceType.equals("Container")) {
                        result.setPersistenceType(1);
                    } else {
                        args = new String[]{"persistence-type", "bean", ejbName, "Bean or Container"};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4017", args);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Incerrect value of element \"" + (String)args[0] + "\" for bean \"" + (String)args[1] + "\". Must be one of the following: " + (String)args[2] + ".");
                    }
                } else if (tag.equals("prim-key-class")) {
                    result.setPrimaryKeyClass(this.getTextValue(el));
                } else if (tag.equals("reentrant")) {
                    result.setReentrant(this.getTextValue(el).equals("True"));
                } else if (tag.equals("cmp-version")) {
                    String strCmpVersion = this.getTextValue(el);
                    if (strCmpVersion.equals(STR_CMP_2_VERSION) && result instanceof CMPEntityDescriptor) {
                        ((CMPEntityDescriptor)result).setCmpVersion(2);
                    } else if (strCmpVersion.equals(STR_CMP_1_VERSION) && result instanceof CMPEntityDescriptor) {
                        ((CMPEntityDescriptor)result).setCmpVersion(1);
                    } else {
                        args = new String[]{"cmp-version", "bean", ejbName, "1.x or 2.x"};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4017", args);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Incerrect value of element \"" + (String)args[0] + "\" for " + (String)args[1] + " \"" + (String)args[2] + "\". Must be one of the following: " + (String)args[3] + ".");
                    }
                } else if (tag.equals("abstract-schema-name") && result instanceof CMPEntityDescriptor) {
                    ((CMPEntityDescriptor)result).setAbstractSchemaName(this.getTextValue(el));
                } else if (tag.equals("cmp-field")) {
                    cmpFields.add(this.processCMPField(el));
                } else if (tag.equals("primkey-field") && result instanceof CMPEntityDescriptor) {
                    if (!((CMPEntityDescriptor)result).getPrimaryKeyClass().equals("java.lang.Object")) {
                        ((CMPEntityDescriptor)result).setPKFieldName(this.getTextValue(el));
                    } else {
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4059", new String[]{this.getTextValue(el)});
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("\nPrimary Key Field " + this.getTextValue(el) + " with wrong field type.\n Only Unknown PK can have type java.lang.Object.\n" + "Primary Key Field will be set to empty string.\n");
                    }
                } else if (tag.equals("env-entry")) {
                    envEntries.add(this.processEnvEntry(el, ejbName));
                } else if (tag.equals("ejb-ref")) {
                    ejbRefs.add(this.processEjbRef(el, ejbName));
                } else if (tag.equals("ejb-local-ref")) {
                    ejbLocalRefs.add(this.processEjbLocalRef(el, ejbName));
                } else if (tag.equals("security-role-ref")) {
                    SecurityRoleReference ref = this.processSecurityRoleRef(el, ejbName);
                    if (ref != null) {
                        securityRoleRefs.put(ref.getRoleName(), ref);
                    }
                } else if (tag.equals("security-identity")) {
                    SecurityIdentity securityIdentity = new SecurityIdentity();
                    NodeList secIdentityList = el.getChildNodes();
                    int j = 0;
                    while (j < secIdentityList.getLength()) {
                        if (secIdentityList.item(j).getNodeType() == 1) {
                            Element nextEl = (Element)secIdentityList.item(j);
                            String nextTag = nextEl.getNodeName();
                            if (nextTag.equals("description")) {
                                securityIdentity.setDescription(this.getTextValue(nextEl));
                            } else if (nextTag.equals("use-caller-identity")) {
                                securityIdentity.setCallerIdentity(true);
                            } else if (nextTag.equals("run-as")) {
                                NodeList runAsList = nextEl.getChildNodes();
                                RunAsIdentity runAsIdentity = new RunAsIdentity();
                                securityIdentity.setCallerIdentity(false);
                                Element runEl = null;
                                int r = 0;
                                while (r < runAsList.getLength()) {
                                    if (runAsList.item(r).getNodeType() == 1) {
                                        runEl = (Element)runAsList.item(r);
                                        if (runEl.getNodeName().equals("role-name")) {
                                            runAsIdentity.setSecurityRoleName(this.getTextValue(runEl));
                                        } else if (runEl.getNodeName().equals("description")) {
                                            runAsIdentity.setDescription(this.getTextValue(runEl));
                                        }
                                    }
                                    ++r;
                                }
                                securityIdentity.setRunAsIdentity(runAsIdentity);
                            }
                        }
                        ++j;
                    }
                    if (!securityIdentity.isCallerIdentity()) {
                        RunAsIdentity run = securityIdentity.getRunAsIdentity();
                        run.setComponentName(result.getName());
                        securityIdentity.setRunAsIdentity(run);
                    }
                    result.setSecurityIdentity(securityIdentity);
                } else if (tag.equals("resource-ref")) {
                    resourceRefs.add(this.processResourceRef(el, ejbName));
                } else if (tag.equals("resource-env-ref")) {
                    resourceEnvRefs.add(this.processResourceEnvRef(el));
                } else if (tag.equals("query")) {
                    queries.add(this.processQuery(el, ejbName));
                } else if (tag.equals("bean-count")) {
                    try {
                        result.setContainerSize(new Integer(this.getTextValue(el)));
                    }
                    catch (NumberFormatException nfe) {
                        args = new String[]{ejbName};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4018", args, nfe);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Illegal value type of element \"container-size\" for bean \"" + ejbName + "\". Required int.");
                    }
                }
            }
            ++i;
        }
        result.setEnvironmentEntries(envEntries.toArray(new EnvironmentEntry[envEntries.size()]));
        result.setEJBeanReferences(ejbRefs.toArray(new EJBeanReference[ejbRefs.size()]));
        result.setEJBeanLocalReferences(ejbLocalRefs.toArray(new EJBeanLocalReference[ejbLocalRefs.size()]));
        result.setRoleReferences(securityRoleRefs);
        result.setResourceReferences(resourceRefs.toArray(new ResourceReference[resourceRefs.size()]));
        result.setResourceEnvReferences(resourceEnvRefs.toArray(new ResourceEnvReference[resourceEnvRefs.size()]));
        if (result instanceof CMPEntityDescriptor) {
            ((CMPEntityDescriptor)result).setCmpFields(cmpFields.toArray(new PersistentField[cmpFields.size()]));
            ((CMPEntityDescriptor)result).setFinderDescriptors(queries.toArray(new FinderDescriptor[queries.size()]));
        }
        return result;
    }

    protected EnvironmentEntry processEnvEntry(Element envEl, String ejbName) throws DeploymentException {
        EnvironmentEntry result = new EnvironmentEntry();
        NodeList list = envEl.getChildNodes();
        String entryType = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                String entryValueStr;
                Element el = (Element)list.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    result.setEntryDescription(this.getTextValue(el));
                } else if (tag.equals("env-entry-name")) {
                    result.setEntryName(this.getTextValue(el));
                } else if (tag.equals("env-entry-type")) {
                    entryType = this.getTextValue(el);
                    result.setEntryType(entryType);
                } else if (tag.equals("env-entry-value") && !(entryValueStr = this.getTextValue(el)).equals("")) {
                    Object entryValue;
                    if (entryValueStr.startsWith("${")) {
                        result.setEntryValue(entryValueStr);
                    } else if (entryType.equals("java.lang.Double")) {
                        entryValue = new Double(entryValueStr);
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.Byte")) {
                        entryValue = new Byte(entryValueStr);
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.Short")) {
                        entryValue = new Short(entryValueStr);
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.Integer")) {
                        entryValue = new Integer(entryValueStr);
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals(DEFAULT_PK_TYPE)) {
                        entryValue = new Long(entryValueStr);
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.Boolean")) {
                        entryValue = new Boolean(entryValueStr);
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.Float")) {
                        entryValue = new Float(entryValueStr);
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.Character")) {
                        entryValue = new Character(entryValueStr.charAt(0));
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.String")) {
                        entryValue = entryValueStr;
                        result.setEntryValue(entryValue);
                    } else {
                        Object[] args = new String[]{entryType, "env-entry-type", "bean", ejbName};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4019", args);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Incorrect value \"" + (String)args[0] + "\" of element \"" + (String)args[1] + "\" for " + (String)args[2] + (String)args[3] + ".");
                    }
                }
            }
            ++i;
        }
        return result;
    }

    protected EJBeanReference processEjbRef(Element elmnt, String ejbName) throws DeploymentException {
        NodeList refsList = elmnt.getChildNodes();
        EJBeanReference ejbRef = new EJBeanReference();
        int k = 0;
        while (k < refsList.getLength()) {
            if (refsList.item(k).getNodeType() == 1) {
                Element nextEl = (Element)refsList.item(k);
                String nextElTag = nextEl.getNodeName();
                String value = null;
                if (nextElTag.equals("description")) {
                    value = this.getTextValue(nextEl);
                    if (!value.equals("")) {
                        ejbRef.setReferenceDescription(value);
                    }
                } else if (nextElTag.equals("ejb-ref-name")) {
                    value = this.getTextValue(nextEl);
                    if (!value.equals("")) {
                        ejbRef.setReferenceName(value);
                    }
                } else if (nextElTag.equals("ejb-ref-type")) {
                    value = this.getTextValue(nextEl);
                    if (value.equals("Entity")) {
                        ejbRef.setType(1);
                    } else if (value.equals("Session")) {
                        ejbRef.setType(0);
                    } else {
                        Object[] args = new String[]{"ejb-ref-type", "bean", ejbName, "Entity or Session"};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4017", args);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Incerrect value of element \"" + (String)args[0] + "\" for " + (String)args[1] + " \"" + (String)args[2] + "\". Must be one of the following: " + (String)args[3] + ".");
                    }
                } else if (nextElTag.equals("home")) {
                    value = this.getTextValue(nextEl);
                    if (!value.equals("")) {
                        ejbRef.setHomeInterfaceName(value);
                    }
                } else if (nextElTag.equals("remote")) {
                    value = this.getTextValue(nextEl);
                    if (!value.equals("")) {
                        ejbRef.setRemoteInterfaceName(value);
                    }
                } else if (nextElTag.equals("ejb-link") && !(value = this.getTextValue(nextEl)).equals("")) {
                    ejbRef.setReferenceEjbLink(value);
                }
            }
            ++k;
        }
        return ejbRef;
    }

    protected EJBeanLocalReference processEjbLocalRef(Element elmnt, String ejbName) throws DeploymentException {
        NodeList refsList = elmnt.getChildNodes();
        EJBeanLocalReference ejbLocalRef = new EJBeanLocalReference();
        int k = 0;
        while (k < refsList.getLength()) {
            if (refsList.item(k).getNodeType() == 1) {
                Element nextEl = (Element)refsList.item(k);
                String nextElTag = nextEl.getNodeName();
                String value = null;
                if (nextElTag.equals("description")) {
                    value = this.getTextValue(nextEl);
                    if (!value.equals("")) {
                        ejbLocalRef.setReferenceDescription(value);
                    }
                } else if (nextElTag.equals("ejb-ref-name")) {
                    value = this.getTextValue(nextEl);
                    if (!value.equals("")) {
                        ejbLocalRef.setReferenceName(value);
                    }
                } else if (nextElTag.equals("ejb-ref-type")) {
                    value = this.getTextValue(nextEl);
                    if (value.equals("Entity")) {
                        ejbLocalRef.setType(1);
                    } else if (value.equals("Session")) {
                        ejbLocalRef.setType(0);
                    } else {
                        Object[] args = new String[]{"ejb-ref-type", "bean", ejbName, "Entity or Session"};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4017", args);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Incerrect value of element \"" + (String)args[0] + "\" for " + (String)args[1] + " \"" + (String)args[2] + "\". Must be one of the following: " + (String)args[3] + ".");
                    }
                } else if (nextElTag.equals("local-home")) {
                    value = this.getTextValue(nextEl);
                    if (!value.equals("")) {
                        ejbLocalRef.setLocalHomeInterfaceName(value);
                    }
                } else if (nextElTag.equals("local")) {
                    value = this.getTextValue(nextEl);
                    if (!value.equals("")) {
                        ejbLocalRef.setLocalInterfaceName(value);
                    }
                } else if (nextElTag.equals("ejb-link") && !(value = this.getTextValue(nextEl)).equals("")) {
                    ejbLocalRef.setReferenceEjbLink(value);
                }
            }
            ++k;
        }
        return ejbLocalRef;
    }

    protected SecurityRoleReference processSecurityRoleRef(Element elmnt, String ejbName) {
        NodeList secList = elmnt.getChildNodes();
        SecurityRoleReference reference = new SecurityRoleReference();
        int k = 0;
        while (k < secList.getLength()) {
            if (secList.item(k).getNodeType() == 1) {
                String roleLink;
                Element nextEl = (Element)secList.item(k);
                String nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("description")) {
                    String description = this.getTextValue(nextEl);
                    if (!description.equals("")) {
                        reference.setDescription(description);
                    }
                } else if (nextElTag.equals("role-name")) {
                    String roleName = this.getTextValue(nextEl);
                    if (!roleName.equals("")) {
                        reference.setRoleName(roleName);
                    }
                } else if (nextElTag.equals("role-link") && !(roleLink = this.getTextValue(nextEl)).equals("")) {
                    reference.setRoleLink(new SecurityRoles(roleLink));
                }
            }
            ++k;
        }
        return reference;
    }

    protected ResourceReference processResourceRef(Element elmnt, String ejbName) throws DeploymentException {
        NodeList resList = elmnt.getChildNodes();
        ResourceReference resRef = new ResourceReference();
        int k = 0;
        while (k < resList.getLength()) {
            if (resList.item(k).getNodeType() == 1) {
                Element nextEl = (Element)resList.item(k);
                String nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("description")) {
                    String description = this.getTextValue(nextEl);
                    if (!description.equals("")) {
                        resRef.setResourceDescription(description);
                    }
                } else if (nextElTag.equals("res-ref-name")) {
                    String name = this.getTextValue(nextEl);
                    if (!name.equals("")) {
                        resRef.setResourceName(name);
                    }
                } else if (nextElTag.equals("res-type")) {
                    String type = this.getTextValue(nextEl);
                    if (!type.equals("")) {
                        resRef.setResourceType(type);
                    }
                } else if (nextElTag.equals("res-auth")) {
                    String authStr = this.getTextValue(nextEl);
                    if (authStr.equals("Application")) {
                        resRef.setResourceAuthorization(3);
                    } else if (authStr.equals("Container")) {
                        resRef.setResourceAuthorization(2);
                    } else {
                        Object[] args = new String[]{authStr, "res-auth", "bean", ejbName};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4019", args);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Incorrect value \"" + (String)args[0] + "\" of element \"" + (String)args[1] + "\" for bean " + (String)args[3] + ".");
                    }
                } else if (nextElTag.equals("res-sharing-scope")) {
                    String resShType = this.getTextValue(nextEl);
                    if (resShType.equals(RESOURCE_SHAREABLE)) {
                        resRef.setResourceSharingScope(0);
                    } else if (resShType.equals(RESOURCE_UNSHAREABLE)) {
                        resRef.setResourceSharingScope(1);
                    }
                }
            }
            ++k;
        }
        return resRef;
    }

    protected ResourceEnvReference processResourceEnvRef(Element elmnt) {
        NodeList resList = elmnt.getChildNodes();
        ResourceEnvReference resRef = new ResourceEnvReference();
        int k = 0;
        while (k < resList.getLength()) {
            if (resList.item(k).getNodeType() == 1) {
                String type;
                Element nextEl = (Element)resList.item(k);
                String nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("description")) {
                    String description = this.getTextValue(nextEl);
                    if (!description.equals("")) {
                        resRef.setDescription(description);
                    }
                } else if (nextElTag.equals("resource-env-ref-name")) {
                    String name = this.getTextValue(nextEl);
                    if (!name.equals("")) {
                        resRef.setName(name);
                    }
                } else if (nextElTag.equals("resource-env-ref-type") && !(type = this.getTextValue(nextEl)).equals("")) {
                    resRef.setType(type);
                }
            }
            ++k;
        }
        return resRef;
    }

    protected PersistentField processCMPField(Element cmpEl) {
        PersistentField result = new PersistentField();
        NodeList list = cmpEl.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    result.setDescription(this.getTextValue(el));
                } else if (tag.equals("field-name")) {
                    result.setFieldName(this.getTextValue(el));
                }
            }
            ++i;
        }
        return result;
    }

    protected void processRelationships(Element relEl, EJBJarDescriptor ejbjarDes) throws DeploymentException {
        Element tempEl = this.getFirstElementByName(relEl, "description");
        if (tempEl != null) {
            ejbjarDes.setRelationshipsDescription(this.getElementText(tempEl));
        }
        NodeList nl = relEl.getElementsByTagName("ejb-relation");
        RelationDescriptor[] relDescr = new RelationDescriptor[nl.getLength()];
        int i = 0;
        while (i < nl.getLength()) {
            Element el = (Element)nl.item(i);
            relDescr[i] = this.processEjbRelation(el, ejbjarDes, i);
            ++i;
        }
        ejbjarDes.getAbstractSchema().setRelDescriptors(relDescr);
    }

    protected RelationDescriptor processEjbRelation(Element ejbRel, EJBJarDescriptor ejbjarDes, int relId) throws DeploymentException {
        Object[] args;
        RelationDescriptor relDescr = new RelationDescriptor();
        OneSideRelationDescriptor side1 = null;
        OneSideRelationDescriptor side2 = null;
        RelationField field = null;
        Element tempEl = null;
        String ejbName1 = null;
        String ejbName2 = null;
        tempEl = this.getFirstElementByName(ejbRel, "description");
        if (tempEl != null) {
            relDescr.setRelationDescription(this.getElementText(tempEl));
        }
        if ((tempEl = this.getFirstElementByName(ejbRel, "ejb-relation-name")) != null) {
            relDescr.setRelationName(this.getElementText(tempEl));
        }
        NodeList roles = ejbRel.getElementsByTagName("ejb-relationship-role");
        Element role1 = (Element)roles.item(0);
        Element role2 = (Element)roles.item(1);
        side1 = this.processEjbRelationRole(role1);
        side2 = this.processEjbRelationRole(role2);
        relDescr.setSide1(side1);
        relDescr.setSide2(side2);
        tempEl = this.getFirstElementByName(role1, "multiplicity");
        if (tempEl == null && this.compliance) {
            throw new ToolDeploymentException("xml_ejb_4035", new String[]{ejbjarDes.getJarName(), "<ejb-relationship-role>", "<multiplicity>"});
        }
        this.errors.add(ejbjarDes.getJarName() + " : Check <ejb-relationship-role> elements in your ejb-jar.xml, <multiplicity> subtag is missing in one of them.");
        String mult1 = this.getElementText(tempEl);
        tempEl = this.getFirstElementByName(role2, "multiplicity");
        if (tempEl == null && this.compliance) {
            throw new ToolDeploymentException("xml_ejb_4035", new String[]{ejbjarDes.getJarName(), "<ejb-relationship-role>", "<multiplicity>"});
        }
        this.errors.add(ejbjarDes.getJarName() + " : Check <ejb-relationship-role> elements in your ejb-jar.xml, <multiplicity> subtag is missing in one of them.");
        String mult2 = this.getElementText(tempEl);
        if (mult1.equals("One")) {
            if (mult2.equals("One")) {
                side1.setMultiplicityType(1);
                side2.setMultiplicityType(1);
            } else if (mult2.equals("Many")) {
                side1.setMultiplicityType(2);
                side2.setMultiplicityType(3);
            } else {
                args = new String[]{mult2, "multiplicity", "jar", ejbjarDes.getJarName()};
                if (this.compliance) {
                    ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4019", args);
                    toThrow.log();
                    throw toThrow;
                }
                this.errors.add("Incorrect value \"" + (String)args[0] + "\" of element \"" + (String)args[1] + "\" for jar " + (String)args[2] + ".");
            }
        } else if (mult1.equals("Many")) {
            if (mult2.equals("One")) {
                side1.setMultiplicityType(3);
                side2.setMultiplicityType(2);
            } else if (mult2.equals("Many")) {
                side1.setMultiplicityType(4);
                side2.setMultiplicityType(4);
            } else {
                args = new String[]{mult2, "multiplicity", "jar", ejbjarDes.getJarName()};
                if (this.compliance) {
                    ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4019", args);
                    toThrow.log();
                    throw toThrow;
                }
                this.errors.add("Incorrect value \"" + (String)args[0] + "\" of element \"" + (String)args[1] + "\" for jar " + (String)args[2] + ".");
            }
        } else {
            args = new String[]{mult1, "multiplicity", "jar", ejbjarDes.getJarName()};
            if (this.compliance) {
                ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4019", args);
                toThrow.log();
                throw toThrow;
            }
            this.errors.add("Incorrect value \"" + (String)args[0] + "\" of element \"" + (String)args[1] + "\" for jar " + (String)args[2] + ".");
        }
        Element roleSourceEl = this.getFirstElementByName(role1, "relationship-role-source");
        tempEl = this.getFirstElementByName(roleSourceEl, "ejb-name");
        if (tempEl == null && this.compliance) {
            throw new ToolDeploymentException("xml_ejb_4035", new String[]{ejbjarDes.getJarName(), "<relationship-role-source>", "<ejb-name>"});
        }
        this.errors.add(ejbjarDes.getJarName() + " : Check <relationship-role-source> elements in your ejb-jar.xml, <ejb-name> subtag is missing in one of them.");
        ejbName1 = this.getElementText(tempEl);
        CMPEntityDescriptor descr1 = ejbjarDes.getAbstractSchema().getDescriptor(ejbName1);
        if (descr1 == null) {
            if (this.compliance) {
                Object[] args2 = new String[]{ejbName1};
                ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4005", args2);
                toThrow.log();
                throw toThrow;
            }
            this.errors.add("Cannot find bean with name " + ejbName1 + ", defined in ejb-jar.xml");
        } else {
            side1.setEjbId(descr1.getId());
        }
        roleSourceEl = this.getFirstElementByName(role2, "relationship-role-source");
        tempEl = this.getFirstElementByName(roleSourceEl, "ejb-name");
        if (tempEl == null) {
            if (this.compliance) {
                throw new ToolDeploymentException("xml_ejb_4035", new String[]{ejbjarDes.getJarName(), "<relationship-role-source>", "<ejb-name>"});
            }
            this.errors.add(ejbjarDes.getJarName() + " : Check <relationship-role-source> elements in your ejb-jar.xml, <ejb-name> subtag is missing in one of them.");
        }
        ejbName2 = this.getElementText(tempEl);
        CMPEntityDescriptor descr2 = ejbjarDes.getAbstractSchema().getDescriptor(ejbName2);
        if (descr2 == null) {
            if (this.compliance) {
                Object[] args3 = new String[]{ejbName2};
                ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4005", args3);
                toThrow.log();
                throw toThrow;
            }
            this.errors.add("Cannot find bean with name " + ejbName2 + ", defined in ejb-jar.xml");
        } else {
            side2.setEjbId(descr2.getId());
        }
        NodeList cmr1 = role1.getElementsByTagName("cmr-field");
        NodeList cmr2 = role2.getElementsByTagName("cmr-field");
        int cmrCount = cmr1.getLength() + cmr2.getLength();
        if (cmrCount < 1 || cmrCount > 2) {
            if (this.compliance) {
                ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4020");
                toThrow.log();
                throw toThrow;
            }
            this.errors.add("ID017341: At least one role in ejb-relation must specify a cmr-field element.");
        }
        if (cmr1.getLength() == 1) {
            field = this.processCmrField((Element)cmr1.item(0));
            field.setRelationId(relId);
            side1.setCmrId(descr1.addCmrField(field));
        }
        if (cmr2.getLength() == 1) {
            field = this.processCmrField((Element)cmr2.item(0));
            field.setRelationId(relId);
            side2.setCmrId(descr2.addCmrField(field));
        }
        return relDescr;
    }

    protected FinderDescriptor processQuery(Element queryEl, String ejbName) throws DeploymentException {
        FinderDescriptor result = new FinderDescriptor();
        Vector<String> params = new Vector<String>();
        String query = null;
        NodeList queryList = queryEl.getChildNodes();
        int i = 0;
        while (i < queryList.getLength()) {
            if (queryList.item(i).getNodeType() == 1) {
                Element el = (Element)queryList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    result.setDescription(this.getTextValue(el));
                } else if (tag.equals("query-method")) {
                    NodeList methodList = el.getChildNodes();
                    int j = 0;
                    while (j < methodList.getLength()) {
                        if (methodList.item(j).getNodeType() == 1) {
                            Element methodEl = (Element)methodList.item(j);
                            if (methodEl.getNodeName().equals("method-name")) {
                                result.setMethodName(this.getTextValue(methodEl));
                            } else if (methodEl.getNodeName().equals("method-params")) {
                                NodeList paramsList = methodEl.getChildNodes();
                                int k = 0;
                                while (k < paramsList.getLength()) {
                                    if (paramsList.item(k).getNodeType() == 1 && ((Element)paramsList.item(k)).getNodeName().equals("method-param")) {
                                        params.add(this.getTextValue((Element)paramsList.item(k)));
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                } else if (tag.equals("result-type-mapping")) {
                    String resultTypeMap = this.getTextValue(el);
                    if (resultTypeMap.equals("Local")) {
                        result.setLocal();
                    } else if (resultTypeMap.equals("Remote")) {
                        result.setRemote();
                    } else {
                        Object[] args = new String[]{"result-type-mapping", "bean", ejbName, "Local and Remote"};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4017", args);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Incerrect value of element \"" + (String)args[0] + "\" for " + (String)args[1] + " \"" + (String)args[2] + "\". Must be one of the following: " + (String)args[3] + ".");
                    }
                } else if (tag.equals("ejb-ql")) {
                    query = this.getTextValue(el);
                    result.setQuery(query);
                }
            }
            ++i;
        }
        result.setParamsTypes(params.toArray(new String[params.size()]));
        return result;
    }

    protected String processString(String str, boolean saving) {
        char separator = File.separatorChar;
        String str2 = new String();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (saving) {
                if (ch == separator) {
                    ch = '\\';
                }
            } else if (ch == '\\') {
                ch = separator;
            }
            str2 = new String(str2 + ch);
            ++i;
        }
        return str2;
    }

    protected String getTextValue(Element element) {
        if (element == null) {
            return new String();
        }
        Node node = element.getFirstChild();
        if (node != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            String value = node.getNodeValue();
            return value.trim();
        }
        return new String("");
    }

    protected DeploymentDescriptor processMessageDriven(Element messageEl, String appName, Vector warnings) throws DeploymentException {
        MessageDrivenDescriptor result = new MessageDrivenDescriptor();
        NodeList messageList = messageEl.getChildNodes();
        Vector<EnvironmentEntry> envEntries = new Vector<EnvironmentEntry>();
        Vector<EJBeanReference> ejbRefs = new Vector<EJBeanReference>();
        Vector<EJBeanLocalReference> ejbLocalRefs = new Vector<EJBeanLocalReference>();
        Vector<ResourceReference> resourceRefs = new Vector<ResourceReference>();
        Vector<ResourceEnvReference> resourceEnvRefs = new Vector<ResourceEnvReference>();
        String acknowledgeType = null;
        String ejbName = null;
        int i = 0;
        while (i < messageList.getLength()) {
            if (messageList.item(i).getNodeType() == 1) {
                Element el = (Element)messageList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    result.setDescription(this.getTextValue(el));
                } else if (tag.equals("display-name")) {
                    result.setDisplayName(this.getTextValue(el));
                } else if (tag.equals("small-icon")) {
                    result.setSmallIcon(this.processString(this.getTextValue(el), false));
                } else if (tag.equals("large-icon")) {
                    result.setLargeIcon(this.processString(this.getTextValue(el), false));
                } else if (tag.equals("ejb-name")) {
                    ejbName = this.getTextValue(el);
                    result.setBeanName(ejbName, appName);
                } else if (tag.equals("ejb-class")) {
                    result.setClassName(this.getTextValue(el));
                } else if (tag.equals("transaction-type")) {
                    String transType = this.getTextValue(el);
                    if (transType.equals("Bean")) {
                        result.setTransactionType(0);
                        if (acknowledgeType != null) {
                            result.setAcknowledgeMode(acknowledgeType);
                        }
                    } else if (transType.equals("Container")) {
                        if (acknowledgeType != null) {
                            Object[] args = new String[]{"acknowledge-mode", "bean transaction type"};
                            if (this.compliance) {
                                ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4021", args);
                                toThrow.log();
                                throw toThrow;
                            }
                            this.errors.add("Element \"" + (String)args[0] + "\" has to be defined only if bean is message driven bean and has " + (String)args[2] + ".");
                        }
                        result.setTransactionType(1);
                    } else {
                        Object[] args = new String[]{transType, "transaction-type", "message driven bean", ejbName};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4019", args);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Incorrect value \"" + (String)args[0] + "\" of element \"" + (String)args[1] + "\" for " + (String)args[2] + (String)args[3] + ".");
                    }
                } else if (tag.equals("message-selector")) {
                    result.setMessageSelector(this.getTextValue(el));
                } else if (tag.equals("acknowledge-mode")) {
                    Object[] args;
                    if (result.getTransactionType() == 1) {
                        args = new String[]{"acknowledge-mode", "bean transaction type"};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4021", args);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Element \"" + (String)args[0] + "\" have to be defined only if bean is message driven bean and has " + (String)args[2] + ".");
                    }
                    if (!(acknowledgeType = this.getTextValue(el)).equals("Auto-acknowledge") && !acknowledgeType.equals("Dups-ok-acknowledge")) {
                        args = new String[]{"acknowledge-mode", "message driven bean", ejbName, "Auto-acknowledge or Dups-ok-acknowledge"};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4017", args);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Incerrect value of element \"" + (String)args[0] + "\" for " + (String)args[1] + " \"" + (String)args[2] + "\". Must be one of the following: " + (String)args[3] + ".");
                    }
                    if (result.getTransactionType() == 0) {
                        result.setAcknowledgeMode(acknowledgeType);
                    }
                } else if (tag.equals("message-driven-destination")) {
                    NodeList destType = el.getElementsByTagName("destination-type");
                    int nl = 0;
                    while (nl < destType.getLength()) {
                        if (destType.item(nl).getNodeType() == 1) {
                            String destTypeStr = this.getTextValue((Element)destType.item(nl));
                            if (!destTypeStr.equals("javax.jms.Queue") && !destTypeStr.equals("javax.jms.Topic")) {
                                Object[] args = new String[]{"destination-type", "message driven bean", result.getEjbName(), "javax.jms.Queue or javax.jms.Topic"};
                                if (this.compliance) {
                                    ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4017", args);
                                    toThrow.log();
                                    throw toThrow;
                                }
                                this.errors.add("Incerrect value of element \"" + (String)args[0] + "\" for " + (String)args[1] + "\"" + (String)args[2] + "\". Must be one of the following: " + (String)args[3] + ".");
                            }
                            result.setDestinationType(destTypeStr);
                            break;
                        }
                        ++nl;
                    }
                    destType = el.getElementsByTagName("subscription-durability");
                    if (destType.getLength() > 0 && result.getDestinationType().equals("javax.jms.Queue")) {
                        Object[] args = new String[]{"subscription-durability", "javax.jms.Queue destination type"};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4021", args);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Element \"" + (String)args[0] + "\" has to be defined only if bean is message driven bean and has " + (String)args[2] + ".");
                    }
                    int nl2 = 0;
                    while (nl2 < destType.getLength()) {
                        if (destType.item(nl2).getNodeType() == 1) {
                            String durable = this.getTextValue((Element)destType.item(nl2));
                            if (!durable.equals("Durable") && !durable.equals("NonDurable")) {
                                Object[] args = new String[]{"ubscription-durability", "message driven bean", result.getEjbName(), "Durable or NonDurable"};
                                if (this.compliance) {
                                    ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4017", args);
                                    toThrow.log();
                                    throw toThrow;
                                }
                                this.errors.add("Incerrect value of element \"" + (String)args[0] + "\" for " + (String)args[1] + "\"" + (String)args[2] + "\". Must be one of the following: " + (String)args[3] + ".");
                            }
                            result.setSubscriptionDurability(durable);
                            break;
                        }
                        ++nl2;
                    }
                } else if (tag.equals("env-entry")) {
                    envEntries.add(this.processEnvEntry(el, ejbName));
                } else if (tag.equals("ejb-ref")) {
                    ejbRefs.add(this.processEjbRef(el, ejbName));
                } else if (tag.equals("ejb-local-ref")) {
                    ejbLocalRefs.add(this.processEjbLocalRef(el, ejbName));
                } else if (tag.equals("security-identity")) {
                    SecurityIdentity securityIdentity = new SecurityIdentity();
                    NodeList secIdentityList = el.getChildNodes();
                    int j = 0;
                    while (j < secIdentityList.getLength()) {
                        if (secIdentityList.item(j).getNodeType() == 1) {
                            Element nextEl = (Element)secIdentityList.item(j);
                            String nextTag = nextEl.getNodeName();
                            if (nextTag.equals("description")) {
                                securityIdentity.setDescription(this.getTextValue(nextEl));
                            } else if (nextTag.equals("use-caller-identity")) {
                                securityIdentity.setCallerIdentity(true);
                            } else if (nextTag.equals("run-as")) {
                                securityIdentity.setCallerIdentity(false);
                                NodeList runAsList = nextEl.getChildNodes();
                                RunAsIdentity runAsIdentity = new RunAsIdentity();
                                Element runEl = null;
                                int r = 0;
                                while (r < runAsList.getLength()) {
                                    if (runAsList.item(r).getNodeType() == 1) {
                                        runEl = (Element)runAsList.item(r);
                                        if (runEl.getNodeName().equals("role-name")) {
                                            runAsIdentity.setSecurityRoleName(this.getTextValue(runEl));
                                        } else if (runEl.getNodeName().equals("description")) {
                                            runAsIdentity.setDescription(this.getTextValue(runEl));
                                        }
                                    }
                                    ++r;
                                }
                                securityIdentity.setRunAsIdentity(runAsIdentity);
                            }
                        }
                        ++j;
                    }
                    if (securityIdentity.isCallerIdentity()) {
                        warnings.add("Run-as security identity is not specified for the Message Driven Bean " + result.getDisplayName());
                    }
                    if (!securityIdentity.isCallerIdentity()) {
                        RunAsIdentity run = securityIdentity.getRunAsIdentity();
                        run.setComponentName(result.getName());
                        securityIdentity.setRunAsIdentity(run);
                    }
                    result.setSecurityIdentity(securityIdentity);
                } else if (tag.equals("resource-ref")) {
                    resourceRefs.add(this.processResourceRef(el, ejbName));
                } else if (tag.equals("resource-env-ref")) {
                    resourceEnvRefs.add(this.processResourceEnvRef(el));
                }
            }
            ++i;
        }
        result.setEnvironmentEntries(envEntries.toArray(new EnvironmentEntry[envEntries.size()]));
        result.setEJBeanReferences(ejbRefs.toArray(new EJBeanReference[ejbRefs.size()]));
        result.setEJBeanLocalReferences(ejbLocalRefs.toArray(new EJBeanLocalReference[ejbLocalRefs.size()]));
        result.setResourceReferences(resourceRefs.toArray(new ResourceReference[resourceRefs.size()]));
        result.setResourceEnvReferences(resourceEnvRefs.toArray(new ResourceEnvReference[resourceEnvRefs.size()]));
        return result;
    }

    protected DeploymentDescriptor processSession(Element sessionEl, String appName) throws DeploymentException {
        SessionDescriptor result = new SessionDescriptor();
        NodeList sessionList = sessionEl.getChildNodes();
        Vector<EnvironmentEntry> envEntries = new Vector<EnvironmentEntry>();
        Vector<EJBeanReference> ejbRefs = new Vector<EJBeanReference>();
        Vector<EJBeanLocalReference> ejbLocalRefs = new Vector<EJBeanLocalReference>();
        Hashtable<String, SecurityRoleReference> securityRoleRefs = new Hashtable<String, SecurityRoleReference>();
        Vector<ResourceReference> resourceRefs = new Vector<ResourceReference>();
        Vector<ResourceEnvReference> resourceEnvRefs = new Vector<ResourceEnvReference>();
        String ejbName = null;
        int i = 0;
        while (i < sessionList.getLength()) {
            if (sessionList.item(i).getNodeType() == 1) {
                Object[] args;
                Element el = (Element)sessionList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    result.setDescription(this.getTextValue(el));
                } else if (tag.equals("display-name")) {
                    result.setDisplayName(this.getTextValue(el));
                } else if (tag.equals("small-icon")) {
                    result.setSmallIcon(this.processString(this.getTextValue(el), false));
                } else if (tag.equals("large-icon")) {
                    result.setLargeIcon(this.processString(this.getTextValue(el), false));
                } else if (tag.equals("ejb-name")) {
                    ejbName = this.getTextValue(el);
                    result.setBeanName(ejbName, appName);
                } else if (tag.equals("home")) {
                    result.setRemoteHomeInterface(this.getTextValue(el));
                } else if (tag.equals("remote")) {
                    result.setRemoteInterface(this.getTextValue(el));
                } else if (tag.equals("local-home")) {
                    result.setLocalHomeInterface(this.getTextValue(el));
                } else if (tag.equals("local")) {
                    result.setLocalInterface(this.getTextValue(el));
                } else if (tag.equals("ejb-class")) {
                    result.setClassName(this.getTextValue(el));
                } else if (tag.equals("session-type")) {
                    String sesType = this.getTextValue(el);
                    if (sesType.equals(STATEFUL_SESSION)) {
                        result.setSessionType(1);
                    } else if (sesType.equals(STATELESS_SESSION)) {
                        result.setSessionType(0);
                    } else {
                        args = new String[]{"session bean", sesType, ejbName};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4022", args);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Incorrect " + (String)args[0] + " type \"" + (String)args[1] + "\" for bean \"" + "\".");
                    }
                } else if (tag.equals("transaction-type")) {
                    String transType = this.getTextValue(el);
                    if (transType.equals("Bean")) {
                        result.setTransactionType(0);
                    } else if (transType.equals("Container")) {
                        result.setTransactionType(1);
                    } else {
                        args = new String[]{"transaction", transType, ejbName};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4022", args);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Incorrect " + (String)args[0] + " type \"" + (String)args[1] + "\" for bean \"" + "\".");
                    }
                } else if (tag.equals("env-entry")) {
                    envEntries.add(this.processEnvEntry(el, ejbName));
                } else if (tag.equals("ejb-ref")) {
                    ejbRefs.add(this.processEjbRef(el, ejbName));
                } else if (tag.equals("ejb-local-ref")) {
                    ejbLocalRefs.add(this.processEjbLocalRef(el, ejbName));
                } else if (tag.equals("security-role-ref")) {
                    SecurityRoleReference ref = this.processSecurityRoleRef(el, ejbName);
                    if (ref != null) {
                        securityRoleRefs.put(ref.getRoleName(), ref);
                    }
                } else if (tag.equals("security-identity")) {
                    SecurityIdentity securityIdentity = new SecurityIdentity();
                    NodeList secIdentityList = el.getChildNodes();
                    int j = 0;
                    while (j < secIdentityList.getLength()) {
                        if (secIdentityList.item(j).getNodeType() == 1) {
                            Element nextEl = (Element)secIdentityList.item(j);
                            String nextTag = nextEl.getNodeName();
                            if (nextTag.equals("description")) {
                                securityIdentity.setDescription(this.getTextValue(nextEl));
                            } else if (nextTag.equals("use-caller-identity")) {
                                securityIdentity.setCallerIdentity(true);
                            } else if (nextTag.equals("run-as")) {
                                securityIdentity.setCallerIdentity(false);
                                RunAsIdentity runAsIdentity = new RunAsIdentity();
                                NodeList runAsList = nextEl.getChildNodes();
                                Element runEl = null;
                                int r = 0;
                                while (r < runAsList.getLength()) {
                                    if (runAsList.item(r).getNodeType() == 1) {
                                        runEl = (Element)runAsList.item(r);
                                        if (runEl.getNodeName().equals("role-name")) {
                                            runAsIdentity.setSecurityRoleName(this.getTextValue(runEl));
                                        } else if (runEl.getNodeName().equals("description")) {
                                            runAsIdentity.setDescription(this.getTextValue(runEl));
                                        }
                                    }
                                    ++r;
                                }
                                securityIdentity.setRunAsIdentity(runAsIdentity);
                            }
                        }
                        ++j;
                    }
                    if (!securityIdentity.isCallerIdentity()) {
                        RunAsIdentity run = securityIdentity.getRunAsIdentity();
                        run.setComponentName(result.getName());
                        securityIdentity.setRunAsIdentity(run);
                    }
                    result.setSecurityIdentity(securityIdentity);
                } else if (tag.equals("resource-ref")) {
                    resourceRefs.add(this.processResourceRef(el, ejbName));
                } else if (tag.equals("resource-env-ref")) {
                    resourceEnvRefs.add(this.processResourceEnvRef(el));
                } else if (tag.equals("bean-count")) {
                    try {
                        result.setContainerSize(new Integer(this.getTextValue(el)));
                    }
                    catch (NumberFormatException nfe) {
                        args = new String[]{ejbName};
                        if (this.compliance) {
                            ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4018", args);
                            toThrow.log();
                            throw toThrow;
                        }
                        this.errors.add("Illegal value type of element \"container-size\" for bean \"" + ejbName + "\". Required int.");
                    }
                }
            }
            ++i;
        }
        result.setEnvironmentEntries(envEntries.toArray(new EnvironmentEntry[envEntries.size()]));
        result.setEJBeanReferences(ejbRefs.toArray(new EJBeanReference[ejbRefs.size()]));
        result.setEJBeanLocalReferences(ejbLocalRefs.toArray(new EJBeanLocalReference[ejbLocalRefs.size()]));
        result.setRoleReferences(securityRoleRefs);
        result.setResourceReferences(resourceRefs.toArray(new ResourceReference[resourceRefs.size()]));
        result.setResourceEnvReferences(resourceEnvRefs.toArray(new ResourceEnvReference[resourceEnvRefs.size()]));
        return result;
    }

    protected void processAssemblyDescriptor(Element assemblyEl, EJBJarDescriptor result, ClassLoader loader, Vector warnings) throws DeploymentException {
        NodeList assemblyList = assemblyEl.getChildNodes();
        Vector<SecurityRoles> securityRoles = new Vector<SecurityRoles>();
        Vector<AccessControls> accessControls = new Vector<AccessControls>();
        Vector<ControlDescriptor> controlDescriptors = new Vector<ControlDescriptor>();
        Vector<MethodEntry> excludeListMethods = new Vector<MethodEntry>();
        int i = 0;
        while (i < assemblyList.getLength()) {
            if (assemblyList.item(i).getNodeType() == 1) {
                int y;
                String accDescr;
                Element el = (Element)assemblyList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("security-role")) {
                    Element roleName = this.getFirstElementByName(el, "role-name");
                    String name = this.getTextValue(roleName);
                    SecurityRoles secRole = new SecurityRoles(name, this.getTextValue(this.getFirstElementByName(el, "description")));
                    securityRoles.add(secRole);
                } else if (tag.equals("method-permission")) {
                    accDescr = null;
                    NodeList descrList = el.getElementsByTagName("description");
                    int y2 = 0;
                    while (y2 < descrList.getLength()) {
                        if (descrList.item(y2).getNodeType() == 1) {
                            accDescr = this.getTextValue((Element)descrList.item(y2));
                            break;
                        }
                        ++y2;
                    }
                    int pid = Integer.MIN_VALUE;
                    NodeList pidList = el.getElementsByTagName("pid");
                    y = 0;
                    while (y < pidList.getLength()) {
                        if (pidList.item(y).getNodeType() == 1) {
                            try {
                                pid = new Integer(this.getTextValue((Element)pidList.item(y)));
                                break;
                            }
                            catch (Exception e) {
                                warnings.add("Cannot read pid element beacuse it is not value! Reson: \n" + e.toString());
                            }
                        }
                        ++y;
                    }
                    String[] secRoles = null;
                    Vector<String> tempRoles = new Vector<String>();
                    NodeList rolesList = el.getElementsByTagName("role-name");
                    int j = 0;
                    while (j < rolesList.getLength()) {
                        if (rolesList.item(j).getNodeType() == 1) {
                            tempRoles.add(this.getTextValue((Element)rolesList.item(j)));
                        }
                        ++j;
                    }
                    secRoles = tempRoles.toArray(new String[tempRoles.size()]);
                    boolean unchecked = false;
                    NodeList uncheckedList = el.getElementsByTagName("unchecked");
                    int u = 0;
                    while (u < uncheckedList.getLength()) {
                        if (uncheckedList.item(u).getNodeType() == 1) {
                            unchecked = true;
                        }
                        ++u;
                    }
                    NodeList methodsList = el.getElementsByTagName("method");
                    int j2 = 0;
                    while (j2 < methodsList.getLength()) {
                        if (methodsList.item(j2).getNodeType() == 1) {
                            MethodEntry[] methodEntryes = this.getMethodXml((Element)methodsList.item(j2), result, loader, false);
                            if (this.compliance || methodEntryes != null) {
                                int me = 0;
                                while (me < methodEntryes.length) {
                                    if (!methodEntryes[me].getMethodName().equals("Entire EJB")) {
                                        boolean accessControlFound = false;
                                        int ac = 0;
                                        while (ac < accessControls.size()) {
                                            if (((AccessControls)accessControls.elementAt(ac)).isCompatible(methodEntryes[me])) {
                                                if (unchecked) {
                                                    ((AccessControls)accessControls.elementAt(ac)).setUnchecked(true);
                                                } else {
                                                    ((AccessControls)accessControls.elementAt(ac)).addSecurityRoles(secRoles);
                                                }
                                                accessControlFound = true;
                                                break;
                                            }
                                            ++ac;
                                        }
                                        if (!accessControlFound) {
                                            AccessControls accCtrl = null;
                                            accCtrl = unchecked ? new AccessControls(accDescr, methodEntryes[me]) : new AccessControls(accDescr, secRoles, methodEntryes[me]);
                                            if (pid != Integer.MIN_VALUE) {
                                                accCtrl.setPid(pid);
                                            }
                                            accessControls.add(accCtrl);
                                        }
                                    }
                                    ++me;
                                }
                            }
                        }
                        ++j2;
                    }
                } else if (tag.equals("container-transaction")) {
                    accDescr = null;
                    NodeList descrList = el.getElementsByTagName("description");
                    int y3 = 0;
                    while (y3 < descrList.getLength()) {
                        if (descrList.item(y3).getNodeType() == 1) {
                            accDescr = this.getTextValue((Element)descrList.item(y3));
                            break;
                        }
                        ++y3;
                    }
                    String transAttr = null;
                    NodeList transList = el.getElementsByTagName("trans-attribute");
                    y = 0;
                    while (y < transList.getLength()) {
                        if (transList.item(y).getNodeType() == 1) {
                            transAttr = this.getTextValue((Element)transList.item(y));
                            break;
                        }
                        ++y;
                    }
                    String isoLevel = null;
                    NodeList isoList = el.getElementsByTagName("isolation-level");
                    int y4 = 0;
                    while (y4 < isoList.getLength()) {
                        if (isoList.item(y4).getNodeType() == 1) {
                            isoLevel = this.getTextValue((Element)isoList.item(y4));
                            break;
                        }
                        ++y4;
                    }
                    NodeList methodsList = el.getElementsByTagName("method");
                    int j = 0;
                    while (j < methodsList.getLength()) {
                        if (methodsList.item(j).getNodeType() == 1) {
                            MethodEntry[] methodEntryes = this.getMethodXml((Element)methodsList.item(j), result, loader, true);
                            if (this.compliance || methodEntryes != null) {
                                int me = 0;
                                while (me < methodEntryes.length) {
                                    if (!methodEntryes[me].getMethodName().equals("Entire EJB")) {
                                        ControlDescriptor ctrlDescr;
                                        MethodEntry prevMethodEntry = null;
                                        boolean attributeIsSet = false;
                                        int k = 0;
                                        while (k < controlDescriptors.size()) {
                                            prevMethodEntry = ((ControlDescriptor)controlDescriptors.elementAt(k)).getMethodEntry();
                                            if (prevMethodEntry.simpleEquals(methodEntryes[me]) && prevMethodEntry.getEjbName().equals(methodEntryes[me].getEjbName())) {
                                                attributeIsSet = true;
                                                break;
                                            }
                                            ++k;
                                        }
                                        if (attributeIsSet) {
                                            if (prevMethodEntry.hasLowPriority(methodEntryes[me])) {
                                                controlDescriptors.removeElementAt(k);
                                                ctrlDescr = new ControlDescriptor(accDescr, methodEntryes[me], transAttr);
                                                if (isoLevel != null) {
                                                    ctrlDescr.setIsolationLevel(isoLevel);
                                                }
                                                controlDescriptors.add(ctrlDescr);
                                            } else if (prevMethodEntry.hasEqualsPriority(methodEntryes[me])) {
                                                warnings.add("Method " + prevMethodEntry.getMethodName() + " in " + prevMethodEntry.getEjbName() + " has more then one transaction attribute. " + "The first one is considered as valid.");
                                            }
                                        } else {
                                            ctrlDescr = new ControlDescriptor(accDescr, methodEntryes[me], transAttr);
                                            if (isoLevel != null) {
                                                ctrlDescr.setIsolationLevel(isoLevel);
                                            }
                                            controlDescriptors.add(ctrlDescr);
                                        }
                                    }
                                    ++me;
                                }
                            }
                        }
                        ++j;
                    }
                } else if (tag.equals("exclude-list")) {
                    NodeList descrList = el.getElementsByTagName("description");
                    int y5 = 0;
                    while (y5 < descrList.getLength()) {
                        if (descrList.item(y5).getNodeType() == 1) {
                            result.setExcludeListDescription(this.getTextValue((Element)descrList.item(y5)));
                            break;
                        }
                        ++y5;
                    }
                    NodeList methodsList = el.getElementsByTagName("method");
                    int j = 0;
                    while (j < methodsList.getLength()) {
                        if (methodsList.item(j).getNodeType() == 1) {
                            MethodEntry[] methodEntryes = this.getMethodXml((Element)methodsList.item(j), result, loader, false);
                            if (this.compliance || methodEntryes != null) {
                                int me = 0;
                                while (me < methodEntryes.length) {
                                    if (!methodEntryes[me].getMethodName().equals("Entire EJB")) {
                                        excludeListMethods.add(methodEntryes[me]);
                                    }
                                    ++me;
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (result.getDescriptors() != null) {
            result.distributeSecurityRoles(securityRoles.toArray(new SecurityRoles[securityRoles.size()]));
            result.distributeControlDescriptors(controlDescriptors.toArray(new ControlDescriptor[controlDescriptors.size()]));
            result.distributeAccessControls(accessControls.toArray(new AccessControls[accessControls.size()]));
            result.distributeExcludeList(excludeListMethods.toArray(new MethodEntry[excludeListMethods.size()]));
        }
    }

    public MethodEntry[] getMethodXml(Element methodEl, EJBJarDescriptor jarDescriptor, ClassLoader loader, boolean containerTxAttrib) throws DeploymentException {
        NodeList methodList = methodEl.getChildNodes();
        Vector<String> methodParams = new Vector<String>();
        String description = null;
        String ejbName = null;
        String methodIntf = null;
        String methodName = null;
        boolean hasMethodParams = false;
        int i = 0;
        while (i < methodList.getLength()) {
            block39: {
                String tag;
                Element el;
                block42: {
                    Object[] args;
                    block43: {
                        block41: {
                            block40: {
                                if (methodList.item(i).getNodeType() != 1) break block39;
                                el = (Element)methodList.item(i);
                                tag = el.getNodeName();
                                if (!tag.equals("description")) break block40;
                                description = this.getTextValue(el);
                                break block39;
                            }
                            if (!tag.equals("ejb-name")) break block41;
                            ejbName = this.getTextValue(el);
                            break block39;
                        }
                        if (!tag.equals("method-intf")) break block42;
                        methodIntf = this.getTextValue(el);
                        if (this.xmlType != 2) break block43;
                        if (!(methodIntf.equals("Remote") || methodIntf.equals("Home") || methodIntf.equals("Local") || methodIntf.equals("LocalHome"))) {
                            args = new String[]{"method-intf", "bean", ejbName, "Remote, Home, Local or LocalHome"};
                            if (this.compliance) {
                                ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4017", args);
                                toThrow.log();
                                throw toThrow;
                            }
                            this.errors.add("Incerrect value of element \"" + (String)args[0] + "\" for " + (String)args[1] + "\"" + (String)args[2] + "\". Must be one of the following: " + (String)args[3] + ".");
                        }
                        break block39;
                    }
                    if (methodIntf.equals("Remote") || methodIntf.equals("Home")) break block39;
                    args = new String[]{"method-intf", "bean", ejbName, "Remote or Home"};
                    if (this.compliance) {
                        ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4017", args);
                        toThrow.log();
                        throw toThrow;
                    }
                    this.errors.add("Incerrect value of element \"" + (String)args[0] + "\" for " + (String)args[1] + "\"" + (String)args[2] + "\". Must be one of the following: " + (String)args[3] + ".");
                    break block39;
                }
                if (tag.equals("method-name")) {
                    methodName = this.getTextValue(el).trim();
                } else if (tag.equals("method-params")) {
                    hasMethodParams = true;
                    NodeList paramList = el.getChildNodes();
                    int j = 0;
                    while (j < paramList.getLength()) {
                        Element pel;
                        if (paramList.item(j).getNodeType() == 1 && (pel = (Element)paramList.item(j)).getNodeName().equals("method-param")) {
                            methodParams.add(this.getTextValue(pel));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        DeploymentDescriptor[] descriptors = jarDescriptor.getDDescriptors();
        DeploymentDescriptor foundDescr = null;
        int i2 = 0;
        while (i2 < descriptors.length) {
            if (descriptors[i2].getEjbName().equals(ejbName)) {
                foundDescr = descriptors[i2];
                break;
            }
            ++i2;
        }
        if (foundDescr == null) {
            if (this.compliance) {
                ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4005", new String[]{ejbName});
                toThrow.log();
                throw toThrow;
            }
            this.errors.add("Cannot find bean with name " + ejbName + ", defined in ejb-jar.xml");
            return new MethodEntry[0];
        }
        MethodEntry[] methodEnts = null;
        if (methodName.equals("*")) {
            try {
                return this.getAllMethodsInBean(methodName, methodIntf, null, foundDescr, loader, description, containerTxAttrib);
            }
            catch (ClassNotFoundException cnfe) {
                if (this.compliance) {
                    ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4023", (Throwable)cnfe);
                    toThrow.log();
                    throw toThrow;
                }
                this.errors.add(" Can not load one of the bean interfaces or ejb-class.");
                return null;
            }
            catch (NoClassDefFoundError err) {
                if (this.compliance) {
                    ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4023", (Throwable)err);
                    toThrow.log();
                    throw toThrow;
                }
                this.errors.add(" Can not load one of the bean interfaces or ejb-class.");
                return null;
            }
        }
        if (!hasMethodParams) {
            try {
                methodEnts = this.getAllMethodsInBean(methodName, methodIntf, new String[]{""}, foundDescr, loader, description, containerTxAttrib);
                int i3 = 0;
                while (i3 < methodEnts.length) {
                    methodEnts[i3].setPriority(2);
                    ++i3;
                }
                return methodEnts;
            }
            catch (ClassNotFoundException cnfe) {
                if (this.compliance) {
                    ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4023", (Throwable)cnfe);
                    toThrow.log();
                    throw toThrow;
                }
                this.errors.add(" Can not load one of the bean interfaces or ejb-class.");
                return null;
            }
            catch (NoClassDefFoundError err) {
                if (this.compliance) {
                    ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4023", (Throwable)err);
                    toThrow.log();
                    throw toThrow;
                }
                this.errors.add(" Can not load one of the bean interfaces or ejb-class.");
                return null;
            }
        }
        Vector<MethodEntry> filteredMethods = new Vector<MethodEntry>();
        String[] params = methodParams.toArray(new String[methodParams.size()]);
        try {
            methodEnts = this.getAllMethodsInBean(methodName, methodIntf, params, foundDescr, loader, description, containerTxAttrib);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.compliance) {
                ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4023", (Throwable)cnfe);
                toThrow.log();
                throw toThrow;
            }
            this.errors.add(" Can not load one of the bean interfaces or ejb-class.");
            return null;
        }
        catch (NoClassDefFoundError err) {
            if (this.compliance) {
                ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4023", (Throwable)err);
                toThrow.log();
                throw toThrow;
            }
            this.errors.add(" Can not load one of the bean interfaces or ejb-class.");
            return null;
        }
        int i4 = 0;
        while (i4 < methodEnts.length) {
            String[] mParams;
            if (!methodEnts[i4].getMethodName().equals("Entire EJB") && params.length == (mParams = methodEnts[i4].getParameters()).length) {
                boolean equals = true;
                int j = 0;
                while (j < params.length) {
                    if (!params[j].equals(this.convertClassName(mParams[j]))) {
                        equals = false;
                    }
                    ++j;
                }
                if (equals) {
                    methodEnts[i4].setPriority(3);
                    filteredMethods.add(methodEnts[i4]);
                }
            }
            ++i4;
        }
        if (filteredMethods.size() == 0) {
            String param = "(";
            int i5 = 0;
            while (i5 < params.length) {
                param = i5 != params.length - 1 ? param + params[i5] + ", " : param + params[i5] + ")";
                ++i5;
            }
            if (this.compliance) {
                ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4013", new String[]{methodName, param, ejbName});
                toThrow.log();
                throw toThrow;
            }
            this.errors.add("Can not find method " + methodName + " with params  " + param + ", declared in ejb-jar.xml for bean " + ejbName + ".");
        }
        return filteredMethods.toArray(new MethodEntry[filteredMethods.size()]);
    }

    private MethodEntry[] getAllMethodsInBean(String methodName, String methodIntf, String[] params, DeploymentDescriptor ddescr, ClassLoader loader, String descrip, boolean containerTxAttrib) throws ClassNotFoundException, DeploymentException {
        int i;
        Method[] methods;
        if (ddescr instanceof MessageDrivenDescriptor) {
            if (methodName.equals("*") || methodName.equals("onMessage")) {
                Class<?> beanClass = loader.loadClass(ddescr.getClassName());
                Class<?> messageClass = loader.loadClass("javax.jms.Message");
                try {
                    Method onMess = beanClass.getMethod("onMessage", messageClass);
                    if (methodName.equals("*")) {
                        MethodEntry[] methodEntryArray = new MethodEntry[2];
                        MethodEntry beanEntry = new MethodEntry((Method)null);
                        beanEntry.setEjbName(ddescr.getEjbName());
                        beanEntry.setMethodInterface(null);
                        beanEntry.setMethodDescription(descrip);
                        methodEntryArray[0] = beanEntry;
                        methodEntryArray[1] = new MethodEntry(ddescr.getEjbName(), null, onMess, descrip);
                        return methodEntryArray;
                    }
                    return new MethodEntry[]{new MethodEntry(ddescr.getEjbName(), null, onMess, descrip)};
                }
                catch (NoSuchMethodException nsme) {
                    if (this.compliance) {
                        ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4024", new String[]{ddescr.getEjbName()}, nsme);
                        toThrow.log();
                        throw toThrow;
                    }
                    this.errors.add("Method onMessage not found in message driven bean \"" + ddescr.getEjbName() + "\".");
                    return null;
                }
            }
            String param = "(";
            if (params != null) {
                int i2 = 0;
                while (i2 < params.length) {
                    param = i2 != params.length - 1 ? param + params[i2] + ", " : param + params[i2];
                    ++i2;
                }
            }
            param = param + ")";
            if (this.compliance) {
                ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4013", new String[]{methodName, param, ddescr.getEjbName()});
                toThrow.log();
                throw toThrow;
            }
            this.errors.add("Can not find method " + methodName + " with params  " + param + ", declared in ejb-jar.xml for bean " + ddescr.getEjbName() + ".");
            return null;
        }
        Class<?> remoteIntf = null;
        Class<?> homeIntf = null;
        Class<?> localIntf = null;
        Class<?> localHomeIntf = null;
        if (ddescr.getRemoteInterface() != null) {
            remoteIntf = loader.loadClass(ddescr.getRemoteInterface());
        }
        if (ddescr.getRemoteHomeInterface() != null) {
            homeIntf = loader.loadClass(ddescr.getRemoteHomeInterface());
        }
        if (ddescr.getLocalInterface() != null) {
            localIntf = loader.loadClass(ddescr.getLocalInterface());
        }
        if (ddescr.getLocalHomeInterface() != null) {
            localHomeIntf = loader.loadClass(ddescr.getLocalHomeInterface());
        }
        if (methodIntf != null) {
            Class<?> currClass = null;
            Object suppClass = null;
            if (methodIntf.equals("Remote")) {
                if (remoteIntf == null) {
                    if (this.compliance) {
                        ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4026", new String[]{"Remote", ddescr.getEjbName()});
                        toThrow.log();
                        throw toThrow;
                    }
                    this.errors.add("Remote interface is not specified for bean \"" + ddescr.getEjbName() + "\", but is used in method-intf. ");
                }
                currClass = remoteIntf;
            } else if (methodIntf.equals("Home")) {
                if (homeIntf == null) {
                    if (this.compliance) {
                        ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4026", new String[]{"Home", ddescr.getEjbName()});
                        toThrow.log();
                        throw toThrow;
                    }
                    this.errors.add("Home interface is not specified for bean \"" + ddescr.getEjbName() + "\", but is used in method-intf. ");
                }
                currClass = homeIntf;
            } else if (methodIntf.equals("Local")) {
                if (localIntf == null) {
                    if (this.compliance) {
                        ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4026", new String[]{"Local", ddescr.getEjbName()});
                        toThrow.log();
                        throw toThrow;
                    }
                    this.errors.add("Local interface is not specified for bean \"" + ddescr.getEjbName() + "\", but is used in method-intf. ");
                }
                currClass = localIntf;
            } else if (methodIntf.equals("LocalHome")) {
                if (localHomeIntf == null) {
                    if (this.compliance) {
                        ToolDeploymentException toThrow = new ToolDeploymentException("xml_ejb_4026", new String[]{"LocalHome", ddescr.getEjbName()});
                        toThrow.log();
                        throw toThrow;
                    }
                    this.errors.add("LocalHome interface is not specified for bean \"" + ddescr.getEjbName() + "\", but is used in method-intf. ");
                }
                currClass = localHomeIntf;
            }
            Vector<MethodEntry> methodEntries = new Vector<MethodEntry>();
            Method[] methods2 = currClass.getMethods();
            if (methodName.equals("*")) {
                MethodEntry beanEntry = new MethodEntry((Method)null);
                beanEntry.setEjbName(ddescr.getEjbName());
                beanEntry.setMethodInterface(methodIntf);
                beanEntry.setMethodDescription(descrip);
                methodEntries.add(beanEntry);
                int i3 = 0;
                while (i3 < methods2.length) {
                    methodEntries.add(new MethodEntry(ddescr.getEjbName(), methodIntf, methods2[i3], descrip));
                    ++i3;
                }
            } else {
                boolean found = false;
                int i4 = 0;
                while (i4 < methods2.length) {
                    if (methods2[i4].getName().equals(methodName)) {
                        found = true;
                        methodEntries.add(new MethodEntry(ddescr.getEjbName(), methodIntf, methods2[i4], descrip));
                    }
                    ++i4;
                }
                if (!found) {
                    if (this.compliance) {
                        throw new ToolDeploymentException("xml_ejb_4027", new String[]{methodName, methodIntf, ddescr.getEjbName()});
                    }
                    this.errors.add("Method " + methodName + " not found in " + methodIntf + " interface of bean " + ddescr.getEjbName());
                }
            }
            return methodEntries.toArray(new MethodEntry[methodEntries.size()]);
        }
        Vector<MethodEntry> methodEntries = new Vector<MethodEntry>();
        boolean found = false;
        boolean sessionBean = ddescr instanceof SessionDescriptor;
        MethodEntry beanEntry = new MethodEntry((Method)null);
        beanEntry.setEjbName(ddescr.getEjbName());
        beanEntry.setMethodInterface(null);
        beanEntry.setMethodDescription(descrip);
        methodEntries.add(beanEntry);
        if (remoteIntf != null) {
            methods = remoteIntf.getMethods();
            if (methodName.equals("*")) {
                i = 0;
                while (i < methods.length) {
                    if (containerTxAttrib) {
                        if (!this.containsIn(EJBOBJECT_METHODS, methods[i].getName(), sessionBean)) {
                            methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Remote", methods[i], descrip));
                        }
                    } else {
                        methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Remote", methods[i], descrip));
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < methods.length) {
                    if (methods[i].getName().equals(methodName)) {
                        found = true;
                        methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Remote", methods[i], descrip));
                    }
                    ++i;
                }
            }
        }
        if (localIntf != null) {
            methods = localIntf.getMethods();
            if (methodName.equals("*")) {
                i = 0;
                while (i < methods.length) {
                    if (containerTxAttrib) {
                        if (!this.containsIn(EJBLOCALOBJECT_METHODS, methods[i].getName(), sessionBean)) {
                            methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Local", methods[i], descrip));
                        }
                    } else {
                        methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Local", methods[i], descrip));
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < methods.length) {
                    if (methods[i].getName().equals(methodName)) {
                        found = true;
                        methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Local", methods[i], descrip));
                    }
                    ++i;
                }
            }
        }
        if (!sessionBean || !containerTxAttrib) {
            if (homeIntf != null) {
                methods = homeIntf.getMethods();
                if (methodName.equals("*")) {
                    i = 0;
                    while (i < methods.length) {
                        if (containerTxAttrib) {
                            if (!this.containsIn(EJBHOME_METHODS, methods[i].getName(), false)) {
                                methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Home", methods[i], descrip));
                            }
                        } else {
                            methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Home", methods[i], descrip));
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < methods.length) {
                        if (methods[i].getName().equals(methodName)) {
                            found = true;
                            methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Home", methods[i], descrip));
                        }
                        ++i;
                    }
                }
            }
            if (localHomeIntf != null) {
                methods = localHomeIntf.getMethods();
                if (methodName.equals("*")) {
                    i = 0;
                    while (i < methods.length) {
                        methodEntries.add(new MethodEntry(ddescr.getEjbName(), "LocalHome", methods[i], descrip));
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < methods.length) {
                        if (methods[i].getName().equals(methodName)) {
                            found = true;
                            methodEntries.add(new MethodEntry(ddescr.getEjbName(), "LocalHome", methods[i], descrip));
                        }
                        ++i;
                    }
                }
            }
        }
        if (!found && !methodName.equals("*")) {
            if (this.compliance) {
                throw new ToolDeploymentException("xml_ejb_4028", new String[]{methodName, ddescr.getEjbName()});
            }
            this.errors.add("Method " + methodName + " not found in bean " + ddescr.getEjbName());
        }
        return methodEntries.toArray(new MethodEntry[methodEntries.size()]);
    }

    /*
     * Unable to fully structure code
     */
    protected void parseFields(EJBJarDescriptor ejbjarDes, ClassLoader loader) throws DeploymentException {
        entityDescriptors = ejbjarDes.getAbstractSchema().getDescriptors();
        isUnknownPK = false;
        i = 0;
        while (i < entityDescriptors.length) {
            block40: {
                block42: {
                    descriptor = entityDescriptors[i];
                    isUnknownPK = false;
                    className = descriptor.getClassName();
                    if (!this.compliance && className == null) break block40;
                    clazz = null;
                    try {
                        clazz = loader.loadClass(className);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (this.compliance) {
                            throw new ToolDeploymentException("xml_ejb_4012", new String[]{className, "entity bean or dependent object"}, cnfe);
                        }
                        this.errors.add("ClassNotFoundException: Probably entity bean or dependent object class name is not correct." + cnfe.toString());
                        break block40;
                    }
                    catch (NoClassDefFoundError err) {
                        if (this.compliance) {
                            throw new ToolDeploymentException("xml_ejb_4012", new String[]{className}, err);
                        }
                        this.errors.add("ClassNotFoundException: Probably entity bean or dependent object class name is not correct." + err.toString());
                        break block40;
                    }
                    if (descriptor.getPKFieldName() != null) break block42;
                    if (!descriptor.isUnknownPK()) {
                        pkClass = null;
                        try {
                            pkClass = loader.loadClass(descriptor.getPrimaryKeyClass());
                        }
                        catch (ClassNotFoundException cnfe) {
                            if (this.compliance) {
                                throw new ToolDeploymentException("xml_ejb_4012", new String[]{descriptor.getPrimaryKeyClass(), "Primary Key"}, cnfe);
                            }
                            this.errors.add("Cannot find " + descriptor.getPrimaryKeyClass() + " class. Probably Primary Key class is not correct.");
                        }
                        catch (NoClassDefFoundError err) {
                            if (this.compliance) {
                                throw new ToolDeploymentException("xml_ejb_4012", new String[]{descriptor.getPrimaryKeyClass(), "Primary Key"}, err);
                            }
                            this.errors.add("Cannot find " + descriptor.getPrimaryKeyClass() + " class. Probably Primary Key class is not correct.");
                        }
                        pkClassFileds = pkClass.getFields();
                        xmlCmpFields = descriptor.getCmpFields();
                        vPKCmpFields = new Vector<PersistentField>();
                        pkClassFieldName = null;
                        l = 0;
                        found = false;
                        p = 0;
                        while (p < pkClassFileds.length) {
                            if (Modifier.isPublic(pkClassFileds[p].getModifiers())) {
                                pkClassFieldName = pkClassFileds[p].getName();
                                l = 0;
                                found = false;
                                while (!found && l < xmlCmpFields.length) {
                                    if (xmlCmpFields[l] != null && pkClassFieldName.equals(xmlCmpFields[l].getFieldName())) {
                                        xmlCmpFields[l].setCompoundPK();
                                        vPKCmpFields.addElement(xmlCmpFields[l]);
                                        xmlCmpFields[l] = null;
                                        found = true;
                                        continue;
                                    }
                                    ++l;
                                }
                                if (!found) {
                                    if (this.compliance) {
                                        throw new ToolDeploymentException("xml_ejb_4029", new String[]{pkClassFieldName, descriptor.getEjbName()});
                                    }
                                    this.errors.add("Field " + pkClassFieldName + " in the primary key class of bean " + descriptor.getEjbName() + " is not described as a <cmp-field> in the ejb-jar.xml");
                                }
                            }
                            ++p;
                        }
                        descriptor.setPKCmpFields(vPKCmpFields.toArray(new PersistentField[vPKCmpFields.size()]));
                        newCmpfields = new PersistentField[xmlCmpFields.length - vPKCmpFields.size()];
                        pos = 0;
                        k = 0;
                        while (k < xmlCmpFields.length) {
                            if (xmlCmpFields[k] != null) {
                                newCmpfields[pos++] = xmlCmpFields[k];
                            }
                            ++k;
                        }
                        descriptor.setCmpFields(newCmpfields);
                    } else {
                        cmpFld = new PersistentField[]{new PersistentField()};
                        cmpFld[0].setDescription("Deployer genrates default PK if it is unknow; spec 10.8.3");
                        cmpFld[0].setFieldName("ejb_pk");
                        cmpFld[0].setFieldType("java.lang.Long");
                        try {
                            cmpFld[0].setFieldClass(Class.forName("java.lang.Long"));
                        }
                        catch (ClassNotFoundException cnf) {
                            if (this.compliance) {
                                throw new ToolDeploymentException("xml_ejb_4030", new String[]{cnf.toString()}, cnf);
                            }
                            this.errors.add("Bean with unknown primary key. The default class for primary key does not loaded. Reason:" + cnf.toString());
                        }
                        catch (NoClassDefFoundError err) {
                            if (this.compliance) {
                                throw new ToolDeploymentException("xml_ejb_4030", new String[]{err.toString()}, err);
                            }
                            this.errors.add("Bean with unknown primary key. The default class for primary key does not loaded. Reason:" + err.toString());
                        }
                        cmpFld[0].setPK();
                        descriptor.setPKCmpFields(cmpFld);
                        isUnknownPK = true;
                    }
                    ** GOTO lbl-1000
                }
                xmlCmpFields = descriptor.getCmpFields();
                pkFieldName = descriptor.getPKFieldName();
                l = 0;
                while (l < xmlCmpFields.length) {
                    if (xmlCmpFields[l].getFieldName().equals(pkFieldName)) {
                        descriptor.setPKCmpFields(new PersistentField[]{xmlCmpFields[l]});
                        newCmpfields = new PersistentField[xmlCmpFields.length - 1];
                        System.arraycopy(xmlCmpFields, 0, newCmpfields, 0, l);
                        System.arraycopy(xmlCmpFields, l + 1, newCmpfields, l, newCmpfields.length - l);
                        descriptor.setCmpFields(newCmpfields);
                        break;
                    }
                    ++l;
                }
                if (descriptor.getPKCmpFields() == null) {
                    if (this.compliance) {
                        throw new ToolDeploymentException("xml_ejb_4031", new String[]{descriptor.getEjbName()});
                    }
                    this.errors.add("Name of <primkey-field> for bean " + descriptor.getEjbName() + " is not described as a <cmp-field> in the ejb-jar.xml");
                } else lbl-1000:
                // 3 sources

                {
                    cmpFields = descriptor.getCmpFields();
                    if (cmpFields != null) {
                        this.fillCmpFieldInfo(cmpFields, descriptor, loader, clazz, false);
                    }
                    cmpFields = descriptor.getPKCmpFields();
                    if (!isUnknownPK) {
                        this.fillCmpFieldInfo(cmpFields, descriptor, loader, clazz, true);
                    }
                    if ((cmrFields = descriptor.getCmrFields()) != null) {
                        j = 0;
                        while (j < cmrFields.length) {
                            block41: {
                                if (cmrFields[j].getFieldType() == null) {
                                    fieldName = cmrFields[j].getFieldName();
                                    getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                                    try {
                                        cmrFields[j].setFieldType(clazz.getMethod(getMethodName, new Class[0]).getReturnType().getName());
                                    }
                                    catch (NoSuchMethodException nsfe) {
                                        if (this.compliance) {
                                            throw new ToolDeploymentException("xml_ejb_4032", new String[]{"cmr", fieldName}, nsfe);
                                        }
                                        this.errors.add("Cannot find cmr-field return type. Probably cmr-field name \"" + fieldName + "\" is not correct.");
                                    }
                                    catch (NoClassDefFoundError ncderr) {
                                        if (this.compliance) break block41;
                                        this.errors.add("Cannot find cmr-field return type. Probably cmr-field name \"" + fieldName + "\" is not correct.");
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void parseFinders(EJBJarDescriptor ejbjarDes, ClassLoader loader) throws DeploymentException {
        descriptors = ejbjarDes.getAbstractSchema().getDescriptors();
        if (descriptors == null) {
            return;
        }
        i = 0;
        while (i < descriptors.length) {
            block42: {
                descriptor = descriptors[i];
                beanClassName = descriptor.getClassName();
                remoteHomeClassName = descriptor.getRemoteHomeInterface();
                localHomeClassName = descriptor.getLocalHomeInterface();
                beanClass = null;
                remHomeClass = null;
                locHomeClass = null;
                try {
                    beanClass = loader.loadClass(beanClassName);
                    if (remoteHomeClassName != null) {
                        remHomeClass = loader.loadClass(remoteHomeClassName);
                    }
                    if (localHomeClassName != null) {
                        locHomeClass = loader.loadClass(localHomeClassName);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    if (this.compliance) {
                        throw new ToolDeploymentException("xml_ejb_4012", new String[]{"local home ", localHomeClassName}, cnfe);
                    }
                    this.errors.add("Cannot find local home class. Probably \"" + localHomeClassName + "\" class is not correct.");
                }
                catch (NoClassDefFoundError err) {
                    if (this.compliance) {
                        throw new ToolDeploymentException("xml_ejb_4012", new String[]{"local home interface", localHomeClassName}, err);
                    }
                    this.errors.add("Cannot find local home interface class. Probably \"" + localHomeClassName + "\" class name is not correct.");
                }
                methods = descriptor.getFinderDescriptors();
                if (methods == null) break block42;
                j = 0;
                while (j < methods.length) {
                    block44: {
                        block43: {
                            block41: {
                                method = methods[j];
                                methodName = method.getMethodName();
                                params = method.getParamsTypes();
                                paramsClass = null;
                                if (params != null) {
                                    paramsClass = new Class[params.length];
                                    k = 0;
                                    while (k < params.length) {
                                        try {
                                            paramsClass[k] = this.getClassFromString(params[k], loader);
                                        }
                                        catch (ClassNotFoundException cnfe) {
                                            if (this.compliance) {
                                                throw new ToolDeploymentException("xml_ejb_4014", new String[]{params[k]}, cnfe);
                                            }
                                            this.errors.add("Cannot find method parameter class " + params[k] + ".");
                                        }
                                        catch (NoClassDefFoundError err) {
                                            if (this.compliance) {
                                                throw new ToolDeploymentException("xml_ejb_4014", new String[]{params[k]}, err);
                                            }
                                            this.errors.add("Cannot find method parameter class " + params[k] + ".");
                                        }
                                        ++k;
                                    }
                                } else {
                                    paramsClass = new Class[]{};
                                }
                                if (!methodName.startsWith("ejbSelect")) break block43;
                                reflMethod = null;
                                try {
                                    reflMethod = beanClass.getMethod(methodName, paramsClass);
                                    break block41;
                                }
                                catch (NoSuchMethodException nsme) {
                                    allParamsStr = "";
                                    b = 0;
                                    ** while (b < params.length)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    allParamsStr = params[b] + ", ";
                                    ++b;
                                    continue;
                                }
lbl73:
                                // 1 sources

                                allParamsStr = allParamsStr.substring(0, allParamsStr.length() - 2);
                                if (this.compliance) {
                                    throw new ToolDeploymentException("xml_ejb_4033", new String[]{methodName, allParamsStr, descriptor.getEjbName()});
                                }
                                this.errors.add("Method: " + methodName + " with parameters: (" + allParamsStr + ") not found in entity bean: " + descriptor.getEjbName());
                                break block44;
                            }
                            method.setSelect();
                            exceptionsClass = null;
                            if (!this.compliance && reflMethod == null) {
                                method.setReturnType("");
                                exceptionsClass = new Class[]{};
                            } else {
                                method.setReturnType(reflMethod.getReturnType().getName());
                                exceptionsClass = reflMethod.getExceptionTypes();
                            }
                            exceptions = new String[exceptionsClass.length];
                            n = 0;
                            while (n < exceptionsClass.length) {
                                exceptions[n] = exceptionsClass[n].getName();
                                ++n;
                            }
                            method.setExceptions(exceptions);
                            break block44;
                        }
                        if (methodName.startsWith("find")) {
                            reflIntfMethod = null;
                            try {
                                reflIntfMethod = remHomeClass.getMethod(methodName, paramsClass);
                            }
                            catch (NoSuchMethodException nsme1) {
                                this.warnings.add("Cannot load local home class! Reason \n" + nsme1);
                            }
                            catch (NullPointerException npe) {
                                this.warnings.add("Cannot load local home class!Reason \n" + npe);
                            }
                            if (reflIntfMethod == null) {
                                try {
                                    if (locHomeClass != null) {
                                        reflIntfMethod = locHomeClass.getMethod(methodName, paramsClass);
                                    } else {
                                        if (this.compliance) {
                                            throw new ToolDeploymentException("xml_ejb_4027", new String[]{methodName, remoteHomeClassName + " and " + localHomeClassName, descriptor.getEjbName()});
                                        }
                                        this.errors.add("Method: " + methodName + "  not found in interface: " + remoteHomeClassName + " and " + localHomeClassName + " of bean " + descriptor.getEjbName());
                                    }
                                }
                                catch (NoSuchMethodException nsme) {
                                    if (this.compliance) {
                                        throw new ToolDeploymentException("xml_ejb_4027", new String[]{methodName, remoteHomeClassName + " and " + localHomeClassName, descriptor.getEjbName()}, nsme);
                                    }
                                    this.errors.add("Method: " + methodName + "  not found in interface: " + remoteHomeClassName + " and " + localHomeClassName + " of bean " + descriptor.getEjbName());
                                }
                            }
                            method.setFinder();
                            exceptionsClass = null;
                            if (!this.compliance && reflIntfMethod == null) {
                                method.setReturnType("");
                                exceptionsClass = new Class[]{};
                            } else {
                                method.setReturnType(reflIntfMethod.getReturnType().getName());
                                exceptionsClass = reflIntfMethod.getExceptionTypes();
                            }
                            exceptions = new String[exceptionsClass.length];
                            n = 0;
                            while (n < exceptionsClass.length) {
                                exceptions[n] = exceptionsClass[n].getName();
                                ++n;
                            }
                            method.setExceptions(exceptions);
                        } else {
                            if (this.compliance) {
                                throw new ToolDeploymentException("xml_ejb_4034");
                            }
                            this.errors.add("Query method must start either with \"ejbSelect\" or with \"find\".");
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected Class getClassFromString(String className, ClassLoader loader) throws ClassNotFoundException {
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.compliance) {
                throw new BaseClassNotFoundException("xml_ejb_4041", new Object[]{className});
            }
            this.errors.add("Cannot find " + className);
            return null;
        }
    }

    private RelationField processCmrField(Element cmr) throws DeploymentException {
        RelationField field = new RelationField();
        Element tempEl = this.getFirstElementByName(cmr, "description");
        if (tempEl != null) {
            field.setDescription(this.getElementText(tempEl));
        }
        if ((tempEl = this.getFirstElementByName(cmr, "cmr-field-type")) != null) {
            field.setFieldType(this.getElementText(tempEl));
        }
        if ((tempEl = this.getFirstElementByName(cmr, "cmr-field-name")) == null) {
            if (this.compliance) {
                throw new ToolDeploymentException("xml_ejb_4035", new String[]{"", "<cmr-field>", "<cmr-field-name>"});
            }
            this.errors.add("Check <cmr-field> elements in your ejb-jar.xml, <cmr-field-name> subtag is missing in one of them.");
        }
        field.setFieldName(this.getElementText(tempEl));
        return field;
    }

    private OneSideRelationDescriptor processEjbRelationRole(Element role) throws DeploymentException {
        OneSideRelationDescriptor side = new OneSideRelationDescriptor();
        Element tempEl = this.getFirstElementByName(role, "description");
        Element roleSourceEl = null;
        if (tempEl != null) {
            side.setRoleDescription(this.getElementText(tempEl));
        }
        if ((tempEl = this.getFirstElementByName(role, "ejb-relationship-role-name")) != null) {
            side.setRoleName(this.getElementText(tempEl));
        }
        if ((tempEl = this.getFirstElementByName(role, "cascade-delete")) != null) {
            side.setCascade(true);
        }
        if ((roleSourceEl = this.getFirstElementByName(role, "relationship-role-source")) == null) {
            if (this.compliance) {
                throw new ToolDeploymentException("xml_ejb_4035", new String[]{"", "<ejb-relationship-role>", "<relationship-role-source>"});
            }
            this.errors.add("Check <ejb-relationship-role> elements in your ejb-jar.xml, <relationship-role-source> subtag is missing in one of them.");
        }
        if ((tempEl = this.getFirstElementByName(roleSourceEl, "description")) != null) {
            side.setRoleSourceDescription(this.getElementText(tempEl));
        }
        return side;
    }

    private String convertClassName(String className) {
        if (className.charAt(0) != '[') {
            return className;
        }
        int first = className.indexOf(91);
        int last = className.lastIndexOf(91);
        char ch = className.charAt(last + 1);
        String st = "";
        int i = 0;
        while (i <= last - first) {
            st = st + "[]";
            ++i;
        }
        switch (ch) {
            case 'B': {
                return "byte" + st;
            }
            case 'C': {
                return "char" + st;
            }
            case 'D': {
                return "double" + st;
            }
            case 'F': {
                return "float" + st;
            }
            case 'I': {
                return "int" + st;
            }
            case 'J': {
                return "long" + st;
            }
            case 'S': {
                return "short" + st;
            }
            case 'Z': {
                return "boolean" + st;
            }
            case 'L': {
                return className.substring(last + 2, className.length() - 1) + st;
            }
        }
        return "";
    }

    private boolean primitive(String type) {
        return type == null || type.equals("int") || type.equals("byte") || type.equals("char") || type.equals("short") || type.equals("long") || type.equals("double") || type.equals("float") || type.equals("boolean") || type.equals("[B");
    }

    private boolean containsIn(String[] excludeMethods, String method, boolean sessionBean) {
        if (sessionBean && method.equals("remove")) {
            return true;
        }
        int i = 0;
        while (i < excludeMethods.length) {
            if (method.equals(excludeMethods[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Element getFirstElementByName(Element el, String name) {
        NodeList nl = el.getElementsByTagName(name);
        if (nl.getLength() < 1) {
            return null;
        }
        return (Element)nl.item(0);
    }

    private String getElementText(Element el) {
        NodeList nodeList = el.getChildNodes();
        Node node = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                ((TextImpl)node).trimWhiteSpace();
                if (!Symbols.isWhitespace((String)((Text)node).getData())) {
                    return ((Text)node).getData();
                }
            }
            ++i;
        }
        return "";
    }

    private void fillCmpFieldInfo(PersistentField[] cmpFields, CMPEntityDescriptor descriptor, ClassLoader loader, Class clazz, boolean pkFields) throws DeploymentException {
        boolean cmp11 = descriptor.getCmpVersion() == 1;
        int j = 0;
        while (j < cmpFields.length) {
            String fieldName = cmpFields[j].getFieldName();
            String fieldType = null;
            if (cmp11) {
                try {
                    cmpFields[j].setFieldClass(clazz.getField(fieldName).getType());
                    fieldType = cmpFields[j].getFieldClass().getName();
                }
                catch (NoSuchFieldException nsfe) {
                    if (this.compliance) {
                        throw new ToolDeploymentException("xml_ejb_4032", new String[]{"cmp", fieldName}, nsfe);
                    }
                    this.errors.add("NoSuchMethodException: Probably entity bean or dependent object cmp-field name: " + fieldName + " is not correct. ");
                    return;
                }
                catch (NoClassDefFoundError err) {
                    if (this.compliance) {
                        throw new ToolDeploymentException("xml_ejb_4032", new String[]{"cmp", fieldName}, err);
                    }
                    this.errors.add("NoSuchMethodException: Probably entity bean or dependent object cmp-field name: " + fieldName + " is not correct. ");
                    return;
                }
            }
            String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                cmpFields[j].setFieldClass(clazz.getMethod(getMethodName, new Class[0]).getReturnType());
                fieldType = cmpFields[j].getFieldClass().getName();
            }
            catch (NoSuchMethodException nsfe) {
                if (this.compliance) {
                    throw new ToolDeploymentException("xml_ejb_4032", new String[]{"cmp", fieldName}, nsfe);
                }
                this.errors.add("NoSuchMethodException: Probably entity bean or dependent object cmp-field name: " + fieldName + " is not correct. ");
                return;
            }
            catch (NoClassDefFoundError err) {
                if (this.compliance) {
                    throw new ToolDeploymentException("xml_ejb_4032", new String[]{"cmp", fieldName}, err);
                }
                this.errors.add("NoSuchMethodException: Probably entity bean or dependent object cmp-field name: " + fieldName + " is not correct. ");
                return;
            }
            if (this.primitive(fieldType) || fieldType.startsWith("java.")) {
                cmpFields[j].setFieldType(fieldType);
            } else {
                Field[] fields = null;
                String[] subFieldNames = null;
                String[] subFieldTypes = null;
                Class[] subFieldClasses = null;
                boolean subFieldsMap = false;
                Class depValueClass = null;
                if (!pkFields) {
                    subFieldsMap = true;
                    depValueClass = cmpFields[j].getFieldClass();
                    fields = depValueClass.getDeclaredFields();
                    subFieldNames = new String[fields.length];
                    subFieldTypes = new String[fields.length];
                    subFieldClasses = new Class[fields.length];
                    if (fields.length == 0) {
                        subFieldsMap = false;
                    } else {
                        int p = 0;
                        while (p < fields.length) {
                            if (!Modifier.isPublic(fields[p].getModifiers())) {
                                subFieldsMap = false;
                                break;
                            }
                            subFieldNames[p] = fields[p].getName();
                            subFieldClasses[p] = fields[p].getType();
                            subFieldTypes[p] = subFieldClasses[p].getName();
                            subFieldsMap = true;
                            ++p;
                        }
                    }
                    if (subFieldsMap) {
                        try {
                            Constructor constr = depValueClass.getConstructor(null);
                        }
                        catch (NoSuchMethodException e) {
                            subFieldsMap = false;
                        }
                    }
                }
                if (subFieldsMap) {
                    DependentValueDescriptor depValueDscr = new DependentValueDescriptor();
                    depValueDscr.setDescription(cmpFields[j].getDescription());
                    depValueDscr.setFieldName(fieldName);
                    depValueDscr.setFieldType(fieldType);
                    depValueDscr.setFieldClass(depValueClass);
                    depValueDscr.setValueFieldNames(subFieldNames);
                    depValueDscr.setValueFieldTypes(subFieldTypes);
                    depValueDscr.setValueFieldClasses(subFieldClasses);
                    cmpFields[j] = depValueDscr;
                } else {
                    cmpFields[j].setFieldType(fieldType);
                    cmpFields[j].disableDVMapping();
                }
            }
            ++j;
        }
    }

    public void setCompliance(boolean compliance) {
        this.compliance = compliance;
    }

    public EJBJarDescriptor fillIfNecessary(EJBJarDescriptor result) {
        DeploymentDescriptor[] eds = (DeploymentDescriptor[])result.getDescriptors();
        if (eds == null) {
            return result;
        }
        int i = 0;
        while (i < eds.length) {
            if (eds[i].getClassName() == null) {
                eds[i].setClassName("");
            }
            if (eds[i] instanceof EntityDescriptor && ((EntityDescriptor)eds[i]).getPrimaryKeyClass() == null) {
                ((EntityDescriptor)eds[i]).setPrimaryKeyClass("");
            }
            ++i;
        }
        return result;
    }

    public Vector getErrors() {
        return this.errors;
    }

    public Vector getWarnings() {
        return this.warnings;
    }
}

