/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.descriptors.jar;

import com.sap.engine.deploy.ejb.descriptors.xml.EJBJarParser;
import com.sap.engine.deploy.ejb.descriptors.xml.InqmyEjbParser;
import com.sap.engine.deploy.ejb.descriptors.xml.PersistentParser;
import com.sap.engine.deploy.exceptions.BaseIOException;
import com.sap.engine.lib.jar.JarHandler;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.converter.EJBConverter;
import com.sap.engine.services.ejb.deploy.admintool.RMappingTool;
import com.sap.engine.services.ejb.deploy.admintool.RMappingTool11;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class ReadEjbJar {
    private String jarFileName = null;
    private String classpath = null;
    private ClassLoader mainLoader = null;
    private String appName;
    private Vector errors = new Vector();
    private ZipFile jar = null;

    public ReadEjbJar() {
        this.errors = new Vector();
    }

    public ReadEjbJar(String _jarFileName) {
        this.jarFileName = _jarFileName;
        this.errors = new Vector();
    }

    public ReadEjbJar(String _jarFileName, String appName, boolean hasAppName) {
        this.jarFileName = _jarFileName;
        this.appName = appName;
        this.errors = new Vector();
    }

    public ReadEjbJar(String _jarFileName, String _classpath) {
        this.jarFileName = _jarFileName;
        this.classpath = _classpath;
        this.errors = new Vector();
    }

    public ReadEjbJar(String _jarFileName, ClassLoader _mainLoader) {
        this.jarFileName = _jarFileName;
        this.mainLoader = _mainLoader;
        this.errors = new Vector();
    }

    public DeploymentDescriptor[] getDeploymentDescriptors() throws IOException {
        return this.getEjbJarDescriptor().getDDescriptors();
    }

    public EJBJarDescriptor getEjbJarDescriptor(String _jarFileName) throws IOException {
        if (_jarFileName == null) {
            throw new BaseIOException("xml_ejb_4100");
        }
        this.jarFileName = _jarFileName;
        return this.getEjbJarDescriptor();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EJBJarDescriptor getEjbJarDescriptor(BufferedInputStream bis) throws IOException {
        File jarFile;
        EJBJarDescriptor result;
        block14: {
            result = null;
            jarFile = new File(this.jarFileName);
            DynamicClassLoader loader = new DynamicClassLoader(this.classpath + File.pathSeparator + this.jarFileName, this.mainLoader);
            try {
                try {
                    if (this.jar == null) {
                        this.jar = new ZipFile(jarFile);
                    }
                    ZipEntry entry = null;
                    result = this.getConvertedEJBDescriptor(loader, bis);
                    bis.close();
                    entry = JarHandler.findEntryIgnoreCase(this.jar, "meta-inf/ejb-j2ee-engine.xml");
                    if (entry != null) {
                        InqmyEjbParser parser = new InqmyEjbParser();
                        parser.parseXml(result, new BufferedInputStream(this.jar.getInputStream(entry)), this.errors, "meta-inf/ejb-j2ee-engine.xml");
                    }
                    boolean hasPersistancy = false;
                    entry = JarHandler.findEntryIgnoreCase(this.jar, "meta-inf/persistent.xml");
                    if (entry != null) {
                        PersistentParser persistentParser = new PersistentParser();
                        persistentParser.parseXML(result, new BufferedInputStream(this.jar.getInputStream(entry)), this.errors, loader, "meta-inf/persistent.xml");
                        hasPersistancy = true;
                    } else {
                        entry = JarHandler.findEntryIgnoreCase(this.jar, "meta-inf/storage.xml");
                        if (entry != null) {
                            RMappingTool11 rTool11 = new RMappingTool11();
                            rTool11.setEJBJarDscr(result);
                            rTool11.readXML(new BufferedInputStream(this.jar.getInputStream(entry)));
                            hasPersistancy = true;
                        }
                    }
                    if (!hasPersistancy) {
                        try {
                            RMappingTool rTool = new RMappingTool(result.getAbstractSchema());
                            rTool.createSchemaMapping();
                        }
                        catch (Exception e1) {
                            this.errors.add("Exception in ReadEjbJar.getEjbJarDescriptor() : " + e1.toString());
                        }
                    }
                    Object var9_12 = null;
                    if (this.jar == null) break block14;
                }
                catch (ZipException ze) {
                    throw new BaseIOException("xml_ejb_4102", new String[]{this.jarFileName, ze.toString()}, ze);
                }
                catch (Exception de) {
                    throw new BaseIOException("xml_ejb_4102", new String[]{this.jarFileName, de.toString()}, de);
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (this.jar != null) {
                    this.jar.close();
                }
                throw throwable;
            }
            this.jar.close();
        }
        result.setJarName(jarFile.getName());
        return result;
    }

    public EJBJarDescriptor getEjbJarDescriptor() throws IOException {
        File jarFile = new File(this.jarFileName);
        this.jar = new ZipFile(jarFile);
        ZipEntry entry = JarHandler.findEntryIgnoreCase(this.jar, "meta-inf/ejb-jar.xml");
        if (entry == null) {
            throw new BaseIOException("xml_ejb_4101", new String[]{this.jarFileName});
        }
        return this.getEjbJarDescriptor(new BufferedInputStream(this.jar.getInputStream(entry)));
    }

    public void setClassPath(String _classpath) {
        this.classpath = _classpath;
    }

    public void setLoader(ClassLoader _loader) {
        this.mainLoader = _loader;
    }

    public void setApplicationName(String name) {
        this.appName = name;
    }

    public EJBJarDescriptor getConvertedEJBDescriptor(ClassLoader loader, BufferedInputStream buffer) throws Exception {
        Document document = null;
        EJBJarDescriptor result = new EJBJarDescriptor();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            StandardDOMParser domParser = new StandardDOMParser();
            Thread.currentThread().setContextClassLoader(cl);
            domParser.setSystemId(this.jarFileName);
            document = domParser.parse((InputStream)buffer);
            buffer.close();
        }
        catch (IOException ioe) {
            throw new BaseIOException("xml_ejb_4103", new String[]{this.jarFileName, ioe.toString()}, ioe);
        }
        catch (Exception ex) {
            throw new BaseIOException("xml_ejb_4103", new String[]{this.jarFileName, ex.toString()}, ex);
        }
        DocumentType dt = document.getDoctype();
        String dtd = "<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type,session-timeout?, transaction-type, bean-count,\n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, bean-count, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link, user-name, password)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT password (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT method-permission (description?, role-name+, method+, pid?)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT pid (#PCDATA)>\n<!ELEMENT bean-count (#PCDATA)>\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n]>";
        if (dt != null && (dtd = dt.getSystemId()) == null) {
            dtd = "<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type,session-timeout?, transaction-type, bean-count,\n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, bean-count, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link, user-name, password)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT password (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT method-permission (description?, role-name+, method+, pid?)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT pid (#PCDATA)>\n<!ELEMENT bean-count (#PCDATA)>\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n]>";
        }
        if (dtd.equals("<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type,session-timeout?, transaction-type, bean-count,\n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, bean-count, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link, user-name, password)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT password (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT method-permission (description?, role-name+, method+, pid?)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT pid (#PCDATA)>\n<!ELEMENT bean-count (#PCDATA)>\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n]>") || dtd.indexOf("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd") >= 0) {
            EJBConverter converter = new EJBConverter();
            converter.setLoader(loader);
            result = (EJBJarDescriptor)converter.parseDocument(document);
            converter.applyChanges(result);
        } else {
            try {
                EJBJarParser parser = new EJBJarParser();
                parser.setCompliance(false);
                result = parser.parseXml(document, this.errors, loader, this.appName);
                try {
                    RMappingTool rTool = new RMappingTool(result.getAbstractSchema());
                    rTool.createSchemaMapping();
                }
                catch (Exception e1) {
                    this.errors.add("Exception in ReadEjbJar.getConvertedEJBDescriptor() : " + e1.toString());
                }
            }
            catch (Exception e) {
                throw new BaseIOException("xml_ejb_4103", new String[]{this.jarFileName, e.toString()}, e);
            }
        }
        return result;
    }

    public Vector getErrors() {
        return this.errors;
    }
}

